/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.core;

import fr.uha.ensisa.ir.walther.milcityblue.core.Building;
import fr.uha.ensisa.ir.walther.milcityblue.core.BuildingsIterator;
import fr.uha.ensisa.ir.walther.milcityblue.core.Cell;
import fr.uha.ensisa.ir.walther.milcityblue.core.Cells;
import fr.uha.ensisa.ir.walther.milcityblue.core.CellsIterator;
import fr.uha.ensisa.ir.walther.milcityblue.core.PlayerAbstract;
import fr.uha.ensisa.ir.walther.milcityblue.core.Size;
import fr.uha.ensisa.ir.walther.milcityblue.core.commands.Command;
import fr.uha.ensisa.ir.walther.milcityblue.core.commands.Commands;

public abstract class Weapon {
    public static final int WEAPON_NULL = 200;
    public static final int WEAPON_MISSILE = 201;
    public static final int WEAPON_SHIELD = 202;
    public static final int WEAPON_AIRCRAFT = 203;
    public static final int WEAPON_MORTAR = 204;
    public static final int WEAPON_NUKE = 205;
    public static final int WEAPON_SPY = 206;
    public static final int SIZE_MISSILE_X = 1;
    public static final int SIZE_MISSILE_Y = 1;
    public static final int SIZE_SHIELD_X = 2;
    public static final int SIZE_SHIELD_Y = 2;
    public static final int SIZE_AIRCRAFT_X = 2;
    public static final int SIZE_AIRCRAFT_Y = 3;
    public static final int SIZE_MORTAR_X = 2;
    public static final int SIZE_MORTAR_Y = 2;
    public static final int SIZE_NUKE_X = 4;
    public static final int SIZE_NUKE_Y = 4;
    public static final int SIZE_SPY_X = 3;
    public static final int SIZE_SPY_Y = 3;
    public static final int STATE_LAUNCHED = 0;
    public static final int STATE_EXPLOSION = 1;
    public static final int STATE_TERMINATED = 2;
    public static final int CELL_UNCHANGED = 0;
    public static final int CELL_GROUNDHIT = 1;
    public static final int CELL_BUILDINGHIT = 2;
    public static final int CELL_BUILDINGDESTROYED = 3;
    protected Cells cells;
    protected int state;
    protected long createdOn;
    protected long updatedOn;
    protected int x0;
    protected int y0;
    protected int r0;

    public Weapon(int x, int y, int r) {
        this.cells = Cells.createCells(this.getSize(), 29, x, y, r);
        this.state = 0;
        this.createdOn = System.currentTimeMillis();
        this.updatedOn = System.currentTimeMillis();
        this.x0 = x;
        this.y0 = y;
        this.r0 = r;
    }

    public Cells getCells() {
        return this.cells;
    }

    public Commands makeEffect(PlayerAbstract player, int playerSenderIndex) {
        Commands commands = new Commands();
        int type = 0;
        boolean isMissed = true;
        int y = this.y0;
        while (y < this.y0 + this.getSize().getSizeY()) {
            int x = this.x0;
            while (x < this.x0 + this.getSize().getSizeX()) {
                type = player.getGrid().getCell(x, y);
                if (type != 1) {
                    int[] params;
                    isMissed = true;
                    if (type > 0) {
                        player.getGrid().setCell(30, x, y);
                        BuildingsIterator itBuildings = new BuildingsIterator(player.getGrid().getBuildings());
                        while (itBuildings.hasNext()) {
                            Building building = itBuildings.next();
                            if (!building.isHit(x, y)) continue;
                            params = new int[]{playerSenderIndex, building.getType(), x, y};
                            commands.push(new Command(player.getPlayerIndex(), 200, 6, params));
                            isMissed = false;
                            if (!building.isDestroyed()) continue;
                            CellsIterator itCells = new CellsIterator(building.getCells());
                            while (itCells.hasNext()) {
                                Cell cell = itCells.next();
                                int[] params2 = new int[]{playerSenderIndex, building.getType(), cell.getX(), cell.getY()};
                                commands.push(new Command(player.getPlayerIndex(), 200, 7, params2));
                            }
                            itCells = null;
                            isMissed = false;
                        }
                    }
                    if (isMissed) {
                        params = new int[]{playerSenderIndex, 100, x, y};
                        commands.push(new Command(player.getPlayerIndex(), 200, 6, params));
                    }
                }
                ++x;
            }
            ++y;
        }
        return commands;
    }

    public abstract Size getSize();
}

