/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.core.buildings;

import fr.uha.ensisa.ir.walther.milcityblue.core.Building;
import fr.uha.ensisa.ir.walther.milcityblue.core.Cell;
import fr.uha.ensisa.ir.walther.milcityblue.core.Config;
import fr.uha.ensisa.ir.walther.milcityblue.core.PlayerAbstract;
import fr.uha.ensisa.ir.walther.milcityblue.core.Size;

public class Commercial
extends Building {
    public Commercial(int x, int y, int r) {
        this.cells.push(new Cell(27, x, y));
    }

    public void update(PlayerAbstract player) {
        if (player.getAccelerationFactor() > 0) {
            if (this.state != 2) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.updatedOn >= (long)(1000 * this.getProductionTime())) {
                    this.updatedOn = currentTime;
                    if (this.state == 1) {
                        player.updateProduction(this);
                    }
                }
                if (this.state == 0 && currentTime - this.createdOn >= (long)(1000 * this.getConstructionTime())) {
                    this.state = 1;
                    player.updateConstruction(this);
                }
            }
        } else {
            super.update(player);
        }
    }

    public int getConstructionCost() {
        return Config.CONSTRUCTION_COST_COMMERCIAL;
    }

    public int getConstructionTime() {
        return Config.CONSTRUCTION_TIME_COMMERCIAL;
    }

    public int getEnergy() {
        return Config.ENERGY_COMMERCIAL;
    }

    public int getProductionTime() {
        return Config.PRODUCTION_TIME_NULL;
    }

    public int getProductionType() {
        return 200;
    }

    public Size getSize() {
        return new Size(1, 1);
    }

    public int getType() {
        return 108;
    }
}

