/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.core.commands;

import fr.uha.ensisa.ir.walther.milcityblue.core.Config;

public class Command {
    public static final int COMMAND_NULL = 0;
    public static final int COMMAND_GRID = 1;
    public static final int COMMAND_START = 2;
    public static final int COMMAND_PAUSE = 3;
    public static final int COMMAND_CONTINUE = 4;
    public static final int COMMAND_FIRE = 5;
    public static final int COMMAND_HIT = 6;
    public static final int COMMAND_DESTROYED = 7;
    public static final int COMMAND_WIN = 8;
    public static final int COMMAND_LOSE = 9;
    public static final int COMMAND_DISCOVER = 10;
    public static final int COMMAND_SETINDEX = 11;
    public static final int COMMAND_END = 12;
    public static final int COMMAND_ADDSCORE = 13;
    public static final int PARAMETERS_NULL = 0;
    public static final int PARAMETERS_GRID = Config.DEFAULT_GRID_SIZE_X * Config.DEFAULT_GRID_SIZE_Y;
    public static final int PARAMETERS_START = 0;
    public static final int PARAMETERS_PAUSE = 0;
    public static final int PARAMETERS_CONTINUE = 0;
    public static final int PARAMETERS_FIRE = 4;
    public static final int PARAMETERS_HIT = 4;
    public static final int PARAMETERS_DESTROYED = 4;
    public static final int PARAMETERS_END = 0;
    public static final int PARAMETERS_WIN = 1;
    public static final int PARAMETERS_LOSE = 1;
    public static final int PARAMETERS_DISCOVER = 3;
    public static final int PARAMETERS_SETINDEX = 1;
    public static final int PARAMETERS_ADDSCORE = 1;
    public static final int SENDER_NULL = 100;
    public static final int TARGET_NULL = 100;
    public static final int TARGET_ALL = 200;
    private int playerSender;
    private int playerTarget;
    private int commandType;
    private int[] parameters;

    public Command(int playerSender, int playerTarget, int commandType, int[] parameters) {
        this.playerSender = playerSender;
        this.playerTarget = playerTarget;
        this.commandType = commandType;
        this.parameters = parameters;
    }

    public int getPlayerSender() {
        return this.playerSender;
    }

    public void setPlayerSender(int playerSender) {
        this.playerSender = playerSender;
    }

    public int getPlayerTarget() {
        return this.playerTarget;
    }

    public void setPlayerTarget(int playerTarget) {
        this.playerTarget = playerTarget;
    }

    public int getCommandType() {
        return this.commandType;
    }

    public void setCommandType(int commandType) {
        this.commandType = commandType;
    }

    public int[] getParameters() {
        return this.parameters;
    }

    public void setParameters(int[] parameters) {
        this.parameters = parameters;
    }

    public int getParameter(int index) {
        if (index >= 0 || index < this.parameters.length) {
            return this.parameters[index];
        }
        return -1;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer("Command (" + this.hashCode() + ")\n{\n");
        tmp.append("\tPlayerSender\t=\t" + this.playerSender + ";\n");
        tmp.append("\tPlayerTarget\t=\t" + this.playerTarget + ";\n");
        tmp.append("\tCommandType \t=\t" + Command.commandTypeToString(this.commandType) + " (" + this.commandType + ");\n");
        tmp.append("\tParameters  \t=\t" + Command.parametersToString(this.parameters) + ";\n");
        tmp.append("}\n");
        return tmp.toString();
    }

    public static String commandTypeToString(int type) {
        switch (type) {
            case 0: {
                return "NULL";
            }
            case 1: {
                return "GRID";
            }
            case 2: {
                return "START";
            }
            case 3: {
                return "PAUSE";
            }
            case 4: {
                return "CONTINUE";
            }
            case 5: {
                return "FIRE";
            }
            case 6: {
                return "HIT";
            }
            case 7: {
                return "DESTROYED";
            }
            case 8: {
                return "WIN";
            }
            case 9: {
                return "LOSE";
            }
            case 10: {
                return "DISCOVER";
            }
            case 11: {
                return "SETINDEX";
            }
            case 12: {
                return "END";
            }
            case 13: {
                return "ADDSCORE";
            }
        }
        return "UNKNOWN COMMAND TYPE";
    }

    public static String parametersToString(int[] args) {
        StringBuffer tmp = new StringBuffer("(");
        int i = 0;
        while (i < args.length) {
            tmp.append(args[i]);
            if (i < args.length - 1) {
                tmp.append(", ");
            }
            ++i;
        }
        tmp.append(")");
        return tmp.toString();
    }
}

