/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.core.players;

import fr.uha.ensisa.ir.walther.milcityblue.bluetooth.ClientServer;
import fr.uha.ensisa.ir.walther.milcityblue.core.Game;
import fr.uha.ensisa.ir.walther.milcityblue.core.Grid;
import fr.uha.ensisa.ir.walther.milcityblue.core.PlayerInterface;
import fr.uha.ensisa.ir.walther.milcityblue.core.StatusGrid;
import fr.uha.ensisa.ir.walther.milcityblue.core.commands.Command;

public class RemotePlayer
implements PlayerInterface {
    private ClientServer cs;
    private StatusGrid statusGrid;
    private int playerIndex;
    private Game game;
    private boolean hasWon;
    private boolean hasLoose;

    public RemotePlayer(ClientServer cs) {
        this.cs = cs;
        this.statusGrid = null;
        this.playerIndex = -1;
        this.game = null;
        this.hasLoose = false;
        this.hasWon = false;
    }

    public void fire(Command commandFire) {
        System.out.println("RemotePlayer-" + this.playerIndex + ":\t Sending Command :" + commandFire);
        this.cs.send(commandFire);
    }

    public void run() {
        while (this.game.getStatus() == 1) {
            Command command = this.cs.receiveCommand();
            CommandExecuter executer = new CommandExecuter(command, this.game);
            executer.start();
        }
        if (this.game.getStatus() == 3 || this.game.getStatus() == 4) {
            this.cs.close();
        }
    }

    public int getPlayerIndex() {
        return this.playerIndex;
    }

    public StatusGrid getStatusGrid() {
        return this.statusGrid;
    }

    public void setPlayerIndex(int playerIndex) {
        this.playerIndex = playerIndex;
    }

    public void start() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void setGrid(Grid grid) {
        this.statusGrid = new StatusGrid(this.playerIndex, grid, this.game);
    }

    public Game getGame() {
        return this.game;
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public boolean isLocal() {
        return false;
    }

    public void sendCommand(Command command) {
        this.cs.send(command);
    }

    public boolean hasLoose() {
        return this.hasLoose;
    }

    public boolean hasWon() {
        return this.hasWon;
    }

    public void win() {
        this.hasWon = true;
    }

    public void lose() {
        this.hasLoose = true;
    }

    private class CommandExecuter
    extends Thread {
        private Command command;
        private Game game;

        public CommandExecuter(Command command, Game game) {
            this.command = command;
            this.game = game;
        }

        public void run() {
            System.out.println("RemotePlayer-" + RemotePlayer.this.playerIndex + ":\t Receveid Command :" + this.command);
            this.game.execute(this.command);
        }
    }
}

