/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.gui;

import fr.uha.ensisa.ir.walther.milcityblue.core.Grid;
import fr.uha.ensisa.ir.walther.milcityblue.core.StatusGrid;
import fr.uha.ensisa.ir.walther.milcityblue.gui.GameView;
import fr.uha.ensisa.ir.walther.milcityblue.gui.ImageDrawer;
import fr.uha.ensisa.ir.walther.milcityblue.gui.MilCityModel;
import javax.microedition.lcdui.Graphics;

public class GridView
implements GameView {
    private MilCityModel mcModel;
    private int gridHeight;
    private int gridWidth;
    private int cellSize;
    private ImageDrawer imageDrawer;
    private byte timer;

    public GridView(int cellSize, ImageDrawer imageDrawer, MilCityModel mcModel) {
        this.mcModel = mcModel;
        this.gridHeight = mcModel.getGame().getLocalPlayer().getGrid().getMaxY();
        this.gridWidth = mcModel.getGame().getLocalPlayer().getGrid().getMaxX();
        this.cellSize = cellSize;
        this.imageDrawer = imageDrawer;
        this.timer = 0;
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    public void setGridHeight(int gridHeight) {
        this.gridHeight = gridHeight;
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public void setGridWidth(int gridWidth) {
        this.gridWidth = gridWidth;
    }

    public int getCellSize() {
        return this.cellSize;
    }

    public void setCellSize(int cellSize) {
        this.cellSize = cellSize;
    }

    public void render(Graphics g) {
        if (this.mcModel.getModeSelected() == -1) {
            Grid grid = this.mcModel.getGame().getLocalPlayer().getGrid();
            int type = 0;
            boolean drawShield = false;
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipH = g.getClipHeight();
            int clipW = g.getClipWidth();
            int y = 0;
            while (y < grid.getMaxY()) {
                int x = 0;
                while (x < grid.getMaxX()) {
                    type = grid.getCell(x, y);
                    if (type < 0) {
                        type = -type;
                        drawShield = true;
                    }
                    if (type > 0 && type <= 34) {
                        this.imageDrawer.cellToImage(g, type, x, y, this.cellSize);
                    }
                    if (type >= 30) {
                        if (++type > 34) {
                            type = 28;
                        }
                        grid.setCell(type, x, y);
                    }
                    if (drawShield) {
                        g.setColor(12517630);
                        g.drawRect(x * this.cellSize, y * this.cellSize, this.cellSize - 1, this.cellSize - 1);
                        drawShield = false;
                    }
                    ++x;
                }
                ++y;
            }
            g.setClip(clipX, clipY, clipW, clipH);
        } else {
            StatusGrid grid = this.mcModel.getGame().getPlayerAt(this.mcModel.modeToPlayerIndex()).getStatusGrid();
            byte type = 0;
            g.setColor(255);
            int y = 0;
            while (y < grid.getMaxY()) {
                int x = 0;
                while (x < grid.getMaxX()) {
                    type = grid.getCellStatusAt(x, y);
                    switch (type) {
                        case 0: {
                            g.setColor(255);
                            break;
                        }
                        case 1: {
                            g.setColor(0);
                            break;
                        }
                        case 2: {
                            g.setColor(0xFF0000);
                            break;
                        }
                        case 3: {
                            g.setColor(65280);
                            break;
                        }
                        case 4: {
                            g.setColor(0xFFFF00);
                            break;
                        }
                        default: {
                            if (type < -128 || type > -1) break;
                            g.setGrayScale(192 + type);
                            if (this.timer != 0) break;
                            grid.decrementCellHitAt(x, y);
                        }
                    }
                    g.fillRect(x * this.cellSize, y * this.cellSize, this.cellSize, this.cellSize);
                    ++x;
                }
                ++y;
            }
            this.timer = (byte)(this.timer + 1);
            if (this.timer >= 10) {
                this.timer = 0;
            }
        }
    }

    public MilCityModel getMcModel() {
        return this.mcModel;
    }

    public void setMcModel(MilCityModel mcModel) {
        this.mcModel = mcModel;
    }

    public ImageDrawer getImageDrawer() {
        return this.imageDrawer;
    }

    public void setImageDrawer(ImageDrawer imageDrawer) {
        this.imageDrawer = imageDrawer;
    }
}

