/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.gui;

import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Splash
extends Canvas {
    private Image image;
    private int color;
    private int centerX;
    private int centerY;
    private boolean showing;
    private boolean isNextSplash;

    public Splash(String image, int background) {
        this.setFullScreenMode(true);
        this.color = background;
        this.showing = false;
        this.isNextSplash = false;
        try {
            this.image = Image.createImage((String)image);
            this.centerX = (this.getWidth() - this.image.getWidth()) / 2;
            this.centerY = (this.getHeight() - this.image.getHeight()) / 2;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void show(Display display, long millis) {
        this.show(display, null, millis);
    }

    public void show(final Display display, final Displayable next, final long millis) {
        this.showing = true;
        display.setCurrent((Displayable)this);
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    try {
                        Thread.sleep(millis);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        Splash.this.showing = false;
                        if (!Splash.this.isNextSplash) {
                            display.setCurrent(next);
                        }
                    }
                }
                finally {
                    Splash.this.showing = false;
                    if (!Splash.this.isNextSplash) {
                        display.setCurrent(next);
                    }
                }
            }
        });
        t.start();
    }

    protected void paint(Graphics g) {
        g.setColor(this.color);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.image != null) {
            g.drawImage(this.image, this.centerX, this.centerY, 0);
        }
    }

    public boolean isSplashing() {
        return this.showing;
    }
}

