/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue;

import fr.uha.ensisa.ir.walther.milcityblue.bluetooth.StartClient;
import fr.uha.ensisa.ir.walther.milcityblue.bluetooth.StartServer;
import fr.uha.ensisa.ir.walther.milcityblue.core.Config;
import fr.uha.ensisa.ir.walther.milcityblue.core.Game;
import fr.uha.ensisa.ir.walther.milcityblue.core.GameListener;
import fr.uha.ensisa.ir.walther.milcityblue.core.Grid;
import fr.uha.ensisa.ir.walther.milcityblue.core.GridBuilder;
import fr.uha.ensisa.ir.walther.milcityblue.core.Size;
import fr.uha.ensisa.ir.walther.milcityblue.core.gridbuilders.RandomWalkGridBuilder;
import fr.uha.ensisa.ir.walther.milcityblue.core.players.AIPlayer;
import fr.uha.ensisa.ir.walther.milcityblue.core.players.LocalPlayer;
import fr.uha.ensisa.ir.walther.milcityblue.gui.CursorView;
import fr.uha.ensisa.ir.walther.milcityblue.gui.DisplayManager;
import fr.uha.ensisa.ir.walther.milcityblue.gui.GameEngine;
import fr.uha.ensisa.ir.walther.milcityblue.gui.GridView;
import fr.uha.ensisa.ir.walther.milcityblue.gui.ImageDrawer;
import fr.uha.ensisa.ir.walther.milcityblue.gui.MenuView;
import fr.uha.ensisa.ir.walther.milcityblue.gui.MilCityModel;
import fr.uha.ensisa.ir.walther.milcityblue.gui.Splash;
import fr.uha.ensisa.ir.walther.milcityblue.tools.ParametersStore;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class MilCityBlue
extends MIDlet
implements CommandListener,
GameListener {
    private GameEngine engine;
    private Display display = Display.getDisplay((MIDlet)this);
    private Command exit;
    private Command pause;
    private Command resume;
    private Command next;
    private Command back;
    private Game game;
    private MilCityModel mcModel;
    private ImageDrawer imageDrawer = new ImageDrawer();
    private DisplayManager displayManager = new DisplayManager(this.display);
    private ParametersStore parametersStore;
    private Displayable mainMenu;
    private Displayable soloMenu;
    private Displayable multiMenu;
    private Displayable optionMenu;
    private Displayable helpMenu;
    private Displayable howToPlayForm;
    private Displayable commandsForm;
    private Displayable buildingsAndWeaponsForm;
    private Displayable aboutForm;
    private Displayable bluetoothHelp;

    protected void startApp() throws MIDletStateChangeException {
        this.back = new Command("Back", 7, 1);
        this.next = new Command("OK", 8, 0);
        this.next = new Command("Select", 8, 0);
        this.mainMenu = this.getMainScreen();
        this.displayManager.setFirst(this.mainMenu);
        Thread displaysplashs = new Thread(){

            public void run() {
                Splash splash1 = new Splash("/Splash_MilCity_Koojoo.png", 0xFFFFFF);
                splash1.show(MilCityBlue.this.display, MilCityBlue.this.mainMenu, 3000L);
            }
        };
        displaysplashs.start();
        this.imageDrawer.init();
        this.parametersStore = new ParametersStore("MilCityBlue_Config");
        String tmp = this.parametersStore.get(1);
        if (tmp != null) {
            boolean bl = Config.ENABLE_SOUND = tmp.equals("TRUE");
        }
        if ((tmp = this.parametersStore.get(2)) != null) {
            boolean bl = Config.ENABLE_VIBRATION = tmp.equals("TRUE");
        }
        if ((tmp = this.parametersStore.get(3)) != null) {
            Config.DEFAULT_PERCENT_OF_WATER = Integer.parseInt(tmp);
        }
        if ((tmp = this.parametersStore.get(4)) != null) {
            Config.DEFAULT_SCORE_TO_WIN = Integer.parseInt(tmp);
        }
        if ((tmp = this.parametersStore.get(5)) != null) {
            Config.DEFAULT_MONEY_AT_START = Integer.parseInt(tmp);
        }
        this.parametersStore.close();
        this.parametersStore = null;
        this.soloMenu = this.getSoloScreen();
        this.multiMenu = this.getMultiScreen();
        this.optionMenu = this.getOptionScreen();
        this.helpMenu = this.getHelpMenu();
        this.commandsForm = this.getCommandsForm();
        this.howToPlayForm = this.getHowToPlayForm();
        this.buildingsAndWeaponsForm = this.getBuildingsAndWeaponsForm();
        this.aboutForm = this.getAboutForm();
        this.bluetoothHelp = this.getBluetoothHelpForm();
        this.resume = new Command("Resume", 1, 2);
        this.pause = new Command("Pause", 1, 1);
        this.exit = new Command("Exit", 7, 1);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.exit) {
            this.game.stop();
        } else if (c == this.resume) {
            this.game.resume();
        } else if (c == this.pause) {
            this.game.pause();
        } else if (c == this.back && d == this.mainMenu) {
            try {
                try {
                    this.destroyApp(true);
                }
                catch (MIDletStateChangeException e) {
                    e.printStackTrace();
                    this.notifyDestroyed();
                }
            }
            finally {
                this.notifyDestroyed();
            }
        } else if (c == this.back) {
            this.displayManager.back();
        } else if (c == this.next) {
            if (d == this.mainMenu) {
                switch (((List)this.mainMenu).getSelectedIndex()) {
                    case 0: {
                        this.displayManager.next(this.soloMenu);
                        break;
                    }
                    case 1: {
                        this.displayManager.next(this.multiMenu);
                        break;
                    }
                    case 2: {
                        this.displayManager.next(this.optionMenu);
                        break;
                    }
                    case 3: {
                        this.displayManager.next(this.helpMenu);
                        break;
                    }
                    case 4: {
                        this.displayManager.next(this.aboutForm);
                        break;
                    }
                    case 5: {
                        this.notifyDestroyed();
                    }
                }
            } else if (d == this.soloMenu) {
                switch (((List)this.soloMenu).getSelectedIndex()) {
                    case 0: {
                        this.startSoloGame(0);
                        break;
                    }
                    case 1: {
                        this.startSoloGame(1);
                        break;
                    }
                    case 2: {
                        this.startSoloGame(2);
                        break;
                    }
                    case 3: {
                        this.startSoloGame(3);
                        System.out.println("This is Madness !\nMadness ? THIS IS SPARTAAAAAAAAA !");
                        break;
                    }
                    case 4: {
                        this.startSoloGame(4);
                    }
                }
            } else if (d == this.multiMenu) {
                switch (((List)this.multiMenu).getSelectedIndex()) {
                    case 0: {
                        StartServer startServer = new StartServer(this);
                        this.displayManager.next((Displayable)startServer);
                        startServer.start();
                        break;
                    }
                    case 1: {
                        StartClient startClient = new StartClient(this);
                        this.displayManager.next((Displayable)startClient);
                        startClient.start();
                        break;
                    }
                    case 2: {
                        this.displayManager.next(this.bluetoothHelp);
                    }
                }
            } else if (d == this.optionMenu) {
                switch (((List)this.optionMenu).getSelectedIndex()) {
                    case 0: {
                        Config.ENABLE_VIBRATION = !Config.ENABLE_VIBRATION;
                        String tmp1 = Config.ENABLE_VIBRATION ? "Yes" : "No";
                        ((List)this.optionMenu).set(0, "Vibration : " + tmp1, null);
                        break;
                    }
                    case 1: {
                        if ((Config.DEFAULT_PERCENT_OF_WATER += 5) > 95) {
                            Config.DEFAULT_PERCENT_OF_WATER = 5;
                        }
                        ((List)this.optionMenu).set(1, "% of Water : " + String.valueOf(Config.DEFAULT_PERCENT_OF_WATER) + "%", null);
                        break;
                    }
                    case 2: {
                        if ((Config.DEFAULT_SCORE_TO_WIN += 500) > 10000) {
                            Config.DEFAULT_SCORE_TO_WIN = 500;
                        }
                        ((List)this.optionMenu).set(2, "Max Score : " + String.valueOf(Config.DEFAULT_SCORE_TO_WIN), null);
                        break;
                    }
                    case 3: {
                        if ((Config.DEFAULT_MONEY_AT_START += 50) > 1000) {
                            Config.DEFAULT_MONEY_AT_START = 50;
                        }
                        ((List)this.optionMenu).set(3, "Default Money : " + String.valueOf(Config.DEFAULT_MONEY_AT_START), null);
                    }
                }
                this.saveParameters();
            } else if (d == this.helpMenu) {
                switch (((List)this.helpMenu).getSelectedIndex()) {
                    case 0: {
                        this.displayManager.next(this.commandsForm);
                        break;
                    }
                    case 1: {
                        this.displayManager.next(this.howToPlayForm);
                        break;
                    }
                    case 2: {
                        this.displayManager.next(this.buildingsAndWeaponsForm);
                    }
                }
            } else {
                this.displayManager.next(this.mainMenu);
            }
        }
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
        this.saveParameters();
        if (this.game != null) {
            this.game.stop();
        }
    }

    protected void pauseApp() {
    }

    public void startGameBegin() {
        this.game = new Game();
        this.game.setGameListener(this);
        this.mcModel = new MilCityModel(this.game, 0, 0, 240, 240, 8, new Size(2, 1));
        this.engine = new GameEngine(this.mcModel, 10);
        this.game.setEngine(this.engine);
        Displayable drawingArea = this.engine.getDrawingArea();
        drawingArea.setCommandListener((CommandListener)this);
        drawingArea.addCommand(this.resume);
        drawingArea.addCommand(this.pause);
        drawingArea.addCommand(this.exit);
    }

    public void startGameEnd() {
        MenuView mView = new MenuView(this.game, this.mcModel, GameEngine.keyToString(9), GameEngine.keyToString(10), GameEngine.keyToString(11), GameEngine.keyToString(12), this.imageDrawer);
        CursorView cView = new CursorView(this.mcModel);
        GridView gView = new GridView(8, this.imageDrawer, this.mcModel);
        this.engine.attach(mView);
        this.engine.attach(gView);
        this.engine.attach(cView);
        this.display.setCurrent(this.engine.getDrawingArea());
        this.game.start();
    }

    private void startSoloGame(int mode) {
        this.startGameBegin();
        this.game.registerLocalPlayer(new LocalPlayer());
        RandomWalkGridBuilder gb = new RandomWalkGridBuilder();
        Grid grid = ((GridBuilder)gb).build(Config.DEFAULT_GRID_SIZE_X, Config.DEFAULT_GRID_SIZE_Y, Config.DEFAULT_PERCENT_OF_WATER);
        gb = null;
        this.game.getLocalPlayer().setPlayerIndex(this.game.getLocalPlayerIndex());
        this.game.getLocalPlayer().setGame(this.game);
        this.game.getLocalPlayer().setGrid(grid);
        if (mode <= 3) {
            AIPlayer aiPlayer = new AIPlayer((byte)mode);
            aiPlayer.setGame(this.game);
            aiPlayer.setPlayerIndex(this.game.registerRemotePlayer(aiPlayer));
            aiPlayer.setGrid(new Grid(Config.DEFAULT_GRID_SIZE_X, Config.DEFAULT_GRID_SIZE_Y, grid.getGrid()));
            System.out.println(aiPlayer.getStatusGrid());
        }
        this.startGameEnd();
    }

    private List getMainScreen() {
        List list = new List("MilCity - Blue Edition", 3);
        list.append("Solo Game", null);
        list.append("Bluetooth Game", null);
        list.append("Options", null);
        list.append("Help", null);
        list.append("About", null);
        list.append("Exit", null);
        list.setCommandListener((CommandListener)this);
        list.addCommand(this.back);
        list.addCommand(this.next);
        list.setSelectCommand(this.next);
        return list;
    }

    private List getSoloScreen() {
        List list = new List("MilCity :: Solo Game", 3);
        list.append("Easy Mode", null);
        list.append("Medium Mode", null);
        list.append("Hard Mode", null);
        list.append("Madness Mode", null);
        list.append("Training Mode", null);
        list.setCommandListener((CommandListener)this);
        list.addCommand(this.back);
        list.addCommand(this.next);
        list.setSelectCommand(this.next);
        return list;
    }

    private List getMultiScreen() {
        List list = new List("MilCity :: Multiplayer Game", 3);
        list.append("As Server", null);
        list.append("As Client", null);
        list.append("What's that ?", null);
        list.setCommandListener((CommandListener)this);
        list.addCommand(this.back);
        list.addCommand(this.next);
        list.setSelectCommand(this.next);
        return list;
    }

    private List getOptionScreen() {
        List list = new List("MilCity :: Options", 3);
        String tmp = Config.ENABLE_VIBRATION ? "Yes" : "No";
        list.append("Vibration : " + tmp, null);
        list.append("% of Water : " + String.valueOf(Config.DEFAULT_PERCENT_OF_WATER) + "%", null);
        list.append("Max Score : " + String.valueOf(Config.DEFAULT_SCORE_TO_WIN), null);
        list.append("Default Money : " + String.valueOf(Config.DEFAULT_MONEY_AT_START), null);
        list.setCommandListener((CommandListener)this);
        list.addCommand(this.back);
        list.addCommand(this.next);
        list.setSelectCommand(this.next);
        return list;
    }

    private List getHelpMenu() {
        List list = new List("MilCity :: Help", 3);
        list.append("Commands", null);
        list.append("How To Play", null);
        list.append("Buildings", null);
        list.setCommandListener((CommandListener)this);
        list.addCommand(this.back);
        list.addCommand(this.next);
        list.setSelectCommand(this.next);
        return list;
    }

    private Form getCommandsForm() {
        Form form = new Form("MilCity :: Commands");
        StringBuffer sb = new StringBuffer();
        sb.append("Commands available in game :\n   ").append(GameEngine.keyToString(8)).append(" : Build / Fire.\n   ").append(GameEngine.keyToString(1)).append(" : Up.\n   ").append(GameEngine.keyToString(6)).append(" : Down.\n   ").append(GameEngine.keyToString(2)).append(" : Left.\n   ").append(GameEngine.keyToString(5)).append(" : Right.\n   ").append(GameEngine.keyToString(9)).append(" : Previous building / weapon.\n   ").append(GameEngine.keyToString(10)).append(" : Next building / weapon.\n   ").append(GameEngine.keyToString(11)).append(" : Previous playing mode.\n   ").append(GameEngine.keyToString(12)).append(" : Next playing mode.\n\n").append("In CITY mode, you can create buildings, and place shields if any.\n").append("In MILITARY mode, you can fire on target player with selected weapons.\n\n").append("Enjoy ^^");
        form.append(sb.toString());
        form.setCommandListener((CommandListener)this);
        form.addCommand(this.back);
        return form;
    }

    private Form getHowToPlayForm() {
        Form form = new Form("MilCity :: How to play");
        StringBuffer sb = new StringBuffer();
        sb.append("In MilCity, you have to build your own city and to destroy your opponents. The game is divided in two main modes : CITY mode, and MILITARY mode.\n\n").append("CITY MODE :\n").append("In CITY mode, you can build the city. For that, select building type you want to construct, and press the action key to build. The cursor is red when you can't build there, or when you don't have enough money.\n").append("Each building costs money and consumes energy. Amounts are located after the building name in building type selection menu.\n").append("If your energy amount went bellow 0, you cannot produce any weapons/shields, and construction times are doubled. If you can't construct enough PowerPlants to raise your energy amount over 0, you'll lose. Moreover, you have only ").append(Config.MAX_TIME_BELLOW_ZERO).append(" seconds to raise your energy level over 0, otherwise you'll lose.\n\n").append("MILITARY MODE :\n").append("In MILITARY mode, you can view a radar map which represents status of your opponent. Current player targeted is indicated after the word MILITARY in mode selection.\n").append("A BLUE cell means that there is water here, so it is useless to fire here.\n").append("A BLACK cell means that you haven't fired there.\n").append("A GREY cell mends that you've fired there, but nothing has been hit (or maybe there was a shield?). Grey intensity grows with time.\n").append("A RED cell meands that a building has been hit there, but not destroyed yet. \n").append("A GREEN cell means that a building has been destroyed there.\n").append("A YELLOW cell meands that something has been discovered there.\n").append("Cursor is green when you can fire with selected weapon, and red when you can't. You must have enough ammos to fire, and, regarding weapon power, you have to wait a certain time between each shots.\n\n").append("Enjoy ^^");
        form.append(sb.toString());
        form.setCommandListener((CommandListener)this);
        form.addCommand(this.back);
        return form;
    }

    private Form getBuildingsAndWeaponsForm() {
        Form form = new Form("MilCity :: Buildings");
        StringBuffer sb = new StringBuffer();
        sb.append("BUILDINGS :\n").append("   PowerPlant : Produces energy\n").append("   Refinery : Produces money\n").append("   House : Accelerates construction times, production and reuse delays\n").append("   Missile Silo : Produces missiles\n").append("   Factory : Produces mortars\n").append("   Air Field : Produces air crafts\n").append("   Nuke Silo : Produces nukes\n").append("   Laboratory : Produces spy satellites\n").append("   Shield Generator : Produces shields\n").append("   Shield : Proctects selected cells with a shield for ").append(Config.PRODUCTION_TIME_SHIELD).append("s\n\n").append("Enjoy ^^");
        form.append(sb.toString());
        form.setCommandListener((CommandListener)this);
        form.addCommand(this.back);
        return form;
    }

    private Form getAboutForm() {
        Form form = new Form("MilCity :: About");
        StringBuffer sb = new StringBuffer();
        sb.append("MilCity - Blue :\n").append("   Version ").append("1.0.5").append("\n\n").append("Developed by :\n").append("   J\u00e9r\u00e9my WALTHER\n").append("   golflima5@gmail.com\n\n").append("Website :\n").append("   https://sourceforge.net/projects/milcity/\n\n").append("This game is free, and distributed under GPL v3 license.");
        form.append(sb.toString());
        form.setCommandListener((CommandListener)this);
        form.addCommand(this.back);
        return form;
    }

    private Form getEndGameForm() {
        Form form = new Form("MilCity :: Game Over");
        StringBuffer sb = new StringBuffer();
        sb.append("Game Over\n\n");
        if (this.game.getWinnerIndex() != -1) {
            if (this.game.getWinnerIndex() == this.game.getLocalPlayerIndex()) {
                sb.append("   You WIN !\n\nYour Score is : ").append(this.game.getLocalPlayer().getScore());
            } else {
                sb.append("   You LOSE !\n\nYour Score is : ").append(this.game.getLocalPlayer().getScore()).append("\nWinner score is : ").append(this.game.getWinnerScore()).append("\n\nWINNER IS PLAYER ").append(this.game.getWinnerIndex() + 1);
            }
        }
        form.append(sb.toString());
        form.setCommandListener((CommandListener)this);
        form.addCommand(this.next);
        return form;
    }

    private Form getBluetoothHelpForm() {
        Form form = new Form("MilCity :: Bluetooth");
        StringBuffer sb = new StringBuffer();
        sb.append("Bluetooth help :\n\n").append("As Server : Host the game, and allow other players to join your party. You should host only if you have a recent phone.\n\n").append("As Client : Join a party hosted by another player. Suitable for all phones.\n\nEnjoy ^^");
        form.append(sb.toString());
        form.setCommandListener((CommandListener)this);
        form.addCommand(this.back);
        return form;
    }

    protected void saveParameters() {
        this.parametersStore = new ParametersStore("MilCityBlue_Config");
        String tmp = Config.ENABLE_SOUND ? "TRUE" : "FALSE";
        this.parametersStore.set(1, tmp);
        tmp = Config.ENABLE_VIBRATION ? "TRUE" : "FALSE";
        this.parametersStore.set(2, tmp);
        this.parametersStore.set(3, String.valueOf(Config.DEFAULT_PERCENT_OF_WATER));
        this.parametersStore.set(4, String.valueOf(Config.DEFAULT_SCORE_TO_WIN));
        this.parametersStore.set(5, String.valueOf(Config.DEFAULT_MONEY_AT_START));
        this.parametersStore.close();
        this.parametersStore = null;
    }

    public GameEngine getEngine() {
        return this.engine;
    }

    public void setEngine(GameEngine engine) {
        this.engine = engine;
    }

    public Game getGame() {
        return this.game;
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public MilCityModel getMcModel() {
        return this.mcModel;
    }

    public void setMcModel(MilCityModel mcModel) {
        this.mcModel = mcModel;
    }

    public DisplayManager getDisplayManager() {
        return this.displayManager;
    }

    public ImageDrawer getImageDrawer() {
        return this.imageDrawer;
    }

    public void notifyGameEvent(Game sender, byte eventType, int arg) {
        if (eventType == 4 || eventType == 5) {
            this.displayManager.next((Displayable)this.getEndGameForm());
        }
        if (eventType == 10 && Config.ENABLE_VIBRATION) {
            this.display.vibrate(arg);
        }
        System.out.println("GameListener : eventType = " + eventType);
    }
}

