/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.bluetooth;

import fr.uha.ensisa.ir.walther.milcityblue.MilCityBlue;
import fr.uha.ensisa.ir.walther.milcityblue.bluetooth.ClientServer;
import fr.uha.ensisa.ir.walther.milcityblue.core.Config;
import fr.uha.ensisa.ir.walther.milcityblue.core.Grid;
import fr.uha.ensisa.ir.walther.milcityblue.core.players.LocalPlayer;
import fr.uha.ensisa.ir.walther.milcityblue.core.players.RemotePlayer;
import java.io.InputStream;
import java.io.OutputStream;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Form;

public class StartClient
extends Form
implements Runnable,
DiscoveryListener {
    private UUID RFCOMM_UUID;
    private DiscoveryAgent discoveryAgent;
    private LocalDevice localDevice;
    private boolean isFinished;
    private String serverUrl;
    private boolean serverFound;
    private StreamConnection streamConnection;
    private InputStream inputStream;
    private OutputStream outputStream;
    private boolean isClientConnected;
    private MilCityBlue MCB;

    public StartClient(MilCityBlue MCB) {
        super("MilCity :: Client");
        this.MCB = MCB;
        this.RFCOMM_UUID = new UUID(3L);
        this.discoveryAgent = null;
        this.localDevice = null;
        this.isFinished = false;
        this.serverUrl = null;
        this.serverFound = false;
        this.streamConnection = null;
        this.inputStream = null;
        this.outputStream = null;
        this.isClientConnected = false;
    }

    public void run() {
        try {
            this.localDevice = LocalDevice.getLocalDevice();
            this.discoveryAgent = this.localDevice.getDiscoveryAgent();
            this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void start() {
        this.isFinished = false;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void waitUntilFinished() {
        while (!this.isFinished) {
            Thread.yield();
        }
    }

    public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
        try {
            System.out.println("Device Discovered");
            System.out.println("Major Device Class: " + cod.getMajorDeviceClass() + " Minor Device Class: " + cod.getMinorDeviceClass());
            System.out.println("Bluetooth Address: " + btDevice.getBluetoothAddress());
            System.out.println("Bluetooth Friendly Name: " + btDevice.getFriendlyName(true));
            UUID[] uuidSet = new UUID[]{this.RFCOMM_UUID};
            this.discoveryAgent.searchServices(null, uuidSet, btDevice, (DiscoveryListener)this);
        }
        catch (Exception e) {
            System.out.println("Device Discovered Error: " + e);
        }
    }

    public void inquiryCompleted(int discType) {
        this.setTitle("MilCity :: Client");
    }

    public void serviceSearchCompleted(int transID, int respCode) {
        System.out.println("serviceSearchCompleted called");
        if (this.serverFound) {
            try {
                this.append("Server found, trying to establish a connection ...");
                this.streamConnection = (StreamConnection)Connector.open((String)this.serverUrl);
                this.outputStream = this.streamConnection.openOutputStream();
                this.inputStream = this.streamConnection.openInputStream();
                System.out.println("Client Connection Openned");
                this.append("Connection openned. Initializing game ...");
                ClientServer cs = new ClientServer(this.inputStream, this.outputStream);
                Config.DEFAULT_SCORE_TO_WIN = Integer.parseInt(cs.receiveString());
                Config.DEFAULT_MONEY_AT_START = Integer.parseInt(cs.receiveString());
                System.out.println("serviceSearchCompleted");
                this.MCB.startGameBegin();
                RemotePlayer remotePlayer = new RemotePlayer(cs);
                Grid grid = cs.receiveGrid();
                this.MCB.getGame().registerRemotePlayer(remotePlayer);
                remotePlayer.setGame(this.MCB.getGame());
                remotePlayer.setPlayerIndex(this.MCB.getGame().getIndexOfPlayer(remotePlayer));
                remotePlayer.setGrid(grid);
                this.MCB.getGame().registerLocalPlayer(new LocalPlayer());
                this.MCB.getGame().getLocalPlayer().setGame(this.MCB.getGame());
                this.MCB.getGame().getLocalPlayer().setPlayerIndex(this.MCB.getGame().getLocalPlayerIndex());
                this.MCB.getGame().getLocalPlayer().setGrid(grid);
                this.append("Starting Game ...");
                this.MCB.startGameEnd();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void servicesDiscovered(int transID, ServiceRecord[] records) {
        int i = 0;
        while (i < records.length) {
            if (records[i].getConnectionURL(2, false).startsWith("btspp")) {
                int j = 0;
                while (j < records[i].getAttributeIDs().length) {
                    System.out.println(records[i].getAttributeIDs()[j]);
                    ++j;
                }
                this.serverUrl = records[i].getConnectionURL(2, false);
                System.out.println(this.serverUrl);
                this.serverFound = true;
                System.out.println("Client Initialized");
                break;
            }
            ++i;
        }
    }

    public boolean isClientConnected() {
        return this.isClientConnected;
    }
}

