/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.bluetooth;

import fr.uha.ensisa.ir.walther.milcityblue.MilCityBlue;
import fr.uha.ensisa.ir.walther.milcityblue.bluetooth.ClientServer;
import fr.uha.ensisa.ir.walther.milcityblue.core.Config;
import fr.uha.ensisa.ir.walther.milcityblue.core.Grid;
import fr.uha.ensisa.ir.walther.milcityblue.core.GridBuilder;
import fr.uha.ensisa.ir.walther.milcityblue.core.gridbuilders.RandomWalkGridBuilder;
import fr.uha.ensisa.ir.walther.milcityblue.core.players.LocalPlayer;
import fr.uha.ensisa.ir.walther.milcityblue.core.players.RemotePlayer;
import java.io.InputStream;
import java.io.OutputStream;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;
import javax.microedition.lcdui.Form;

public class StartServer
extends Form
implements Runnable {
    private UUID RFCOMM_UUID;
    private String serverUrl;
    private StreamConnection streamConnection;
    private LocalDevice localDevice;
    private InputStream inputStream;
    private OutputStream outputStream;
    private StreamConnectionNotifier streamConnectionNotifier;
    private boolean isServerStarted;
    private boolean isClientConnected;
    private boolean isFinished;
    private MilCityBlue MCB;

    public StartServer(MilCityBlue MCB) {
        super("MilCity :: Server");
        this.MCB = MCB;
        this.RFCOMM_UUID = new UUID(3L);
        this.serverUrl = "btspp://localhost:" + this.RFCOMM_UUID + ";name=milcityrfcomm;authorize=true";
        this.streamConnection = null;
        this.localDevice = null;
        this.inputStream = null;
        this.outputStream = null;
        this.streamConnectionNotifier = null;
        this.isServerStarted = false;
        this.isFinished = false;
        this.isClientConnected = false;
    }

    public void run() {
        try {
            this.localDevice = LocalDevice.getLocalDevice();
            this.localDevice.setDiscoverable(10390323);
            this.streamConnectionNotifier = (StreamConnectionNotifier)Connector.open((String)this.serverUrl);
            this.append("Server initialized.");
            this.append("Waiting for another player ...");
            this.isServerStarted = true;
            ClientServer cs = null;
            this.streamConnection = this.streamConnectionNotifier.acceptAndOpen();
            this.append("Player connected.");
            this.outputStream = this.streamConnection.openOutputStream();
            this.inputStream = this.streamConnection.openInputStream();
            cs = new ClientServer(this.inputStream, this.outputStream);
            this.append("Player accepted.");
            this.streamConnectionNotifier.close();
            this.append("Starting Game ...");
            cs.send(String.valueOf(Config.DEFAULT_SCORE_TO_WIN));
            cs.send(String.valueOf(Config.DEFAULT_MONEY_AT_START));
            this.MCB.startGameBegin();
            this.MCB.getGame().registerLocalPlayer(new LocalPlayer());
            RandomWalkGridBuilder gb = new RandomWalkGridBuilder();
            Grid grid = ((GridBuilder)gb).build(Config.DEFAULT_GRID_SIZE_X, Config.DEFAULT_GRID_SIZE_Y, Config.DEFAULT_PERCENT_OF_WATER);
            gb = null;
            this.MCB.getGame().getLocalPlayer().setGame(this.MCB.getGame());
            this.MCB.getGame().getLocalPlayer().setPlayerIndex(this.MCB.getGame().getLocalPlayerIndex());
            this.MCB.getGame().getLocalPlayer().setGrid(grid);
            RemotePlayer remotePlayer = new RemotePlayer(cs);
            this.MCB.getGame().registerRemotePlayer(remotePlayer);
            remotePlayer.setPlayerIndex(this.MCB.getGame().getIndexOfPlayer(remotePlayer));
            remotePlayer.setGame(this.MCB.getGame());
            remotePlayer.setGrid(grid);
            cs.send(grid);
            this.MCB.startGameEnd();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isFinished = true;
    }

    public void start() {
        this.isFinished = false;
        this.isServerStarted = false;
        this.isClientConnected = false;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void waitUntilFinished() {
        while (!this.isFinished) {
            Thread.yield();
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public boolean isServerStarted() {
        return this.isServerStarted;
    }

    public boolean isClientConnected() {
        return this.isClientConnected;
    }
}

