/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.core;

import fr.uha.ensisa.ir.walther.milcityblue.core.Cell;
import fr.uha.ensisa.ir.walther.milcityblue.core.Size;

public class Cells {
    private Cells next;
    private Cell value;

    public Cells(Cell value, Cells next) {
        this.value = value;
        this.next = next;
    }

    public Cells() {
        this.value = null;
        this.next = null;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public void push(Cell value) {
        if (this.hasNext()) {
            this.next.push(value);
        } else {
            this.next = new Cells(value, null);
        }
    }

    public boolean isHit(int x, int y) {
        if (this.value == null && this.hasNext()) {
            return this.next.isHit(x, y);
        }
        if (this.value.isHit(x, y)) {
            return true;
        }
        if (this.hasNext()) {
            return this.next.isHit(x, y);
        }
        return false;
    }

    public boolean isDestroyed() {
        if (this.value == null && this.hasNext()) {
            return this.next.isDestroyed();
        }
        if (this.value.isDestroyed()) {
            if (this.hasNext()) {
                return this.next.isDestroyed();
            }
            return true;
        }
        return false;
    }

    public Cells next() {
        if (this.next != null) {
            return this.next;
        }
        return null;
    }

    public void setNext(Cells next) {
        this.next = next;
    }

    public Cell value() {
        return this.value;
    }

    public void setValue(Cell value) {
        this.value = value;
    }

    public static Cells createCells(Size size, int type, int x, int y, int r) {
        Cells cells = new Cells();
        int j = 0;
        while (j < y) {
            int i = 0;
            while (i < x) {
                cells.push(new Cell(type, x + i, y + j));
                ++i;
            }
            ++j;
        }
        return cells;
    }
}

