/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.core;

import fr.uha.ensisa.ir.walther.milcityblue.core.Building;
import fr.uha.ensisa.ir.walther.milcityblue.core.Buildings;
import fr.uha.ensisa.ir.walther.milcityblue.core.BuildingsIterator;
import fr.uha.ensisa.ir.walther.milcityblue.core.Cell;
import fr.uha.ensisa.ir.walther.milcityblue.core.Cells;
import fr.uha.ensisa.ir.walther.milcityblue.core.CellsIterator;
import fr.uha.ensisa.ir.walther.milcityblue.core.Config;
import fr.uha.ensisa.ir.walther.milcityblue.core.Game;
import fr.uha.ensisa.ir.walther.milcityblue.core.Grid;
import fr.uha.ensisa.ir.walther.milcityblue.core.PlayerInterface;
import fr.uha.ensisa.ir.walther.milcityblue.core.Size;
import fr.uha.ensisa.ir.walther.milcityblue.core.StatusGrid;
import fr.uha.ensisa.ir.walther.milcityblue.core.TimedCell;
import fr.uha.ensisa.ir.walther.milcityblue.core.Weapon;
import fr.uha.ensisa.ir.walther.milcityblue.core.WeaponFactory;
import fr.uha.ensisa.ir.walther.milcityblue.core.commands.Command;
import java.util.Enumeration;

public abstract class PlayerAbstract
implements PlayerInterface {
    protected int playerIndex = 100;
    protected int accelerationFactor = 0;
    protected int destroyedBuildings = 0;
    protected int destroyedCells = 0;
    protected int score = 0;
    protected int scoreToWin = Config.DEFAULT_SCORE_TO_WIN;
    protected int energy = 0;
    protected int money = Config.DEFAULT_MONEY_AT_START;
    protected int ammoMissiles = 0;
    protected int ammoShields = 0;
    protected int ammoAirCrafts = 0;
    protected int ammoMortars = 0;
    protected int ammoSpies = 0;
    protected int ammoNukes = 0;
    protected int constructedBuildings = 0;
    protected long firstBuildingConstructedAt = 0L;
    protected long cannotFireBefore = 0L;
    protected long energyBellowZeroSince = System.currentTimeMillis();
    protected Game game = null;
    protected Grid grid = null;
    protected StatusGrid statusGrid = null;
    protected boolean hasLoose = false;
    protected boolean hasWon = false;
    protected boolean energyBellowZero = true;

    public void fire(Command commandFire) {
        if (commandFire.getPlayerTarget() == this.playerIndex && this.grid != null) {
            int weaponType = commandFire.getParameters()[0];
            int x = commandFire.getParameters()[1];
            int y = commandFire.getParameters()[2];
            int r = commandFire.getParameters()[3];
            if (this.grid.getWeaponFactory().canCreateWeapon(weaponType, x, y, r)) {
                Weapon weapon = this.grid.getWeaponFactory().createWeapon(weaponType, x, y, r);
                if (weaponType == 202 && commandFire.getPlayerSender() == this.playerIndex) {
                    if (this.ammoShields > 0) {
                        --this.ammoShields;
                        this.game.execute(weapon.makeEffect(this, commandFire.getPlayerSender()));
                    }
                } else {
                    this.game.execute(weapon.makeEffect(this, commandFire.getPlayerSender()));
                    System.out.println(String.valueOf(this.playerIndex) + " : I've got a fucking bullet in my fucking ass from " + commandFire.getPlayerSender() + " !");
                }
            }
        }
    }

    public void fireOnAnotherPlayer(Command commandFire) {
        PlayerInterface anotherPlayer;
        int r;
        int y;
        int x;
        int weaponType;
        if (commandFire.getPlayerSender() == this.playerIndex && System.currentTimeMillis() >= this.cannotFireBefore && WeaponFactory.canCreateWeapon(weaponType = commandFire.getParameters()[0], x = commandFire.getParameters()[1], y = commandFire.getParameters()[2], r = commandFire.getParameters()[3], (anotherPlayer = this.game.getRemotePlayer(commandFire.getPlayerTarget())).getStatusGrid().getMaxX(), anotherPlayer.getStatusGrid().getMaxY()) && this.getAmmoForWeaponType(weaponType) > 0) {
            this.setAmmoForWeaponType(weaponType, this.getAmmoForWeaponType(weaponType) - 1);
            Size size = WeaponFactory.getSizeOfWeapon(weaponType);
            this.cannotFireBefore = System.currentTimeMillis() + (long)(1000 * size.getSizeX() * size.getSizeY()) - (long)(this.accelerationFactor * (10 * size.getSizeX() * size.getSizeY()));
            anotherPlayer.fire(commandFire);
            System.out.println(String.valueOf(this.playerIndex) + " : I've got a bullet ! Fired on " + anotherPlayer.getPlayerIndex());
        }
    }

    public void constructBuilding(int type, int x, int y, int r) {
        int cost = 0;
        cost = this.grid.getBuildingFactory().getCostOfBuilding(type);
        if (this.money >= cost && this.grid.construct(type, x, y, r)) {
            this.money -= cost;
            ++this.constructedBuildings;
            if (this.constructedBuildings == 1) {
                this.firstBuildingConstructedAt = System.currentTimeMillis();
                this.energyBellowZeroSince = System.currentTimeMillis();
            }
        }
    }

    public boolean hasEnoughMoneyToBuild(int buildingType) {
        switch (buildingType) {
            case 104: {
                return this.money >= Config.CONSTRUCTION_COST_AIRFIELD;
            }
            case 108: {
                return this.money >= Config.CONSTRUCTION_COST_COMMERCIAL;
            }
            case 106: {
                return this.money >= Config.CONSTRUCTION_COST_FACTORY;
            }
            case 107: {
                return this.money >= Config.CONSTRUCTION_COST_HOUSE;
            }
            case 105: {
                return this.money >= Config.CONSTRUCTION_COST_LABORATORY;
            }
            case 101: {
                return this.money >= Config.CONSTRUCTION_COST_MISSILESILO;
            }
            case 109: {
                return this.money >= Config.CONSTRUCTION_COST_NUKESILO;
            }
            case 103: {
                return this.money >= Config.CONSTRUCTION_COST_POWERPLANT;
            }
            case 102: {
                return this.money >= Config.CONSTRUCTION_COST_SHIELDGENERATOR;
            }
        }
        return false;
    }

    public boolean hasEnoughAmmoToFire(int weaponType) {
        return this.getAmmoForWeaponType(weaponType) > 0;
    }

    public boolean hasLoose(Buildings buildings) {
        if (this.hasLoose) {
            return true;
        }
        if (this.energyBellowZero && this.energy <= 0 && this.constructedBuildings > 0) {
            if (this.energyBellowZeroSince + (long)(Config.MAX_TIME_BELLOW_ZERO * 1000) < System.currentTimeMillis()) {
                this.hasLoose = true;
                System.out.println("Player loose because he spent to much time bellow zero energy level.");
            } else {
                int neededPowerplants = (int)Math.ceil((double)(-this.energy) / (double)Config.ENERGY_POWERPLANT);
                System.out.println(String.valueOf(this.playerIndex) + " : NEEDED POWERPLANTS = " + neededPowerplants);
                boolean bl = this.hasLoose = this.money < neededPowerplants * Config.CONSTRUCTION_COST_POWERPLANT;
            }
        }
        if (this.hasLoose) {
            int[] params = new int[]{this.score};
            this.game.execute(new Command(this.playerIndex, 200, 9, params));
            System.out.println(String.valueOf(this.playerIndex) + " : YOU LOSE !");
            if (this.game.getNumberOfPlayers() == 1) {
                this.game.end();
            }
        }
        return this.hasLoose;
    }

    public boolean hasLoose() {
        return this.hasLoose;
    }

    public boolean hasWon() {
        if (this.hasWon) {
            return true;
        }
        if (this.score >= this.scoreToWin) {
            this.hasWon = true;
        } else {
            Enumeration players = this.game.getPlayers();
            int playerLooseCount = 0;
            while (players.hasMoreElements()) {
                PlayerInterface player = (PlayerInterface)players.nextElement();
                if (player.getPlayerIndex() == this.playerIndex || !player.hasLoose()) continue;
                ++playerLooseCount;
            }
            boolean bl = this.hasWon = playerLooseCount == this.game.getNumberOfPlayers() - 1 && this.game.getNumberOfPlayers() > 1;
        }
        if (this.hasWon) {
            int[] params = new int[]{this.score};
            this.game.execute(new Command(this.playerIndex, 200, 8, params));
            System.out.println(String.valueOf(this.playerIndex) + " : YOU WIN !");
        }
        return this.hasWon;
    }

    public void updateProduction(Building building) {
        if (this.energy > 0) {
            switch (building.getProductionType()) {
                case 201: {
                    ++this.ammoMissiles;
                    break;
                }
                case 202: {
                    ++this.ammoShields;
                    break;
                }
                case 203: {
                    ++this.ammoAirCrafts;
                    break;
                }
                case 204: {
                    ++this.ammoMortars;
                    break;
                }
                case 206: {
                    ++this.ammoSpies;
                    break;
                }
                case 205: {
                    ++this.ammoNukes;
                }
            }
        }
    }

    public void updateConstruction(Building building) {
        CellsIterator it = new CellsIterator(building.getCells());
        while (it.hasNext()) {
            Cell cell = it.next();
            this.grid.setCell(cell.getType(), cell.getX(), cell.getY());
        }
    }

    public void updateShields() {
        CellsIterator it = new CellsIterator(this.grid.getShieldedCells());
        Cells cells = new Cells();
        while (it.hasNext()) {
            TimedCell timedCell = (TimedCell)it.next();
            if (timedCell.isOver()) {
                this.grid.setCell(timedCell.getType(), timedCell.getX(), timedCell.getY());
                continue;
            }
            cells.push(timedCell);
        }
        this.grid.setShieldedCells(cells);
    }

    public void computeEnergy(Buildings buildings) {
        BuildingsIterator it = new BuildingsIterator(buildings);
        int count = 0;
        Building building = null;
        while (it.hasNext()) {
            building = it.next();
            if (building.getState() != 1) continue;
            count += building.getEnergy();
        }
        if (this.energy > 0 && count <= 0) {
            this.energyBellowZero = true;
            this.energyBellowZeroSince = System.currentTimeMillis();
        } else if (count > 0) {
            this.energyBellowZero = false;
        }
        this.energy = count;
    }

    public void computeMoney(Buildings buildings) {
        if (this.energy > 0) {
            BuildingsIterator it = new BuildingsIterator(buildings);
            int count = 0;
            Building building = null;
            while (it.hasNext()) {
                building = it.next();
                if (building.getState() != 1 || building.getType() != 108) continue;
                ++count;
            }
            this.money += count * Config.MONEY_EARNED_PER_SECOND;
        }
    }

    public void computeAccelerationFactor(Buildings buildings) {
        if (this.energy > 0) {
            BuildingsIterator it = new BuildingsIterator(buildings);
            int count = 0;
            Building building = null;
            while (it.hasNext()) {
                building = it.next();
                if (building.getState() != 1 || building.getType() != 107) continue;
                ++count;
            }
            this.accelerationFactor = count * Config.ACCELERATION_FACTOR_PER_HOUSE;
            if (this.accelerationFactor > 50) {
                this.accelerationFactor = 50;
            }
        } else {
            this.accelerationFactor = -200;
        }
    }

    public int getAccelerationFactor() {
        return this.accelerationFactor;
    }

    public void setAccelerationFactor(int accelerationFactor) {
        this.accelerationFactor = accelerationFactor;
    }

    public int getDestroyedBuildings() {
        return this.destroyedBuildings;
    }

    public void setDestroyedBuildings(int destroyedBuildings) {
        this.destroyedBuildings = destroyedBuildings;
    }

    public int getDestroyedCells() {
        return this.destroyedCells;
    }

    public void setDestroyedCells(int destroyedCells) {
        this.destroyedCells = destroyedCells;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public int getScoreToWin() {
        return this.scoreToWin;
    }

    public void setScoreToWin(int scoreToWin) {
        this.scoreToWin = scoreToWin;
    }

    public int getMoney() {
        return this.money;
    }

    public void setMoney(int money) {
        this.money = money;
    }

    public int getAmmoMissiles() {
        return this.ammoMissiles;
    }

    public void setAmmoMissiles(int ammoMissiles) {
        this.ammoMissiles = ammoMissiles;
    }

    public int getAmmoAirCrafts() {
        return this.ammoAirCrafts;
    }

    public void setAmmoAirCrafts(int ammoAirCrafts) {
        this.ammoAirCrafts = ammoAirCrafts;
    }

    public int getAmmoMortars() {
        return this.ammoMortars;
    }

    public void setAmmoMortars(int ammoMortars) {
        this.ammoMortars = ammoMortars;
    }

    public int getAmmoSpies() {
        return this.ammoSpies;
    }

    public void setAmmoSpies(int ammoSpies) {
        this.ammoSpies = ammoSpies;
    }

    public int getAmmoNukes() {
        return this.ammoNukes;
    }

    public void setAmmoNukes(int ammoNukes) {
        this.ammoNukes = ammoNukes;
    }

    public Game getGame() {
        return this.game;
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public Grid getGrid() {
        return this.grid;
    }

    public void setGrid(Grid grid) {
        this.grid = grid;
        this.statusGrid = new StatusGrid(this.playerIndex, grid, this.game);
    }

    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public int getAmmoShields() {
        return this.ammoShields;
    }

    public void setAmmoShields(int ammoShields) {
        this.ammoShields = ammoShields;
    }

    public int getAmmoForWeaponType(int type) {
        switch (type) {
            case 201: {
                return this.ammoMissiles;
            }
            case 204: {
                return this.ammoMortars;
            }
            case 203: {
                return this.ammoAirCrafts;
            }
            case 205: {
                return this.ammoNukes;
            }
            case 206: {
                return this.ammoSpies;
            }
            case 202: {
                return this.ammoShields;
            }
        }
        return 0;
    }

    public void setAmmoForWeaponType(int type, int ammo) {
        switch (type) {
            case 201: {
                this.ammoMissiles = ammo;
                break;
            }
            case 204: {
                this.ammoMortars = ammo;
                break;
            }
            case 203: {
                this.ammoAirCrafts = ammo;
                break;
            }
            case 205: {
                this.ammoNukes = ammo;
                break;
            }
            case 206: {
                this.ammoSpies = ammo;
                break;
            }
            case 202: {
                this.ammoShields = ammo;
            }
        }
    }

    public void start() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public boolean isLocal() {
        return true;
    }

    public void sendCommand(Command command) {
    }

    public int getPlayerIndex() {
        return this.playerIndex;
    }

    public StatusGrid getStatusGrid() {
        return this.statusGrid;
    }

    public void setPlayerIndex(int playerIndex) {
        this.playerIndex = playerIndex;
        if (this.statusGrid != null) {
            this.statusGrid.setPlayerIndex(playerIndex);
        }
    }

    public void win() {
        this.hasWon = true;
    }

    public void lose() {
        this.hasLoose = true;
    }

    public int getConstructedBuildings() {
        return this.constructedBuildings;
    }

    public long getFirstBuildingConstructedAt() {
        return this.firstBuildingConstructedAt;
    }

    public long getCannotFireBefore() {
        return this.cannotFireBefore;
    }

    public long getEnergyBellowZeroSince() {
        return this.energyBellowZeroSince;
    }

    public boolean isEnergyBellowZero() {
        return this.energyBellowZero;
    }
}

