/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.core;

import fr.uha.ensisa.ir.walther.milcityblue.core.Config;
import fr.uha.ensisa.ir.walther.milcityblue.core.Game;
import fr.uha.ensisa.ir.walther.milcityblue.core.Grid;
import fr.uha.ensisa.ir.walther.milcityblue.core.commands.Command;
import fr.uha.ensisa.ir.walther.milcityblue.core.commands.Commands;
import fr.uha.ensisa.ir.walther.milcityblue.core.commands.CommandsIterator;

public class StatusGrid {
    public static final byte STATUS_WATER = 0;
    public static final byte STATUS_GROUND = 1;
    public static final byte STATUS_BUILDINGHIT = 2;
    public static final byte STATUS_BUILDINGDESTROYED = 3;
    public static final byte STATUS_BUILDINGDISCOVERED = 4;
    public static final byte STATUS_CELLHIT_MAX = -1;
    public static final byte STATUS_CELLHIT_MIN = -128;
    private byte[][] grid;
    private int playerIndex;
    private Game game;
    private int maxX;
    private int maxY;

    public StatusGrid(int playerIndex, Grid grid, Game game) {
        this.playerIndex = playerIndex;
        this.grid = new byte[grid.getMaxX()][grid.getMaxY()];
        this.game = game;
        this.maxX = grid.getMaxX();
        this.maxY = grid.getMaxY();
        this.update(grid);
    }

    public void update(Grid grid) {
        if (this.maxX == grid.getMaxX() && this.maxY == grid.getMaxY()) {
            int y = 0;
            while (y < this.maxY) {
                int x = 0;
                while (x < this.maxX) {
                    this.grid[x][y] = grid.getCell(x, y) == 1 ? (byte)0 : 1;
                    ++x;
                }
                ++y;
            }
        }
    }

    public void update(Commands commands) {
        CommandsIterator it = new CommandsIterator(commands);
        while (it.hasNext()) {
            this.update(it.next());
        }
    }

    public void update(Command command) {
        block12: {
            block11: {
                if (this.playerIndex != command.getPlayerSender()) break block11;
                System.out.println("StatusGrid of player number " + this.playerIndex + " updated");
                switch (command.getCommandType()) {
                    case 6: {
                        if (command.getParameter(1) == 100) {
                            this.grid[command.getParameter((int)2)][command.getParameter((int)3)] = -1;
                            break;
                        }
                        if (this.grid[command.getParameter(2)][command.getParameter(3)] != 2) {
                            this.grid[command.getParameter((int)2)][command.getParameter((int)3)] = 2;
                            int[] params = new int[]{Config.SCORE_PER_BUILDING_HIT_CELL};
                            this.game.execute(new Command(this.playerIndex, this.game.getOtherPlayerIndex(this.playerIndex), 13, params));
                            break;
                        }
                        break block12;
                    }
                    case 7: {
                        if (this.grid[command.getParameter(2)][command.getParameter(3)] != 3) {
                            this.grid[command.getParameter((int)2)][command.getParameter((int)3)] = 3;
                            int[] params = new int[]{Config.SCORE_PER_BUILDING_DESTROYED_CELL};
                            this.game.execute(new Command(this.playerIndex, this.game.getOtherPlayerIndex(this.playerIndex), 13, params));
                            break;
                        }
                        break block12;
                    }
                    case 10: {
                        if ((command.getParameter(0) < 3 || command.getParameter(0) >= 28) && command.getParameter(0) != 255 || this.grid[command.getParameter(1)][command.getParameter(2)] == 2 || this.grid[command.getParameter(1)][command.getParameter(2)] == 3) break block12;
                        this.grid[command.getParameter((int)1)][command.getParameter((int)2)] = 4;
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block12;
            }
            System.out.println("StatusGrid of player number " + this.playerIndex + " not updating because command is addressed to player number " + command.getPlayerSender());
        }
    }

    public byte[][] getStatusGrid() {
        return this.grid;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public byte getCellStatusAt(int x, int y) {
        if (x >= 0 && x < this.maxX && y >= 0 && y < this.maxY) {
            return this.grid[x][y];
        }
        return 0;
    }

    public void decrementCellHitAt(int x, int y) {
        if (x >= 0 && x < this.maxX && y >= 0 && y < this.maxY && this.grid[x][y] > -128) {
            byte[] byArray = this.grid[x];
            int n = y;
            byArray[n] = (byte)(byArray[n] - 1);
        }
    }

    public int getPlayerIndex() {
        return this.playerIndex;
    }

    public void setPlayerIndex(int playerIndex) {
        this.playerIndex = playerIndex;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        int y = 0;
        while (y < this.maxY) {
            int x = 0;
            while (x < this.maxX) {
                tmp.append(this.grid[x][y]);
                ++x;
            }
            tmp.append('\n');
            ++y;
        }
        return tmp.toString();
    }
}

