/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.core;

import fr.uha.ensisa.ir.walther.milcityblue.core.Grid;
import fr.uha.ensisa.ir.walther.milcityblue.core.Size;
import fr.uha.ensisa.ir.walther.milcityblue.core.Weapon;
import fr.uha.ensisa.ir.walther.milcityblue.core.weapons.Aircraft;
import fr.uha.ensisa.ir.walther.milcityblue.core.weapons.Missile;
import fr.uha.ensisa.ir.walther.milcityblue.core.weapons.Mortar;
import fr.uha.ensisa.ir.walther.milcityblue.core.weapons.Nuke;
import fr.uha.ensisa.ir.walther.milcityblue.core.weapons.Shield;
import fr.uha.ensisa.ir.walther.milcityblue.core.weapons.Spy;

public class WeaponFactory {
    private Grid grid;

    public WeaponFactory(Grid grid) {
        this.grid = grid;
    }

    public boolean canCreateWeapon(int type, int x, int y, int r) {
        Weapon weapon = WeaponFactory.typeToWeapon(type, x, y, r);
        return this.canCreateWeapon(weapon, x, y, r);
    }

    public boolean canCreateWeapon(Weapon weapon, int x, int y, int r) {
        return weapon.getSize().isInGridAt(this.grid, x, y, r);
    }

    public static boolean canCreateWeapon(int type, int x, int y, int r, int maxX, int maxY) {
        Weapon weapon = WeaponFactory.typeToWeapon(type, x, y, r);
        return weapon.getSize().isInGridAt(maxX, maxY, x, y, r);
    }

    public Weapon createWeapon(int type, int x, int y, int r) {
        Weapon weapon = WeaponFactory.typeToWeapon(type, x, y, r);
        if (weapon == null) {
            System.out.println("Unreconized weapon #" + type);
            return null;
        }
        if (!this.canCreateWeapon(weapon, x, y, r)) {
            System.out.println("Cannot create here");
            return null;
        }
        return weapon;
    }

    public static Weapon typeToWeapon(int type, int x, int y, int r) {
        switch (type) {
            case 203: {
                return new Aircraft(x, y, r);
            }
            case 201: {
                return new Missile(x, y, r);
            }
            case 204: {
                return new Mortar(x, y, r);
            }
            case 205: {
                return new Nuke(x, y, r);
            }
            case 202: {
                return new Shield(x, y, r);
            }
            case 206: {
                return new Spy(x, y, r);
            }
        }
        System.out.println("Unreconized weapon #" + type);
        return null;
    }

    public static Size getSizeOfWeapon(int type) {
        return WeaponFactory.typeToWeapon(type, 0, 0, 0).getSize();
    }
}

