/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.core.buildings;

import fr.uha.ensisa.ir.walther.milcityblue.core.Building;
import fr.uha.ensisa.ir.walther.milcityblue.core.Cell;
import fr.uha.ensisa.ir.walther.milcityblue.core.Config;
import fr.uha.ensisa.ir.walther.milcityblue.core.PlayerAbstract;
import fr.uha.ensisa.ir.walther.milcityblue.core.Size;

public class PowerPlant
extends Building {
    public PowerPlant(int x, int y, int r) {
        this.cells.push(new Cell(6, x, y));
        this.cells.push(new Cell(7, x + 1, y));
    }

    public void update(PlayerAbstract player) {
        long currentTime = System.currentTimeMillis();
        if (this.state == 0 && currentTime - this.createdOn >= (long)(1000 * this.getConstructionTime())) {
            this.state = 1;
            player.updateConstruction(this);
        }
    }

    public int getType() {
        return 103;
    }

    public int getConstructionTime() {
        return Config.CONSTRUCTION_TIME_POWERPLANT;
    }

    public int getEnergy() {
        return Config.ENERGY_POWERPLANT;
    }

    public int getProductionTime() {
        return Config.PRODUCTION_TIME_NULL;
    }

    public int getProductionType() {
        return 200;
    }

    public Size getSize() {
        return new Size(2, 1);
    }

    public int getConstructionCost() {
        return Config.CONSTRUCTION_COST_POWERPLANT;
    }
}

