/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.core.commands;

import fr.uha.ensisa.ir.walther.milcityblue.core.Game;
import fr.uha.ensisa.ir.walther.milcityblue.core.PlayerAbstract;
import fr.uha.ensisa.ir.walther.milcityblue.core.commands.Command;
import fr.uha.ensisa.ir.walther.milcityblue.core.commands.Commands;
import fr.uha.ensisa.ir.walther.milcityblue.core.commands.CommandsIterator;

public class Commander {
    private Game game;

    public Commander(Game game) {
        this.game = game;
    }

    public void execute(Command command) {
        PlayerAbstract player = this.game.getLocalPlayer();
        if (command.getPlayerTarget() == this.game.getLocalPlayerIndex()) {
            switch (command.getCommandType()) {
                case 5: {
                    player.fire(command);
                    break;
                }
                case 13: {
                    player.setScore(player.getScore() + command.getParameter(0));
                    break;
                }
                case 10: {
                    this.game.getPlayerAt(command.getPlayerSender()).getStatusGrid().update(command);
                }
            }
        }
        if (command.getPlayerTarget() == 200) {
            switch (command.getCommandType()) {
                case 6: {
                    System.out.println("Begin GridStatus update");
                    this.game.getPlayerAt(command.getPlayerSender()).getStatusGrid().update(command);
                    System.out.println("GridStatus updated");
                    break;
                }
                case 7: {
                    this.game.getPlayerAt(command.getPlayerSender()).getStatusGrid().update(command);
                    break;
                }
                case 2: {
                    this.game.setStatus((byte)1);
                    break;
                }
                case 3: {
                    this.game.setStatus((byte)2);
                    break;
                }
                case 4: {
                    this.game.setStatus((byte)1);
                    break;
                }
                case 12: {
                    this.game.setStatus((byte)3);
                    break;
                }
                case 8: {
                    this.game.getPlayerAt(command.getPlayerSender()).win();
                    this.game.setWinnerIndex(command.getPlayerSender());
                    this.game.setWinnerScore(command.getParameter(0));
                    this.game.setStatus((byte)3);
                    break;
                }
                case 9: {
                    this.game.getPlayerAt(command.getPlayerSender()).lose();
                }
            }
        }
        if (command.getPlayerSender() == this.game.getLocalPlayerIndex() && command.getPlayerTarget() != command.getPlayerSender()) {
            if (this.game.isServer()) {
                int playersCount = this.game.getNumberOfPlayers();
                int i = 0;
                while (i < playersCount) {
                    if (i != this.game.getServerIndex()) {
                        this.game.getRemotePlayer(i).sendCommand(command);
                    }
                    ++i;
                }
            } else {
                this.game.getRemotePlayer(this.game.getServerIndex()).sendCommand(command);
            }
        }
    }

    public void execute(Commands commands) {
        CommandsIterator it = new CommandsIterator(commands);
        while (it.hasNext()) {
            this.execute(it.next());
        }
    }
}

