/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.core.gridbuilders;

import fr.uha.ensisa.ir.walther.milcityblue.core.Grid;
import java.util.Random;

public class RandomWalker {
    private int x;
    private int y;
    private int cellType;
    private Grid grid;
    private Random rand;

    public RandomWalker(Grid grid, int cellType) {
        this.grid = grid;
        this.cellType = cellType;
        this.rand = new Random();
        this.x = this.rand.nextInt(grid.getMaxX());
        this.y = this.rand.nextInt(grid.getMaxY());
        this.grid.setCell(this.cellType, this.x, this.y);
    }

    public void next() {
        if (this.isBlocked()) {
            boolean shouldRepeat = true;
            int count = 0;
            while (shouldRepeat) {
                this.x = this.rand.nextInt(this.grid.getMaxX());
                this.y = this.rand.nextInt(this.grid.getMaxY());
                boolean bl = shouldRepeat = this.grid.getCell(this.x, this.y) == this.cellType;
                if (++count <= 10) continue;
                System.out.println("RND:" + count);
            }
        } else {
            boolean shouldRepeat = true;
            int rnd = 0;
            int lx = this.x;
            int ly = this.y;
            int count = 0;
            while (shouldRepeat) {
                ++count;
                rnd = this.rand.nextInt(4);
                switch (rnd) {
                    case 0: {
                        if (this.x <= 0) break;
                        --this.x;
                        shouldRepeat = false;
                        break;
                    }
                    case 1: {
                        if (this.x >= this.grid.getMaxX() - 1) break;
                        ++this.x;
                        shouldRepeat = false;
                        break;
                    }
                    case 2: {
                        if (this.y <= 0) break;
                        --this.y;
                        shouldRepeat = false;
                        break;
                    }
                    case 3: {
                        if (this.y >= this.grid.getMaxY() - 1) break;
                        ++this.y;
                        shouldRepeat = false;
                    }
                }
                if (this.grid.getCell(this.x, this.y) != this.cellType) continue;
                shouldRepeat = true;
                this.x = lx;
                this.y = ly;
                if (count <= 10) continue;
                System.out.println("SWITCH:" + count + ":" + this.isBlocked() + ":" + this.x + ":" + this.y + "::" + this.grid.getCell(this.x - 1, this.y) + ":" + this.grid.getCell(this.x + 1, this.y) + ":" + this.grid.getCell(this.x, this.y - 1) + ":" + this.grid.getCell(this.x, this.y + 1));
            }
        }
        this.grid.setCell(this.cellType, this.x, this.y);
    }

    public boolean isBlocked() {
        int count = 0;
        if (this.x == 0) {
            ++count;
        } else if (this.grid.getCell(this.x - 1, this.y) == this.cellType) {
            ++count;
        }
        if (this.y == 0) {
            ++count;
        } else if (this.grid.getCell(this.x, this.y - 1) == this.cellType) {
            ++count;
        }
        if (this.x == this.grid.getMaxX() - 1) {
            ++count;
        } else if (this.grid.getCell(this.x + 1, this.y) == this.cellType) {
            ++count;
        }
        if (this.y == this.grid.getMaxY() - 1) {
            ++count;
        } else if (this.grid.getCell(this.x, this.y + 1) == this.cellType) {
            ++count;
        }
        return count == 4;
    }
}

