/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.core.players;

import fr.uha.ensisa.ir.walther.milcityblue.core.Building;
import fr.uha.ensisa.ir.walther.milcityblue.core.BuildingsIterator;
import fr.uha.ensisa.ir.walther.milcityblue.core.Config;
import fr.uha.ensisa.ir.walther.milcityblue.core.PlayerAbstract;
import fr.uha.ensisa.ir.walther.milcityblue.core.commands.Command;
import java.util.Random;

public class AIPlayer
extends PlayerAbstract {
    public static final byte LEVEL_EASY = 0;
    public static final byte LEVEL_MEDIUM = 1;
    public static final byte LEVEL_HARD = 2;
    public static final byte LEVEL_MADNESS = 3;
    private byte level;
    private byte turn;

    public AIPlayer(byte level) {
        this.level = level;
        this.turn = 0;
    }

    private void play() {
        this.turn = (byte)(this.turn + 1);
        int powerplantCount = 0;
        int commercialCount = 0;
        int missilesiloCount = 0;
        int buildingCount = 0;
        int factoryCount = 0;
        int airfieldCount = 0;
        int nukesiloCount = 0;
        int currentBuildingType = 0;
        BuildingsIterator it = new BuildingsIterator(this.grid.getBuildings());
        while (it.hasNext()) {
            Building currentBuilding = it.next();
            if (currentBuilding.isDestroyed()) continue;
            currentBuildingType = currentBuilding.getType();
            switch (currentBuildingType) {
                case 103: {
                    ++powerplantCount;
                    break;
                }
                case 108: {
                    ++commercialCount;
                    break;
                }
                case 101: {
                    ++missilesiloCount;
                    break;
                }
                case 106: {
                    ++factoryCount;
                    break;
                }
                case 104: {
                    ++airfieldCount;
                    break;
                }
                case 109: {
                    ++nukesiloCount;
                }
            }
            ++buildingCount;
        }
        if (this.turn == 1) {
            if (this.money > Config.CONSTRUCTION_COST_POWERPLANT * (buildingCount - powerplantCount + 1) && this.energy > 6) {
                if (commercialCount < this.level * 2) {
                    this.build(108);
                } else if (this.level == 0) {
                    this.build(101);
                } else if (this.level == 1) {
                    this.build(106);
                } else if (this.level == 2) {
                    this.build(104);
                } else if (this.level == 3) {
                    this.build(109);
                }
            } else if (this.money > Config.CONSTRUCTION_COST_POWERPLANT + Config.CONSTRUCTION_COST_COMMERCIAL && commercialCount < 2) {
                this.build(108);
            } else if (this.energy <= 6 && this.money > Config.CONSTRUCTION_COST_POWERPLANT && commercialCount > 1) {
                this.build(103);
            } else if (this.energy <= 0 && powerplantCount * 10 - buildingCount <= 0) {
                this.build(103);
            }
        } else if (this.turn >= 5) {
            this.turn = 0;
        }
        if (System.currentTimeMillis() >= this.cannotFireBefore) {
            if (this.ammoMissiles > 0) {
                this.fire(201);
            }
            if (this.ammoMortars > 0) {
                this.fire(204);
            }
            if (this.ammoAirCrafts > 0) {
                this.fire(203);
            }
            if (this.ammoNukes > 0) {
                this.fire(205);
            }
        }
    }

    private void build(int buildingType) {
        Random rnd = new Random();
        int tries = 0;
        int x = rnd.nextInt(Config.DEFAULT_GRID_SIZE_X);
        int y = rnd.nextInt(Config.DEFAULT_GRID_SIZE_Y);
        while (!this.grid.getBuildingFactory().canCreateBuilding(buildingType, x, y, 0) && tries < 10) {
            x = rnd.nextInt(Config.DEFAULT_GRID_SIZE_X);
            y = rnd.nextInt(Config.DEFAULT_GRID_SIZE_Y);
            ++tries;
        }
        System.out.println("IA-" + this.playerIndex + ":\tBuilding a " + buildingType + " at (" + x + ", " + y + ")");
        this.constructBuilding(buildingType, x, y, 0);
    }

    private void fire(int weaponType) {
        Random rnd = new Random();
        int tries = 0;
        int x = rnd.nextInt(Config.DEFAULT_GRID_SIZE_X);
        int y = rnd.nextInt(Config.DEFAULT_GRID_SIZE_Y);
        int target = this.getRandomPlayerIndexButNotSelf();
        while (this.game.getPlayerAt(target).getStatusGrid().getCellStatusAt(x, y) == 0 && tries < 10) {
            x = rnd.nextInt(Config.DEFAULT_GRID_SIZE_X);
            y = rnd.nextInt(Config.DEFAULT_GRID_SIZE_Y);
            ++tries;
        }
        System.out.println("IA-" + this.playerIndex + ":\tFiring a " + weaponType + " at (" + x + ", " + y + ")");
        int[] nArray = new int[4];
        nArray[0] = weaponType;
        nArray[1] = x;
        nArray[2] = y;
        int[] params = nArray;
        Command command = new Command(this.playerIndex, target, 5, params);
        this.fireOnAnotherPlayer(command);
    }

    private int getRandomPlayerIndexButNotSelf() {
        Random rnd = new Random();
        int result = 0;
        if (this.game.getNumberOfPlayers() > 1) {
            result = rnd.nextInt(this.game.getNumberOfPlayers());
            while (result == this.playerIndex) {
                result = rnd.nextInt(this.game.getNumberOfPlayers());
            }
        }
        return result;
    }

    public void run() {
        while (this.game.getStatus() == 1) {
            try {
                this.computeEnergy(this.grid.getBuildings());
                this.computeAccelerationFactor(this.grid.getBuildings());
                this.computeMoney(this.grid.getBuildings());
                this.updateShields();
                BuildingsIterator it = new BuildingsIterator(this.grid.getBuildings());
                while (it.hasNext()) {
                    it.next().update(this);
                }
                this.hasLoose(this.grid.getBuildings());
                this.hasWon();
                this.play();
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public byte getLevel() {
        return this.level;
    }

    public void setLevel(byte level) {
        this.level = level;
    }
}

