/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.core.players;

import fr.uha.ensisa.ir.walther.milcityblue.core.BuildingsIterator;
import fr.uha.ensisa.ir.walther.milcityblue.core.PlayerAbstract;
import fr.uha.ensisa.ir.walther.milcityblue.core.PlayerInterface;
import fr.uha.ensisa.ir.walther.milcityblue.core.Size;
import fr.uha.ensisa.ir.walther.milcityblue.core.WeaponFactory;
import fr.uha.ensisa.ir.walther.milcityblue.core.commands.Command;

public class LocalPlayer
extends PlayerAbstract
implements PlayerInterface {
    public void run() {
        while (this.game.getStatus() == 1) {
            try {
                this.computeEnergy(this.grid.getBuildings());
                this.computeAccelerationFactor(this.grid.getBuildings());
                this.computeMoney(this.grid.getBuildings());
                this.updateShields();
                BuildingsIterator it = new BuildingsIterator(this.grid.getBuildings());
                while (it.hasNext()) {
                    it.next().update(this);
                }
                this.hasLoose(this.grid.getBuildings());
                this.hasWon();
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void fireOnAnotherPlayer(Command commandFire) {
        this.vibrateOnWeaponExplosion(commandFire.getParameter(0));
        super.fireOnAnotherPlayer(commandFire);
    }

    public void fire(Command commandFire) {
        this.vibrateOnWeaponExplosion(commandFire.getParameter(0));
        super.fire(commandFire);
    }

    private void vibrateOnWeaponExplosion(int weaponType) {
        this.grid.getWeaponFactory();
        Size size = WeaponFactory.getSizeOfWeapon(weaponType);
        this.game.vibrate(size.getSizeX() * size.getSizeY() * 100);
    }
}

