/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.gui;

import fr.uha.ensisa.ir.walther.milcityblue.core.Engine;
import fr.uha.ensisa.ir.walther.milcityblue.gui.GameModel;
import fr.uha.ensisa.ir.walther.milcityblue.gui.GameView;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public class GameEngine
implements Runnable,
Engine {
    private GameCanvasProxy canvas = new GameCanvasProxy();
    private Graphics graphics;
    private GameModel models;
    private Vector views = new Vector();
    private int fps;
    private boolean paused;
    private boolean stoped;

    public GameEngine(GameModel model, int fps) {
        this.graphics = this.canvas.getGraphics();
        this.models = model;
        this.stoped = true;
        this.fps = fps;
    }

    public Displayable getDrawingArea() {
        return this.canvas;
    }

    public void start() {
        if (this.stoped) {
            Thread t = new Thread(this);
            t.start();
        }
    }

    public void stop() {
        if (!this.stoped) {
            this.stoped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        GameEngine gameEngine = this;
        synchronized (gameEngine) {
            if (this.paused) {
                this.paused = false;
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        GameEngine gameEngine = this;
        synchronized (gameEngine) {
            if (!this.paused) {
                this.paused = true;
            }
        }
    }

    public void attach(GameView view) {
        if (!this.views.contains(view)) {
            this.views.addElement(view);
        }
    }

    public void detach(GameView view) {
        this.views.removeElement(view);
    }

    public void paint(Graphics g) {
        int keys = this.canvas.getKeyStates();
        this.models.Ai(keys, this.canvas.getWidth(), this.canvas.getHeight());
        Enumeration enumeration = this.views.elements();
        while (enumeration.hasMoreElements()) {
            GameView view = (GameView)enumeration.nextElement();
            view.render(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.stoped = false;
        while (!this.stoped) {
            try {
                GameEngine gameEngine = this;
                synchronized (gameEngine) {
                    if (this.paused) {
                        this.wait();
                    }
                }
                long interval = System.currentTimeMillis();
                this.paint(this.graphics);
                this.canvas.flushGraphics();
                interval = System.currentTimeMillis() - interval;
                interval = (long)(1000 / this.fps) - interval;
                Thread.sleep(interval > 0L ? interval : 0L);
                System.gc();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.stoped = true;
    }

    public static String keyToString(int key) {
        try {
            GameCanvas gcp = new GameCanvas(true){};
            return gcp.getKeyName(gcp.getKeyCode(key));
        }
        catch (Exception e) {
            e.printStackTrace();
            return "N/A";
        }
    }

    private class GameCanvasProxy
    extends GameCanvas {
        protected GameCanvasProxy() {
            super(true);
            this.setFullScreenMode(true);
        }

        public Graphics getGraphics() {
            return super.getGraphics();
        }
    }
}

