/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.gui;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageDrawer {
    private Image image = null;
    public static final String alpha = " !\"#%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ\\[]^_abcdefghijklmnopqrstuvwxyz{|}~$\u00a7\u00e9\u00e8\u00e7\u00e0\u00f9\u00ea";

    public boolean init() {
        try {
            this.image = Image.createImage((String)"/images.png");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("ERROR : ImageDrawer : Image not fully loaded !");
        }
        return this.image != null;
    }

    private int charToInt(char c) {
        int i = alpha.indexOf(c);
        if (i < 0) {
            i = 0;
        }
        return i;
    }

    public void stringToImage(Graphics g, String s, int x, int y, int anchor) {
        if (this.image != null) {
            int l = s.length();
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipH = g.getClipHeight();
            int clipW = g.getClipWidth();
            int x_offset = 0;
            int y_offset = 0;
            int charpos = 0;
            int i = 0;
            while (i < l) {
                charpos = this.charToInt(s.charAt(i));
                y_offset = charpos / 16;
                x_offset = charpos % 16;
                g.setClip(x + i * 6, y, 6, 8);
                g.drawImage(this.image, x + i * 6 - x_offset * 7, y - y_offset * 9, anchor);
                ++i;
            }
            g.setClip(clipX, clipY, clipW, clipH);
        } else {
            g.setFont(Font.getFont((int)32, (int)0, (int)8));
            g.setColor(0);
            g.drawString(s, x, y, anchor);
        }
    }

    public void cellToImage(Graphics g, int type, int x, int y, int size) {
        if (this.image != null) {
            g.setClip(x * size, y * size, size, size);
            g.drawImage(this.image, x * size - type % 12 * 9, y * size - (65 + type / 12 * 9), 20);
        }
    }
}

