/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.gui;

import fr.uha.ensisa.ir.walther.milcityblue.core.Config;
import fr.uha.ensisa.ir.walther.milcityblue.core.Game;
import fr.uha.ensisa.ir.walther.milcityblue.core.Size;
import fr.uha.ensisa.ir.walther.milcityblue.core.WeaponFactory;
import fr.uha.ensisa.ir.walther.milcityblue.core.commands.Command;
import fr.uha.ensisa.ir.walther.milcityblue.gui.GameModel;

public class MilCityModel
implements GameModel {
    private int x;
    private int y;
    private int w;
    private int h;
    private int s;
    private Size size;
    private int lastKeys;
    private Game game;
    private int actionSelected;
    private int previousActionSelected;
    private String actionSelectedName;
    private int actionSelectedCost;
    private int actionSelectedEnergy;
    private int modeSelected;
    private int previousModeSelected;
    private String modeSelectedName;
    private boolean hasFired;
    public static final int MODE_CITY = -1;
    public static final int MODE_ATTACK_P1 = 0;
    public static final int MODE_ATTACK_P2 = 1;
    public static final int MODE_ATTACK_P3 = 2;
    public static final int MODE_ATTACK_P4 = 3;
    public static final int MODE_ATTACK_P5 = 4;
    public static final int MODE_ATTACK_P6 = 5;
    public static final int MODE_ATTACK_P7 = 6;
    public static final int MODE_ATTACK_P8 = 7;
    public static final int ACTION_PLACE_POWERPLANT = 0;
    public static final int ACTION_PLACE_REFINERY = 1;
    public static final int ACTION_PLACE_HOUSE = 2;
    public static final int ACTION_PLACE_MISSILESILO = 3;
    public static final int ACTION_PLACE_FACTORY = 4;
    public static final int ACTION_PLACE_AIRFIELD = 5;
    public static final int ACTION_PLACE_LABORATORY = 6;
    public static final int ACTION_PLACE_SHIELDGENERATOR = 7;
    public static final int ACTION_PLACE_NUKESILO = 8;
    public static final int ACTION_PLACE_SHIELD = 9;
    public static final int ACTION_USE_MISSILE = 0;
    public static final int ACTION_USE_ARTILLERY = 1;
    public static final int ACTION_USE_AIRCRAFT = 2;
    public static final int ACTION_USE_NUKE = 3;
    public static final int ACTION_USE_SPY = 4;

    public MilCityModel(Game game, int x, int y, int w, int h, int s, Size size) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.s = s;
        this.size = size;
        this.lastKeys = 0;
        this.game = game;
        this.actionSelected = 0;
        this.previousActionSelected = 0;
        this.actionSelectedName = "Powerplant";
        this.actionSelectedCost = Config.CONSTRUCTION_COST_POWERPLANT;
        this.actionSelectedEnergy = Config.ENERGY_POWERPLANT;
        this.modeSelected = -1;
        this.modeSelectedName = "City";
        this.previousModeSelected = -1;
        this.hasFired = false;
    }

    public void Ai(int keys, int width, int height) {
        try {
            if (this.hasFired && (keys & 0x100) == 0) {
                this.hasFired = false;
            }
            if ((keys & 2) != 0 && this.y > 0) {
                this.y -= this.s;
            }
            if ((keys & 0x40) != 0 && this.y + this.size.getSizeY() * this.s < this.h) {
                this.y += this.s;
            }
            if ((keys & 4) != 0 && this.x > 0) {
                this.x -= this.s;
            }
            if ((keys & 0x20) != 0 && this.x + this.size.getSizeX() * this.s < this.w) {
                this.x += this.s;
            }
            if ((keys & 0x200) != 0) {
                --this.actionSelected;
                this.checkActionSelected();
            }
            if ((keys & 0x400) != 0) {
                ++this.actionSelected;
                this.checkActionSelected();
            }
            if ((keys & 0x800) != 0) {
                --this.modeSelected;
                if (this.modeSelected == this.game.getLocalPlayerIndex()) {
                    --this.modeSelected;
                }
                this.checkModeSelected();
            }
            if ((keys & 0x1000) != 0) {
                ++this.modeSelected;
                if (this.modeSelected == this.game.getLocalPlayerIndex()) {
                    ++this.modeSelected;
                }
                this.checkModeSelected();
            }
            if ((keys & 0x100) != 0) {
                if (!this.hasFired) {
                    this.performSelectedAction();
                }
                this.hasFired = true;
            }
            if ((keys & 0x200) != 0 && (keys & 0x800) != 0 && (keys & 0x1000) != 0) {
                Config.CONSTRUCTION_COST_AIRFIELD = 0;
                Config.CONSTRUCTION_COST_COMMERCIAL = 0;
                Config.CONSTRUCTION_COST_FACTORY = 0;
                Config.CONSTRUCTION_COST_HOUSE = 0;
                Config.CONSTRUCTION_COST_LABORATORY = 0;
                Config.CONSTRUCTION_COST_MISSILESILO = 0;
                Config.CONSTRUCTION_COST_NUKESILO = 0;
                Config.CONSTRUCTION_COST_POWERPLANT = 0;
                Config.CONSTRUCTION_COST_SHIELDGENERATOR = 0;
            }
            this.lastKeys = keys;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkModeSelected() {
        if (this.modeSelected < -1) {
            this.modeSelected = this.game.getNumberOfPlayers() - 1;
        }
        if (this.modeSelected >= this.game.getNumberOfPlayers()) {
            this.modeSelected = -1;
        }
        if (this.modeSelected == -1 && this.previousModeSelected > -1) {
            int tmp = this.actionSelected;
            this.actionSelected = this.previousActionSelected;
            this.previousActionSelected = tmp;
        } else if (this.modeSelected > -1 && this.previousModeSelected == -1) {
            int tmp = this.actionSelected;
            this.actionSelected = this.previousActionSelected;
            this.previousActionSelected = tmp;
        }
        this.previousModeSelected = this.modeSelected;
        this.modeSelectedName = this.modeToString();
        this.checkActionSelected();
        System.out.println("ModeToPlayerIndex: " + this.modeToPlayerIndex());
    }

    private void checkActionSelected() {
        if (this.modeSelected == -1) {
            if (this.actionSelected < 0) {
                this.actionSelected = 9;
            }
            if (this.actionSelected > 9) {
                this.actionSelected = 0;
            }
            this.size = this.actionToSize();
            this.actionSelectedName = this.actionToString();
            this.actionSelectedCost = this.actionToCost();
            this.actionSelectedEnergy = this.actionToEnergy();
        } else {
            if (this.actionSelected < 0) {
                this.actionSelected = 4;
            }
            if (this.actionSelected > 4) {
                this.actionSelected = 0;
            }
            this.size = this.actionToSize();
            this.actionSelectedName = this.actionToString();
            this.actionSelectedCost = 0;
            this.actionSelectedEnergy = 0;
        }
    }

    private void performSelectedAction() {
        if (this.canPerformActionHere()) {
            if (this.modeSelected == -1) {
                if (this.actionSelected < 9) {
                    this.game.getLocalPlayer().constructBuilding(this.actionToType(), this.x / this.s, this.y / this.s, 0);
                }
                if (this.actionSelected == 9) {
                    int[] nArray = new int[4];
                    nArray[0] = this.actionToType();
                    nArray[1] = this.x / this.s;
                    nArray[2] = this.y / this.s;
                    int[] args = nArray;
                    this.game.getLocalPlayer().fire(new Command(this.game.getLocalPlayerIndex(), this.game.getLocalPlayerIndex(), 5, args));
                }
            } else {
                int[] nArray = new int[4];
                nArray[0] = this.actionToType();
                nArray[1] = this.x / this.s;
                nArray[2] = this.y / this.s;
                int[] args = nArray;
                this.game.getLocalPlayer().fireOnAnotherPlayer(new Command(this.game.getLocalPlayerIndex(), this.modeToPlayerIndex(), 5, args));
            }
        }
    }

    public boolean canPerformActionHere() {
        if (this.modeSelected == -1) {
            if (this.actionSelected < 9) {
                if (this.game.getLocalPlayer().hasEnoughMoneyToBuild(this.actionToType())) {
                    return this.game.getLocalPlayer().getGrid().getBuildingFactory().canCreateBuilding(this.actionToType(), this.x / this.s, this.y / this.s, 0);
                }
                return false;
            }
            if (this.actionSelected == 9) {
                return this.game.getLocalPlayer().hasEnoughAmmoToFire(202);
            }
        }
        if (this.game.getLocalPlayer().hasEnoughAmmoToFire(this.actionToType())) {
            return System.currentTimeMillis() >= this.game.getLocalPlayer().getCannotFireBefore();
        }
        return false;
    }

    public String modeToString() {
        switch (this.modeSelected) {
            case -1: {
                return "City";
            }
            case 0: {
                return "Military(P1)";
            }
            case 1: {
                return "Military(P2)";
            }
            case 2: {
                return "Military(P3)";
            }
            case 3: {
                return "Military(P4)";
            }
            case 4: {
                return "Military(P5)";
            }
            case 5: {
                return "Military(P6)";
            }
            case 6: {
                return "Military(P7)";
            }
            case 7: {
                return "Military(P8)";
            }
        }
        return "N/A";
    }

    public String actionToString() {
        if (this.modeSelected == -1) {
            switch (this.actionSelected) {
                case 0: {
                    return "Powerplant";
                }
                case 1: {
                    return "Refinery";
                }
                case 2: {
                    return "House";
                }
                case 3: {
                    return "Missile Silo";
                }
                case 4: {
                    return "Factory";
                }
                case 5: {
                    return "Airfield";
                }
                case 6: {
                    return "Laboratory";
                }
                case 7: {
                    return "Shield Generator";
                }
                case 8: {
                    return "Nuke Silo";
                }
                case 9: {
                    return "Shield";
                }
            }
        } else {
            switch (this.actionSelected) {
                case 0: {
                    return "Missile(\u00e9)";
                }
                case 1: {
                    return "Artillery(\u00e8)";
                }
                case 2: {
                    return "Aircraft(\u00e7)";
                }
                case 3: {
                    return "Nuke(\u00e0)";
                }
                case 4: {
                    return "Spy(\u00ea)";
                }
            }
        }
        return "N/A";
    }

    public int actionToType() {
        if (this.modeSelected == -1) {
            switch (this.actionSelected) {
                case 0: {
                    return 103;
                }
                case 1: {
                    return 108;
                }
                case 2: {
                    return 107;
                }
                case 3: {
                    return 101;
                }
                case 4: {
                    return 106;
                }
                case 5: {
                    return 104;
                }
                case 6: {
                    return 105;
                }
                case 7: {
                    return 102;
                }
                case 8: {
                    return 109;
                }
                case 9: {
                    return 202;
                }
            }
            return 100;
        }
        switch (this.actionSelected) {
            case 0: {
                return 201;
            }
            case 1: {
                return 204;
            }
            case 2: {
                return 203;
            }
            case 3: {
                return 205;
            }
            case 4: {
                return 206;
            }
        }
        return 200;
    }

    public int actionToCost() {
        if (this.modeSelected == -1 && this.actionSelected < 9) {
            return this.game.getLocalPlayer().getGrid().getBuildingFactory().getCostOfBuilding(this.actionToType());
        }
        return 0;
    }

    public int actionToEnergy() {
        if (this.modeSelected == -1 && this.actionSelected < 9) {
            return this.game.getLocalPlayer().getGrid().getBuildingFactory().getEnergyOfBuilding(this.actionToType());
        }
        return 0;
    }

    public Size actionToSize() {
        if (this.modeSelected == -1) {
            if (this.actionSelected < 9) {
                return this.game.getLocalPlayer().getGrid().getBuildingFactory().getSizeOfBuilding(this.actionToType());
            }
            this.game.getLocalPlayer().getGrid().getWeaponFactory();
            return WeaponFactory.getSizeOfWeapon(this.actionToType());
        }
        this.game.getLocalPlayer().getGrid().getWeaponFactory();
        return WeaponFactory.getSizeOfWeapon(this.actionToType());
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getW() {
        return this.w;
    }

    public void setW(int w) {
        this.w = w;
    }

    public int getH() {
        return this.h;
    }

    public void setH(int h) {
        this.h = h;
    }

    public int getS() {
        return this.s;
    }

    public void setS(int s) {
        this.s = s;
    }

    public Size getSize() {
        return this.size;
    }

    public void setSize(Size size) {
        this.size = size;
    }

    public int getLastKeys() {
        return this.lastKeys;
    }

    public int getActionSelected() {
        return this.actionSelected;
    }

    public String getActionSelectedName() {
        return this.actionSelectedName;
    }

    public int getActionSelectedCost() {
        return this.actionSelectedCost;
    }

    public int getActionSelectedEnergy() {
        return this.actionSelectedEnergy;
    }

    public int getModeSelected() {
        return this.modeSelected;
    }

    public String getModeSelectedName() {
        return this.modeSelectedName;
    }

    public Game getGame() {
        return this.game;
    }

    public int modeToPlayerIndex() {
        if (this.modeSelected == -1) {
            return this.game.getLocalPlayerIndex();
        }
        return this.modeSelected;
    }
}

