/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.tools;

import java.util.Vector;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class ParametersStore {
    private RecordStore recordStore;

    public ParametersStore(String storeName) {
        try {
            this.recordStore = RecordStore.openRecordStore((String)storeName, (boolean)true);
        }
        catch (RecordStoreFullException e) {
            e.printStackTrace();
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }

    public int size() {
        try {
            return this.recordStore.getNumRecords();
        }
        catch (RecordStoreNotOpenException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public String get(int index) {
        try {
            if (index <= this.recordStore.getNumRecords()) {
                byte[] result = new byte[this.recordStore.getRecordSize(index)];
                this.recordStore.getRecord(index, result, 0);
                return new String(result);
            }
            return null;
        }
        catch (RecordStoreNotOpenException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvalidRecordIDException e) {
            e.printStackTrace();
            return null;
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void add(String value) {
        byte[] data = value.getBytes();
        try {
            this.recordStore.addRecord(data, 0, data.length);
        }
        catch (RecordStoreNotOpenException e) {
            e.printStackTrace();
        }
        catch (RecordStoreFullException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.recordStore.closeRecordStore();
        }
        catch (RecordStoreNotOpenException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }

    public void set(int index, String value) {
        byte[] data = value.getBytes();
        try {
            if (index <= this.recordStore.getNumRecords()) {
                this.recordStore.setRecord(index, data, 0, data.length);
            } else {
                this.recordStore.addRecord(data, 0, data.length);
            }
        }
        catch (RecordStoreNotOpenException e) {
            e.printStackTrace();
        }
        catch (RecordStoreFullException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }

    public void deleteStore(String storeName) {
        try {
            if (this.recordStore.getName().equals(storeName)) {
                this.close();
            }
            RecordStore.deleteRecordStore((String)storeName);
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }

    public Vector getAll() {
        try {
            Vector<String> result = new Vector<String>(this.recordStore.getNumRecords());
            int i = 1;
            while (i <= this.recordStore.getNumRecords()) {
                byte[] buffer = new byte[this.recordStore.getRecordSize(i)];
                buffer = this.recordStore.getRecord(i);
                result.addElement(new String(buffer));
                ++i;
            }
            return result;
        }
        catch (RecordStoreNotOpenException e) {
            e.printStackTrace();
            return null;
        }
        catch (RecordStoreFullException e) {
            e.printStackTrace();
            return null;
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        Vector content = this.getAll();
        StringBuffer tmp = new StringBuffer();
        int i = 0;
        while (i < content.size()) {
            tmp.append((String)content.elementAt(i)).append("\n");
            ++i;
        }
        return tmp.toString();
    }

    public void delete(int index) {
        try {
            if (index <= this.recordStore.getNumRecords()) {
                this.recordStore.deleteRecord(index);
            }
        }
        catch (RecordStoreNotOpenException e) {
            e.printStackTrace();
        }
        catch (RecordStoreFullException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }
}

