/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.game;

import com.tqm.agave.MainLogic;
import com.tqm.agave.menu.Container;
import com.tqm.fantasydefense.GameLogic;
import com.tqm.fantasydefense.GameTemplate;
import com.tqm.fantasydefense.game.Defender;
import com.tqm.fantasydefense.game.DefenderGroup;
import com.tqm.fantasydefense.game.EnemyWaves;
import com.tqm.fantasydefense.menu.Achievements;
import com.tqm.fantasydefense.shop.secret.SecretItemsManager;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public final class AchivementStats {
    public int killedOrks;
    public int killedSkeletons;
    public int killedElementals;
    public int killedWiches;
    public int killedGhosts;
    public int killedDrakes;
    public int killedEnemies;
    public int finishedOnNormal;
    public int achivementsOnLevel;
    private GameLogic gameLogic;
    private Achievements achievements;
    private Vector achivementsDrawn = new Vector();
    private boolean unlocked;
    private int elixirCount;
    private Vector achievementsGained = new Vector();
    private static String[] text;
    private static int shiftX;

    public AchivementStats(GameLogic gameLogic) {
        this.gameLogic = gameLogic;
        this.achievements = Achievements.getInstance();
    }

    public final void loadRms() {
        this.killedOrks = this.gameLogic.getGData().loadAsInt(50);
        this.killedSkeletons = this.gameLogic.getGData().loadAsInt(51);
        this.killedElementals = this.gameLogic.getGData().loadAsInt(52);
        this.killedWiches = this.gameLogic.getGData().loadAsInt(53);
        this.killedGhosts = this.gameLogic.getGData().loadAsInt(54);
        this.killedDrakes = this.gameLogic.getGData().loadAsInt(55);
        this.killedEnemies = this.gameLogic.getGData().loadAsInt(56);
        this.finishedOnNormal = this.gameLogic.getGData().loadAsInt(61);
    }

    public final void saveRms() {
        this.gameLogic.getGData().save(this.killedOrks, 50);
        this.gameLogic.getGData().save(this.killedSkeletons, 51);
        this.gameLogic.getGData().save(this.killedElementals, 52);
        this.gameLogic.getGData().save(this.killedWiches, 53);
        this.gameLogic.getGData().save(this.killedGhosts, 54);
        this.gameLogic.getGData().save(this.killedDrakes, 55);
        this.gameLogic.getGData().save(this.killedEnemies, 56);
        this.gameLogic.getGData().save(this.finishedOnNormal, 61);
    }

    public final void testAchivments() {
        int i;
        if (this.killedOrks >= 100 && !this.achievements.isUnlockedAchievement(5)) {
            this.achievements.unlockAchievement(5);
            this.addAchivement(5);
        }
        if (this.killedSkeletons >= 100 && !this.achievements.isUnlockedAchievement(6)) {
            this.achievements.unlockAchievement(6);
            this.addAchivement(6);
        }
        if (this.killedElementals >= 100 && !this.achievements.isUnlockedAchievement(7)) {
            this.achievements.unlockAchievement(7);
            this.addAchivement(7);
        }
        if (this.killedWiches >= 100 && !this.achievements.isUnlockedAchievement(8)) {
            this.achievements.unlockAchievement(8);
            this.addAchivement(8);
        }
        if (this.killedGhosts >= 100 && !this.achievements.isUnlockedAchievement(9)) {
            this.achievements.unlockAchievement(9);
            this.addAchivement(9);
        }
        if (this.killedDrakes >= 100 && !this.achievements.isUnlockedAchievement(10)) {
            this.achievements.unlockAchievement(10);
            this.addAchivement(10);
        }
        if (this.killedEnemies >= 666 && !this.achievements.isUnlockedAchievement(11)) {
            this.achievements.unlockAchievement(11);
            this.addAchivement(11);
        }
        if (this.gameLogic.getShopManager().getShopVisitCounter() >= 5 && !this.achievements.isUnlockedAchievement(21)) {
            this.achievements.unlockAchievement(21);
            this.addAchivement(21);
        }
        if (!this.achievements.isUnlockedAchievement(22) && GameTemplate._elixirsActive) {
            if (Defender.secretElixir == null) {
                Defender.secretElixir = SecretItemsManager.getInstance().getElixirs();
            }
            for (i = 0; i < 11; ++i) {
                if (!Defender.secretElixir[i].isActive()) continue;
                this.achievements.unlockAchievement(22);
                this.addAchivement(22);
                break;
            }
        }
        if (SecretItemsManager.getInstance().getGates()[2].isUnlocked() && !this.achievements.isUnlockedAchievement(13)) {
            this.achievements.unlockAchievement(13);
            this.addAchivement(13);
        }
        if (SecretItemsManager.getInstance().getCatapults()[2].isUnlocked() && !this.achievements.isUnlockedAchievement(14)) {
            this.achievements.unlockAchievement(14);
            this.addAchivement(14);
        }
        if (SecretItemsManager.getInstance().getDragons()[2].isUnlocked() && !this.achievements.isUnlockedAchievement(15)) {
            this.achievements.unlockAchievement(15);
            this.addAchivement(15);
        }
        if (!this.achievements.isUnlockedAchievement(16) && SecretItemsManager.getInstance().getGates()[2].isUnlocked() && SecretItemsManager.getInstance().getCatapults()[2].isUnlocked() && SecretItemsManager.getInstance().getDragons()[2].isUnlocked()) {
            this.achievements.unlockAchievement(16);
            this.addAchivement(16);
        }
        if (!this.achievements.isUnlockedAchievement(20) && SecretItemsManager.getInstance().getDefenceUnits()[0].isUnlocked() && SecretItemsManager.getInstance().getDefenceUnits()[1].isUnlocked() && SecretItemsManager.getInstance().getDefenceUnits()[2].isUnlocked()) {
            this.achievements.unlockAchievement(20);
            this.addAchivement(20);
        }
        if (!this.achievements.isUnlockedAchievement(23) && GameTemplate._elixirsActive) {
            if (Defender.secretElixir == null) {
                Defender.secretElixir = SecretItemsManager.getInstance().getElixirs();
            }
            this.elixirCount = 0;
            for (i = 0; i < 11; ++i) {
                if (!Defender.secretElixir[i].isActive()) continue;
                ++this.elixirCount;
            }
            if (this.elixirCount >= 5) {
                this.achievements.unlockAchievement(23);
                this.addAchivement(23);
            }
        }
        if (GameTemplate._mode == 1) {
            if (!this.achievements.isUnlockedAchievement(24) && EnemyWaves._currentWave >= 9) {
                this.achievements.unlockAchievement(24);
                this.addAchivement(24);
            }
            if (!this.achievements.isUnlockedAchievement(25) && EnemyWaves._currentWave >= 19) {
                this.achievements.unlockAchievement(25);
                this.addAchivement(25);
            }
            if (!this.achievements.isUnlockedAchievement(26) && EnemyWaves._currentWave >= 29) {
                this.achievements.unlockAchievement(26);
                this.addAchivement(26);
            }
            if (!this.achievements.isUnlockedAchievement(27) && EnemyWaves._currentWave >= 39) {
                this.achievements.unlockAchievement(27);
                this.addAchivement(27);
            }
            if (!this.achievements.isUnlockedAchievement(28) && EnemyWaves._currentWave >= 49) {
                this.achievements.unlockAchievement(28);
                this.addAchivement(28);
            }
        }
        if (GameTemplate.playerWon) {
            int i2;
            int lastUnfinishedLvl;
            if (!DefenderGroup.usedElf && GameTemplate.getLevel() == 8 && !this.achievements.isUnlockedAchievement(17)) {
                this.achievements.unlockAchievement(17);
                this.addAchivement(17);
            }
            if (!(!DefenderGroup.usedSorcerer && !DefenderGroup.usedWarlock || DefenderGroup.usedArcher || DefenderGroup.usedElf || DefenderGroup.usedKnight || DefenderGroup.usedPaladin || this.achievements.isUnlockedAchievement(18))) {
                this.achievements.unlockAchievement(18);
                this.addAchivement(18);
            }
            if (!(!DefenderGroup.usedKnight && !DefenderGroup.usedPaladin || DefenderGroup.usedArcher || DefenderGroup.usedElf || DefenderGroup.usedSorcerer || DefenderGroup.usedWarlock || this.achievements.isUnlockedAchievement(19))) {
                this.achievements.unlockAchievement(19);
                this.addAchivement(19);
            }
            if (GameTemplate.myCastle._castleHp == GameTemplate.myCastle._castleHpFull && GameTemplate.getLevel() >= 11 && !this.achievements.isUnlockedAchievement(12)) {
                this.achievements.unlockAchievement(12);
                this.addAchivement(12);
            }
            if (GameTemplate.getLevel() == 6 && !this.achievements.isUnlockedAchievement(0)) {
                this.achievements.unlockAchievement(0);
                this.addAchivement(0);
            }
            if (GameTemplate.getLevel() == 13 && !this.achievements.isUnlockedAchievement(1)) {
                this.achievements.unlockAchievement(1);
                this.addAchivement(1);
            }
            if (GameTemplate.getLevel() == 20 && !this.achievements.isUnlockedAchievement(2)) {
                this.achievements.unlockAchievement(2);
                this.addAchivement(2);
            }
            if (!this.achievements.isUnlockedAchievement(3)) {
                this.unlocked = true;
                int unfinishedNum = 0;
                lastUnfinishedLvl = -1;
                for (i2 = 0; i2 < GameLogic.worldMap.getCastlesDifficultyLevels().length; ++i2) {
                    if (GameLogic.worldMap.getCastlesDifficultyLevels()[i2] != 0) continue;
                    ++unfinishedNum;
                    lastUnfinishedLvl = i2 + 1;
                }
                if (unfinishedNum != 1 || lastUnfinishedLvl != GameLogic.worldMap.getCurrLevelNumber() || GameTemplate.playerLost) {
                    this.unlocked = false;
                }
                if (this.unlocked) {
                    this.achievements.unlockAchievement(3);
                    this.addAchivement(3);
                    GameTemplate.setFinishGame(361);
                }
            }
            if (this.finishedOnNormal == 0) {
                this.unlocked = true;
                int unfinishedNormalNum = 0;
                lastUnfinishedLvl = -1;
                for (i2 = 0; i2 < GameLogic.worldMap.getCastlesDifficultyLevels().length; ++i2) {
                    if (GameLogic.worldMap.getCastlesDifficultyLevels()[i2] != 0 && GameLogic.worldMap.getCastlesDifficultyLevels()[i2] != 3) continue;
                    ++unfinishedNormalNum;
                    lastUnfinishedLvl = i2 + 1;
                }
                if (unfinishedNormalNum != 1 || lastUnfinishedLvl != GameLogic.worldMap.getCurrLevelNumber() || GameTemplate.playerLost || GameTemplate._difficulty == 0) {
                    this.unlocked = false;
                }
                if (this.unlocked) {
                    GameTemplate.setFinishGame(362);
                    this.finishedOnNormal = 1;
                    this.saveRms();
                }
            }
            if (!this.achievements.isUnlockedAchievement(4)) {
                this.unlocked = true;
                if (GameTemplate.playerLost || GameTemplate.getDifficulty() != 2) {
                    this.unlocked = false;
                }
                for (i = 0; i < GameLogic.worldMap.getCastlesDifficultyLevels().length; ++i) {
                    if (i + 1 == GameLogic.worldMap.getCurrLevelNumber() || GameLogic.worldMap.getCastlesDifficultyLevels()[i] == 1) continue;
                    this.unlocked = false;
                    break;
                }
                if (this.unlocked) {
                    this.achievements.unlockAchievement(4);
                    this.addAchivement(4);
                    GameTemplate.setFinishGame(360);
                }
            }
        }
    }

    private void addAchivement(int n) {
        this.achivementsDrawn.addElement(new Achiv(n));
        ++this.achivementsOnLevel;
        this.achievementsGained.addElement(new Integer(n));
    }

    public final void resetAchievementsToDraw() {
        this.achivementsOnLevel -= this.achivementsDrawn.size();
        this.achivementsDrawn.removeAllElements();
        text = null;
    }

    public final int getTimeLeft() {
        if (this.achivementsDrawn.size() > 0) {
            return ((Achiv)this.achivementsDrawn.elementAt((int)0)).time;
        }
        return -1;
    }

    public final void draw(Graphics graphics) {
        if (this.getTimeLeft() > 0) {
            int n;
            shiftX = GameTemplate.achivment.getWidth() / 4;
            GameTemplate.achivshadow.setPosition(shiftX + GameLogic.width / 2 - GameTemplate.achivtxt1.getWidth() / 2, GameLogic.height / 2 + GameTemplate.achivtxt2.getHeight() / 2 + GameTemplate.achivtxt1.getHeight() / 2);
            GameTemplate.achivshadow.paint(graphics);
            graphics.setColor(GameLogic.GAME_ACHIV_BG_COLOR);
            graphics.fillRect(shiftX + GameLogic.width / 2 - GameTemplate.achivtxt1.getWidth() / 2 + GameTemplate.achivtxt2.getWidth(), GameLogic.height / 2 - GameTemplate.achivtxt2.getHeight() / 2, GameTemplate.achivtxt1.getWidth() - (GameTemplate.achivtxt2.getWidth() << 1), GameTemplate.achivtxt2.getHeight());
            GameTemplate.achivtxt1.setTransform(3);
            GameTemplate.achivtxt1.setPosition(shiftX + GameLogic.width / 2 - GameTemplate.achivtxt1.getWidth() / 2, GameLogic.height / 2 - GameTemplate.achivtxt2.getHeight() / 2 - GameTemplate.achivtxt1.getHeight());
            GameTemplate.achivtxt1.paint(graphics);
            GameTemplate.achivtxt1.setTransform(0);
            GameTemplate.achivtxt1.setPosition(shiftX + GameLogic.width / 2 - GameTemplate.achivtxt1.getWidth() / 2, GameLogic.height / 2 + GameTemplate.achivtxt2.getHeight() / 2);
            GameTemplate.achivtxt1.paint(graphics);
            GameTemplate.achivtxt2.setTransform(0);
            GameTemplate.achivtxt2.setPosition(shiftX + GameLogic.width / 2 + GameTemplate.achivtxt1.getWidth() / 2 - GameTemplate.achivtxt2.getWidth(), GameLogic.height / 2 - GameTemplate.achivtxt2.getHeight() / 2);
            GameTemplate.achivtxt2.paint(graphics);
            GameTemplate.achivtxt2.setTransform(3);
            GameTemplate.achivtxt2.setPosition(shiftX + GameLogic.width / 2 - GameTemplate.achivtxt1.getWidth() / 2, GameLogic.height / 2 - GameTemplate.achivtxt2.getHeight() / 2);
            GameTemplate.achivtxt2.paint(graphics);
            GameTemplate.achivshadow2.setPosition(shiftX + GameLogic.width / 2 - GameTemplate.achivtxt1.getWidth() / 2 - GameTemplate.achivshadow2.getWidth() / 2 - 5, GameLogic.height / 2 - GameTemplate.achivshadow2.getHeight() / 2);
            GameTemplate.achivshadow2.paint(graphics);
            GameTemplate.achivment.setPosition(shiftX + GameLogic.width / 2 - GameTemplate.achivtxt1.getWidth() / 2 - GameTemplate.achivment.getWidth() / 2 + GameTemplate.achivment.getWidth() / 23 - 4, GameLogic.height / 2 - GameTemplate.achivment.getHeight() / 2);
            GameTemplate.achivment.paint(graphics);
            graphics.setColor(GameLogic.GAME_BROWN_TEXT_COLOR);
            if (text == null) {
                AchivementStats achivementStats = this;
                n = achivementStats.achivementsDrawn.size() > 0 ? ((Achiv)achivementStats.achivementsDrawn.elementAt((int)0)).num : -1;
                String string = "";
                switch (n) {
                    case 0: {
                        string = MainLogic.strings[210];
                        break;
                    }
                    case 1: {
                        string = MainLogic.strings[212];
                        break;
                    }
                    case 2: {
                        string = MainLogic.strings[214];
                        break;
                    }
                    case 3: {
                        string = MainLogic.strings[216];
                        break;
                    }
                    case 4: {
                        string = MainLogic.strings[218];
                        break;
                    }
                    case 5: {
                        string = MainLogic.strings[220];
                        break;
                    }
                    case 6: {
                        string = MainLogic.strings[222];
                        break;
                    }
                    case 7: {
                        string = MainLogic.strings[224];
                        break;
                    }
                    case 8: {
                        string = MainLogic.strings[226];
                        break;
                    }
                    case 9: {
                        string = MainLogic.strings[228];
                        break;
                    }
                    case 10: {
                        string = MainLogic.strings[230];
                        break;
                    }
                    case 11: {
                        string = MainLogic.strings[232];
                        break;
                    }
                    case 12: {
                        string = MainLogic.strings[234];
                        break;
                    }
                    case 13: {
                        string = MainLogic.strings[236];
                        break;
                    }
                    case 14: {
                        string = MainLogic.strings[238];
                        break;
                    }
                    case 15: {
                        string = MainLogic.strings[240];
                        break;
                    }
                    case 16: {
                        string = MainLogic.strings[242];
                        break;
                    }
                    case 17: {
                        string = MainLogic.strings[244];
                        break;
                    }
                    case 18: {
                        string = MainLogic.strings[246];
                        break;
                    }
                    case 19: {
                        string = MainLogic.strings[248];
                        break;
                    }
                    case 20: {
                        string = MainLogic.strings[250];
                        break;
                    }
                    case 21: {
                        string = MainLogic.strings[252];
                        break;
                    }
                    case 22: {
                        string = MainLogic.strings[254];
                        break;
                    }
                    case 23: {
                        string = MainLogic.strings[266];
                        break;
                    }
                    case 24: {
                        string = MainLogic.strings[256];
                        break;
                    }
                    case 25: {
                        string = MainLogic.strings[258];
                        break;
                    }
                    case 26: {
                        string = MainLogic.strings[260];
                        break;
                    }
                    case 27: {
                        string = MainLogic.strings[262];
                        break;
                    }
                    case 28: {
                        string = MainLogic.strings[264];
                    }
                }
                text = Container.wrapText(string, (GameTemplate.achivtxt1.getX() + GameTemplate.achivtxt1.getWidth() - GameTemplate.achivment.getX() - GameTemplate.achivment.getWidth()) * 15 / 16, graphics.getFont());
            }
            graphics.setFont(GameLogic.getSystemFont());
            for (n = 0; n < text.length; ++n) {
                if (text.length == 1) {
                    graphics.drawString(text[n], (GameTemplate.achivtxt1.getX() + GameTemplate.achivtxt1.getWidth() + GameTemplate.achivment.getX() + GameTemplate.achivment.getWidth()) / 2, GameLogic.height / 2 - GameLogic._sFontHeight / 2, 17);
                    continue;
                }
                graphics.drawString(text[n], (GameTemplate.achivtxt1.getX() + GameTemplate.achivtxt1.getWidth() + GameTemplate.achivment.getX() + GameTemplate.achivment.getWidth()) / 2, GameLogic.height / 2 - GameLogic._sFontHeight + GameLogic._sFontHeight * n, 17);
            }
            AchivementStats achivementStats = this;
            if (achivementStats.achivementsDrawn.size() > 0) {
                --((Achiv)achivementStats.achivementsDrawn.elementAt((int)0)).time;
                if (achivementStats.getTimeLeft() <= 0) {
                    achivementStats.achivementsDrawn.removeElementAt(0);
                    text = null;
                }
            }
        }
    }

    private final class Achiv {
        int num;
        int time;

        Achiv(int n) {
            this.num = n;
            this.time = 48;
        }
    }
}

