/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.agave;

import com.tqm.agave.IReader;
import com.tqm.agave.Main;
import com.tqm.agave.MainScreen;
import com.tqm.agave.menu.Container;
import com.tqm.agave.ui.ExtendedSprite;
import com.tqm.agave.ui.GameImage;
import com.tqm.agave.ui.Sprite;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public abstract class MainLogic {
    public static int currLang;
    private Vector languageOptions = new Vector();
    private Hashtable languageIntegerMap = new Hashtable();
    private Hashtable languageMap = new Hashtable();
    private int[] rootFonts;
    private Hashtable languageFonts = new Hashtable();
    private Hashtable[] diacriticalFonts;
    private static FSM _gsm;
    private static FSM _ssm;
    private Stack _stack;
    public static int width;
    public static int height;
    public static int halfWidth;
    public static int tmpWidth;
    public static int tmpHeight;
    public static int tmpHalfWidth;
    private Hashtable menuChildren;
    private Hashtable menuParent;
    private MainScreen _cm;
    public static String[] strings;
    public static long counter;
    private EventBuffer _events;
    private boolean _synchEvents;
    private static int fontOffset;
    public static Sprite icons;
    public static String[] imgNames;
    private static int[][] imgData;
    private static String resPathGlobal;

    public MainLogic() {
        _gsm = new FSM();
        _ssm = new FSM();
        this._stack = new Stack();
        this._events = new EventBuffer();
        this.menuChildren = new Hashtable();
        this.menuParent = new Hashtable();
        this._synchEvents = true;
        this.pushState$255f295(1);
        _gsm.changeState(11, -1, 0, false);
    }

    public final void setCanvasReference(MainScreen cm) {
        this._cm = cm;
    }

    public static void setResourceData$5b21aab5(String[] stringArray, int[][] nArray) {
        imgNames = stringArray;
        imgData = nArray;
    }

    public static void setResourcePath(String path) {
        resPathGlobal = path;
    }

    protected static boolean isCanvasInitialized() {
        return MainScreen.hasProperDimensions();
    }

    public abstract void notifyInterruption();

    public final void keyPressed(int n) {
        if (this._synchEvents) {
            this._events.add(new KeyEvent(n, 0));
            return;
        }
        this.onKeyEvent(n, 0);
    }

    public final void keyReleased(int n) {
        if (this._synchEvents) {
            this._events.add(new KeyEvent(n, 1));
            return;
        }
        this.onKeyEvent(n, 1);
    }

    public final void keyRepeated(int n) {
        if (this._synchEvents) {
            this._events.add(new KeyEvent(n, 2));
            return;
        }
        this.onKeyEvent(n, 2);
    }

    public final void pointerPressed(int n, int n2) {
        if (this._synchEvents) {
            this._events.add(new PointerEvent(this, n, n2, 0));
        }
    }

    public final void pointerReleased(int n, int n2) {
        if (this._synchEvents) {
            this._events.add(new PointerEvent(this, n, n2, 1));
        }
    }

    public final void pointerDragged(int n, int n2) {
        if (this._synchEvents) {
            this._events.add(new PointerEvent(this, n, n2, 2));
        }
    }

    public final void commmandAction(Command command) {
        if (this._synchEvents) {
            this._events.add(new CommandEvent(this, command));
        }
    }

    public static void incProgress(int step) {
        _gsm.incLoadProgress(step);
    }

    public static int getProgress() {
        return _gsm.getLoadProgress();
    }

    protected final void finish() {
        this._cm.finish();
    }

    protected void pause(boolean bl) {
    }

    protected final void changeLanguage(String string, String string2, IReader iReader) {
        currLang = (Integer)this.languageIntegerMap.get(string);
        this.loadText(string2, iReader);
    }

    protected final int getLanguageId(String name) {
        return (Integer)this.languageIntegerMap.get(name);
    }

    public static int getCurrLang() {
        return currLang;
    }

    protected final String getSignature(int lang) {
        return (String)this.languageMap.get(new Integer(lang));
    }

    protected abstract String getNameMenu(int var1);

    protected final void addLanguage(int n) {
        switch (n) {
            case 7: {
                this.languageOptions.addElement("English");
                this.languageIntegerMap.put("English", new Integer(7));
                this.languageMap.put(new Integer(7), "en");
                return;
            }
            case 0: {
                this.languageOptions.addElement("Polski");
                this.languageIntegerMap.put("Polski", new Integer(0));
                this.languageMap.put(new Integer(0), "pl");
                return;
            }
            case 1: {
                this.languageOptions.addElement("Deutsch");
                this.languageIntegerMap.put("Deutsch", new Integer(1));
                this.languageMap.put(new Integer(1), "de");
                return;
            }
            case 2: {
                this.languageOptions.addElement("\u010cesky");
                this.languageIntegerMap.put("\u010cesky", new Integer(2));
                this.languageMap.put(new Integer(2), "cz");
                return;
            }
            case 3: {
                this.languageOptions.addElement("English");
                this.languageIntegerMap.put("English", new Integer(3));
                this.languageMap.put(new Integer(3), "us");
                return;
            }
            case 9: {
                this.languageOptions.addElement("Fran\u00e7ais");
                this.languageIntegerMap.put("Fran\u00e7ais", new Integer(9));
                this.languageMap.put(new Integer(9), "fr");
                return;
            }
            case 5: {
                this.languageOptions.addElement("Espa\u00f1ol");
                this.languageIntegerMap.put("Espa\u00f1ol", new Integer(5));
                this.languageMap.put(new Integer(5), "es");
                return;
            }
            case 4: {
                this.languageOptions.addElement("Italiano");
                this.languageIntegerMap.put("Italiano", new Integer(4));
                this.languageMap.put(new Integer(4), "it");
                return;
            }
            case 6: {
                this.languageOptions.addElement("Simpified Chinese");
                this.languageIntegerMap.put("Simpified Chinese", new Integer(6));
                this.languageMap.put(new Integer(6), "cs");
                return;
            }
            case 8: {
                this.languageOptions.addElement("\u0639\u0631\u0628\u064a");
                this.languageIntegerMap.put("\u0639\u0631\u0628\u064a", new Integer(8));
                this.languageMap.put(new Integer(8), "ar");
                return;
            }
            case 10: {
                this.languageOptions.addElement("Turkish");
                this.languageIntegerMap.put("Turkish", new Integer(10));
                this.languageMap.put(new Integer(10), "tr");
                return;
            }
            case 12: {
                this.languageOptions.addElement("Traditional Chinese");
                this.languageIntegerMap.put("Traditional Chinese", new Integer(12));
                this.languageMap.put(new Integer(12), "ct");
                return;
            }
            case 11: {
                this.languageOptions.addElement("\u0420\u0443\u0441\u0441\u043a\u0438\u0439");
                this.languageIntegerMap.put("\u0420\u0443\u0441\u0441\u043a\u0438\u0439", new Integer(11));
                this.languageMap.put(new Integer(11), "ru");
                return;
            }
            case 13: {
                this.languageOptions.addElement("Nederlands");
                this.languageIntegerMap.put("Nederlands", new Integer(13));
                this.languageMap.put(new Integer(13), "nl");
                return;
            }
            case 14: {
                this.languageOptions.addElement("Portugu\u00eas");
                this.languageIntegerMap.put("Portugu\u00eas", new Integer(14));
                this.languageMap.put(new Integer(14), "pt");
                return;
            }
            case 15: {
                this.languageOptions.addElement("Vi\u1ec7t");
                this.languageIntegerMap.put("Vi\u1ec7t", new Integer(15));
                this.languageMap.put(new Integer(13), "vi");
                return;
            }
            case 16: {
                this.languageOptions.addElement("Bahasa Indonesia");
                this.languageIntegerMap.put("Bahasa Indonesia", new Integer(16));
                this.languageMap.put(new Integer(16), "id");
                return;
            }
            case 17: {
                this.languageOptions.addElement("Melayu");
                this.languageIntegerMap.put("Melayu", new Integer(17));
                this.languageMap.put(new Integer(17), "ms");
            }
        }
    }

    protected final void addRootFont(int[] ids) {
        this.rootFonts = ids;
    }

    protected final void addDiacriticalFont(int n, int[] nArray) {
        this.languageFonts.put(new Integer(n), nArray);
    }

    protected final int getRootFont$134621() {
        return this.rootFonts[0];
    }

    protected final Hashtable getDiacriticalFonts$1aa4ccc1() {
        return this.diacriticalFonts[0];
    }

    protected final void bindFonts() {
        int n = this.rootFonts.length;
        this.diacriticalFonts = new Hashtable[n];
        for (int i = 0; i < n; ++i) {
            this.diacriticalFonts[i] = new Hashtable();
            Enumeration enumeration = this.languageFonts.keys();
            while (enumeration.hasMoreElements()) {
                int n2 = (Integer)enumeration.nextElement();
                int n3 = i;
                n3 = ((int[])this.languageFonts.get(new Integer(n2)))[n3];
                this.diacriticalFonts[i].put(new Integer(n2), new Integer(n3));
            }
        }
    }

    protected final String[] buildLanguageMenu() {
        String[] options = new String[this.languageOptions.size()];
        for (int i = 0; i < this.languageOptions.size(); ++i) {
            options[i] = (String)this.languageOptions.elementAt(i);
        }
        return options;
    }

    protected String[] getOptionsMenu(int n) {
        int[] nArray = (int[])this.menuChildren.get(new Integer(n));
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = this.getNameMenu(nArray[i]);
        }
        return stringArray;
    }

    protected final int getNextMenu(int n, int n2) {
        int[] nArray = (int[])this.menuChildren.get(new Integer(n));
        if (nArray == null) {
            return -1;
        }
        return nArray[n2];
    }

    protected final int getPrevMenu(int menu) {
        Integer i = (Integer)this.menuParent.get(new Integer(menu));
        if (i == null) {
            return -1;
        }
        return i;
    }

    protected final int getIndexMenu(int n) {
        int n2 = this.getPrevMenu(n);
        if (n2 == -1) {
            return 0;
        }
        int[] nArray = (int[])this.menuChildren.get(new Integer(n2));
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    protected final void makeMenu(int menu, int[] submenu) {
        this.bindChildren(menu, submenu);
        for (int m = 0; m < submenu.length; ++m) {
            this.bindParent(submenu[m], menu);
        }
    }

    protected final void addMenuEntry(int n, int n2, int n3) {
        int n4;
        int[] nArray = (int[])this.menuChildren.get(new Integer(n));
        if (nArray == null) {
            nArray = new int[]{};
        }
        int[] nArray2 = new int[nArray.length + 1];
        for (n4 = 0; n4 < nArray.length; ++n4) {
            if (nArray[n4] != n2) continue;
            return;
        }
        if (n3 < 0 || n3 > nArray.length) {
            n3 = nArray2.length - 1;
        }
        n4 = 0;
        for (int i = 0; i < nArray2.length; ++i) {
            if (i == n3) {
                nArray2[i] = n2;
                continue;
            }
            nArray2[i] = nArray[n4];
            ++n4;
        }
        this.bindChildren(n, nArray2);
        this.bindParent(n2, n);
    }

    protected final void delMenuEntry$13462e() {
        int n;
        Integer n2 = new Integer(207);
        n2 = (Integer)this.menuParent.get(n2);
        int[] nArray = (int[])this.menuChildren.get(n2);
        int[] nArray2 = new int[nArray.length - 1];
        int n3 = 0;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] != 207) continue;
            n3 = 1;
        }
        if (n3 == 0) {
            return;
        }
        n = 0;
        for (n3 = 0; n3 < nArray2.length; ++n3) {
            int n4 = nArray[n];
            if (n4 == 207) {
                --n3;
            } else {
                nArray2[n3] = n4;
            }
            ++n;
        }
        this.bindChildren(n2, nArray2);
    }

    private void bindParent(int n, int n2) {
        Integer n3 = new Integer(n);
        if (this.menuParent.containsKey(n3)) {
            this.menuParent.remove(n3);
        }
        this.menuParent.put(new Integer(n), new Integer(n2));
    }

    private void bindChildren(int n, int[] nArray) {
        Integer n2 = new Integer(n);
        if (this.menuChildren.containsKey(n2)) {
            this.menuChildren.remove(n2);
        }
        this.menuChildren.put(new Integer(n), nArray);
    }

    public abstract void drawGame(Graphics var1);

    protected abstract void thinkGame();

    protected abstract void doAction(int var1, int var2, int var3);

    protected abstract void onKeyEvent(int var1, int var2);

    public final void think() {
        block5: {
            block4: {
                if (!this._synchEvents) break block4;
                this._events.execute();
                if (_gsm.isStatePrepared()) break block5;
            }
            this.thinkGame();
        }
        if (_gsm.isStatePrepared()) {
            _gsm.changeState();
        }
    }

    public final void draw(Graphics g) {
        int w = width;
        int h = height;
        if (Main.hasLandscapeSupport() && _ssm.getState() == 3) {
            w = tmpWidth;
            h = tmpHeight;
        }
        g.setClip(0, 0, w, h);
        g.setColor(-16777216);
        g.fillRect(0, 0, w, h);
        this.drawGame(g);
    }

    public static void changeState(int n, int n2, int n3, boolean bl) {
        _gsm.prepareState(n, n2, n3, bl);
    }

    public final void pushState$255f295(int state) {
        this._stack.addElement(new int[]{state, -1});
        _ssm.changeState(state, -1, 0, false);
    }

    public final void popState() {
        this._stack.removeElement(this._stack.lastElement());
        int[] nArray = (int[])this._stack.lastElement();
        _ssm.changeState(nArray[0], nArray[1], 0, false);
    }

    public static int getGameState() {
        return _gsm.getState();
    }

    public static int getGameNextState() {
        return _gsm.getNextState();
    }

    public static int getGamePrevState() {
        return _gsm.getPrevState();
    }

    public static int getGameSubState() {
        return _gsm.getSubState();
    }

    public static int getGameNextSubState() {
        return _gsm.getNextSubState();
    }

    public static int getGamePrevSubState() {
        return _gsm.getPrevSubState();
    }

    public static int getSystemState() {
        return _ssm.getState();
    }

    public static void drawGradient$5ba08a83(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n4 >> 16 & 0xFF;
        int n9 = n4 >> 8 & 0xFF;
        n4 &= 0xFF;
        int n10 = n5 >> 16 & 0xFF;
        int n11 = n5 >> 8 & 0xFF;
        n5 &= 0xFF;
        int n12 = n6 << 10;
        n <<= 10;
        n3 = (n3 << 10) / n6;
        for (n6 = 0; n6 < n7; ++n6) {
            int n13 = n8 + (n6 * (n10 - n8) << 10) / n12;
            int n14 = n9 + (n6 * (n11 - n9) << 10) / n12;
            int n15 = n4 + (n6 * (n5 - n4) << 10) / n12;
            graphics.setColor(n13, n14, n15);
            graphics.fillRect(0, n >> 10, n2, (n3 >> 10) + 1);
            n += n3;
        }
    }

    public static void drawString(Graphics graphics, String stringArray, int n, int n2, int n3, Font font) {
        int n4 = font.getHeight() + 1;
        stringArray = Container.wrapText((String)stringArray, width, font);
        graphics.setFont(font);
        for (int i = 0; i < stringArray.length; ++i) {
            graphics.drawString(stringArray[i], n, n2 + i * n4, n3);
        }
    }

    public static javax.microedition.lcdui.game.Sprite loadSystemSprite(int n) {
        int n2 = imgData[n][1];
        int n3 = imgData[n][0];
        String string = resPathGlobal + "/" + imgNames[n];
        string = new javax.microedition.lcdui.game.Sprite(GameImage.createSystemSpriteImage(string), n3, n2);
        string.setRefPixelPosition(string.getWidth() / 2, string.getHeight() / 2);
        return string;
    }

    public static Sprite loadTqmSprite(int shortName) {
        Sprite s = new Sprite(GameImage.createTqmSpriteImage(resPathGlobal + "/" + imgNames[shortName]), imgData[shortName][0], imgData[shortName][1]);
        s.setRefPixelPosition(s.getWidth() / 2, s.getHeight() / 2);
        return s;
    }

    public static ExtendedSprite loadExtendedSprite(int n) {
        return new ExtendedSprite(GameImage.createTqmSpriteImage(resPathGlobal + "/" + imgNames[n]), MainLogic.getExtSpriteResName(n));
    }

    public static String getFontMapResName(int shortName) {
        return "/" + imgNames[shortName] + ".png.m";
    }

    public static String getExtSpriteResName(int shortName) {
        return "/" + imgNames[shortName] + ".png.r";
    }

    public static void disposeImage(int n) {
        GameImage.dispose(resPathGlobal + "/" + imgNames[n]);
    }

    protected abstract void replaceTemplates();

    public final void loadText(String string, IReader iReader) {
        if (!string.equals("")) {
            string = "/" + string;
        }
        try {
            if (this.languageMap.isEmpty()) {
                string = string + "/strings.mas";
                strings = iReader.readLanguage(string);
            } else {
                string = string + "/strings_" + (String)this.languageMap.get(new Integer(currLang)) + ".mas";
                strings = iReader.readLanguage(string);
            }
            this.replaceTemplates();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static String replaceKeyString(String charSequence, String string, String string2) {
        int n = ((String)charSequence).indexOf(string);
        charSequence = new StringBuffer((String)charSequence);
        if (n != -1) {
            ((StringBuffer)charSequence).delete(n, n + string.length());
            ((StringBuffer)charSequence).insert(n, string2);
        }
        return ((StringBuffer)charSequence).toString();
    }

    protected static void setSystemFontOffset(int offset) {
        fontOffset = 0;
    }

    public static int getSystemFontOffset() {
        return fontOffset;
    }

    public final boolean goToUrl(String url) throws ConnectionNotFoundException {
        return this._cm.goToUrl(url);
    }

    static {
        resPathGlobal = "";
    }

    private final class EventBuffer {
        private final Object lockBuffer = new Object();
        private Vector _events = new Vector();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void add(Event event) {
            Object object = this.lockBuffer;
            synchronized (object) {
                this._events.addElement(event);
                return;
            }
        }

        public final void execute() {
            Event[] events = this.take();
            for (int i = 0; i < events.length; ++i) {
                events[i].perform();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Event[] take() {
            Object[] objectArray;
            Object object = this.lockBuffer;
            synchronized (object) {
                objectArray = new Event[this._events.size()];
                this._events.copyInto(objectArray);
                this._events.removeAllElements();
            }
            return objectArray;
        }
    }

    private final class CommandEvent
    implements Event {
        public CommandEvent(MainLogic mainLogic, Command command) {
        }

        public final void perform() {
        }
    }

    private final class PointerEvent
    implements Event {
        public PointerEvent(MainLogic mainLogic, int n, int n2, int n3) {
        }

        public final void perform() {
        }
    }

    private final class KeyEvent
    implements Event {
        private int _key;
        private int _event;

        public KeyEvent(int key, int event) {
            this._key = key;
            this._event = event;
        }

        public final void perform() {
            MainLogic.this.onKeyEvent(this._key, this._event);
        }
    }

    private static interface Event {
        public void perform();
    }

    private final class FSM
    implements Runnable {
        private Thread _threadLoad;
        private boolean _prepared;
        private int _loadProgress;
        private int _maxLoadProgress = 100;
        private int _maxLoadFullTime = 500;
        private int _currState = -1;
        private int _currSubState = -1;
        private int _nextState = -1;
        private int _nextSubState = -1;
        private int _prevState = -1;
        private int _prevSubState = -1;
        private int _tmpTransition;
        private boolean _tmpThread;

        public final int getState() {
            return this._currState;
        }

        public final int getNextState() {
            return this._nextState;
        }

        public final int getPrevState() {
            return this._prevState;
        }

        public final int getSubState() {
            return this._currSubState;
        }

        public final int getNextSubState() {
            return this._nextSubState;
        }

        public final int getPrevSubState() {
            return this._prevSubState;
        }

        public final int getLoadProgress() {
            return this._loadProgress;
        }

        public final boolean isStatePrepared() {
            return this._prepared;
        }

        public final void incLoadProgress(int amount) {
            this._loadProgress += amount;
            if (this._loadProgress > this._maxLoadProgress) {
                this._loadProgress = this._maxLoadProgress;
            }
        }

        public final synchronized void prepareState(int nextState, int nextSubState, int transition, boolean thread) {
            this._nextState = nextState;
            this._nextSubState = nextSubState;
            this._tmpTransition = transition;
            this._tmpThread = thread;
            this._prepared = true;
        }

        public final synchronized void changeState() {
            this._prepared = false;
            this.changeState(this._nextState, this._nextSubState, this._tmpTransition, this._tmpThread);
        }

        public final synchronized void changeState(int n, int n2, int n3, boolean bl) {
            this._nextState = n;
            this._nextSubState = n2;
            this._tmpTransition = n3;
            this._prevState = this._currState;
            this._prevSubState = this._currSubState;
            if (!bl) {
                this.loadState();
                this.assignStates();
                return;
            }
            this._loadProgress = 0;
            this._currState = 0;
            this._threadLoad = new Thread(this);
            this._threadLoad.start();
        }

        public final void run() {
            this.loadState();
            int n = this._maxLoadFullTime;
            FSM fSM = this;
            fSM._loadProgress = fSM._maxLoadProgress;
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.assignStates();
        }

        private void loadState() {
            int n = this._nextState;
            int n2 = this._prevState;
            int n3 = this._nextSubState;
            int n4 = this._prevSubState;
            int n5 = this._tmpTransition;
            if (n4 != -1 && n2 == n) {
                MainLogic.this.doAction(n4, n5, 1);
                MainLogic.this.doAction(n4, n3, 2);
                MainLogic.this.doAction(n3, n5, 0);
                return;
            }
            MainLogic.this.doAction(n4, n5, 1);
            MainLogic.this.doAction(n2, n5, 1);
            MainLogic.this.doAction(n2, n, 2);
            MainLogic.this.doAction(n, n5, 0);
            MainLogic.this.doAction(n3, n5, 0);
        }

        private void assignStates() {
            this._currState = this._nextState;
            this._currSubState = this._nextSubState;
            this._nextState = -1;
            this._nextSubState = -1;
            this._prevState = -1;
            this._prevSubState = -1;
        }
    }
}

