/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense;

import com.tqm.fantasydefense.GameLogic;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class FontWrapper {
    private Font _font;
    private Image _gFont;
    private Image _gDFont;
    private int[] _fontCoords;
    private int[] _dfontCoords;
    private int _spacing;
    private short[] _fontCodes;
    private short[] _dfontCodes;
    private byte[] _codesToIndex;
    private int _mode;

    public FontWrapper(String string) {
        this._gFont = null;
        this._gDFont = null;
        this.reloadFont(string);
    }

    private void loadFontSettings(String object, int n) {
        try {
            object = new DataInputStream(this.getClass().getResourceAsStream((String)object));
            int n2 = ((DataInputStream)object).readShort();
            int[] nArray = new int[n2 << 2];
            short[] sArray = new short[n2];
            for (int i = 0; i < n2; ++i) {
                sArray[i] = ((DataInputStream)object).readShort();
                nArray[i << 2] = ((DataInputStream)object).readShort();
                nArray[(i << 2) + 1] = ((DataInputStream)object).readShort();
                nArray[(i << 2) + 2] = ((DataInputStream)object).readShort();
                nArray[(i << 2) + 3] = ((DataInputStream)object).readShort();
            }
            ((FilterInputStream)object).close();
            switch (n) {
                case 0: {
                    this._fontCoords = nArray;
                    this._fontCodes = sArray;
                    return;
                }
            }
            this._dfontCoords = nArray;
            this._dfontCodes = sArray;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private void deinitialize() {
        this._gFont = null;
        this._fontCoords = null;
        this._gDFont = null;
        this._dfontCoords = null;
    }

    public final int stringWidth(String object) {
        int n = ((String)object).length();
        char[] cArray = ((String)object).toCharArray();
        object = this;
        int n2 = 0;
        switch (((FontWrapper)object)._mode) {
            case 2: {
                for (int i = 0; i < n; ++i) {
                    n2 += super.getGFontCharWidth(cArray[i]) + ((FontWrapper)object)._spacing;
                }
                break;
            }
            case 1: {
                n2 = ((FontWrapper)object)._font.charsWidth(cArray, 0, n);
            }
        }
        return n2;
    }

    private int getGFontCharWidth(char c) {
        if (c == '\n') {
            return 0;
        }
        if (this._codesToIndex[c] > 0) {
            return this._fontCoords[4 * (this._codesToIndex[c] - 1) + 2];
        }
        return this._dfontCoords[4 * (-this._codesToIndex[c] - 1) + 2];
    }

    public final int getHeight() {
        switch (this._mode) {
            case 2: {
                return this._fontCoords[3];
            }
            case 1: {
                return this._font.getHeight();
            }
        }
        return 0;
    }

    public final void drawString(Graphics graphics, String string, int n, int n2, int n3) {
        if (this._mode == 2) {
            string = string.toUpperCase();
        }
        string = string.trim();
        int c = this.stringWidth(string);
        if ((n3 & 2) != 0) {
            n2 -= this.getHeight() >> 1;
            n3 = n3 & 0xFFFFFFFD | 0x10;
        }
        switch (this._mode) {
            case 1: {
                graphics.setFont(this._font);
                graphics.setColor(-7388160);
                graphics.drawString(string, n, n2, n3);
                return;
            }
            case 2: {
                if ((n3 & 0x40) != 0 || (n3 & 0x20) != 0) {
                    n2 -= this.getHeight();
                }
                if ((n3 & 4) == 0) {
                    if ((n3 & 1) != 0) {
                        n -= c >> 1;
                    } else if ((n3 & 8) != 0) {
                        n -= c;
                    }
                }
                for (n3 = 0; n3 < string.length(); ++n3) {
                    int n4;
                    char c2 = this._codesToIndex[string.charAt(n3)];
                    Image image = c2 > '\u0000' ? this._gFont : this._gDFont;
                    int[] nArray = c2 > '\u0000' ? this._fontCoords : this._dfontCoords;
                    c2 = Math.abs(c2) - 1;
                    graphics.drawRegion(image, nArray[c2 << 2], nArray[(c2 << 2) + 1], nArray[(c2 << 2) + 2], nArray[(c2 << 2) + 3], 0, n, n2, 0);
                    c2 = string.charAt(n3);
                    FontWrapper fontWrapper = this;
                    switch (fontWrapper._mode) {
                        case 2: {
                            n4 = fontWrapper.getGFontCharWidth(c2);
                            break;
                        }
                        case 1: {
                            n4 = fontWrapper._font.charWidth(c2);
                            break;
                        }
                        default: {
                            n4 = 0;
                        }
                    }
                    n += n4 + this._spacing;
                }
                break;
            }
        }
    }

    public final void reloadFont(String object) {
        String string = "g_fontbasic.ch";
        String string2 = null;
        String string3 = null;
        String string4 = "g_fontbasic_158x66.png";
        if (!((String)object).equals("en")) {
            if (((String)object).equals("de")) {
                string3 = "g_fontde.ch";
                string2 = "g_fontde_50x22.png";
            } else if (((String)object).equals("es")) {
                string3 = "g_fontes.ch";
                string2 = "g_fontes_85x22.png";
            } else if (((String)object).equals("fr")) {
                string3 = "g_fontfr.ch";
                string2 = "g_fontfr_149x22.png";
            } else if (((String)object).equals("it")) {
                string3 = "g_fontit.ch";
                string2 = "g_fontit_93x22.png";
            } else if (((String)object).equals("pt")) {
                string3 = "g_fontpt.ch";
                string2 = "g_fontpt_119x22.png";
            } else {
                this.deinitialize();
                this._font = null;
                object = GameLogic.getDefaultFontParams();
                this._font = Font.getFont((int)object[0], (int)object[1], (int)object[2]);
                this._mode = 1;
                return;
            }
        }
        String string5 = string2;
        string2 = string;
        string = string5;
        object = this;
        ((FontWrapper)object).deinitialize();
        try {
            ((FontWrapper)object)._gFont = Image.createImage((String)("/com/tqm/fantasydefense/" + string4));
            super.loadFontSettings("/com/tqm/fantasydefense/" + string2, 0);
            if (string != null) {
                ((FontWrapper)object)._gDFont = Image.createImage((String)("/com/tqm/fantasydefense/" + string));
                super.loadFontSettings("/com/tqm/fantasydefense/" + string3, 1);
            } else {
                ((FontWrapper)object)._gDFont = null;
                ((FontWrapper)object)._dfontCoords = null;
                ((FontWrapper)object)._dfontCodes = null;
            }
            try {
                int n;
                ((FontWrapper)object)._codesToIndex = new byte[500];
                for (n = 0; n < ((FontWrapper)object)._fontCodes.length; ++n) {
                    ((FontWrapper)object)._codesToIndex[((FontWrapper)object)._fontCodes[n]] = (byte)(n + 1);
                }
                if (string != null) {
                    for (n = 0; n < ((FontWrapper)object)._dfontCodes.length; ++n) {
                        ((FontWrapper)object)._codesToIndex[((FontWrapper)object)._dfontCodes[n]] = (byte)(-n - 1);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ((FontWrapper)object)._mode = 2;
        ((FontWrapper)object)._spacing = -1;
    }

    public FontWrapper() {
    }
}

