/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.game;

import com.tqm.fantasydefense.GameLogic;
import com.tqm.fantasydefense.GameTemplate;
import com.tqm.fantasydefense.game.Enemy;
import com.tqm.fantasydefense.game.EnemyWaves;
import com.tqm.fantasydefense.game.ParticleGroup;
import com.tqm.fantasydefense.game.Unit;
import com.tqm.fantasydefense.shop.secret.SecretElixir;
import com.tqm.fantasydefense.shop.secret.SecretItemsManager;
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public final class Defender
extends Unit {
    private int _hit;
    private int _idle;
    public int _level;
    public int _range;
    private int _rangeSquared;
    public int _rangeSpecial;
    private int _rangeSpecialSquared;
    public int _damageGround;
    public int _damageAir;
    private int _damageAdditional;
    private int _slowdownChance;
    private int _currentAttackDelay;
    public int _startAttackDelay;
    private int _auraDelay;
    private int _frame;
    public int _tileX;
    public int _tileY;
    private boolean _front = true;
    private boolean _left = true;
    private static int dx;
    private static int dy;
    private static Enemy enemy;
    private static int _enemyDistanceFromRoadEnd;
    private static int _enemyDistanceFromRoadEndAir;
    private static boolean _enemyIsAir;
    public static Random rand;
    public static SecretElixir[] secretElixir;
    private static int drawBiasX;
    private static int drawBiasY;
    private Enemy enemyToHitObj;

    private void calculateRange(int n) {
        this._range = this._range * 28 * 3 / 20 * (n + 100) / 100;
        this._rangeSquared = this._range * this._range;
        this._rangeSpecial = this._rangeSpecial * 28 * 3 / 20 * (n + 100) / 100;
        this._rangeSpecialSquared = this._rangeSpecial * this._rangeSpecial;
    }

    private boolean inRange(int x, int y) {
        dx = x - this._x;
        dy = (y - this._y) * 28 / 26;
        return dx * dx + dy * dy <= this._rangeSquared;
    }

    public final void setPosition(int tileX, int tileY) {
        this._tileX = tileX;
        this._tileY = tileY;
        this._x = tileX * 28 - tileY * 13;
        this._y = tileY * 26;
    }

    public Defender(int n, int n2, int n3, boolean bl) {
        this._tileX = n;
        this._tileY = n2;
        this._x = n * 28 - n2 * 13;
        this._y = n2 * 26;
        this._type = n3;
        this._frame = 0;
        this._currentAttackDelay = 0;
        this._level = 1;
        this._front = true;
        this._left = true;
        switch (this._type) {
            case 20: {
                this._width = GameTemplate.knight.getWidth();
                this._height = GameTemplate.knight.getHeight();
                this.setUnitStats(bl & GameTemplate._elixirsActive);
                return;
            }
            case 21: {
                this._width = GameTemplate.archer.getWidth();
                this._height = GameTemplate.archer.getHeight();
                this.setUnitStats(bl & GameTemplate._elixirsActive);
                return;
            }
            case 22: {
                this._width = GameTemplate.sorcerer.getWidth();
                this._height = GameTemplate.sorcerer.getHeight();
                this.setUnitStats(bl & GameTemplate._elixirsActive);
                return;
            }
            case 23: {
                this._width = GameTemplate.paladin.getWidth();
                this._height = GameTemplate.paladin.getHeight();
                this.setUnitStats(bl & GameTemplate._elixirsActive);
                return;
            }
            case 24: {
                this._width = GameTemplate.elf.getWidth();
                this._height = GameTemplate.elf.getHeight();
                this.setUnitStats(bl & GameTemplate._elixirsActive);
                return;
            }
            case 25: {
                this._width = GameTemplate.warlock.getWidth();
                this._height = GameTemplate.warlock.getHeight();
                this.setUnitStats(bl & GameTemplate._elixirsActive);
            }
        }
    }

    public final boolean upgradeUnit() {
        if (this._level < 3 && this.price(this._level + 1) <= GameTemplate._money) {
            GameTemplate._money -= this.price(this._level + 1);
            ++this._level;
            this.setUnitStats(GameTemplate._elixirsActive);
            return true;
        }
        return false;
    }

    public final int sellPrice() {
        int n = 0;
        for (int i = 1; i <= this._level; ++i) {
            n += this.price(i);
        }
        return n / 2;
    }

    public final int price(int level) {
        switch (this._type) {
            case 20: {
                if (level == 1) {
                    return 40;
                }
                if (level == 2) {
                    return 20;
                }
                return 40;
            }
            case 21: {
                if (level == 1) {
                    return 60;
                }
                if (level == 2) {
                    return 30;
                }
                return 60;
            }
            case 22: {
                if (level == 1) {
                    return 50;
                }
                if (level == 2) {
                    return 25;
                }
                return 50;
            }
            case 23: {
                if (level == 1) {
                    return 70;
                }
                if (level == 2) {
                    return 35;
                }
                return 70;
            }
            case 24: {
                if (level == 1) {
                    return 90;
                }
                if (level == 2) {
                    return 45;
                }
                return 90;
            }
            case 25: {
                if (level == 1) {
                    return 80;
                }
                if (level == 2) {
                    return 40;
                }
                return 80;
            }
        }
        return 0;
    }

    public final void setUnitStats(boolean bl) {
        this._rangeSpecial = 0;
        switch (this._type) {
            case 20: {
                this._damageAir = 0;
                if (this._level == 1) {
                    this._range = 10;
                    this._damageGround = 20;
                    this._startAttackDelay = 12;
                    break;
                }
                if (this._level == 2) {
                    this._range = 10;
                    this._damageGround = 25;
                    this._startAttackDelay = 12;
                    break;
                }
                this._range = 10;
                this._damageGround = 30;
                this._startAttackDelay = 8;
                break;
            }
            case 21: {
                if (this._level == 1) {
                    this._damageGround = 5;
                    this._damageAir = 15;
                    this._range = 13;
                    this._startAttackDelay = 12;
                    break;
                }
                if (this._level == 2) {
                    this._damageGround = 10;
                    this._damageAir = 20;
                    this._range = 14;
                    break;
                }
                this._damageGround = 15;
                this._damageAir = 25;
                this._range = 15;
                this._startAttackDelay = 8;
                break;
            }
            case 22: {
                if (this._level == 1) {
                    this._range = 12;
                    this._damageGround = 15;
                    this._damageAir = 10;
                    this._startAttackDelay = 16;
                    this._slowdownChance = 70;
                    break;
                }
                if (this._level == 2) {
                    this._damageGround = 20;
                    this._damageAir = 15;
                    this._range = 13;
                    this._startAttackDelay = 16;
                    this._slowdownChance = 80;
                    break;
                }
                this._damageGround = 25;
                this._damageAir = 20;
                this._range = 14;
                this._startAttackDelay = 12;
                this._slowdownChance = 90;
                break;
            }
            case 23: {
                this._damageAir = 0;
                if (this._level == 1) {
                    this._range = 10;
                    this._rangeSpecial = 11;
                    this._damageGround = 30;
                    this._startAttackDelay = 12;
                    break;
                }
                if (this._level == 2) {
                    this._range = 10;
                    this._rangeSpecial = 11;
                    this._damageGround = 35;
                    this._startAttackDelay = 12;
                    break;
                }
                this._range = 10;
                this._rangeSpecial = 11;
                this._damageGround = 40;
                this._startAttackDelay = 8;
                break;
            }
            case 24: {
                if (this._level == 1) {
                    this._damageGround = 10;
                    this._damageAir = 20;
                    this._range = 15;
                    this._startAttackDelay = 12;
                    this._damageAdditional = 8;
                    break;
                }
                if (this._level == 2) {
                    this._damageGround = 15;
                    this._damageAir = 25;
                    this._range = 16;
                    this._damageAdditional = 10;
                    break;
                }
                this._damageGround = 20;
                this._damageAir = 30;
                this._range = 17;
                this._startAttackDelay = 8;
                this._damageAdditional = 12;
                break;
            }
            case 25: {
                if (this._level == 1) {
                    this._range = 13;
                    this._damageGround = 15;
                    this._damageAir = 15;
                    this._startAttackDelay = 16;
                    this._slowdownChance = 0;
                    this._damageAdditional = 8;
                    break;
                }
                if (this._level == 2) {
                    this._damageGround = 20;
                    this._damageAir = 20;
                    this._range = 14;
                    this._startAttackDelay = 16;
                    this._damageAdditional = 12;
                    break;
                }
                this._damageGround = 25;
                this._damageAir = 25;
                this._range = 15;
                this._startAttackDelay = 12;
                this._damageAdditional = 16;
            }
        }
        if (bl) {
            if (secretElixir == null) {
                secretElixir = SecretItemsManager.getInstance().getElixirs();
            }
            if (secretElixir[0].isActive()) {
                this.calculateRange(secretElixir[0].getPower());
            } else if (secretElixir[1].isActive()) {
                this.calculateRange(secretElixir[1].getPower());
            } else {
                this.calculateRange(0);
            }
            if (secretElixir[4].isActive()) {
                this._damageAir = this._damageAir * (100 + secretElixir[4].getPower()) / 100;
                this._damageGround = this._damageGround * (100 + secretElixir[4].getPower()) / 100;
            } else if (secretElixir[5].isActive()) {
                this._damageAir = this._damageAir * (100 + secretElixir[5].getPower()) / 100;
                this._damageGround = this._damageGround * (100 + secretElixir[5].getPower()) / 100;
            }
            if (secretElixir[2].isActive()) {
                this._startAttackDelay = this._startAttackDelay * (100 - secretElixir[2].getPower()) / 100;
                return;
            }
            if (secretElixir[2].isActive()) {
                this._startAttackDelay = this._startAttackDelay * (100 - secretElixir[2].getPower()) / 100;
                return;
            }
        } else {
            this.calculateRange(0);
        }
    }

    public final void drawShadow(Graphics g) {
        GameTemplate.shadow.setPosition(this._x + GameTemplate.viewX - (GameTemplate.shadow.getWidth() >> 1) + 20, this._y + GameTemplate.viewY - (GameTemplate.shadow.getHeight() >> 1) + 13);
        GameTemplate.shadow.setFrame(1);
        GameTemplate.shadow.paint(g);
        if (this._type == 23) {
            GameTemplate.aura.setPosition(this._x + GameTemplate.viewX - (GameTemplate.aura.getWidth() >> 1) + 20, this._y + GameTemplate.viewY - (GameTemplate.aura.getHeight() >> 1) + 13);
            GameTemplate.aura.setFrame(GameTemplate.getIter() % 4);
            GameTemplate.aura.paint(g);
        }
    }

    public final void draw(Graphics g) {
        drawBiasX = 0;
        drawBiasY = 0;
        if (this._type == 21) {
            drawBiasX = -8;
        } else if (this._type == 24) {
            drawBiasY = 2;
        } else if (this._type == 25 || this._type == 22) {
            drawBiasY = 2;
        } else if (this._type == 20) {
            if (this._front) {
                drawBiasX = -14;
            } else {
                drawBiasX = 2;
                drawBiasY = 2;
            }
        } else if (this._type == 23) {
            drawBiasY = 8;
        }
        if (!GameTemplate._pause) {
            if (this._type != 25 && this._type != 22) {
                if (this._hit > 0) {
                    this._frame = this._hit > 2 ? 2 : 3;
                    --this._hit;
                } else {
                    this._frame = 0;
                }
            } else if (this._hit > 0) {
                this._frame = this._hit > 4 ? 2 : (this._hit > 2 ? 3 : 4);
                --this._hit;
            } else {
                this._frame = 0;
            }
            if (this._frame == 0) {
                if (this._idle <= 0) {
                    this._idle = 24 + Math.abs(rand.nextInt() % 8);
                }
                if (this._idle > 0) {
                    --this._idle;
                }
                if (this._idle > 20) {
                    this._frame = 1;
                }
            }
            if (this._type == 25 || this._type == 22) {
                if (!this._front) {
                    this._frame += 5;
                }
            } else if (!this._front) {
                this._frame += 4;
            }
        }
        if (!this._left) {
            drawBiasX = -drawBiasX;
        }
        switch (this._type) {
            case 20: {
                if (this._left) {
                    GameTemplate.knight.setTransform(0);
                } else {
                    GameTemplate.knight.setTransform(2);
                }
                GameTemplate.knight.setPosition(this._x + drawBiasX + GameTemplate.viewX - (this._width >> 1) + 20, this._y + drawBiasY + GameTemplate.viewY - this._height + 13);
                GameTemplate.knight.setFrame(this._frame);
                GameTemplate.knight.paint(g);
                break;
            }
            case 21: {
                if (this._left) {
                    GameTemplate.archer.setTransform(0);
                } else {
                    GameTemplate.archer.setTransform(2);
                }
                GameTemplate.archer.setPosition(this._x + drawBiasX + GameTemplate.viewX - (this._width >> 1) + 20, this._y + GameTemplate.viewY - this._height + 13);
                GameTemplate.archer.setFrame(this._frame);
                GameTemplate.archer.paint(g);
                break;
            }
            case 22: {
                if (this._left) {
                    GameTemplate.sorcerer.setTransform(0);
                } else {
                    GameTemplate.sorcerer.setTransform(2);
                }
                GameTemplate.sorcerer.setPosition(this._x + GameTemplate.viewX - (this._width >> 1) + 20, this._y + drawBiasY + GameTemplate.viewY - this._height + 13);
                GameTemplate.sorcerer.setFrame(this._frame);
                GameTemplate.sorcerer.paint(g);
                break;
            }
            case 23: {
                if (this._left) {
                    GameTemplate.paladin.setTransform(0);
                } else {
                    GameTemplate.paladin.setTransform(2);
                }
                GameTemplate.paladin.setPosition(this._x + GameTemplate.viewX - (this._width >> 1) + 20, this._y + drawBiasY + GameTemplate.viewY - this._height + 13);
                GameTemplate.paladin.setFrame(this._frame);
                GameTemplate.paladin.paint(g);
                break;
            }
            case 24: {
                if (this._left) {
                    GameTemplate.elf.setTransform(0);
                } else {
                    GameTemplate.elf.setTransform(2);
                }
                GameTemplate.elf.setPosition(this._x + GameTemplate.viewX - (this._width >> 1) + 20, this._y + drawBiasY + GameTemplate.viewY - this._height + 13);
                GameTemplate.elf.setFrame(this._frame);
                GameTemplate.elf.paint(g);
                break;
            }
            case 25: {
                if (this._left) {
                    GameTemplate.warlock.setTransform(0);
                } else {
                    GameTemplate.warlock.setTransform(2);
                }
                GameTemplate.warlock.setPosition(this._x + GameTemplate.viewX - (this._width >> 1) + 20, this._y + drawBiasY + GameTemplate.viewY - this._height + 13);
                GameTemplate.warlock.setFrame(this._frame);
                GameTemplate.warlock.paint(g);
            }
        }
        GameTemplate.lvlstars.setFrame(this._level - 1);
        GameTemplate.lvlstars.setPosition(this._x + GameTemplate.viewX, this._y + GameTemplate.viewY - GameTemplate.knight.getHeight() + GameTemplate.lvlstars.getHeight());
        GameTemplate.lvlstars.paint(g);
    }

    public final void think() {
        int n;
        int n2;
        if (this._type == 23) {
            ++this._auraDelay;
            if (this._auraDelay >= 4) {
                this._auraDelay = 0;
                for (n2 = 0; n2 < EnemyWaves.enemies.size(); ++n2) {
                    enemy = (Enemy)EnemyWaves.enemies.elementAt(n2);
                    if (!enemy.isUndead()) continue;
                    int n3 = Defender.enemy._y;
                    int n4 = Defender.enemy._x;
                    Defender defender = this;
                    dx = n4 - defender._x;
                    dy = (n3 - defender._y) * 28 / 26;
                    if (!(dx * dx + dy * dy <= defender._rangeSpecialSquared)) continue;
                    ((Enemy)EnemyWaves.enemies.elementAt(n2)).receiveHit(4);
                }
            }
        }
        if (this._currentAttackDelay > 0) {
            --this._currentAttackDelay;
            return;
        }
        _enemyDistanceFromRoadEnd = 1000000;
        _enemyDistanceFromRoadEndAir = 1000000;
        _enemyIsAir = false;
        n2 = -1;
        if (this._type == 20 || this._type == 23) {
            for (n = 0; n < EnemyWaves.enemies.size(); ++n) {
                enemy = (Enemy)EnemyWaves.enemies.elementAt(n);
                if (Defender.enemy._distanceFromEnd >= _enemyDistanceFromRoadEnd || enemy.isAir() || !this.inRange(Defender.enemy._x, Defender.enemy._y)) continue;
                _enemyDistanceFromRoadEnd = Defender.enemy._distanceFromEnd;
                n2 = n;
            }
        } else {
            for (n = 0; n < EnemyWaves.enemies.size(); ++n) {
                enemy = (Enemy)EnemyWaves.enemies.elementAt(n);
                if (enemy.isAir()) {
                    if (Defender.enemy._distanceFromEnd >= _enemyDistanceFromRoadEndAir || !this.inRange(Defender.enemy._x, Defender.enemy._y)) continue;
                    _enemyIsAir = true;
                    _enemyDistanceFromRoadEndAir = Defender.enemy._distanceFromEnd;
                    n2 = n;
                    continue;
                }
                if (_enemyIsAir || Defender.enemy._distanceFromEnd >= _enemyDistanceFromRoadEnd || !this.inRange(Defender.enemy._x, Defender.enemy._y)) continue;
                _enemyDistanceFromRoadEnd = Defender.enemy._distanceFromEnd;
                n2 = n;
            }
        }
        if (n2 >= 0) {
            this.enemyToHitObj = (Enemy)EnemyWaves.enemies.elementAt(n2);
            this._front = this.enemyToHitObj._y > this._y;
            this._left = this.enemyToHitObj._x <= this._x;
            if (secretElixir[10].isActive() && GameTemplate._elixirsActive) {
                if (Math.abs(rand.nextInt()) % 100 < this._slowdownChance + 50) {
                    this.enemyToHitObj.receiveSlowdown$13462e();
                }
            } else if (this._type == 22 && Math.abs(rand.nextInt()) % 100 < this._slowdownChance) {
                this.enemyToHitObj.receiveSlowdown$13462e();
            }
            if (this.enemyToHitObj.isAir()) {
                this.enemyToHitObj.receiveHit(this._damageAir);
            } else {
                this.enemyToHitObj.receiveHit(this._damageGround);
            }
            if (secretElixir[11].isActive() && GameTemplate._elixirsActive) {
                if (this._type == 24) {
                    this.enemyToHitObj.receivePoison(this._damageAdditional + 7);
                } else {
                    this.enemyToHitObj.receivePoison(7);
                }
            } else if (this._type == 24) {
                this.enemyToHitObj.receivePoison(this._damageAdditional);
            }
            if (secretElixir[9].isActive() && GameTemplate._elixirsActive) {
                if (this._type == 25) {
                    this.enemyToHitObj.receiveFire(this._damageAdditional + 7);
                } else {
                    this.enemyToHitObj.receiveFire(7);
                }
            } else if (this._type == 25) {
                this.enemyToHitObj.receiveFire(this._damageAdditional);
            }
            this._currentAttackDelay = this._startAttackDelay - 1;
            this._hit = 3;
            this._hit = this._type != 20 && this._type != 21 ? (this._hit += 3) : 4;
            if (this._type == 21 || this._type == 24) {
                n = 0;
                if (this._left) {
                    if (this._front) {
                        n2 = 2;
                        if (this._type == 24) {
                            n = this._height >> 2;
                        }
                    } else {
                        n2 = 8;
                    }
                    ParticleGroup.addParticle$576cfb61(this._x - this._width / 3 + 20, this._y - (this._height >> 1) + n + 13, this.enemyToHitObj._x + 20, this.enemyToHitObj._y - (this.enemyToHitObj._height >> 1) + 13, n2);
                    return;
                }
                if (this._front) {
                    n2 = 1;
                    if (this._type == 24) {
                        n = this._height >> 2;
                    }
                } else {
                    n2 = 9;
                }
                ParticleGroup.addParticle$576cfb61(this._x + this._width / 3 + 20, this._y - (this._height >> 1) + n + 13, this.enemyToHitObj._x + 20, this.enemyToHitObj._y - (this.enemyToHitObj._height >> 1) + 13, n2);
                return;
            }
        } else {
            this._front = true;
            this._left = true;
        }
    }

    public final boolean shadowVisible() {
        return this._x + GameTemplate.viewX + (this._width >> 1) + 20 >= 0 && this._y + GameTemplate.viewY + 26 >= 0 && this._x + GameTemplate.viewX - (this._width >> 1) + 20 <= GameLogic.width && this._y + GameTemplate.viewY - this._height + 13 <= GameLogic.height;
    }

    public final boolean visible() {
        return this._x + GameTemplate.viewX + (this._width >> 1) + 20 >= 0 && this._y + GameTemplate.viewY + 13 >= 0 && this._x + GameTemplate.viewX - (this._width >> 1) + 20 <= GameLogic.width && this._y + GameTemplate.viewY - this._height + 13 <= GameLogic.height;
    }

    static {
        rand = new Random();
    }
}

