/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.shop;

import com.tqm.agave.MainLogic;
import com.tqm.agave.menu.Cell;
import com.tqm.agave.menu.Container;
import com.tqm.agave.menu.Row;
import com.tqm.agave.menu.TextLabel;
import com.tqm.fantasydefense.FramedPaper;
import com.tqm.fantasydefense.GameLogic;
import com.tqm.fantasydefense.Tutorial;
import com.tqm.fantasydefense.menu.WorldMap;
import com.tqm.fantasydefense.shop.ShopCampaigns;
import com.tqm.fantasydefense.shop.ShopCastleCatapults;
import com.tqm.fantasydefense.shop.ShopCastleDragons;
import com.tqm.fantasydefense.shop.ShopCastleGates;
import com.tqm.fantasydefense.shop.ShopCastleTypeSelection;
import com.tqm.fantasydefense.shop.ShopDefenceUnits;
import com.tqm.fantasydefense.shop.ShopElixirs;
import com.tqm.fantasydefense.shop.ShopGems;
import com.tqm.fantasydefense.shop.ShopTypeSelection;
import com.tqm.fantasydefense.shop.secret.SecretGems;
import com.tqm.fantasydefense.shop.secret.SecretItemsManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public final class ShopManager {
    private GameLogic gameLogic;
    private Tutorial tutorial;
    private ShopCampaigns shopCampaignes;
    private ShopCastleDragons shopDragons;
    private ShopDefenceUnits shopDefenceUnits;
    private ShopElixirs shopElixirs;
    private ShopTypeSelection shopTypeSelection;
    private ShopGems shopGems;
    private ShopCastleCatapults shopCatapults;
    private ShopCastleTypeSelection shopCastleDefenceUnitsTypeSelection;
    private ShopCastleGates shopGates;
    private Sprite moneyWindowSprite;
    private Sprite crystalIconSprite;
    private Sprite sashSprite;
    private Sprite curtainSideSprite;
    private Sprite curtainUpperSprite;
    private Sprite wallSprite;
    private Sprite fronBoardSprite;
    private Sprite boardSprite;
    private Sprite rackSprite;
    private Sprite priceSprite;
    private Sprite padlockSprite;
    private Sprite activeSprite;
    private FramedPaper framedPaper;
    private Container itemDesc;
    private boolean descWithTitle;
    private int priceIconSpriteX;
    private int priceIconSpriteY;
    private int rmsShopVisitCounter;
    private int rmsCurrShopTipNumber;
    private boolean tipShown;
    private boolean gemsShopAfterQuestion;
    private int shopGemsFromState;
    private int shopGemsFromSubState;

    public ShopManager(GameLogic object, WorldMap worldMap, Tutorial tutorial) {
        this.gameLogic = object;
        this.tutorial = tutorial;
        this.framedPaper = new FramedPaper();
        object = SecretItemsManager.getInstance();
        this.shopCampaignes = new ShopCampaigns(((SecretItemsManager)object).getCampaigns(), worldMap);
        this.shopDragons = new ShopCastleDragons(((SecretItemsManager)object).getDragons());
        this.shopDefenceUnits = new ShopDefenceUnits(((SecretItemsManager)object).getDefenceUnits());
        this.shopElixirs = new ShopElixirs(((SecretItemsManager)object).getElixirs());
        this.shopTypeSelection = new ShopTypeSelection();
        this.shopGems = new ShopGems(((SecretItemsManager)object).getGems());
        this.shopCatapults = new ShopCastleCatapults(((SecretItemsManager)object).getCatapults());
        this.shopCastleDefenceUnitsTypeSelection = new ShopCastleTypeSelection();
        this.shopGates = new ShopCastleGates(((SecretItemsManager)object).getGates());
        this.itemDesc = new Container(MainLogic.width, MainLogic.height, 129);
        FramedPaper.setContainerParams(this.itemDesc);
        this.gemsShopAfterQuestion = false;
    }

    public final void initSprites(int n) {
        Object object;
        ShopManager shopManager = this;
        if (shopManager.moneyWindowSprite == null) {
            shopManager.framedPaper.loadSprites();
            shopManager.moneyWindowSprite = GameLogic.loadSprite(193);
            shopManager.crystalIconSprite = GameLogic.loadSprite(132);
            shopManager.sashSprite = GameLogic.loadSprite(12);
            shopManager.curtainSideSprite = GameLogic.loadSprite(10);
            shopManager.curtainUpperSprite = GameLogic.loadSprite(89);
            shopManager.wallSprite = GameLogic.loadSprite(35);
            shopManager.fronBoardSprite = GameLogic.loadSprite(110);
            shopManager.boardSprite = GameLogic.loadSprite(20);
            shopManager.rackSprite = GameLogic.loadSprite(31);
            shopManager.priceSprite = GameLogic.loadSprite(54);
            shopManager.padlockSprite = GameLogic.loadSprite(122);
            shopManager.activeSprite = GameLogic.loadSprite(124);
            object = shopManager;
            GameLogic.setSashSpritePosition(((ShopManager)object).sashSprite);
            ((ShopManager)object).boardSprite.setPosition(0, MainLogic.height - ((ShopManager)object).fronBoardSprite.getHeight() - ((ShopManager)object).boardSprite.getHeight());
            if (MainLogic.height < 480) {
                ((ShopManager)object).boardSprite.setPosition(((ShopManager)object).boardSprite.getX(), ((ShopManager)object).boardSprite.getY() + ((ShopManager)object).boardSprite.getHeight() / 3);
            }
            ((ShopManager)object).rackSprite.setPosition((MainLogic.width - ((ShopManager)object).rackSprite.getWidth()) / 2, MainLogic.height * 3 / 8);
            ((ShopManager)object).priceSprite.setPosition(MainLogic.width - MainLogic.width / 24 - ((ShopManager)object).priceSprite.getWidth(), ((ShopManager)object).boardSprite.getY() - ((ShopManager)object).priceSprite.getHeight() * 3 / 5);
        }
        switch (n) {
            case 217: {
                this.shopTypeSelection.initSprites();
                if (this.tutorial.isShopTutorial()) {
                    this.rackSprite.getX();
                    this.rackSprite.getX();
                    this.rackSprite.getWidth();
                    this.tutorial.initShopTutorial$3b4dfe4b(this.boardSprite.getY(), this.boardSprite.getHeight());
                    return;
                }
                if (!this.isShopTipDisplayed()) break;
                shopManager = this;
                object = SecretItemsManager.getInstance();
                n = 0;
                for (int i = 0; i < 3; ++i) {
                    switch (shopManager.rmsCurrShopTipNumber) {
                        case 0: {
                            if (((SecretItemsManager)object).isAllCastleUpgradesBought()) {
                                shopManager.updateCurrShopTipNumber();
                                break;
                            }
                            n = 1;
                            break;
                        }
                        case 1: {
                            if (((SecretItemsManager)object).isAllDefenceUnitsBought()) {
                                shopManager.updateCurrShopTipNumber();
                                break;
                            }
                            n = 1;
                            break;
                        }
                        case 2: {
                            if (((SecretItemsManager)object).isAllElixirsBought()) {
                                shopManager.updateCurrShopTipNumber();
                                break;
                            }
                            n = 1;
                        }
                    }
                    if (n != 0) break;
                }
                if (n != 0) {
                    switch (shopManager.rmsCurrShopTipNumber) {
                        case 0: {
                            shopManager.shopTypeSelection.setCurrRackItem(2);
                            break;
                        }
                        case 1: {
                            shopManager.shopTypeSelection.setCurrRackItem(3);
                            break;
                        }
                        case 2: {
                            shopManager.shopTypeSelection.setCurrRackItem(1);
                        }
                    }
                    shopManager.shopTypeSelection.setSelectionDesc();
                    Tutorial tutorial = shopManager.tutorial;
                    String string = MainLogic.strings[280 + shopManager.rmsCurrShopTipNumber];
                    shopManager.rackSprite.getX();
                    shopManager.rackSprite.getX();
                    shopManager.rackSprite.getWidth();
                    tutorial.initShopTipTutorial$ba2c33f(string, shopManager.boardSprite.getY(), shopManager.boardSprite.getHeight());
                    shopManager.updateCurrShopTipNumber();
                    shopManager.saveCurrShopTipNumberToRMS();
                    return;
                }
                shopManager.tipShown = true;
                return;
            }
            case 239: {
                this.shopCampaignes.initSprites();
                return;
            }
            case 244: {
                this.shopDragons.initSprites();
                return;
            }
            case 240: {
                this.shopDefenceUnits.initSprites();
                return;
            }
            case 241: {
                this.shopElixirs.initSprites();
                return;
            }
            case 242: {
                this.shopGems.initSprites();
                return;
            }
            case 245: {
                this.shopCatapults.initSprites();
                return;
            }
            case 243: {
                this.shopCastleDefenceUnitsTypeSelection.initSprites();
                return;
            }
            case 246: {
                this.shopGates.initSprites();
            }
        }
    }

    protected final void setPriceCrystalPosition(int n) {
        n = this.crystalIconSprite.getWidth() + this.getCrystalAndPriceSpace() + GameLogic._gNumbers.getWidth(n);
        this.priceIconSpriteX = this.priceSprite.getX() + (this.priceSprite.getWidth() * 15 / 19 - n) / 2;
        this.priceIconSpriteY = this.priceSprite.getY() + (this.priceSprite.getHeight() - this.crystalIconSprite.getHeight()) / 2;
    }

    private int getCrystalAndPriceSpace() {
        return this.crystalIconSprite.getWidth() / 3;
    }

    public final void disposeSprites(int state2) {
        switch (state2) {
            case 217: {
                this.shopTypeSelection.disposeSprites();
                break;
            }
            case 239: {
                this.shopCampaignes.disposeSprites();
                break;
            }
            case 244: {
                this.shopDragons.disposeSprites();
                break;
            }
            case 240: {
                this.shopDefenceUnits.disposeSprites();
                break;
            }
            case 241: {
                this.shopElixirs.disposeSprites();
                break;
            }
            case 242: {
                this.shopGems.disposeSprites();
                break;
            }
            case 245: {
                this.shopCatapults.disposeSprites();
                break;
            }
            case 243: {
                this.shopCastleDefenceUnitsTypeSelection.disposeSprites();
                break;
            }
            case 246: {
                this.shopGates.disposeSprites();
            }
        }
        ShopManager state2 = this;
        if (!GameLogic.isShopMenu(MainLogic.getGameNextSubState())) {
            state2.framedPaper.disposeSprites();
            MainLogic.disposeImage(193);
            MainLogic.disposeImage(132);
            MainLogic.disposeImage(12);
            MainLogic.disposeImage(10);
            MainLogic.disposeImage(89);
            MainLogic.disposeImage(35);
            MainLogic.disposeImage(110);
            MainLogic.disposeImage(20);
            MainLogic.disposeImage(31);
            MainLogic.disposeImage(54);
            MainLogic.disposeImage(122);
            MainLogic.disposeImage(124);
            state2.moneyWindowSprite = null;
            state2.crystalIconSprite = null;
            state2.sashSprite = null;
            state2.curtainSideSprite = null;
            state2.curtainUpperSprite = null;
            state2.wallSprite = null;
            state2.fronBoardSprite = null;
            state2.boardSprite = null;
            state2.rackSprite = null;
            state2.priceSprite = null;
            state2.padlockSprite = null;
            state2.activeSprite = null;
        }
    }

    public final void draw(Graphics graphics) {
        int n;
        int n2;
        Graphics graphics2 = graphics;
        ShopManager shopManager = this;
        shopManager.curtainSideSprite.getHeight();
        for (n2 = shopManager.curtainUpperSprite.getHeight() - shopManager.wallSprite.getHeight() / 2; n2 < shopManager.boardSprite.getY() + shopManager.wallSprite.getHeight(); n2 += shopManager.wallSprite.getHeight()) {
            shopManager.wallSprite.setPosition(0, n2);
            shopManager.wallSprite.paint(graphics2);
        }
        n2 = MainLogic.width - shopManager.curtainSideSprite.getWidth() + shopManager.curtainUpperSprite.getWidth();
        for (n = shopManager.curtainSideSprite.getWidth() - shopManager.curtainUpperSprite.getWidth(); n < n2; n += shopManager.curtainUpperSprite.getWidth()) {
            shopManager.curtainUpperSprite.setPosition(n, 0);
            shopManager.curtainUpperSprite.paint(graphics2);
        }
        shopManager.curtainSideSprite.setTransform(2);
        shopManager.curtainSideSprite.setPosition(0, 0);
        shopManager.curtainSideSprite.paint(graphics2);
        shopManager.curtainSideSprite.setTransform(0);
        shopManager.curtainSideSprite.setPosition(MainLogic.width - shopManager.curtainSideSprite.getWidth(), 0);
        shopManager.curtainSideSprite.paint(graphics2);
        for (n = 0; n < MainLogic.width; n += shopManager.fronBoardSprite.getWidth()) {
            shopManager.fronBoardSprite.setPosition(n, MainLogic.height - shopManager.fronBoardSprite.getHeight());
            shopManager.fronBoardSprite.paint(graphics2);
        }
        shopManager.boardSprite.paint(graphics2);
        shopManager.rackSprite.paint(graphics2);
        shopManager.sashSprite.paint(graphics2);
        shopManager.gameLogic.drawMenuTitle(graphics2, shopManager.sashSprite.getY(), shopManager.sashSprite.getHeight());
        ShopManager.drawMoneyWindow(graphics2, shopManager.moneyWindowSprite, shopManager.crystalIconSprite);
        switch (MainLogic.getGameSubState()) {
            case 217: {
                this.shopTypeSelection.draw(graphics);
                if (this.tutorial.isShopTutorial()) {
                    this.tutorial.draw(graphics);
                    this.shopTypeSelection.resetSelection();
                    return;
                }
                if (this.isShopTipDisplayed()) {
                    this.tutorial.draw(graphics);
                    if (MainLogic.counter % 16L > 7L) {
                        this.shopTypeSelection.drawSelectionMark$272d79b7();
                        return;
                    }
                    this.shopTypeSelection.resetSelection();
                    return;
                }
                this.shopTypeSelection.drawSelectionMark$272d79b7();
                this.shopTypeSelection.drawEnterAndBackIcons(graphics);
                this.drawItemDesc(graphics);
                return;
            }
            case 239: {
                this.shopCampaignes.draw(graphics);
                return;
            }
            case 244: {
                this.shopDragons.draw(graphics);
                return;
            }
            case 240: {
                this.shopDefenceUnits.draw(graphics);
                return;
            }
            case 241: {
                this.shopElixirs.draw(graphics);
                return;
            }
            case 242: {
                if (ShopGems.confirmation) {
                    GameLogic.drawGradient$5ba08a83(graphics, 0, GameLogic.width, GameLogic.height, -13219756, -15590883, GameLogic.height, GameLogic.height);
                    this.shopGems.text.draw(graphics);
                    if (ShopGems.smsSending) break;
                    if (ShopGems.smsSendingFinished) {
                        GameLogic.drawEnterIcon(graphics);
                        return;
                    }
                    this.shopGems.drawBottomIcons(graphics);
                    return;
                }
                this.shopGems.draw(graphics);
                return;
            }
            case 245: {
                this.shopCatapults.draw(graphics);
                return;
            }
            case 243: {
                this.shopCastleDefenceUnitsTypeSelection.draw(graphics);
                return;
            }
            case 246: {
                this.shopGates.draw(graphics);
            }
        }
    }

    public static void drawMoneyWindow(Graphics graphics, Sprite sprite, Sprite sprite2) {
        sprite.setPosition((MainLogic.width - sprite.getWidth()) / 2, MainLogic.height - MainLogic.icons.getHeight() + (MainLogic.icons.getHeight() - sprite.getHeight()) / 2);
        sprite.paint(graphics);
        int n = GameLogic._gNumbers.getWidth(SecretGems.getTotalGems());
        Sprite sprite3 = sprite2;
        Sprite sprite4 = sprite;
        int n2 = n;
        Sprite sprite5 = sprite2;
        sprite2.setPosition(sprite4.getX() + (sprite4.getWidth() - n2 - sprite3.getWidth() * 5 / 3) / 2, MainLogic.height - MainLogic.icons.getHeight() / 2 - sprite5.getHeight() / 2);
        sprite2.paint(graphics);
        GameLogic._gNumbers.drawNumber(graphics, SecretGems.getTotalGems(), sprite2.getX() + sprite2.getWidth() * 5 / 3, MainLogic.height - MainLogic.icons.getHeight() / 2 - GameLogic._gNumbers.numbersSprite.getHeight() / 2, 20);
    }

    protected final void drawShopPriceSprite(Graphics graphics, int n, boolean bl) {
        if (!bl) {
            Graphics graphics2 = graphics;
            ShopManager shopManager = this;
            shopManager.priceSprite.paint(graphics2);
            shopManager.crystalIconSprite.setPosition(shopManager.priceIconSpriteX, shopManager.priceIconSpriteY);
            shopManager.crystalIconSprite.paint(graphics2);
            GameLogic._gNumbers.drawNumber(graphics, n, this.crystalIconSprite.getX() + this.crystalIconSprite.getWidth() + this.getCrystalAndPriceSpace(), this.crystalIconSprite.getY(), 20);
        }
    }

    protected final void drawItemDesc(Graphics graphics) {
        GameLogic.setMenuScrollbarColor();
        this.framedPaper.drawWideLowFramedPaper(graphics);
        if (this.descWithTitle) {
            int n = graphics.getClipX();
            int n2 = graphics.getClipY();
            int n3 = graphics.getClipWidth();
            int n4 = graphics.getClipHeight();
            graphics.setClip(this.itemDesc.getX(), this.itemDesc.getY(), this.itemDesc.getWidth(), this.itemDesc.getHeight());
            graphics.setColor(-3621766);
            graphics.drawLine(this.itemDesc.getX(), this.getTitleStressY() + this.itemDesc.getTransY(), this.itemDesc.getX() + this.itemDesc.getWidth() - this.framedPaper.getHorizontalPaperMargin(), this.getTitleStressY() + this.itemDesc.getTransY());
            graphics.setClip(n, n2, n3, n4);
        }
        this.itemDesc.setPosition(this.itemDesc.getX(), this.itemDesc.getY());
        this.itemDesc.draw(graphics);
    }

    protected final int getTitleStressY() {
        int titleRowHeight = this.itemDesc.getRowAt(0).getHeight();
        return this.itemDesc.getY() + titleRowHeight * 11 / 12;
    }

    public final void keyPressed(int n) {
        switch (MainLogic.getGameSubState()) {
            case 217: {
                if (this.tutorial.isShopTutorial() || this.isShopTipDisplayed()) {
                    this.tutorial.keyPressed(n);
                    break;
                }
                this.shopTypeSelection.keyPressed(n);
                break;
            }
            case 239: {
                this.shopCampaignes.keyPressed(n);
                break;
            }
            case 244: {
                this.shopDragons.keyPressed(n);
                break;
            }
            case 240: {
                this.shopDefenceUnits.keyPressed(n);
                break;
            }
            case 241: {
                this.shopElixirs.keyPressed(n);
                break;
            }
            case 242: {
                this.shopGems.keyPressed(n);
                break;
            }
            case 245: {
                this.shopCatapults.keyPressed(n);
                break;
            }
            case 243: {
                this.shopCastleDefenceUnitsTypeSelection.keyPressed(n);
                break;
            }
            case 246: {
                this.shopGates.keyPressed(n);
            }
        }
        if (!this.isShopTipDisplayed()) {
            int n2 = n;
            ShopManager shopManager = this;
            switch (n2) {
                case 50: 
                case 56: 
                case 85: 
                case 87: {
                    shopManager.itemDesc.keyPressed(n2);
                }
            }
        }
    }

    private boolean isShopTipDisplayed() {
        return this.rmsShopVisitCounter % 3 == 0 && !this.tipShown;
    }

    protected final int getRackItemY(Sprite sprite) {
        return this.rackSprite.getY() + this.rackSprite.getHeight() / 2 - sprite.getHeight();
    }

    protected final int getRackBottomY() {
        return this.rackSprite.getY() + this.rackSprite.getHeight();
    }

    protected final void setFramedPaperPosition(int x, int y) {
        this.framedPaper.setFramePosition(x, y);
        this.setItemDescDefaultSize();
        this.itemDesc.setPosition(this.framedPaper.getPaperX() + this.framedPaper.getHorizontalPaperMargin(), this.framedPaper.getPaperY() + 2);
    }

    protected final void setItemDescDefaultSize() {
        ShopManager.setShopContainerDefaultSize(this.itemDesc, this.framedPaper);
    }

    public static void setShopContainerDefaultSize(Container container, FramedPaper framedPaper) {
        container.setSize(framedPaper.getWidePaperWidth() - 2 * framedPaper.getHorizontalPaperMargin(), framedPaper.getLowPaperHeight() - 2 * framedPaper.getVerticalPaperMargin());
    }

    protected final void setDescTextWithTitle(String object, String object2) {
        this.descWithTitle = true;
        object2 = ShopManager.createTextLabel((String)object2);
        ((TextLabel)object2).setAnchor(4);
        object = ShopManager.createTextLabel((String)object);
        ((TextLabel)object).setAnchor(4);
        Row[] rowArray = new Row[2];
        Row[] rowArray2 = rowArray;
        rowArray[0] = new Row(this.itemDesc.getWidth(), new Cell[]{object2});
        rowArray2[0].setSize(this.itemDesc.getWidth(), rowArray2[0].getHeight());
        rowArray2[1] = new Row(this.itemDesc.getWidth(), new Cell[]{object});
        this.itemDesc.setRows(rowArray2, 3);
        this.itemDesc.setPosition(this.itemDesc.getX(), this.itemDesc.getY());
        int n = rowArray2[0].getHeight() + 5 + rowArray2[1].getHeight();
        if (n < this.itemDesc.getHeight()) {
            object2 = ShopManager.createTextLabel("");
            ((TextLabel)object2).setAnchor(4);
            Row[] rowArray3 = new Row[3];
            Row[] rowArray4 = rowArray3;
            rowArray3[0] = rowArray2[0];
            rowArray4[1] = rowArray2[1];
            rowArray4[2] = new Row(this.itemDesc.getWidth(), new Cell[]{object2});
            rowArray4[2].setSize(this.itemDesc.getWidth(), this.itemDesc.getHeight() - n - 5);
            this.itemDesc.setRows(rowArray4, 3);
            this.itemDesc.setPosition(this.itemDesc.getX(), this.itemDesc.getY());
        }
    }

    private static TextLabel createTextLabel(String string) {
        return new TextLabel(string, 1, GameLogic.getSystemFont(), null, 100);
    }

    protected final FramedPaper getFramedPaper() {
        return this.framedPaper;
    }

    protected final Sprite getRackSprite() {
        return this.rackSprite;
    }

    protected final Sprite getPriceSprite() {
        return this.priceSprite;
    }

    protected final Sprite getPadlockSprite() {
        return this.padlockSprite;
    }

    protected final Sprite getActiveSprite() {
        return this.activeSprite;
    }

    protected final Container getItemDesc() {
        return this.itemDesc;
    }

    public final void loadShopVisitCounterFromRMS() {
        this.rmsShopVisitCounter = this.gameLogic.getGData().loadAsInt(49);
    }

    private void saveShopVisitCounterToRMS() {
        this.gameLogic.getGData().save(this.rmsShopVisitCounter, 49);
    }

    public final void loadCurrShopTipNumberFromRMS() {
        this.rmsCurrShopTipNumber = this.gameLogic.getGData().loadAsInt(59);
    }

    private void saveCurrShopTipNumberToRMS() {
        this.gameLogic.getGData().save(this.rmsCurrShopTipNumber, 59);
    }

    private void updateCurrShopTipNumber() {
        this.rmsCurrShopTipNumber = (this.rmsCurrShopTipNumber + 1) % 3;
    }

    public final void visitShop() {
        ++this.rmsShopVisitCounter;
        this.saveShopVisitCounterToRMS();
    }

    public final int getShopVisitCounter() {
        return this.rmsShopVisitCounter;
    }

    public final ShopGems getShopGems() {
        return this.shopGems;
    }

    public final void resetShopParams() {
        this.rmsShopVisitCounter = 0;
        this.saveShopVisitCounterToRMS();
        this.rmsCurrShopTipNumber = 0;
        this.saveCurrShopTipNumberToRMS();
    }

    protected final boolean isGemsShopAfterQuestion() {
        return this.gemsShopAfterQuestion;
    }

    protected final boolean isGemsShopFromWorldMap() {
        return this.gemsShopAfterQuestion && this.shopGemsFromSubState == 204;
    }

    private void setGemsShopFromStates(int state, int subState) {
        this.shopGemsFromState = state;
        this.shopGemsFromSubState = subState;
    }

    protected static void goToShopGems() {
        GameLogic.changeState(17, 242, 1, false);
    }

    public final void goToShopGemsAfterGemsQuestion() {
        this.gemsShopAfterQuestion = true;
        this.setGemsShopFromStates(GameLogic.getGameState(), GameLogic.getGameSubState());
        if (SecretGems.isGemsBoughtAtLeastOnce() && SecretItemsManager.getInstance().getGems().length > 1) {
            this.shopGems.setCurrRackItem(1);
        } else {
            this.shopGems.setCurrRackItem(0);
        }
        ShopManager.goToShopGems();
    }

    protected final void goToScreenBeforeGemsShop() {
        boolean bl = this.shopGemsFromSubState == 204;
        GameLogic.changeState(this.shopGemsFromState, this.shopGemsFromSubState, 1, bl);
        this.resetShopGemsAfterGemsQuestionSettings();
    }

    protected final void resetShopGemsAfterGemsQuestionSettings() {
        this.gemsShopAfterQuestion = false;
        this.setGemsShopFromStates(-1, -1);
    }

    public final void setTipShown(boolean tipShown) {
        this.tipShown = tipShown;
    }
}

