/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.shop.secret;

import com.tqm.fantasydefense.shop.secret.AbstractSecretItem;

public final class SecretGems
extends AbstractSecretItem {
    private static int totalGems;
    private static boolean gemsBoughtAtLeastOnce;
    private int gems;

    public static int getTotalGems() {
        return totalGems;
    }

    public SecretGems(int gems, int statsPaymentId) {
        super(0, statsPaymentId);
        this.gems = gems;
    }

    protected final int getRMSId() {
        return 16;
    }

    public final int getGems() {
        return this.gems;
    }

    public static void reduceGems(int gems) {
        totalGems -= gems;
        SecretGems.saveGems();
    }

    public static boolean isEnoughGems(int n) {
        return totalGems >= n;
    }

    private static void saveGems() {
        SecretGems.saveToRMS(16, totalGems);
    }

    public final void saveDefaultToRMS() {
        SecretGems.saveToRMS(16, 10);
    }

    public final boolean buy(int statsSourceId) {
        totalGems += this.gems;
        SecretGems.saveGems();
        if (!gemsBoughtAtLeastOnce) {
            gemsBoughtAtLeastOnce = true;
            SecretGems.saveToRMS(58, gemsBoughtAtLeastOnce ? 1 : 0);
        }
        return true;
    }

    public static void grantGemsAsReward(int gemsAmount) {
        totalGems += gemsAmount;
        SecretGems.saveGems();
    }

    public static void setGemsAmount(int gemsAmount) {
        totalGems = gemsAmount;
        SecretGems.saveGems();
    }

    public final void loadFromRMS() {
        totalGems = SecretGems.loadFromRMS(16);
    }

    public static void loadGemsBoughtAtLeastOnceFromRMS() {
        gemsBoughtAtLeastOnce = SecretGems.loadFromRMS(58) == 1;
    }

    public static boolean isGemsBoughtAtLeastOnce() {
        return gemsBoughtAtLeastOnce;
    }
}

