/*
 * Decompiled with CFR 0.152.
 */
package com.am.activity.components;

import com.am.activity.interfaces.TimerListener;
import com.am.activity.main.Activity;

public class Timer {
    private float procTime;
    private float counter;
    private int timerID;
    private Activity activity;
    private TimerListener listener;
    private boolean enabled;

    public Timer(Activity parent, float proc, boolean on) {
        try {
            this.setProcTime(proc);
            this.listener = (TimerListener)((Object)parent);
            this.counter = 0.0f;
            this.activity = parent;
            this.activity.addTimer(this);
            this.timerID = this.activity.getTimerID(this);
            this.setEnabled(on);
        }
        catch (ClassCastException e) {
            System.out.println("TIMER ERROR: parent does not implement TimerListener (parent class: " + parent.getClass().getName() + ")");
        }
    }

    public Timer(Activity parent, float proc) {
        this(parent, proc, false);
    }

    public void update(float delta) {
        if (!this.isEnabled()) {
            return;
        }
        this.counter += delta;
        if (this.counter >= this.getProcTime()) {
            this.counter = 0.0f;
            this.listener.timerProced(this.timerID);
        }
    }

    public float getProcTime() {
        return this.procTime;
    }

    public void setProcTime(float procTime) {
        this.procTime = procTime;
    }

    public int getID() {
        return this.timerID;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void toggle() {
        this.enabled = !this.enabled;
    }
}

