/*
 * Decompiled with CFR 0.152.
 */
package com.am.activity.tools;

import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageHelper {
    private static ImageHelper self;
    public static Hashtable cachedImages;

    static {
        cachedImages = new Hashtable();
    }

    private ImageHelper() {
    }

    public static ImageHelper getInstance() {
        if (self == null) {
            self = new ImageHelper();
        }
        return self;
    }

    public static Image loadImage(String path, int width, int height) throws RuntimeException {
        ImageHelper.getInstance();
        return ImageHelper.scaleImage(ImageHelper.loadImage(path), width, height);
    }

    public static Image loadImage(String path, float scaling) throws RuntimeException {
        ImageHelper.getInstance();
        return ImageHelper.scaleImage(ImageHelper.loadImage(path), scaling);
    }

    public static Image loadImage(String path) throws RuntimeException {
        Image image;
        try {
            InputStream in = ImageHelper.getInstance().getClass().getResourceAsStream(path);
            image = Image.createImage((InputStream)in);
        }
        catch (Exception e) {
            RuntimeException re = new RuntimeException("ImageLoader failed to load image:" + path + " " + e.getMessage());
            re.printStackTrace();
            throw re;
        }
        return image;
    }

    public static Image loadImage(String path, float xScaling, float yScaling) {
        ImageHelper.getInstance();
        Image original = ImageHelper.loadImage(path);
        return ImageHelper.scaleImage(original, (int)((float)original.getWidth() * xScaling), (int)((float)original.getHeight() * yScaling));
    }

    public static Image loadCached(String path, float xScaling, float yScaling) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(xScaling));
        buffer.append(" x ");
        buffer.append(String.valueOf(yScaling));
        buffer.append(" ");
        buffer.append(path);
        String key = buffer.toString();
        if (cachedImages.containsKey(key)) {
            return (Image)cachedImages.get(key);
        }
        Image image = ImageHelper.loadImage(path, xScaling, yScaling);
        cachedImages.put(key, image);
        return image;
    }

    public static Image loadCached(String path, float scaling) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(scaling));
        buffer.append(" x ");
        buffer.append(path);
        String key = buffer.toString();
        if (cachedImages.containsKey(key)) {
            return (Image)cachedImages.get(key);
        }
        Image image = ImageHelper.loadImage(path, scaling);
        cachedImages.put(key, image);
        return image;
    }

    public static Image loadCached(String path, int width, int height) throws RuntimeException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(width));
        buffer.append(" x ");
        buffer.append(String.valueOf(height));
        buffer.append(" ");
        buffer.append(path);
        String key = buffer.toString();
        if (cachedImages.containsKey(key)) {
            return (Image)cachedImages.get(key);
        }
        ImageHelper.getInstance();
        Image image = ImageHelper.loadImage(path, width, height);
        cachedImages.put(key, image);
        return image;
    }

    public static Image loadCached(String path) {
        if (cachedImages.containsKey(path)) {
            return (Image)cachedImages.get(path);
        }
        ImageHelper.getInstance();
        Image image = ImageHelper.loadImage(path);
        cachedImages.put(path, image);
        return image;
    }

    public static Image scaleImage(Image original, float scaling) {
        return ImageHelper.scaleImage(original, (int)((double)(scaling * (float)original.getWidth()) + 0.5), (int)((double)(scaling * (float)original.getHeight()) + 0.5));
    }

    public static Image scaleImage(Image original, int newWidth, int newHeight) {
        int originalWidth = original.getWidth();
        int originalHeight = original.getHeight();
        if (originalWidth == newWidth && originalHeight == newHeight) {
            return original;
        }
        if (originalWidth <= newWidth) {
            return ImageHelper.pixelMixing(original, newWidth, newHeight);
        }
        if (originalWidth > newWidth) {
            return ImageHelper.bilinearInterpolation(original, newWidth, newHeight);
        }
        return original;
    }

    private static Image pixelMixing(Image original, int newWidth, int newHeight) {
        int[] rawInput = new int[original.getHeight() * original.getWidth()];
        original.getRGB(rawInput, 0, original.getWidth(), 0, 0, original.getWidth(), original.getHeight());
        int[] rawOutput = new int[newWidth * newHeight];
        int oWidth = original.getWidth();
        int[] oX16 = new int[newWidth + 1];
        int newX = 0;
        while (newX <= newWidth) {
            oX16[newX] = (newX * oWidth << 4) / newWidth;
            ++newX;
        }
        int[] oXStartWidth = new int[newWidth];
        int[] oXEndWidth = new int[newWidth];
        int newX2 = 0;
        while (newX2 < newWidth) {
            oXStartWidth[newX2] = 16 - oX16[newX2] % 16;
            oXEndWidth[newX2] = oX16[newX2 + 1] % 16;
            ++newX2;
        }
        int oHeight = original.getHeight();
        int[] oY16 = new int[newHeight + 1];
        int newY = 0;
        while (newY <= newHeight) {
            oY16[newY] = (newY * oHeight << 4) / newHeight;
            ++newY;
        }
        int newY2 = 0;
        while (newY2 < newHeight) {
            int oY16Start = oY16[newY2];
            int oY16End = oY16[newY2 + 1];
            int oYStart = oY16Start >>> 4;
            int oYEnd = oY16End >>> 4;
            int oYStartHeight = 16 - oY16Start % 16;
            int oYEndHeight = oY16End % 16;
            int newX3 = 0;
            while (newX3 < newWidth) {
                int oX16Start = oX16[newX3];
                int oX16End = oX16[newX3 + 1];
                int oXStart = oX16Start >>> 4;
                int oXEnd = oX16End >>> 4;
                int outArea = 0;
                int outColorArea = 0;
                int outAlpha = 0;
                int outRed = 0;
                int outGreen = 0;
                int outBlue = 0;
                int j = oYStart;
                while (j <= oYEnd) {
                    int areaHeight = 16;
                    if (oYStart == oYEnd) {
                        areaHeight = oY16End - oY16Start;
                    } else if (j == oYStart) {
                        areaHeight = oYStartHeight;
                    } else if (j == oYEnd) {
                        areaHeight = oYEndHeight;
                    }
                    if (areaHeight != 0) {
                        int i = oXStart;
                        while (i <= oXEnd) {
                            int areaWidth = 16;
                            if (oXStart == oXEnd) {
                                areaWidth = oX16End - oX16Start;
                            } else if (i == oXStart) {
                                areaWidth = oXStartWidth[newX3];
                            } else if (i == oXEnd) {
                                areaWidth = oXEndWidth[newX3];
                            }
                            if (areaWidth != 0) {
                                int area = areaWidth * areaHeight;
                                outArea += area;
                                int argb = rawInput[i + j * original.getWidth()];
                                int a = argb >>> 24;
                                if (a != 0) {
                                    area = a * area;
                                    outColorArea += area;
                                    int r = (argb & 0xFF0000) >>> 16;
                                    int g = (argb & 0xFF00) >>> 8;
                                    int b = argb & 0xFF;
                                    outRed += area * r;
                                    outGreen += area * g;
                                    outBlue += area * b;
                                }
                            }
                            ++i;
                        }
                    }
                    ++j;
                }
                if (outColorArea > 0) {
                    outAlpha = outColorArea / outArea;
                    outRed /= outColorArea;
                    outGreen /= outColorArea;
                    outBlue /= outColorArea;
                }
                rawOutput[newX3 + newY2 * newWidth] = outAlpha << 24 | outRed << 16 | outGreen << 8 | outBlue;
                ++newX3;
            }
            ++newY2;
        }
        return Image.createRGBImage((int[])rawOutput, (int)newWidth, (int)newHeight, (boolean)true);
    }

    private static Image bilinearInterpolation(Image original, int newWidth, int newHeight) {
        int[] rawInput = new int[original.getHeight() * original.getWidth()];
        original.getRGB(rawInput, 0, original.getWidth(), 0, 0, original.getWidth(), original.getHeight());
        int[] rawOutput = new int[newWidth * newHeight];
        int oWidth = original.getWidth();
        int[] oX16 = new int[newWidth];
        int max = oWidth - 1 << 4;
        int newX = 0;
        while (newX < newWidth) {
            oX16[newX] = (((newX << 1) + 1) * oWidth << 3) / newWidth - 8;
            if (oX16[newX] < 0) {
                oX16[newX] = 0;
            } else if (oX16[newX] > max) {
                oX16[newX] = max;
            }
            ++newX;
        }
        int oHeight = original.getHeight();
        int[] oY16 = new int[newHeight];
        max = oHeight - 1 << 4;
        int newY = 0;
        while (newY < newHeight) {
            oY16[newY] = (((newY << 1) + 1) * oHeight << 3) / newHeight - 8;
            if (oY16[newY] < 0) {
                oY16[newY] = 0;
            } else if (oY16[newY] > max) {
                oY16[newY] = max;
            }
            ++newY;
        }
        int[] oX = new int[2];
        int[] oY = new int[2];
        int[] wX = new int[2];
        int[] wY = new int[2];
        int newY2 = 0;
        while (newY2 < newHeight) {
            oY[0] = oY16[newY2] >>> 4;
            wY[1] = oY16[newY2] & 0xF;
            wY[0] = 16 - wY[1];
            oY[1] = wY[1] == 0 ? oY[0] : oY[0] + 1;
            int newX2 = 0;
            while (newX2 < newWidth) {
                oX[0] = oX16[newX2] >>> 4;
                wX[1] = oX16[newX2] & 0xF;
                wX[0] = 16 - wX[1];
                oX[1] = wX[1] == 0 ? oX[0] : oX[0] + 1;
                int outWeight = 0;
                int outColorWeight = 0;
                int outAlpha = 0;
                int outRed = 0;
                int outGreen = 0;
                int outBlue = 0;
                int j = 0;
                while (j < 2) {
                    int i = 0;
                    while (i < 2) {
                        if (wY[j] != 0 && wX[i] != 0) {
                            int w = wX[i] * wY[j];
                            outWeight += w;
                            int argb = rawInput[oX[i] + oY[j] * original.getWidth()];
                            int a = argb >>> 24;
                            if (a != 0) {
                                w = a * w;
                                outColorWeight += w;
                                int r = (argb & 0xFF0000) >>> 16;
                                int g = (argb & 0xFF00) >>> 8;
                                int b = argb & 0xFF;
                                outRed += w * r;
                                outGreen += w * g;
                                outBlue += w * b;
                            }
                        }
                        ++i;
                    }
                    ++j;
                }
                if (outColorWeight > 0) {
                    outAlpha = outColorWeight / outWeight;
                    outRed /= outColorWeight;
                    outGreen /= outColorWeight;
                    outBlue /= outColorWeight;
                }
                rawOutput[newX2 + newY2 * newWidth] = outAlpha << 24 | outRed << 16 | outGreen << 8 | outBlue;
                ++newX2;
            }
            ++newY2;
        }
        return Image.createRGBImage((int[])rawOutput, (int)newWidth, (int)newHeight, (boolean)true);
    }

    public static void printCache() {
        System.out.println();
    }

    public static void cleanCache() {
        cachedImages.clear();
    }

    public static Image rotate(Image imgSource, int cx, int cy, double theta) {
        int[] dd = new int[2];
        int w1 = imgSource.getWidth();
        int h1 = imgSource.getHeight();
        int[] srcMap = new int[w1 * h1];
        imgSource.getRGB(srcMap, 0, w1, 0, 0, w1, h1);
        int dx = cx;
        int dy = cy;
        double dr = Math.sqrt(dx * dx + dy * dy);
        int wh2 = (int)(2.0 * dr + 1.0);
        int[] destMap = new int[wh2 * wh2];
        double radian = theta * Math.PI / 180.0;
        int i = 0;
        while (i < w1) {
            int j = 0;
            while (j < h1) {
                int destX = (int)(dr + (double)(i - cx) * Math.cos(radian) + (double)(j - cy) * Math.sin(radian));
                int destY = (int)(dr + (double)(j - cy) * Math.cos(radian) - (double)(i - cx) * Math.sin(radian));
                destMap[wh2 * destY + destX] = srcMap[j * w1 + i];
                destMap[wh2 * destY + destX + 1] = srcMap[j * w1 + i];
                ++j;
            }
            ++i;
        }
        dd[0] = (int)((double)cx - dr);
        dd[1] = (int)((double)cy - dr);
        return Image.createRGBImage((int[])destMap, (int)wh2, (int)wh2, (boolean)true);
    }

    public static Image rotate(Image imgSource, int cx, int cy, double theta, int[] dd) {
        if (Math.abs(theta % 360.0) < 0.1) {
            return imgSource;
        }
        int w1 = imgSource.getWidth();
        int h1 = imgSource.getHeight();
        int[] srcMap = new int[w1 * h1];
        imgSource.getRGB(srcMap, 0, w1, 0, 0, w1, h1);
        int dx = cx;
        int dy = cy;
        double dr = Math.sqrt(dx * dx + dy * dy);
        int wh2 = (int)(2.0 * dr + 1.0);
        int[] destMap = new int[wh2 * wh2];
        double radian = theta * Math.PI / 180.0;
        int i = 0;
        while (i < w1) {
            int j = 0;
            while (j < h1) {
                int destX = (int)(dr + (double)(i - cx) * Math.cos(radian) + (double)(j - cy) * Math.sin(radian));
                int destY = (int)(dr + (double)(j - cy) * Math.cos(radian) - (double)(i - cx) * Math.sin(radian));
                destMap[wh2 * destY + destX] = srcMap[j * w1 + i];
                destMap[wh2 * destY + destX + 1] = srcMap[j * w1 + i];
                ++j;
            }
            ++i;
        }
        dd[0] = (int)((double)cx - dr);
        dd[1] = (int)((double)cy - dr);
        return Image.createRGBImage((int[])destMap, (int)wh2, (int)wh2, (boolean)true);
    }

    public static Image drawTextOnImage(Image img, String str, Font font) {
        String text = str;
        Image image = img;
        Font fn = font != null ? font : Font.getDefaultFont();
        int hTitle = image.getHeight();
        int wTitle = image.getWidth();
        int hFont = fn.getHeight();
        int wFont = fn.stringWidth(text);
        Image titleImg = Image.createImage((int)wTitle, (int)hTitle);
        Graphics textGrP1 = titleImg.getGraphics();
        textGrP1.drawRegion(image, 0, 0, wTitle, hTitle, 0, 0, 0, 20);
        textGrP1.setColor(0);
        textGrP1.setFont(fn);
        if (wFont < wTitle) {
            textGrP1.drawString(text, wTitle / 2, hTitle / 2 - hFont / 2, 17);
        }
        if (wFont > wTitle) {
            int i = 0;
            while (i < text.length()) {
                if (text.charAt(i) == ' ') {
                    textGrP1.drawString(text.substring(0, i), wTitle / 2, hTitle / 2, 33);
                    textGrP1.drawString(text.substring(i), wTitle / 2, hTitle / 2, 17);
                    break;
                }
                ++i;
            }
        }
        return titleImg;
    }

    public static Image createInvisiblePic(int w, int h) {
        int[] srcMap = new int[w * h];
        int i = 0;
        while (i < srcMap.length) {
            srcMap[i] = 0;
            ++i;
        }
        Image destImgNull = Image.createRGBImage((int[])srcMap, (int)w, (int)h, (boolean)true);
        return destImgNull;
    }

    public static Image createImageWithText(int w, int h, String str, Font font, int colorTextIn, int colorFonIn) {
        String text = str;
        Font fn = Font.getDefaultFont();
        int colorText = colorTextIn;
        int colorFon = colorFonIn;
        if (font != null) {
            fn = font;
        }
        int hTitle = h;
        int wTitle = w;
        int hFont = fn.getHeight();
        int wFont = fn.stringWidth(text);
        Image titleImg = Image.createImage((int)wTitle, (int)hTitle);
        Graphics textGrP1 = titleImg.getGraphics();
        textGrP1.setColor(colorFon);
        textGrP1.fillRect(0, 0, w, h);
        textGrP1.setColor(colorText);
        textGrP1.setFont(fn);
        if (wFont < wTitle) {
            textGrP1.drawString(text, wTitle / 2, hTitle / 2 - hFont / 2, 17);
        }
        if (wFont > wTitle) {
            int i = 0;
            while (i < text.length()) {
                if (text.charAt(i) == ' ') {
                    textGrP1.drawString(text.substring(0, i), wTitle / 2, hTitle / 2, 33);
                    textGrP1.drawString(text.substring(i), wTitle / 2, hTitle / 2, 17);
                    break;
                }
                ++i;
            }
        }
        return titleImg;
    }
}

