/*
 * Decompiled with CFR 0.152.
 */
package com.am.ashamidlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;

public class Settings {
    private static final String SEPARATOR = "|";
    private static final String IN_APP_CLASS_PATH = "/inapp.txt";
    private static final String DEFAULT_PAYMENT_MANAGER = "com.am.ashamidlet.EmptyPaymentManager";
    private static final String SETTINGS_PATH = "/settings.txt";
    private static String pathToClassInApp = null;
    private static boolean initialized = false;
    private static Hashtable settings = new Hashtable();

    private static void initSettings(String filename) throws UnsupportedEncodingException, IOException {
        if (!settings.isEmpty()) {
            settings.clear();
        }
        new Settings().readFile(filename);
    }

    public static String get(String key) {
        if (!initialized) {
            try {
                Settings.initSettings(SETTINGS_PATH);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            initialized = true;
        }
        String result = null;
        Object value = settings.get(key);
        result = value != null ? (String)value : "null";
        return result;
    }

    public static String getInAppClass() {
        if (pathToClassInApp == null) {
            try {
                pathToClassInApp = new Settings().readFilePath(IN_APP_CLASS_PATH);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            System.out.println("path to class is :" + pathToClassInApp);
        }
        return pathToClassInApp;
    }

    private String readFilePath(String filename) throws UnsupportedEncodingException {
        String result;
        block15: {
            InputStream is = this.getClass().getResourceAsStream(filename);
            result = DEFAULT_PAYMENT_MANAGER;
            if (is != null) {
                InputStreamReader reader = new InputStreamReader(is, "UTF-8");
                String line = null;
                if (reader != null) {
                    try {
                        try {
                            while ((line = this.readLine(reader)) != null) {
                                result = line;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            if (reader == null) break block15;
                            try {
                                ((Reader)reader).close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                    }
                    finally {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    private void readFile(String filename) throws UnsupportedEncodingException, IOException {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(filename), "UTF-8");
        String line = null;
        while ((line = this.readLine(reader)) != null) {
            String[] result = this.split(line, SEPARATOR);
            settings.put(result[0], result[1]);
        }
        ((Reader)reader).close();
    }

    private String readLine(Reader reader) throws IOException {
        int readChar = reader.read();
        if (readChar == -1) {
            return null;
        }
        StringBuffer string = new StringBuffer("");
        while (readChar != -1 && readChar != 10) {
            if (readChar != 13) {
                string.append((char)readChar);
            }
            readChar = reader.read();
        }
        return string.toString();
    }

    private String[] split(String original, String separator) {
        Vector<String> nodes = new Vector<String>();
        int index = original.indexOf(separator);
        while (index >= 0) {
            nodes.addElement(new String(original.substring(0, index)));
            original = original.substring(index + separator.length());
            index = original.indexOf(separator);
        }
        nodes.addElement(original);
        String[] result = new String[nodes.size()];
        if (nodes.size() > 0) {
            int loop = 0;
            while (loop < nodes.size()) {
                result[loop] = (String)nodes.elementAt(loop);
                ++loop;
            }
        }
        return result;
    }
}

