/*
 * Decompiled with CFR 0.152.
 */
package com.am.blockapplib.utils;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Font;

public class BalUiSettings {
    public static final String MICROEDITION_PLATFORM = "microedition.platform";
    public static final String MICROEDITION_LOCALE = "microedition.locale";
    public static final String DEFAULT_LOCALE = "_en";
    public static final String EN = "en";
    public static final String ES = "es";
    public static final String DE = "de";
    public static final String FR = "fr";
    public static final String PT = "pt";
    public static final String IT = "it";
    public static final String RU = "ru";
    public static final String ZH = "zh";
    private static Hashtable listLocale = new Hashtable();
    public static final String TXT = ".txt";
    private static String pathToFolder = "/";
    private static String prefixForFiles = "strings";
    private static String[] strLocale = new String[]{"_en", "_es", "_de", "_ru", "_fr", "_it", "_pt", "_zh"};
    private static String[] strKey = new String[]{"en", "es", "de", "ru", "fr", "it", "pt", "zh"};
    private static String locale;
    private static Hashtable text;
    public static final String SEPARATOR = "|";
    private static boolean initialized;

    static {
        text = new Hashtable();
        initialized = false;
    }

    private static void initTextRes(String filename) throws UnsupportedEncodingException, IOException {
        if (!text.isEmpty()) {
            text.clear();
        }
        new BalUiSettings().readFile(filename);
    }

    private static void silentInitTextRes() {
        StringBuffer pathToTextFile = new StringBuffer();
        if (locale == null) {
            locale = BalUiSettings.identifyLocale();
            System.out.println("Locale is: " + locale);
        }
        pathToTextFile.append(pathToFolder).append(prefixForFiles).append(locale).append(TXT);
        try {
            BalUiSettings.initTextRes(pathToTextFile.toString());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            System.err.println("    !!!!NOT FOUND " + pathToTextFile.toString() + " FILE! SET DEFAULT EN!");
            locale = DEFAULT_LOCALE;
            pathToTextFile.delete(0, pathToTextFile.length());
            pathToTextFile.append(pathToFolder).append(prefixForFiles).append(locale).append(TXT);
            try {
                BalUiSettings.initTextRes(pathToTextFile.toString());
            }
            catch (UnsupportedEncodingException e1) {
                System.err.println("Unsupported Encoding by files " + pathToTextFile.toString());
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (NullPointerException e1) {
                System.err.println("    !!!!NOT FOUND " + pathToTextFile.toString() + " FILE!");
                e1.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        initialized = true;
    }

    private static String identifyLocale() {
        String locale;
        if (listLocale.isEmpty()) {
            int i = 0;
            while (i < strLocale.length) {
                listLocale.put(strKey[i], strLocale[i]);
                ++i;
            }
        }
        if ((locale = System.getProperty(MICROEDITION_LOCALE)).length() > 2) {
            locale = locale.substring(0, 2);
        }
        System.out.println("in locale " + locale);
        String result = null;
        Object value = listLocale.get(locale);
        System.out.println("value " + value);
        result = value != null ? (String)value : DEFAULT_LOCALE;
        return result;
    }

    public static String getString(String key) {
        if (!initialized) {
            BalUiSettings.silentInitTextRes();
        }
        String result = null;
        Object value = text.get(key);
        result = value != null ? (String)value : " ";
        return result;
    }

    public static Font getFont(String key) {
        String fontName = BalUiSettings.getString(key);
        if (fontName.equals("SMALL")) {
            return Font.getFont((int)64, (int)2, (int)8);
        }
        if (fontName.equals("LARGE")) {
            return Font.getFont((int)64, (int)2, (int)16);
        }
        return Font.getFont((int)64, (int)2, (int)0);
    }

    private void readFile(String filename) throws UnsupportedEncodingException, IOException {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(filename), "UTF-8");
        String line = null;
        while ((line = this.readLine(reader)) != null) {
            String[] result;
            if (line.length() == 0 || (result = this.split(line, SEPARATOR))[0].substring(0, 2).equals("//")) continue;
            text.put(result[0], result[1]);
        }
        ((Reader)reader).close();
    }

    private String readLine(Reader reader) throws IOException {
        int readChar = reader.read();
        if (readChar == -1) {
            return null;
        }
        StringBuffer string = new StringBuffer("");
        while (readChar != -1 && readChar != 10) {
            if (readChar != 13) {
                string.append((char)readChar);
            }
            readChar = reader.read();
        }
        return string.toString();
    }

    private String[] split(String original, String separator) {
        Vector<String> nodes = new Vector<String>();
        int index = original.indexOf(separator);
        while (index >= 0) {
            nodes.addElement(new String(original.substring(0, index)));
            original = original.substring(index + separator.length());
            index = original.indexOf(separator);
        }
        nodes.addElement(original);
        String[] result = new String[nodes.size()];
        if (nodes.size() > 0) {
            int loop = 0;
            while (loop < nodes.size()) {
                result[loop] = (String)nodes.elementAt(loop);
                ++loop;
            }
        }
        return result;
    }
}

