/*
 * Decompiled with CFR 0.152.
 */
package com.amediax.epicheroes.views;

import com.am.activity.components.NewButton;
import com.am.activity.interfaces.ActivityInterface;
import com.am.activity.main.Activity;
import com.amediax.epicheroes.content.Res;
import com.amediax.epicheroes.engine.Engine;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Layer;

public class MenuView
extends Activity
implements ActivityInterface {
    private NewButton btnStart;
    private NewButton btnHelp;
    private NewButton btnAbout;
    private NewButton btnExit;
    private NewButton btnSounds;
    private int btnStartX;
    private int btnStartY;
    private int btnHelpX;
    private int btnHelpY;
    private int btnAboutX;
    private int btnAboutY;
    private int btnExitX;
    private int btnExitY;
    private int halfDisplay = Engine.displayWidth / 2;

    public MenuView(int width, int height) {
        super(width, height);
    }

    public void paint(Graphics g, int x, int y) {
        super.paint(g, x, y);
        g.setFont(Res.BIG_BOLD_FONT);
        g.setColor(255);
        g.drawString(Res.STR_BEST_RESULT + ": " + Engine.bestResult, this.halfDisplay, 140, 17);
    }

    public void buttonIsPressed(int i) {
    }

    public void buttonIsReleased(int i) {
        if (this.btnStart.getID() == i) {
            Engine.getInstance().handleEvent(105);
        }
        if (this.btnHelp.getID() == i) {
            Engine.getInstance().handleEvent(103);
        }
        if (this.btnAbout.getID() == i) {
            Engine.getInstance().handleEvent(102);
        }
        if (this.btnExit.getID() == i) {
            Engine.getInstance().exitApp();
        }
        if (this.btnSounds.getID() == i) {
            Engine.switchMusic();
            if (Engine.enableMusic) {
                this.btnSounds.setImage(Res.IMG_BTN_UNMUTE, 40, 40);
            } else {
                this.btnSounds.setImage(Res.IMG_BTN_MUTE, 40, 40);
            }
        }
    }

    public void returnState(int i, int i1) {
    }

    public void initResources() {
        this.btnStart = NewButton.createButtonWithImage(this, Res.IMG_BTN_START);
        this.btnHelp = NewButton.createButtonWithImage(this, Res.IMG_BTN_HELP);
        this.btnAbout = NewButton.createButtonWithImage(this, Res.IMG_BTN_ABOUT);
        this.btnExit = NewButton.createButtonWithImage(this, Res.IMG_BTN_EXIT);
        this.btnSounds = NewButton.createButtonWithImage(this, Res.IMG_BTN_MUTE);
        this.initPosOfElements();
        this.btnStart.setPosition(this.btnStartX, this.btnStartY);
        this.btnHelp.setPosition(this.btnHelpX, this.btnHelpY);
        this.btnAbout.setPosition(this.btnAboutX, this.btnAboutY);
        this.btnExit.setPosition(this.btnExitX, this.btnExitY);
        this.btnSounds.setPosition(0, 0);
        this.append((Layer)Res.sprMenuBackground);
    }

    private void initPosOfElements() {
        boolean isShowBanner = Engine.getInstance().isShowBanner();
        this.btnStartX = this.activityWidth / 2 - this.btnStart.getWidth() / 2;
        this.btnStartY = this.activityHeight - this.btnStart.getHeight() - 10;
        int bannerH = 0;
        if (isShowBanner) {
            bannerH = 0;
        }
        this.btnHelpX = 0;
        this.btnHelpY = this.activityHeight - this.btnHelp.getHeight() - bannerH;
        this.btnAboutX = 0;
        this.btnAboutY = this.activityHeight - this.btnAbout.getHeight() - this.btnHelp.getHeight() - bannerH;
        this.btnExitX = this.activityWidth - this.btnExit.getWidth();
        this.btnExitY = this.activityHeight - this.btnExit.getHeight() - bannerH;
    }

    public void refreshResources() {
        if (Engine.enableMusic) {
            this.btnSounds.setImage(Res.IMG_BTN_UNMUTE, 40, 40);
        } else {
            this.btnSounds.setImage(Res.IMG_BTN_MUTE, 40, 40);
        }
    }

    public void buttonIsDragged(int i, int i1, int i2) {
    }
}

