/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Image;

public class Reanim
implements GameConstants,
Constants,
ReanimAttributes,
ReanimInterface,
ConstantsReanim {
    public static final int[] REANIM_DATA = new int[75];
    public static final int[] REANIM_LOADED_TEMP_VALS = new int[6];
    public static TrackData[] nReanims = new TrackData[25];
    static int[][] TRACK_ATTRIBS = new int[25][275];
    static Image[] TRACK_IMGS = new Image[2000];
    static int[] TRACK_IMG_CROPPED_VALS = new int[4000];
    static boolean[] LOADED_REANIMS = new boolean[51];
    static int[] REANIM_UPDATE_VALS = new int[7];
    static int m_nReanims;
    static int m_nTracks;
    private static int m_nTracksCountTemp;
    static int m_nImgsCount;
    static int m_nTrackBaseImgX;
    static int m_nTrackBaseImgY;
    static int m_nReanimDataPos;
    static int m_nFPReanimFrame;
    static int DEFAULT_REANIM_VAL;
    static boolean[] REANIMS_REQUIRED_FOR_LEVEL;
    static long[] REANIMS_IMG_SETS_REQUIRED_FOR_LEVEL;
    static int m_nReanimsLoaded;
    static int m_nReanimsRequired;
    static int m_nReanimStep;
    static boolean m_bLoadNewReanim;
    static long m_lLevelImagesSet;
    static int STEP_LOAD_TRACKS_COUNT;
    static int STEP_LOAD_REANIM_OFFSET;
    static int STEP_LOAD_TRACK_ATTRIB_INDEX;
    static int STEP_LOAD_TRACK_GLOBAL_INDEX;
    static int STEP_LOAD_DATA_POS;
    static int STEP_LOAD_DATA_NUM_BYTES;
    static int STEP_LOAD_NUM_TRACKS;
    static int STEP_LOAD_CURR_TRACK_INDEX;
    static int STEP_LOAD_FPS;
    static int STEP_LOAD_NUM_FRAMES;
    static int STEP_LOAD_CURRENT_FRAME;
    static int STEP_LOAD_FRAME_START;
    static int STEP_LOAD_FRAME_COUNT;
    static int STEP_LOAD_TRACK_TYPE;
    static int STEP_LOAD_PREV_X;
    static int STEP_LOAD_PREV_Y;
    static int STEP_LOAD_PREV_SX;
    static int STEP_LOAD_PREV_SY;
    static int STEP_LOAD_PREV_KX;
    static int STEP_LOAD_PREV_KY;
    static int STEP_LOAD_PREV_IMG;
    static int STEP_LOAD_IMG_ID;
    static int STEP_LOAD_BASE_IMG_ID;
    static int STEP_LOAD_MAX_VALS;
    static int[] REANIM_STEP_LOADER;
    static byte[] REANIM_BYTE_DATA;
    static final int[] CALCULATIONS;
    static int m_nTrackPosX;
    static int m_nTrackPosY;
    static int m_nReanimFrameW;
    static int m_nReanimFrameH;
    static int m_nReanimFrameX;
    static int m_nReanimFrameY;

    static void init() {
        Reanim.calcReanimMaxByteSize();
    }

    static void resetLoadingParams() {
        Util.resetArray(REANIMS_REQUIRED_FOR_LEVEL, false);
        Util.resetArray(REANIMS_IMG_SETS_REQUIRED_FOR_LEVEL, -1L);
        m_nReanimsLoaded = 0;
        m_nReanimsRequired = 0;
        m_nReanimStep = 2;
        m_lLevelImagesSet = 0L;
    }

    static void flagReanimToBeLoaded(int n, int n2) {
        Reanim.REANIMS_REQUIRED_FOR_LEVEL[n] = true;
        if (n2 >= 0) {
            Reanim.REANIMS_IMG_SETS_REQUIRED_FOR_LEVEL[n] = 1L << n2;
        }
    }

    static void preLoadReanimImageSets() {
        m_lLevelImagesSet = 470L;
        for (int i = 0; i < REANIMS_IMG_SETS_REQUIRED_FOR_LEVEL.length; ++i) {
            if (REANIMS_IMG_SETS_REQUIRED_FOR_LEVEL[i] == -1L) continue;
            m_lLevelImagesSet |= REANIMS_IMG_SETS_REQUIRED_FOR_LEVEL[i];
        }
        ResManager.preLoadImageSets(m_lLevelImagesSet, 50, 100);
    }

    static boolean calcLoadingSteps(int n) {
        GFLoader.setCustomTaskSteps(1);
        for (int i = 0; i < REANIMS_REQUIRED_FOR_LEVEL.length; ++i) {
            if (REANIMS_REQUIRED_FOR_LEVEL[i]) {
                int n2 = "\u0005\u001e\uffff\uffffNXku\uffff\u009c\u00a5\u00b4\u00bd\u00d3\uffff\u00f3\u011e\uffff\uffff\u0143\u0150\u0157\u0162\u016c\u0176\u017a\u017c\u0187\u018d\u0192\u0196\u019c\u01a6\u01ac\u01b1\u01b8\u01bb\u01c1\u01ce\u01d5\u01dc\u01e1\u01ee\u01f2\u01f7\u01fd\u0201\u0204\u0213\uffff\uffff".charAt(i);
                if (n2 == -1) {
                    n2 = (short)"\u0004!.AMYjv\u0089\u0098\u00a3\u00b3\u00be\u00d7\uffff\u00f2\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(i);
                }
                if (n2 == -1) {
                    if (i == 17) {
                        n2 = 307;
                    } else if (i == 18) {
                        n2 = 314;
                    }
                }
                int n3 = 0;
                n3 = Reanim.loadReanimTrackStep(i, n2, 1, true);
                if (n3 > 0) {
                    GFLoader.setCustomTaskSteps(GFLoader.m_nCustomTaskSteps + n3);
                    ++m_nReanimsRequired;
                }
            }
            m_bLoadNewReanim = true;
        }
        return m_nReanimsRequired == 0;
    }

    static boolean loadNextStep() {
        boolean bl = false;
        if (GFLoader.tryLoadTaskStep(m_nReanimStep)) {
            for (int i = 0; i < REANIMS_REQUIRED_FOR_LEVEL.length; ++i) {
                if (!REANIMS_REQUIRED_FOR_LEVEL[i] || LOADED_REANIMS[i]) continue;
                int n = "\u0005\u001e\uffff\uffffNXku\uffff\u009c\u00a5\u00b4\u00bd\u00d3\uffff\u00f3\u011e\uffff\uffff\u0143\u0150\u0157\u0162\u016c\u0176\u017a\u017c\u0187\u018d\u0192\u0196\u019c\u01a6\u01ac\u01b1\u01b8\u01bb\u01c1\u01ce\u01d5\u01dc\u01e1\u01ee\u01f2\u01f7\u01fd\u0201\u0204\u0213\uffff\uffff".charAt(i);
                if (n == -1) {
                    n = (short)"\u0004!.AMYjv\u0089\u0098\u00a3\u00b3\u00be\u00d7\uffff\u00f2\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(i);
                }
                if (n == -1) {
                    if (i == 17) {
                        n = 307;
                    } else if (i == 18) {
                        n = 314;
                    }
                }
                Reanim.loadReanimTrackStep(i, n, m_nReanimStep, false);
                ++m_nReanimStep;
                if (!LOADED_REANIMS[i]) break;
                ++m_nReanimsLoaded;
                break;
            }
            if (m_nReanimsLoaded == m_nReanimsRequired) {
                bl = true;
            }
        }
        return bl;
    }

    static void calcReanimMaxByteSize() {
        int n = 0;
        for (int i = 0; i < 51; ++i) {
            int n2 = ReanimInterface.REANIM_BYTE_OFFSETS[i + 1] - ReanimInterface.REANIM_BYTE_OFFSETS[i];
            if (n2 <= n) continue;
            n = n2;
        }
        REANIM_BYTE_DATA = new byte[n];
    }

    static void resetVars() {
        m_nFPReanimFrame = 0;
        m_nReanims = 0;
        m_nTracks = 0;
        m_nImgsCount = 0;
        Util.resetArray(REANIM_DATA, -1);
        Util.resetArray(LOADED_REANIMS, false);
        for (int i = 0; i < TRACK_IMGS.length; ++i) {
            Reanim.TRACK_IMGS[i] = null;
        }
        Util.resetArray(TRACK_IMG_CROPPED_VALS, 0);
    }

    static void loadReanim(int n, int n2) {
        if (Reanim.bIsReanimLoaded(n, n2)) {
            return;
        }
        m_nTracksCountTemp = 0;
        int n3 = m_nReanims * 3;
        int n4 = -1;
        int n5 = -1;
        Reanim.REANIM_DATA[n3 + 0] = n;
        try {
            System.gc();
            DataInputStream dataInputStream = new DataInputStream(Graphic.STANDARD_GRAPHICS_FILE.getClass().getResourceAsStream("/re"));
            int n6 = ReanimInterface.REANIM_BYTE_OFFSETS[n + 1] - ReanimInterface.REANIM_BYTE_OFFSETS[n];
            byte[] byArray = new byte[n6];
            m_nReanimDataPos = 0;
            dataInputStream.skipBytes(ReanimInterface.REANIM_BYTE_OFFSETS[n]);
            int n7 = dataInputStream.read(byArray);
            dataInputStream.close();
            dataInputStream = null;
            int n8 = Reanim.readByte(byArray);
            int n9 = Reanim.readInt(byArray);
            Reanim.REANIM_DATA[n3 + 1] = n9 > 0 ? n9 : 4;
            int n10 = -1;
            Reanim.nReanims[Reanim.m_nReanims] = null;
            Reanim.nReanims[Reanim.m_nReanims] = new TrackData((byte)n, n8);
            for (int i = 0; i < n8; ++i) {
                n10 = Reanim.readInt(byArray);
                int n11 = Reanim.loadTrack(byArray, m_nReanims, i, ReanimInterface.REANIM_STRINGS[n].charAt(i), n10);
                if (ReanimInterface.REANIM_STRINGS[n].charAt(i) != n2) continue;
                n4 = i;
                n5 = n11;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Reanim.REANIM_DATA[n3 + 2] = m_nTracksCountTemp;
        int n12 = TRACK_ATTRIBS[m_nReanims][n4 * 5 + 2];
        Reanim.REANIM_LOADED_TEMP_VALS[0] = m_nReanims;
        Reanim.REANIM_LOADED_TEMP_VALS[1] = n12;
        Reanim.REANIM_LOADED_TEMP_VALS[2] = n5;
        Reanim.REANIM_LOADED_TEMP_VALS[3] = REANIM_DATA[n3 + 1];
        Reanim.REANIM_LOADED_TEMP_VALS[4] = Reanim.getStartTrackGlobalIndex(m_nReanims);
        ++m_nReanims;
        Reanim.LOADED_REANIMS[n] = true;
    }

    static int loadReanimFrameStep(int n, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        if (Reanim.bIsReanimLoaded(n, n2)) {
            return 0;
        }
        int n6 = m_nReanims * 3;
        m_nTracksCountTemp = 0;
        int n7 = -1;
        int n8 = -1;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        m_nReanimDataPos = 0;
        if (n3 == 1 || m_bLoadNewReanim) {
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_TRACKS_COUNT] = 0;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_REANIM_OFFSET] = m_nReanims * 3;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_TRACK_ATTRIB_INDEX] = -1;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_TRACK_GLOBAL_INDEX] = -1;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_DATA_POS] = 0;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_CURR_TRACK_INDEX] = 0;
            Reanim.REANIM_DATA[n6 + 0] = n;
            try {
                System.gc();
                DataInputStream dataInputStream = new DataInputStream(Graphic.STANDARD_GRAPHICS_FILE.getClass().getResourceAsStream("/re"));
                Util.resetArray(REANIM_BYTE_DATA, (byte)-1);
                n5 = ReanimInterface.REANIM_BYTE_OFFSETS[n + 1] - ReanimInterface.REANIM_BYTE_OFFSETS[n];
                dataInputStream.skipBytes(ReanimInterface.REANIM_BYTE_OFFSETS[n]);
                int n12 = dataInputStream.read(REANIM_BYTE_DATA);
                dataInputStream.close();
                dataInputStream = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return -1;
            }
            byte by = Reanim.readByte(REANIM_BYTE_DATA);
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_NUM_TRACKS] = by;
            n9 = by;
            n4 = Reanim.readInt(REANIM_BYTE_DATA);
            Reanim.REANIM_DATA[n6 + 1] = n4 > 0 ? n4 : 4;
        } else {
            m_nTracksCountTemp = REANIM_STEP_LOADER[STEP_LOAD_TRACKS_COUNT];
            m_nReanimDataPos = REANIM_STEP_LOADER[STEP_LOAD_DATA_POS];
            n6 = REANIM_STEP_LOADER[STEP_LOAD_REANIM_OFFSET];
            n7 = REANIM_STEP_LOADER[STEP_LOAD_TRACK_ATTRIB_INDEX];
            n8 = REANIM_STEP_LOADER[STEP_LOAD_TRACK_GLOBAL_INDEX];
            n9 = REANIM_STEP_LOADER[STEP_LOAD_NUM_TRACKS];
            n10 = REANIM_STEP_LOADER[STEP_LOAD_NUM_FRAMES];
            n11 = REANIM_STEP_LOADER[STEP_LOAD_CURR_TRACK_INDEX];
        }
        if (bl) {
            m_bLoadNewReanim = false;
            n10 = Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_NUM_FRAMES] = Reanim.readInt(REANIM_BYTE_DATA);
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_DATA_POS] = m_nReanimDataPos;
            return n9 * n10;
        }
        if (m_bLoadNewReanim) {
            n10 = Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_NUM_FRAMES] = Reanim.readInt(REANIM_BYTE_DATA);
        } else if (REANIM_STEP_LOADER[STEP_LOAD_TRACKS_COUNT] > 0 && REANIM_STEP_LOADER[STEP_LOAD_CURRENT_FRAME] == 0) {
            Reanim.readInt(REANIM_BYTE_DATA);
        }
        m_bLoadNewReanim = false;
        Reanim.nReanims[Reanim.m_nReanims] = null;
        Reanim.nReanims[Reanim.m_nReanims] = new TrackData((byte)n, n9);
        n4 = Reanim.loadTrackFrameStep(REANIM_BYTE_DATA, m_nReanims, n11, ReanimInterface.REANIM_STRINGS[n].charAt(n11), n10, n3, REANIM_STEP_LOADER);
        if (n4 != -1) {
            int n13 = STEP_LOAD_CURR_TRACK_INDEX;
            REANIM_STEP_LOADER[n13] = REANIM_STEP_LOADER[n13] + 1;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_TRACKS_COUNT] = m_nTracksCountTemp;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_CURRENT_FRAME] = 0;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_FRAME_START] = -1;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_FRAME_COUNT] = -1;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_TRACK_TYPE] = 1;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_PREV_X] = DEFAULT_REANIM_VAL;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_PREV_Y] = DEFAULT_REANIM_VAL;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_PREV_SX] = 0;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_PREV_SY] = 0;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_PREV_KX] = 0;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_PREV_KY] = 0;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_PREV_IMG] = -1;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_IMG_ID] = -1;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_BASE_IMG_ID] = -1;
            if (ReanimInterface.REANIM_STRINGS[n].charAt(n11) == n2) {
                Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_TRACK_ATTRIB_INDEX] = n7 = n11;
                Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_TRACK_GLOBAL_INDEX] = n8 = n4;
            }
        }
        if (n9 == REANIM_STEP_LOADER[STEP_LOAD_TRACKS_COUNT]) {
            Reanim.REANIM_DATA[n6 + 0] = n;
            Reanim.REANIM_DATA[n6 + 2] = REANIM_STEP_LOADER[STEP_LOAD_TRACKS_COUNT];
            n7 = REANIM_STEP_LOADER[STEP_LOAD_TRACK_ATTRIB_INDEX];
            n8 = REANIM_STEP_LOADER[STEP_LOAD_TRACK_GLOBAL_INDEX];
            n5 = TRACK_ATTRIBS[m_nReanims][n7 * 5 + 2];
            Reanim.REANIM_LOADED_TEMP_VALS[0] = m_nReanims;
            Reanim.REANIM_LOADED_TEMP_VALS[1] = n5;
            Reanim.REANIM_LOADED_TEMP_VALS[2] = n8;
            Reanim.REANIM_LOADED_TEMP_VALS[3] = REANIM_DATA[n6 + 1];
            Reanim.REANIM_LOADED_TEMP_VALS[4] = Reanim.getStartTrackGlobalIndex(m_nReanims);
            Reanim.LOADED_REANIMS[n] = true;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_TRACKS_COUNT] = 0;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_REANIM_OFFSET] = ++m_nReanims * 3;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_TRACK_ATTRIB_INDEX] = -1;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_TRACK_GLOBAL_INDEX] = -1;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_DATA_POS] = 0;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_CURR_TRACK_INDEX] = 0;
            m_bLoadNewReanim = true;
        }
        return 0;
    }

    static int loadReanimTrackStep(int n, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        if (Reanim.bIsReanimLoaded(n, n2)) {
            return 0;
        }
        int n6 = m_nReanims * 3;
        m_nTracksCountTemp = 0;
        int n7 = -1;
        int n8 = -1;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        m_nReanimDataPos = 0;
        if (n3 == 1 || m_bLoadNewReanim) {
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_TRACKS_COUNT] = 0;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_REANIM_OFFSET] = m_nReanims * 3;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_TRACK_ATTRIB_INDEX] = -1;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_TRACK_GLOBAL_INDEX] = -1;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_DATA_POS] = 0;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_CURR_TRACK_INDEX] = 0;
            Reanim.REANIM_DATA[n6 + 0] = n;
            try {
                System.gc();
                DataInputStream dataInputStream = new DataInputStream(Graphic.STANDARD_GRAPHICS_FILE.getClass().getResourceAsStream("/re"));
                Util.resetArray(REANIM_BYTE_DATA, (byte)-1);
                n5 = ReanimInterface.REANIM_BYTE_OFFSETS[n + 1] - ReanimInterface.REANIM_BYTE_OFFSETS[n];
                dataInputStream.skipBytes(ReanimInterface.REANIM_BYTE_OFFSETS[n]);
                int n12 = dataInputStream.read(REANIM_BYTE_DATA);
                dataInputStream.close();
                dataInputStream = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return -1;
            }
            byte by = Reanim.readByte(REANIM_BYTE_DATA);
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_NUM_TRACKS] = by;
            n9 = by;
            Reanim.nReanims[Reanim.m_nReanims] = null;
            Reanim.nReanims[Reanim.m_nReanims] = new TrackData((byte)n, n9);
            n4 = Reanim.readInt(REANIM_BYTE_DATA);
            Reanim.REANIM_DATA[n6 + 1] = n4 > 0 ? n4 : 4;
        } else {
            m_nTracksCountTemp = REANIM_STEP_LOADER[STEP_LOAD_TRACKS_COUNT];
            m_nReanimDataPos = REANIM_STEP_LOADER[STEP_LOAD_DATA_POS];
            n6 = REANIM_STEP_LOADER[STEP_LOAD_REANIM_OFFSET];
            n7 = REANIM_STEP_LOADER[STEP_LOAD_TRACK_ATTRIB_INDEX];
            n8 = REANIM_STEP_LOADER[STEP_LOAD_TRACK_GLOBAL_INDEX];
            n9 = REANIM_STEP_LOADER[STEP_LOAD_NUM_TRACKS];
            n10 = REANIM_STEP_LOADER[STEP_LOAD_NUM_FRAMES];
            n11 = REANIM_STEP_LOADER[STEP_LOAD_CURR_TRACK_INDEX];
        }
        if (bl) {
            m_bLoadNewReanim = false;
            n10 = Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_NUM_FRAMES] = Reanim.readInt(REANIM_BYTE_DATA);
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_DATA_POS] = m_nReanimDataPos;
            return n9;
        }
        if (m_bLoadNewReanim) {
            n10 = Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_NUM_FRAMES] = Reanim.readInt(REANIM_BYTE_DATA);
        } else if (REANIM_STEP_LOADER[STEP_LOAD_TRACKS_COUNT] > 0 && REANIM_STEP_LOADER[STEP_LOAD_CURRENT_FRAME] == 0) {
            Reanim.readInt(REANIM_BYTE_DATA);
        }
        m_bLoadNewReanim = false;
        n4 = Reanim.loadTrack(REANIM_BYTE_DATA, m_nReanims, n11, ReanimInterface.REANIM_STRINGS[n].charAt(n11), n10);
        if (n4 != -1) {
            int n13 = STEP_LOAD_CURR_TRACK_INDEX;
            REANIM_STEP_LOADER[n13] = REANIM_STEP_LOADER[n13] + 1;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_TRACKS_COUNT] = m_nTracksCountTemp;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_DATA_POS] = m_nReanimDataPos;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_CURRENT_FRAME] = 0;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_FRAME_START] = -1;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_FRAME_COUNT] = -1;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_TRACK_TYPE] = 1;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_PREV_X] = DEFAULT_REANIM_VAL;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_PREV_Y] = DEFAULT_REANIM_VAL;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_PREV_SX] = 0;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_PREV_SY] = 0;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_PREV_KX] = 0;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_PREV_KY] = 0;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_PREV_IMG] = -1;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_IMG_ID] = -1;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_BASE_IMG_ID] = -1;
            if (ReanimInterface.REANIM_STRINGS[n].charAt(n11) == n2) {
                Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_TRACK_ATTRIB_INDEX] = n7 = n11;
                Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_TRACK_GLOBAL_INDEX] = n8 = n4;
            }
        }
        if (n9 == REANIM_STEP_LOADER[STEP_LOAD_TRACKS_COUNT]) {
            Reanim.REANIM_DATA[n6 + 0] = n;
            Reanim.REANIM_DATA[n6 + 2] = REANIM_STEP_LOADER[STEP_LOAD_TRACKS_COUNT];
            n7 = REANIM_STEP_LOADER[STEP_LOAD_TRACK_ATTRIB_INDEX];
            n8 = REANIM_STEP_LOADER[STEP_LOAD_TRACK_GLOBAL_INDEX];
            n5 = TRACK_ATTRIBS[m_nReanims][n7 * 5 + 2];
            Reanim.REANIM_LOADED_TEMP_VALS[0] = m_nReanims;
            Reanim.REANIM_LOADED_TEMP_VALS[1] = n5;
            Reanim.REANIM_LOADED_TEMP_VALS[2] = n8;
            Reanim.REANIM_LOADED_TEMP_VALS[3] = REANIM_DATA[n6 + 1];
            Reanim.REANIM_LOADED_TEMP_VALS[4] = Reanim.getStartTrackGlobalIndex(m_nReanims);
            Reanim.LOADED_REANIMS[n] = true;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_TRACKS_COUNT] = 0;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_REANIM_OFFSET] = ++m_nReanims * 3;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_TRACK_ATTRIB_INDEX] = -1;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_TRACK_GLOBAL_INDEX] = -1;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_DATA_POS] = 0;
            Reanim.REANIM_STEP_LOADER[Reanim.STEP_LOAD_CURR_TRACK_INDEX] = 0;
            m_bLoadNewReanim = true;
        }
        return 0;
    }

    private static int loadTrack(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = -1;
        int n7 = -1;
        int n8 = 1;
        int n9 = DEFAULT_REANIM_VAL;
        int n10 = DEFAULT_REANIM_VAL;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = -1;
        int n16 = -1;
        int n17 = -1;
        Reanim.nReanims[Reanim.m_nReanims].nTracks[n2] = new Tracks(n4);
        for (int i = 0; i < n4; ++i) {
            n5 = i * 9;
            try {
                Reanim.nReanims[n].nTracks[n2].nTrackFrames[i].TRACK_F = Reanim.readByte(byArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (Reanim.nReanims[n].nTracks[n2].nTrackFrames[i].TRACK_F == -1) {
                if (n16 != -1) {
                    n17 = n16;
                }
                n16 = -1;
                n15 = -1;
            } else if (Reanim.nReanims[n].nTracks[n2].nTrackFrames[i].TRACK_F == 0 && n17 != -1) {
                n15 = n17;
                n17 = -1;
            }
            if (Reanim.readByte(byArray) != 0) {
                int n18;
                Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[i].TRACK_FP_X = n18 = Reanim.readInt(byArray);
                n9 = n18;
            } else {
                Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[i].TRACK_FP_X = n9;
            }
            if (Reanim.readByte(byArray) != 0) {
                int n19;
                Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[i].TRACK_FP_Y = n19 = Reanim.readInt(byArray);
                n10 = n19;
            } else {
                Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[i].TRACK_FP_Y = n10;
            }
            if (Reanim.readByte(byArray) != 0) {
                int n20;
                Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[i].TRACK_FP_SX = n20 = Reanim.readInt(byArray);
                n11 = n20;
            } else {
                Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[i].TRACK_FP_SX = n11;
            }
            if (Reanim.readByte(byArray) != 0) {
                int n21;
                Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[i].TRACK_FP_SY = n21 = Reanim.readInt(byArray);
                n12 = n21;
            } else {
                Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[i].TRACK_FP_SY = n12;
            }
            if (Reanim.readByte(byArray) != 0) {
                int n22;
                Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[i].TRACK_FP_KX = n22 = Reanim.readInt(byArray);
                n13 = n22;
            } else {
                Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[i].TRACK_FP_KX = n13;
            }
            if (Reanim.readByte(byArray) != 0) {
                int n23;
                Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[i].TRACK_FP_KY = n23 = Reanim.readInt(byArray);
                n14 = n23;
            } else {
                Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[i].TRACK_FP_KY = n14;
            }
            n15 = n16 = Reanim.loadTrackImageID(byArray, n15);
            if (i == 0) {
                m_nTrackBaseImgX = Reanim.nReanims[n].nTracks[n2].nTrackFrames[i].TRACK_FP_X;
                m_nTrackBaseImgY = Reanim.nReanims[n].nTracks[n2].nTrackFrames[i].TRACK_FP_Y;
            }
            if (n6 == -1 && Reanim.nReanims[n].nTracks[n2].nTrackFrames[i].TRACK_F != -1) {
                n6 = i;
            } else if (n7 == -1 && n6 != -1 && Reanim.nReanims[n].nTracks[n2].nTrackFrames[i].TRACK_F == -1) {
                n7 = i - n6;
            }
            if (n16 != -1) {
                Reanim.nReanims[n].nTracks[n2].nTrackFrames[i].TRACK_IMG = Reanim.createTrackImage(n, n2, n16, m_nImgsCount, m_nTracks, i);
                n11 = Reanim.nReanims[n].nTracks[n2].nTrackFrames[i].TRACK_FP_SX;
                n12 = Reanim.nReanims[n].nTracks[n2].nTrackFrames[i].TRACK_FP_SY;
                Reanim.nReanims[n].nTracks[n2].nTrackFrames[i].TRACK_BASE_IMG = n16;
            } else {
                Reanim.nReanims[n].nTracks[n2].nTrackFrames[i].TRACK_IMG = -1;
            }
            if (n8 != 1 || n16 == -1) continue;
            n8 = 0;
        }
        if (n7 == -1) {
            n7 = n6 == 0 ? n4 - 1 - n6 : n4 - n6;
        }
        Reanim.createTrackAttribs(n, m_nTracks, n2, n3, n8, n6, n7);
        ++m_nTracksCountTemp;
        return ++m_nTracks - 1;
    }

    private static int loadTrackFrameStep(byte[] byArray, int n, int n2, int n3, int n4, int n5, int[] nArray) {
        int n6 = 0;
        int n7 = -1;
        int n8 = -1;
        int n9 = 1;
        int n10 = DEFAULT_REANIM_VAL;
        int n11 = DEFAULT_REANIM_VAL;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = -1;
        int n17 = -1;
        int n18 = -1;
        if (n5 == 2) {
            nArray[Reanim.STEP_LOAD_CURRENT_FRAME] = 0;
            n6 = 0;
            nArray[Reanim.STEP_LOAD_FRAME_START] = -1;
            n7 = -1;
            nArray[Reanim.STEP_LOAD_FRAME_COUNT] = -1;
            n8 = -1;
            nArray[Reanim.STEP_LOAD_TRACK_TYPE] = 1;
            n9 = 1;
            n10 = nArray[Reanim.STEP_LOAD_PREV_X] = DEFAULT_REANIM_VAL;
            n11 = nArray[Reanim.STEP_LOAD_PREV_Y] = DEFAULT_REANIM_VAL;
            nArray[Reanim.STEP_LOAD_PREV_SX] = 0;
            n12 = 0;
            nArray[Reanim.STEP_LOAD_PREV_SY] = 0;
            n13 = 0;
            nArray[Reanim.STEP_LOAD_PREV_KX] = 0;
            n14 = 0;
            nArray[Reanim.STEP_LOAD_PREV_KY] = 0;
            n15 = 0;
            nArray[Reanim.STEP_LOAD_PREV_IMG] = -1;
            n16 = -1;
            nArray[Reanim.STEP_LOAD_IMG_ID] = -1;
            n17 = -1;
            nArray[Reanim.STEP_LOAD_BASE_IMG_ID] = -1;
            n18 = -1;
        } else {
            n6 = nArray[STEP_LOAD_CURRENT_FRAME];
            n7 = nArray[STEP_LOAD_FRAME_START];
            n8 = nArray[STEP_LOAD_FRAME_COUNT];
            n9 = nArray[STEP_LOAD_TRACK_TYPE];
            n10 = nArray[STEP_LOAD_PREV_X];
            n11 = nArray[STEP_LOAD_PREV_Y];
            n12 = nArray[STEP_LOAD_PREV_SX];
            n13 = nArray[STEP_LOAD_PREV_SY];
            n14 = nArray[STEP_LOAD_PREV_KX];
            n15 = nArray[STEP_LOAD_PREV_KY];
            n16 = nArray[STEP_LOAD_PREV_IMG];
            n17 = nArray[STEP_LOAD_IMG_ID];
            n18 = nArray[STEP_LOAD_BASE_IMG_ID];
        }
        int n19 = n6 * 9;
        try {
            Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[n6].TRACK_F = Reanim.readByte(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[n6].TRACK_F == -1) {
            if (n17 != -1) {
                n18 = n17;
            }
            n17 = -1;
            n16 = -1;
        } else if (Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[n6].TRACK_F == 0 && n18 != -1) {
            n16 = n18;
            n18 = -1;
        }
        if (Reanim.readByte(byArray) != 0) {
            int n20;
            Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[n6].TRACK_FP_X = n20 = Reanim.readInt(byArray);
            n10 = n20;
        } else {
            Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[n6].TRACK_FP_X = n10;
        }
        if (Reanim.readByte(byArray) != 0) {
            int n21;
            Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[n6].TRACK_FP_Y = n21 = Reanim.readInt(byArray);
            n11 = n21;
        } else {
            Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[n6].TRACK_FP_Y = n11;
        }
        if (Reanim.readByte(byArray) != 0) {
            int n22;
            Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[n6].TRACK_FP_SX = n22 = Reanim.readInt(byArray);
            n12 = n22;
        } else {
            Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[n6].TRACK_FP_SX = n12;
        }
        if (Reanim.readByte(byArray) != 0) {
            int n23;
            Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[n6].TRACK_FP_SY = n23 = Reanim.readInt(byArray);
            n13 = n23;
        } else {
            Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[n6].TRACK_FP_SY = n13;
        }
        if (Reanim.readByte(byArray) != 0) {
            int n24;
            Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[n6].TRACK_FP_KX = n24 = Reanim.readInt(byArray);
            n14 = n24;
        } else {
            Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[n6].TRACK_FP_KX = n14;
        }
        if (Reanim.readByte(byArray) != 0) {
            int n25;
            Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[n6].TRACK_FP_KY = n25 = Reanim.readInt(byArray);
            n15 = n25;
        } else {
            Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[n6].TRACK_FP_KY = n15;
        }
        n16 = n17 = Reanim.loadTrackImageID(byArray, n16);
        if (n6 == 0) {
            m_nTrackBaseImgX = Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[n6].TRACK_FP_X;
            m_nTrackBaseImgY = Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[n6].TRACK_FP_Y;
        }
        if (n7 == -1 && Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[n6].TRACK_F != -1) {
            n7 = n6;
        } else if (n8 == -1 && n7 != -1 && Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[n6].TRACK_F == -1) {
            n8 = n6 - n7;
        }
        if (n17 != -1) {
            Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[n6].TRACK_IMG = Reanim.createTrackImage(m_nReanims, n2, n17, m_nImgsCount, m_nTracks, n6);
            n12 = Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[n6].TRACK_FP_SX;
            n13 = Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[n6].TRACK_FP_SY;
            Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[n6].TRACK_BASE_IMG = n17;
        } else {
            Reanim.nReanims[Reanim.m_nReanims].nTracks[n2].nTrackFrames[n6].TRACK_IMG = -1;
        }
        if (n9 == 1 && n17 != -1) {
            n9 = 0;
        }
        if (n8 == -1 && n6 == n4 - 1) {
            n8 = n7 == 0 ? n4 - 1 - n7 : n4 - n7;
        }
        nArray[Reanim.STEP_LOAD_CURRENT_FRAME] = ++n6;
        nArray[Reanim.STEP_LOAD_FRAME_START] = n7;
        nArray[Reanim.STEP_LOAD_FRAME_COUNT] = n8;
        nArray[Reanim.STEP_LOAD_TRACK_TYPE] = n9;
        nArray[Reanim.STEP_LOAD_PREV_X] = n10;
        nArray[Reanim.STEP_LOAD_PREV_Y] = n11;
        nArray[Reanim.STEP_LOAD_PREV_SX] = n12;
        nArray[Reanim.STEP_LOAD_PREV_SY] = n13;
        nArray[Reanim.STEP_LOAD_PREV_KX] = n14;
        nArray[Reanim.STEP_LOAD_PREV_KY] = n15;
        nArray[Reanim.STEP_LOAD_PREV_IMG] = n16;
        nArray[Reanim.STEP_LOAD_IMG_ID] = n17;
        nArray[Reanim.STEP_LOAD_BASE_IMG_ID] = n18;
        nArray[Reanim.STEP_LOAD_DATA_POS] = m_nReanimDataPos;
        if (n6 == n4) {
            nArray[Reanim.STEP_LOAD_CURRENT_FRAME] = 0;
            Reanim.createTrackAttribs(n, m_nTracks, n2, n3, n9, n7, n8);
            ++m_nTracksCountTemp;
            return ++m_nTracks - 1;
        }
        return -1;
    }

    private static int loadTrackImageID(byte[] byArray, int n) {
        try {
            boolean bl;
            byte by = Reanim.readByte(byArray);
            boolean bl2 = bl = by != -1;
            if (bl) {
                int n2 = Reanim.readInt(byArray);
                return n2;
            }
            return n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    static boolean bIsReanimLoaded(int n, int n2) {
        boolean bl = LOADED_REANIMS[n];
        if (bl) {
            int n3 = Reanim.getReanimIndexFromID(n);
            int n4 = Reanim.getTrackAttribsIndexFromTrackID(n3, n2);
            int n5 = Reanim.getTrackGlobalIndex(n3, n4);
            int n6 = n3 * 3;
            int n7 = TRACK_ATTRIBS[n3][n4 * 5 + 2];
            Reanim.REANIM_LOADED_TEMP_VALS[0] = n3;
            Reanim.REANIM_LOADED_TEMP_VALS[1] = n7;
            Reanim.REANIM_LOADED_TEMP_VALS[2] = n5;
            Reanim.REANIM_LOADED_TEMP_VALS[3] = REANIM_DATA[n6 + 1];
            Reanim.REANIM_LOADED_TEMP_VALS[4] = Reanim.getStartTrackGlobalIndex(n3);
        }
        return bl;
    }

    static void resetLoadedReanims() {
        Util.resetArray(REANIM_DATA, -1);
        Util.resetArray(LOADED_REANIMS, false);
        for (int i = 0; i < TRACK_IMGS.length; ++i) {
            Reanim.TRACK_IMGS[i] = null;
        }
        Util.resetArray(TRACK_IMG_CROPPED_VALS, 0);
        m_nFPReanimFrame = 0;
        m_nReanims = 0;
        m_nTracks = 0;
        m_nImgsCount = 0;
    }

    private static int createTrackImage(int n, int n2, int n3, int n4, int n5, int n6) {
        try {
            int n7;
            int n8 = n6 * 9;
            int n9 = Reanim.nReanims[n].nTracks[n2].nTrackFrames[n6].TRACK_FP_KX;
            int n10 = Reanim.nReanims[n].nTracks[n2].nTrackFrames[n6].TRACK_FP_KY;
            int n11 = Reanim.nReanims[n].nTracks[n2].nTrackFrames[n6].TRACK_FP_SX;
            int n12 = Reanim.nReanims[n].nTracks[n2].nTrackFrames[n6].TRACK_FP_SY;
            if (n11 == 0) {
                n11 = 4096;
            }
            if (n12 == 0) {
                n12 = 4096;
            }
            int n13 = Math.abs(4096 - n11);
            int n14 = Math.abs(4096 - n12);
            if (n13 < GModel.FP_2_PERCENT) {
                n11 = 4096;
            }
            if (n14 < GModel.FP_2_PERCENT) {
                n12 = 4096;
            }
            Reanim.nReanims[n].nTracks[n2].nTrackFrames[n6].TRACK_FP_SX = n11;
            Reanim.nReanims[n].nTracks[n2].nTrackFrames[n6].TRACK_FP_SY = n12;
            boolean bl = Reanim.bIsStandardImage(n11, n12, n9, n10);
            int n15 = -1;
            for (n7 = 0; n7 < n6; ++n7) {
                int n16 = n7 * 9;
                int n17 = Reanim.nReanims[n].nTracks[n2].nTrackFrames[n7].TRACK_FP_KX;
                int n18 = Reanim.nReanims[n].nTracks[n2].nTrackFrames[n7].TRACK_FP_KY;
                int n19 = Reanim.nReanims[n].nTracks[n2].nTrackFrames[n7].TRACK_FP_SX;
                int n20 = Reanim.nReanims[n].nTracks[n2].nTrackFrames[n7].TRACK_FP_SY;
                int n21 = Reanim.nReanims[n].nTracks[n2].nTrackFrames[n7].TRACK_BASE_IMG;
                if (n3 != n21 || n19 != 4096 && Math.abs(n13 - n19) > GModel.FP_2_PERCENT || n20 != 4096 && Math.abs(n14 - n20) > GModel.FP_2_PERCENT || n9 != n17 || n10 != n18) continue;
                n15 = Reanim.nReanims[n].nTracks[n2].nTrackFrames[n7].TRACK_IMG;
                break;
            }
            if (bl) {
                if (n15 != -1) {
                    return n15;
                }
                Reanim.TRACK_IMGS[Reanim.m_nImgsCount] = Reanim.sharpen((Image)Graphic.m_ImgPool[n3].imageData, true);
            } else {
                boolean bl2;
                n7 = n13 > GModel.FP_2_PERCENT || n14 > GModel.FP_2_PERCENT ? 1 : 0;
                boolean bl3 = bl2 = n9 != 0 || n10 != 0;
                if (bl2) {
                    if (n15 != -1) {
                        Reanim.computeDerivedImageDiffs(n, n2, (Image)Graphic.m_ImgPool[n3].imageData, n5, n6, n9, n15, n13, n14, false);
                        return n15;
                    }
                    if (n7 != 0) {
                        Reanim.TRACK_IMGS[Reanim.m_nImgsCount] = Reanim.rotateImage((Image)Graphic.m_ImgPool[n3].imageData, n9);
                        Reanim.TRACK_IMG_CROPPED_VALS[Reanim.m_nImgsCount * 2] = DeriveImage.m_nCropResultOffsetX;
                        Reanim.TRACK_IMG_CROPPED_VALS[Reanim.m_nImgsCount * 2 + 1] = DeriveImage.m_nCropResultOffsetY;
                        int n22 = TRACK_IMGS[m_nImgsCount].getWidth();
                        int n23 = TRACK_IMGS[m_nImgsCount].getHeight();
                        Reanim.TRACK_IMGS[Reanim.m_nImgsCount] = Reanim.scaleImage(TRACK_IMGS[m_nImgsCount], n11, n12, -1);
                        int n24 = TRACK_IMGS[m_nImgsCount].getWidth();
                        int n25 = TRACK_IMGS[m_nImgsCount].getHeight();
                        Reanim.computeDerivedImageDiffs(n, n2, (Image)Graphic.m_ImgPool[n3].imageData, n5, n6, n9, m_nImgsCount, n11, n12, true);
                        Reanim.TRACK_IMGS[Reanim.m_nImgsCount] = Reanim.sharpen(TRACK_IMGS[m_nImgsCount], false);
                    } else {
                        Reanim.TRACK_IMGS[Reanim.m_nImgsCount] = Reanim.rotateImage((Image)Graphic.m_ImgPool[n3].imageData, n9);
                        Reanim.TRACK_IMG_CROPPED_VALS[Reanim.m_nImgsCount * 2] = DeriveImage.m_nCropResultOffsetX;
                        Reanim.TRACK_IMG_CROPPED_VALS[Reanim.m_nImgsCount * 2 + 1] = DeriveImage.m_nCropResultOffsetY;
                        Reanim.computeDerivedImageDiffs(n, n2, (Image)Graphic.m_ImgPool[n3].imageData, n5, n6, n9, m_nImgsCount, n11, n12, false);
                        Reanim.TRACK_IMGS[Reanim.m_nImgsCount] = Reanim.sharpen(TRACK_IMGS[m_nImgsCount], false);
                    }
                } else if (n7 != 0) {
                    Reanim.TRACK_IMGS[Reanim.m_nImgsCount] = Reanim.scaleImage(n3, n11, n12);
                    Reanim.TRACK_IMGS[Reanim.m_nImgsCount] = Reanim.sharpen(TRACK_IMGS[m_nImgsCount], false);
                } else if (n15 != -1) {
                    return n15;
                }
            }
            return ++m_nImgsCount - 1;
        }
        catch (Exception exception) {
            System.out.println("_________Error: Reanim.createTrackImage(), new_imageID: " + n3);
            return m_nImgsCount;
        }
    }

    static Image sharpen(Image image, boolean bl) {
        int n = image.getWidth();
        int n2 = image.getHeight();
        int[] nArray = new int[n * n2];
        image.getRGB(nArray, 0, n, 0, 0, n, n2);
        int[] nArray2 = new int[n * n2];
        nArray2 = DeriveImage.blur(nArray, n, n2, DeriveImage.BLUR_KERNEL);
        if (bl) {
            int n3 = FP.fpDiv(4096, 409600);
            DeriveImage.sharpen(nArray, nArray2, n, n2, n3, 0);
        } else {
            int n4 = FP.fpDiv(204800, 409600);
            DeriveImage.sharpen(nArray, nArray2, n, n2, n4, 0);
        }
        return Image.createRGBImage((int[])nArray2, (int)n, (int)n2, (boolean)true);
    }

    private static void computeDerivedImageDiffs(int n, int n2, Image image, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        int n9;
        int n10;
        int n11 = n4 * 9;
        int n12 = FP.fpMul(n5, 71);
        int n13 = TRACK_IMG_CROPPED_VALS[n6 * 2] * 4096;
        int n14 = TRACK_IMG_CROPPED_VALS[n6 * 2 + 1] * 4096;
        int n15 = m_nTrackBaseImgX;
        int n16 = m_nTrackBaseImgY;
        int n17 = 0;
        int n18 = 0;
        if (bl) {
            n10 = image.getWidth() * 4096;
            n9 = image.getHeight() * 4096;
            n17 = FP.fpMul(n10, n7);
            n18 = FP.fpMul(n9, n8);
        } else {
            n17 = image.getWidth() * 4096;
            n18 = image.getHeight() * 4096;
        }
        n10 = n15 + n17 / 2;
        n9 = n16 + n18 / 2;
        Reanim.fpCoordinatesRotate(n15, n16, n10, n9, FP.fpSin(n12), FP.fpCos(n12));
        int n19 = CALCULATIONS[0];
        int n20 = CALCULATIONS[1];
        int n21 = Reanim.nReanims[n].nTracks[n2].nTrackFrames[n4].TRACK_FP_X - CALCULATIONS[0];
        int n22 = Reanim.nReanims[n].nTracks[n2].nTrackFrames[n4].TRACK_FP_Y - CALCULATIONS[1];
        Reanim.fpCoordinatesRotate(n15, n16 + n18, n10, n9, FP.fpSin(n12), FP.fpCos(n12));
        n19 = Math.min(n19, CALCULATIONS[0]);
        n20 = Math.min(n20, CALCULATIONS[1]);
        Reanim.fpCoordinatesRotate(n15 + n17, n16 + n18, n10, n9, FP.fpSin(n12), FP.fpCos(n12));
        n19 = Math.min(n19, CALCULATIONS[0]);
        n20 = Math.min(n20, CALCULATIONS[1]);
        Reanim.fpCoordinatesRotate(n15 + n17, n16, n10, n9, FP.fpSin(n12), FP.fpCos(n12));
        n19 = Math.min(n19, CALCULATIONS[0]);
        n20 = Math.min(n20, CALCULATIONS[1]);
        Reanim.nReanims[n].nTracks[n2].nTrackFrames[n4].TRACK_FP_X = n19 + n21 + n13;
        Reanim.nReanims[n].nTracks[n2].nTrackFrames[n4].TRACK_FP_Y = n20 + n22 + n14;
    }

    static void fpCoordinatesRotate(int n, int n2, int n3, int n4, int n5, int n6) {
        Reanim.CALCULATIONS[0] = FP.fpMul(n -= n3, n6) - FP.fpMul(n2 -= n4, n5) + n3;
        Reanim.CALCULATIONS[1] = FP.fpMul(n, n5) + FP.fpMul(n2, n6) + n4;
    }

    private static boolean bIsStandardImage(int n, int n2, int n3, int n4) {
        int n5 = Math.abs(4096 - n);
        int n6 = Math.abs(4096 - n2);
        if (n != 0 && n5 > GModel.FP_2_PERCENT) {
            return false;
        }
        if (n2 != 0 && n6 > GModel.FP_2_PERCENT) {
            return false;
        }
        if (n3 != 0 && Math.abs(n3) > GModel.FP2) {
            return false;
        }
        return n4 == 0 || Math.abs(n4) <= GModel.FP2;
    }

    static Image scaleImage(int n, int n2, int n3) {
        return Reanim.scaleImage((Image)Graphic.m_ImgPool[n].imageData, n2, n3, -1);
    }

    static Image scaleImage(Image image, int n, int n2, int n3) {
        int n4 = FP.fpMul(n, 409600);
        int n5 = FP.fpMul(n2, 409600);
        int n6 = 100;
        int n7 = 100;
        if (n3 == -1) {
            n6 = FP.toInt(n4);
            n7 = FP.toInt(n5);
        } else if (n3 == 0) {
            n7 = n6 = FP.toInt(n4);
        } else if (n3 == 1) {
            n6 = n7 = FP.toInt(n5);
        }
        int n8 = image.getWidth();
        int n9 = image.getHeight();
        int n10 = (n6 + 1) * n8 / 100;
        int n11 = (n7 + 1) * n9 / 100;
        int[] nArray = new int[n8 * n9];
        int[] nArray2 = new int[n10 * n11];
        image.getRGB(nArray, 0, n8, 0, 0, n8, n9);
        return DeriveImage.scaleImage(nArray, nArray2, n8, n9, n6, n7);
    }

    static Image scaleImage(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = 100;
        int n7 = 100;
        if (n5 == -1) {
            n6 = FP.toInt(n3);
            n7 = FP.toInt(n4);
        } else if (n5 == 0) {
            n7 = n6 = FP.toInt(n3);
        } else if (n5 == 1) {
            n6 = n7 = FP.toInt(n4);
        }
        int n8 = (n6 + 1) * n / 100;
        int n9 = (n7 + 1) * n2 / 100;
        int[] nArray2 = new int[n8 * n9];
        return DeriveImage.scaleImage(nArray, nArray2, n, n2, n6, n7);
    }

    private static Image rotateImage(Image image, int n) {
        int n2 = FP.fpMul(n, 71);
        int n3 = image.getWidth();
        int n4 = image.getHeight();
        int n5 = Math.max(n3, n4);
        int n6 = FP.toInt(2896 * n5 + 2896 * n5) + 1;
        int[] nArray = new int[n3 * n4];
        int[] nArray2 = new int[n6 * n6];
        Image image2 = Image.createImage((Image)image);
        image2.getRGB(nArray, 0, n3, 0, 0, n3, n4);
        return DeriveImage.rotateImage(nArray, nArray2, n3, n4, n2);
    }

    private static void createTrackAttribs(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n3 * 5;
        Reanim.TRACK_ATTRIBS[n][n8 + 0] = n3;
        Reanim.TRACK_ATTRIBS[n][n8 + 1] = n4;
        Reanim.TRACK_ATTRIBS[n][n8 + 2] = n6;
        Reanim.TRACK_ATTRIBS[n][n8 + 3] = n7;
        Reanim.TRACK_ATTRIBS[n][n8 + 4] = n5;
    }

    static int getTrackGlobalIndex(int n, int n2) {
        int n3 = n2 * 5;
        int n4 = TRACK_ATTRIBS[n][n3 + 0];
        return n4;
    }

    static int getTrackGlobalIndexFromTrackID(int n, int n2) {
        int n3 = Reanim.getTrackAttribsIndexFromTrackID(n, n2);
        int n4 = n3 * 5;
        int n5 = TRACK_ATTRIBS[n][n4 + 0];
        return n5;
    }

    static int getTrackAttribsIndexFromTrackID(int n, int n2) {
        int n3 = n * 3;
        int n4 = REANIM_DATA[n3 + 2];
        int n5 = -1;
        for (int i = 0; i < n4; ++i) {
            n5 = TRACK_ATTRIBS[n][i * 5 + 1];
            if (n5 != n2) continue;
            return i;
        }
        return -1;
    }

    static int getTrackAttribsIndex(int n, int n2) {
        int n3 = n * 3;
        int n4 = REANIM_DATA[n3 + 2];
        int n5 = -1;
        int n6 = -1;
        for (int i = 0; i < n4; ++i) {
            n5 = i * 5;
            n6 = TRACK_ATTRIBS[n][n5 + 0];
            if (n6 != n2) continue;
            return i;
        }
        return -1;
    }

    static int getTrackAttributeFromTrackID(int n, int n2, int n3) {
        if (n3 >= 5) {
            return -1;
        }
        int n4 = n * 3;
        int n5 = REANIM_DATA[n4 + 2];
        int n6 = -1;
        int n7 = -1;
        for (int i = 0; i < n5; ++i) {
            n6 = i * 5;
            n7 = TRACK_ATTRIBS[n][n6 + 1];
            if (n7 != n2) continue;
            return TRACK_ATTRIBS[n][n6 + n3];
        }
        return -1;
    }

    static int getStartTrackGlobalIndex(int n) {
        return TRACK_ATTRIBS[n][0];
    }

    static int getReanimIndexFromID(int n) {
        for (int i = 0; i < m_nReanims; ++i) {
            if (REANIM_DATA[i * 3 + 0] != n) continue;
            return i;
        }
        return -1;
    }

    static int getReanimID(int n) {
        return REANIM_DATA[n * 3 + 0];
    }

    static int getTrackIDFromTrackGlobalIndex(int n, int n2) {
        int n3 = Reanim.getTrackAttribsIndex(n, n2);
        int n4 = n3 * 5;
        return TRACK_ATTRIBS[n][n4 + 1];
    }

    static int incrementReanimAnimTrack(int[] nArray, int n, int n2) {
        int n3 = n * 3;
        int n4 = REANIM_DATA[n3 + 2];
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = Reanim.getTrackAttribsIndexFromTrackID(n, n2);
        for (int i = 0; i <= n4; ++i) {
            int n9;
            n8 = (n8 + 1) % n4;
            n5 = n8 * 5;
            n7 = TRACK_ATTRIBS[n][n5 + 1];
            n6 = TRACK_ATTRIBS[n][n5 + 4];
            if (n6 != 1) continue;
            int n10 = n8;
            int n11 = Reanim.getTrackGlobalIndex(n, n10);
            nArray[1] = n9 = TRACK_ATTRIBS[n][n10 * 5 + 2];
            nArray[2] = n11;
            return n7;
        }
        return -1;
    }

    private static byte readByte(byte[] byArray) {
        byte by = byArray[m_nReanimDataPos];
        ++m_nReanimDataPos;
        return by;
    }

    private static int readInt(byte[] byArray) {
        int n = Util.readInt(byArray, m_nReanimDataPos);
        m_nReanimDataPos += 4;
        return n;
    }

    static void updateReanimGlobalFrame() {
        m_nFPReanimFrame = m_nFPReanimFrame >= 0x7FFFFFFE ? 0 : ++m_nFPReanimFrame;
    }

    static boolean updateReanim(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[3];
        int n3 = nArray[4];
        if ((n3 += 4096) < n2) {
            nArray[4] = n3;
            return false;
        }
        nArray[4] = n3 -= n2;
        int n4 = nArray[1];
        int n5 = nArray[2];
        int n6 = nArray[6];
        int n7 = Reanim.getTrackAttribsIndex(n, n5);
        int n8 = n7 * 5;
        int n9 = TRACK_ATTRIBS[n][n8 + 2];
        int n10 = TRACK_ATTRIBS[n][n8 + 3];
        boolean bl = false;
        if (++n4 >= n9 + n10) {
            if (n6 == 0) {
                n4 = n9;
            } else if (n6 == 1) {
                n4 = n9 + Math.max(n10 - 1, 0);
            }
            nArray[5] = nArray[5] + 1;
            bl = true;
        }
        nArray[1] = n4;
        return bl;
    }

    static void setAnimTrack(int[] nArray, int n, int n2) {
        int n3;
        int n4 = Reanim.getTrackAttribsIndexFromTrackID(n, n2);
        int n5 = Reanim.getTrackGlobalIndex(n, n4);
        nArray[1] = n3 = TRACK_ATTRIBS[n][n4 * 5 + 2];
        nArray[2] = n5;
    }

    static int hideTrack(int n, int n2, int n3, int n4) {
        int n5 = Reanim.getTrackAttribsIndexFromTrackID(n, n3);
        int n6 = Reanim.getTrackGlobalIndex(n, n5);
        int n7 = Math.abs(n2 - n6);
        return n4 |= 1 << n7;
    }

    static int showTrack(int n, int n2, int n3, int n4) {
        int n5 = Reanim.getTrackAttribsIndexFromTrackID(n, n3);
        int n6 = Reanim.getTrackGlobalIndex(n, n5);
        int n7 = Math.abs(n2 - n6);
        return n4 &= ~(1 << n7);
    }

    static boolean isTrackHidden(int n, int n2, int n3) {
        if (n3 == 0) {
            return false;
        }
        int n4 = Util.findNextSetBit(n3, 0);
        while (n4 != -1) {
            if (n2 + n4 == n) {
                return true;
            }
            n4 = Util.findNextSetBit(n3, n4 + 1);
        }
        return false;
    }

    static boolean getTrackDrawPos(int n, int n2, int n3, boolean bl) {
        m_nTrackPosX = 0;
        m_nTrackPosY = 0;
        int n4 = Reanim.getTrackGlobalIndexFromTrackID(n, n2);
        int n5 = n3 * 9;
        int n6 = Reanim.nReanims[n].nTracks[n4].nTrackFrames[n3].TRACK_IMG;
        if (n6 >= 0) {
            m_nTrackPosX = FP.toInt(Reanim.nReanims[n].nTracks[n4].nTrackFrames[n3].TRACK_FP_X);
            m_nTrackPosY = FP.toInt(Reanim.nReanims[n].nTracks[n4].nTrackFrames[n3].TRACK_FP_Y);
            if (bl) {
                m_nTrackPosX = -m_nTrackPosX;
            }
            return true;
        }
        return false;
    }

    static int getTrackImgID(int n, int n2, int n3) {
        int n4 = Reanim.getTrackGlobalIndexFromTrackID(n, n2);
        return Reanim.nReanims[n].nTracks[n4].nTrackFrames[n3].TRACK_IMG;
    }

    static int getTrackStartFrame(int n, int n2) {
        int n3 = Reanim.getTrackAttribsIndex(n, n2);
        int n4 = n3 * 5;
        int n5 = TRACK_ATTRIBS[n][n4 + 2];
        return n5;
    }

    static int getTrackFrameCount(int n, int n2) {
        int n3 = Reanim.getTrackAttribsIndex(n, n2);
        int n4 = n3 * 5;
        return TRACK_ATTRIBS[n][n4 + 3];
    }

    static int getReanimImgCount(int n) {
        return Reanim.getReanimImgCount(n, true, -1, -1);
    }

    static int getReanimImgCount(int n, boolean bl, int n2, int n3) {
        int n4 = 0;
        if (n != -1) {
            int n5 = n * 3;
            int n6 = REANIM_DATA[n5 + 2];
            for (int i = 0; i < n6; ++i) {
                int n7 = i * 5;
                int n8 = TRACK_ATTRIBS[n][n7 + 4];
                if (n8 != 0) continue;
                if (!bl) {
                    int n9 = Reanim.getTrackGlobalIndex(n, i);
                    if (Reanim.isTrackHidden(n9, n2, n3)) continue;
                    ++n4;
                    continue;
                }
                ++n4;
            }
        }
        return n4;
    }

    static void getReanimFrameDims(int n, int n2, int n3, int n4) {
        int n5 = n * 3;
        int n6 = REANIM_DATA[n5 + 2];
        int n7 = 1000;
        int n8 = -1000;
        int n9 = 1000;
        int n10 = -1000;
        m_nReanimFrameH = 0;
        m_nReanimFrameW = 0;
        for (int i = 0; i < n6; ++i) {
            int n11 = i * 5;
            int n12 = TRACK_ATTRIBS[n][n11 + 4];
            if (n12 != 0) continue;
            int n13 = TRACK_ATTRIBS[n][n11 + 0];
            if (n4 != -1 && n3 != -1 && Reanim.isTrackHidden(n13, n3, n4)) continue;
            int n14 = n2 * 9;
            int n15 = Reanim.nReanims[n].nTracks[n13].nTrackFrames[n2].TRACK_IMG;
            if (n15 < 0) continue;
            int n16 = FP.toInt(Reanim.nReanims[n].nTracks[n13].nTrackFrames[n2].TRACK_FP_X);
            int n17 = FP.toInt(Reanim.nReanims[n].nTracks[n13].nTrackFrames[n2].TRACK_FP_Y);
            n7 = Math.min(n16, n7);
            n8 = Math.max(n16 + GFCanvas.getImageWidth(TRACK_IMGS[n15]), n8);
            n9 = Math.min(n17, n9);
            n10 = Math.max(n17 + GFCanvas.getImageHeight(TRACK_IMGS[n15]), n10);
        }
        m_nReanimFrameX = n7;
        m_nReanimFrameY = n9;
        m_nReanimFrameW = Math.abs(n8 - n7);
        m_nReanimFrameH = Math.abs(n10 - n9);
    }

    static {
        DEFAULT_REANIM_VAL = -4091904;
        REANIMS_REQUIRED_FOR_LEVEL = new boolean[51];
        REANIMS_IMG_SETS_REQUIRED_FOR_LEVEL = new long[51];
        STEP_LOAD_TRACKS_COUNT = 0;
        STEP_LOAD_REANIM_OFFSET = STEP_LOAD_TRACKS_COUNT + 1;
        STEP_LOAD_TRACK_ATTRIB_INDEX = STEP_LOAD_REANIM_OFFSET + 1;
        STEP_LOAD_TRACK_GLOBAL_INDEX = STEP_LOAD_TRACK_ATTRIB_INDEX + 1;
        STEP_LOAD_DATA_POS = STEP_LOAD_TRACK_GLOBAL_INDEX + 1;
        STEP_LOAD_DATA_NUM_BYTES = STEP_LOAD_DATA_POS + 1;
        STEP_LOAD_NUM_TRACKS = STEP_LOAD_DATA_NUM_BYTES + 1;
        STEP_LOAD_CURR_TRACK_INDEX = STEP_LOAD_NUM_TRACKS + 1;
        STEP_LOAD_FPS = STEP_LOAD_CURR_TRACK_INDEX + 1;
        STEP_LOAD_NUM_FRAMES = STEP_LOAD_FPS + 1;
        STEP_LOAD_CURRENT_FRAME = STEP_LOAD_NUM_FRAMES + 1;
        STEP_LOAD_FRAME_START = STEP_LOAD_CURRENT_FRAME + 1;
        STEP_LOAD_FRAME_COUNT = STEP_LOAD_FRAME_START + 1;
        STEP_LOAD_TRACK_TYPE = STEP_LOAD_FRAME_COUNT + 1;
        STEP_LOAD_PREV_X = STEP_LOAD_TRACK_TYPE + 1;
        STEP_LOAD_PREV_Y = STEP_LOAD_PREV_X + 1;
        STEP_LOAD_PREV_SX = STEP_LOAD_PREV_Y + 1;
        STEP_LOAD_PREV_SY = STEP_LOAD_PREV_SX + 1;
        STEP_LOAD_PREV_KX = STEP_LOAD_PREV_SY + 1;
        STEP_LOAD_PREV_KY = STEP_LOAD_PREV_KX + 1;
        STEP_LOAD_PREV_IMG = STEP_LOAD_PREV_KY + 1;
        STEP_LOAD_IMG_ID = STEP_LOAD_PREV_IMG + 1;
        STEP_LOAD_BASE_IMG_ID = STEP_LOAD_IMG_ID + 1;
        STEP_LOAD_MAX_VALS = STEP_LOAD_BASE_IMG_ID + 1;
        REANIM_STEP_LOADER = new int[STEP_LOAD_MAX_VALS];
        CALCULATIONS = new int[2];
    }
}

