/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

public class SeedBank
implements GameConstants,
Constants {
    static int m_nSeeds;
    static int m_nCurrMaxSeeds;
    static int m_nSelectedSeedTypeToPlant;
    static int m_nSelectedSeedIndexToPlant;
    static int SEED_TYPE;
    static int SEED_BANK_POS;
    static int SEED_BANK_ROW;
    static int SEED_RECHARGE_COUNTDOWN;
    static int SEED_FP_X;
    static int SEED_FP_Y;
    static int SEED_FP_VX;
    static int SEED_FP_VY;
    static int SEED_FP_DEST_X;
    static int SEED_FP_DEST_Y;
    static int SEED_ZONE_ID;
    static int SEED_FLAGS;
    static int SEED_MAX_VALS;
    static final int[] SEEDS;
    static int m_nSeedTempPosX;
    static int m_nSeedTempPosY;
    static Image[] SEED_IMGS_SML;
    static int[] SEED_SCALED_REANIM_IMG_INDEXES;
    static boolean[] SEED_SCALED_REQUIRED_REANIM_IDS;

    static void init() {
        Util.resetArray(SEEDS, -1);
        m_nSeeds = 0;
        m_nCurrMaxSeeds = 6;
        Util.resetArray(SEED_SCALED_REANIM_IMG_INDEXES, -1);
    }

    static void createScaledSeedImages() {
        int n = FP.fpDiv(327680, 409600);
        if (SeedPicker.getNumOfUnlockedSeeds() > m_nCurrMaxSeeds && SeedPicker.m_nSeeds > 0) {
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < 7 && n2 < SeedPicker.m_nSeeds; ++i) {
                int n4;
                short s;
                if (!SeedPicker.isSeedAtIndex(i) || (s = (short)"\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(n4 = SeedPicker.SEED_PICKER_SELECTION[(n3 = i * SeedPicker.SEED_PICKER_MAX_VALS) + SeedPicker.SEED_PICKER_SEED_TYPE])) < 0 || SEED_IMGS_SML[n4] != null) continue;
                SeedBank.SEED_IMGS_SML[n4] = Reanim.scaleImage(s, n, n);
                SeedBank.SEED_IMGS_SML[n4] = Reanim.sharpen(SEED_IMGS_SML[n4], false);
            }
        } else {
            for (int i = 0; i < SeedPicker.UNLOCKED_SEED_TYPES.length && SeedPicker.UNLOCKED_SEED_TYPES[i] != -1; ++i) {
                int n5 = SeedPicker.UNLOCKED_SEED_TYPES[i];
                short s = (short)"\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(n5);
                if (s < 0 || SEED_IMGS_SML[n5] != null) continue;
                SeedBank.SEED_IMGS_SML[n5] = Reanim.scaleImage(s, n, n);
                SeedBank.SEED_IMGS_SML[n5] = Reanim.sharpen(SEED_IMGS_SML[n5], false);
            }
        }
    }

    static void resetVarsNewLevel() {
        Util.resetArray(SEEDS, -1);
        if (GameController.m_nLevel >= 31) {
            m_nCurrMaxSeeds = 7;
        }
        m_nSeeds = 0;
        m_nSelectedSeedTypeToPlant = -1;
    }

    static int addSeed(int n, int n2) {
        if (n >= 0) {
            int n3 = 0;
            for (int i = 0; i < 7; ++i) {
                if (SeedBank.isSeedAtIndex(i)) continue;
                n3 = SEED_MAX_VALS * i;
                SeedBank.SEEDS[n3 + SeedBank.SEED_TYPE] = n;
                SeedBank.SEEDS[n3 + SeedBank.SEED_BANK_POS] = n2;
                SeedBank.setSeedRow(i, n2);
                SeedBank.SEEDS[n3 + SeedBank.SEED_FP_X] = SeedBank.getStartSeedBankPosFPX(n2, SEEDS[n3 + SEED_BANK_ROW]);
                SeedBank.SEEDS[n3 + SeedBank.SEED_FP_Y] = SeedBank.getStartSeedBankPosFPY(n2, SEEDS[n3 + SEED_BANK_ROW]);
                SeedBank.SEEDS[n3 + SeedBank.SEED_FLAGS] = 0;
                SeedBank.SEEDS[n3 + SeedBank.SEED_ZONE_ID] = TouchGameController.createNewSeedZone(FP.toInt(SEEDS[n3 + SEED_FP_X]), FP.toInt(SEEDS[n3 + SEED_FP_Y]), n);
                SeedBank.SEEDS[n3 + SeedBank.SEED_RECHARGE_COUNTDOWN] = (short)"\u0001\u0001\u0001\u0001\uffff\u0001\u0001\uffff\uffff\u0001\u0001\uffff\uffff\u0001\u0001\uffff\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\uffff\uffff\uffff\uffff\uffff".charAt(n) == 1 || GModel.m_bConveyorLevel ? 0 : (int)((short)"\u00a2\u029a\u00a2\u00a2\u029a\u00a2\u00a2\u0402\u029a\u00a2\u00a2\u029a\u0402\u00a2\u00a2\u0402\u00a2\u00a2\u00a2\u00a2\u00a2\u00a2\u00a2\u00a2\u00a2\u00a2\u0402\u029a\u0402\u00a2\u00a2".charAt(n));
                ++m_nSeeds;
                return i;
            }
        }
        return -1;
    }

    static int addSeedConveyorLevel(int n, int n2, int n3) {
        if (m_nSeeds >= n3) {
            return -1;
        }
        if (n >= 0) {
            int n4 = 0;
            for (int i = 0; i < 7; ++i) {
                if (SeedBank.isSeedAtIndex(i)) continue;
                n4 = SEED_MAX_VALS * i;
                SeedBank.SEEDS[n4 + SeedBank.SEED_TYPE] = n;
                SeedBank.SEEDS[n4 + SeedBank.SEED_BANK_POS] = m_nSeeds++;
                SeedBank.SEEDS[n4 + SeedBank.SEED_FP_X] = SeedBank.getStartSeedBankConveyorPosFPX(n2);
                SeedBank.SEEDS[n4 + SeedBank.SEED_FP_Y] = SeedBank.getStartSeedBankConveyorPosFPY(n2);
                SeedBank.SEEDS[n4 + SeedBank.SEED_FLAGS] = 8;
                SeedBank.SEEDS[n4 + SeedBank.SEED_RECHARGE_COUNTDOWN] = 0;
                SeedBank.SEEDS[n4 + SeedBank.SEED_ZONE_ID] = TouchGameController.createNewSeedZone(FP.toInt(SEEDS[n4 + SEED_FP_X]), FP.toInt(SEEDS[n4 + SEED_FP_Y]), n);
                return i;
            }
        }
        return -1;
    }

    static boolean isSeedAtIndex(int n) {
        return SEEDS[SEED_MAX_VALS * n + SEED_TYPE] != -1;
    }

    static void selectSeed(int n) {
        if (n >= 0 && n < m_nSeeds) {
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < 7 && n3 < m_nSeeds; ++i) {
                if (!SeedBank.isSeedAtIndex(i)) continue;
                n2 = SEEDS[i * SEED_MAX_VALS + SEED_BANK_POS];
                if (n2 == n) {
                    m_nSelectedSeedTypeToPlant = SEEDS[i * SEED_MAX_VALS + SEED_TYPE];
                    m_nSelectedSeedIndexToPlant = i;
                    return;
                }
                ++n3;
            }
        }
    }

    static void setSeedRow(int n, int n2) {
        int n3 = n * SEED_MAX_VALS;
        if (Layer.isPortrait(2)) {
            int n4 = SeedPicker.m_nSeedPickerOnScreenRows == 0 ? 3 : SeedPicker.m_nSeedPickerOnScreenRows;
            SeedBank.SEEDS[n3 + SeedBank.SEED_BANK_ROW] = n2 / n4;
        } else {
            SeedBank.SEEDS[n3 + SeedBank.SEED_BANK_ROW] = 0;
        }
    }

    static int getStartSeedBankPosFPX(int n, int n2) {
        int n3 = SeedPicker.m_nSeedSelected;
        int n4 = GFCanvas.getImageWidth(SEED_IMGS_SML[n3]);
        int n5 = 0;
        if (Layer.isLandscape(2)) {
            n5 = 3;
        } else {
            int n6 = (Layer.getLayerProperty(2, 3) - 3 * n4) / 2;
            int n7 = n % 3;
            n5 = n6 + n7 * (n4 + 0);
        }
        return n5 * 4096;
    }

    static int getStartSeedBankPosFPY(int n, int n2) {
        int n3 = SeedPicker.m_nSeedSelected;
        int n4 = GFCanvas.getImageHeight(SEED_IMGS_SML[n3]);
        int n5 = 0;
        n5 = Layer.isLandscape(2) ? 34 + n * (n4 + 0) : 244 + n2 * (n4 + 0);
        return n5 * 4096;
    }

    static int getStartSeedBankConveyorPosFPX(int n) {
        int n2 = 0;
        if (Layer.isLandscape(2)) {
            n2 = 1 + Conveyor.m_imgConveyorLeft.getWidth();
        } else {
            int n3 = (Layer.getLayerProperty(2, 3) - Conveyor.m_imgConveyorTop.getWidth()) / 2;
            n2 = n3 + Conveyor.m_imgConveyorTop.getWidth() - Conveyor.m_imgConveyorLeft.getWidth();
        }
        return n2 * 4096;
    }

    static int getStartSeedBankConveyorPosFPY(int n) {
        int n2 = 0;
        n2 = Layer.isLandscape(2) ? 2 + Conveyor.m_imgConveyorTop.getHeight() + Conveyor.m_imgConveyorLeft.getHeight() : 244 + Conveyor.m_imgConveyorTop.getHeight();
        return n2 * 4096;
    }

    static boolean isFlagSet(int n, int n2) {
        return (SEEDS[n2 * SEED_MAX_VALS + SEED_FLAGS] & 1 << n) != 0;
    }

    static void setFlag(int n, int n2) {
        int n3 = n2 * SEED_MAX_VALS + SEED_FLAGS;
        SEEDS[n3] = SEEDS[n3] | 1 << n;
    }

    static void unSetFlag(int n, int n2) {
        int n3 = n2 * SEED_MAX_VALS + SEED_FLAGS;
        SEEDS[n3] = SEEDS[n3] & ~(1 << n);
    }

    static void update() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 7 && n < m_nSeeds; ++i) {
            if (!SeedBank.isSeedAtIndex(i)) continue;
            n2 = i * SEED_MAX_VALS;
            if (SEEDS[n2 + SEED_RECHARGE_COUNTDOWN] > 0) {
                int n3 = n2 + SEED_RECHARGE_COUNTDOWN;
                SEEDS[n3] = SEEDS[n3] - 1;
            }
            if (SeedBank.isFlagSet(1, i)) {
                SeedBank.updateSeedZoomToDest(i);
            }
            TouchGameController.updateSeedZone(i, false);
            ++n;
        }
    }

    static void plantSeed(int n, int n2) {
        short s = (short)"\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e".charAt(n2);
        Plants.addPlant(s, n);
        if (GModel.m_bConveyorLevel) {
            if (m_nSelectedSeedIndexToPlant != -1) {
                int n3 = SEEDS[m_nSelectedSeedIndexToPlant * SEED_MAX_VALS + SEED_BANK_POS];
                TouchGameController.updateSeedZone(m_nSelectedSeedIndexToPlant, true);
                SeedBank.killSeed(m_nSelectedSeedIndexToPlant);
                int n4 = 0;
                for (int i = m_nSelectedSeedIndexToPlant; i < 7 && n4 < m_nSeeds; ++i) {
                    int n5 = i * SEED_MAX_VALS;
                    int n6 = (i + 1) * SEED_MAX_VALS;
                    if (i + 1 >= 7 || !SeedBank.isSeedAtIndex(i + 1)) continue;
                    for (int j = SEED_TYPE; j < SEED_MAX_VALS; ++j) {
                        if (j != SEED_TYPE && j != SEED_RECHARGE_COUNTDOWN && j != SEED_ZONE_ID && j != SEED_FLAGS && j != SEED_FP_Y) continue;
                        SeedBank.SEEDS[n5 + j] = SEEDS[n6 + j];
                    }
                    SeedBank.SEEDS[(i + 1) * SeedBank.SEED_MAX_VALS + SeedBank.SEED_TYPE] = -1;
                    ++n4;
                }
            }
        } else {
            ScoreController.m_nSun -= (short)"\u0000\u00192d2\u00c8\u00af\u0096\u0019\u0096\u01452}d\u00af}dd\u012c}}\u0000\u0019KK\u0019KK}\u0019\u0019".charAt(n2);
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            for (int i = 0; i < 7 && n7 < m_nSeeds; ++i) {
                if (!SeedBank.isSeedAtIndex(i)) continue;
                n8 = i * SEED_MAX_VALS;
                n9 = SEEDS[n8 + SEED_TYPE];
                if (n9 == n2) {
                    SeedBank.SEEDS[n8 + SeedBank.SEED_RECHARGE_COUNTDOWN] = (short)"\u00a2\u029a\u00a2\u00a2\u029a\u00a2\u00a2\u0402\u029a\u00a2\u00a2\u029a\u0402\u00a2\u00a2\u0402\u00a2\u00a2\u00a2\u00a2\u00a2\u00a2\u00a2\u00a2\u00a2\u00a2\u0402\u029a\u0402\u00a2\u00a2".charAt(n9);
                    break;
                }
                ++n7;
            }
        }
        m_nSelectedSeedTypeToPlant = -1;
        m_nSelectedSeedIndexToPlant = -1;
        Hints.m_bSeedPlantedThisFrame = true;
    }

    static boolean bSeedRecharged(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < 7 && n2 < m_nSeeds; ++i) {
            if (!SeedBank.isSeedAtIndex(i)) continue;
            n3 = i * SEED_MAX_VALS;
            n5 = SEEDS[n3 + SEED_BANK_POS];
            if (n5 == n) {
                n4 = SEEDS[n3 + SEED_TYPE];
                short s = (short)"\u00a2\u029a\u00a2\u00a2\u029a\u00a2\u00a2\u0402\u029a\u00a2\u00a2\u029a\u0402\u00a2\u00a2\u0402\u00a2\u00a2\u00a2\u00a2\u00a2\u00a2\u00a2\u00a2\u00a2\u00a2\u0402\u029a\u0402\u00a2\u00a2".charAt(n4);
                int n6 = s - SEEDS[n3 + SEED_RECHARGE_COUNTDOWN];
                boolean bl = n6 >= s;
                return bl;
            }
            ++n2;
        }
        return false;
    }

    static int getSeedAttributeAtPos(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < 7 && n3 < m_nSeeds; ++i) {
            if (!SeedBank.isSeedAtIndex(i)) continue;
            n4 = i * SEED_MAX_VALS;
            if (SEEDS[n4 + SEED_BANK_POS] == n) {
                return SEEDS[n4 + n2];
            }
            ++n3;
        }
        return -1;
    }

    static int getSeedIndexFromType(int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < 7 && n2 < m_nSeeds; ++i) {
            if (!SeedBank.isSeedAtIndex(i)) continue;
            n3 = i * SEED_MAX_VALS;
            if (SEEDS[n3 + SEED_TYPE] == n) {
                return i;
            }
            ++n2;
        }
        return -1;
    }

    static void updatePositions(int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6;
        int n7;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (n7 = 0; n7 < 7 && n8 < m_nSeeds; ++n7) {
            if (!SeedBank.isSeedAtIndex(n7)) continue;
            n10 = SEEDS[n7 * SEED_MAX_VALS + SEED_BANK_POS];
            if (bl && n10 == n) {
                SeedBank.setFlag(2, n7);
                continue;
            }
            SeedBank.unSetFlag(2, n7);
        }
        if (GModel.m_bConveyorLevel) {
            return;
        }
        n7 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = SeedPicker.m_nSeedSelected;
        int n21 = GFCanvas.getImageHeight("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(n20));
        int n22 = GFCanvas.getImageHeight(SEED_IMGS_SML[n20]);
        int n23 = GFCanvas.getImageWidth("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(n20));
        int n24 = GFCanvas.getImageWidth(SEED_IMGS_SML[n20]);
        for (n6 = 0; n6 < 7 && n8 < m_nSeeds; ++n6) {
            if (!SeedBank.isSeedAtIndex(n6)) continue;
            n9 = n6 * SEED_MAX_VALS;
            n10 = SEEDS[n9 + SEED_BANK_POS];
            if (n10 == n) {
                n11 = SEEDS[n9 + SEED_BANK_ROW];
                n12 = n10 % 3;
                if (bl) {
                    n13 = Util.clampInt(SeedBank.getStartSeedBankPosFPY(n10, n11), n2 * 4096, (n3 - n21) * 4096);
                    n14 = Util.clampInt(SeedBank.getStartSeedBankPosFPX(n10, n11), n4 * 4096, (n5 - n23) * 4096);
                } else {
                    n13 = Util.clampInt(SeedBank.getStartSeedBankPosFPY(n10, n11), n2 * 4096, (n3 - n22) * 4096);
                    n14 = Util.clampInt(SeedBank.getStartSeedBankPosFPX(n10, n11), n4 * 4096, n5 * 4096);
                }
                n18 = SEEDS[n9 + SEED_FP_Y];
                n15 = n13 - SEEDS[n9 + SEED_FP_Y];
                if (Layer.isLandscape(2)) {
                    SeedBank.moveSeed(n6, 0, n15);
                    break;
                }
                n19 = SEEDS[n9 + SEED_FP_X];
                n16 = n14 - SEEDS[n9 + SEED_FP_X];
                if (bl) {
                    n16 -= (n23 - n24) * 4096 / 2;
                }
                SeedBank.moveSeed(n6, n16, n15);
                break;
            }
            ++n8;
        }
        n8 = 0;
        for (int i = 0; i < 7 && n8 < m_nSeeds; ++i) {
            if (!SeedBank.isSeedAtIndex(i)) continue;
            n9 = i * SEED_MAX_VALS;
            n10 = SEEDS[n9 + SEED_BANK_POS];
            if (n10 != n) {
                int n25 = SeedPicker.m_nSeedPickerOnScreenRows == 0 ? 3 : SeedPicker.m_nSeedPickerOnScreenRows;
                n7 = n10 % n25;
                n6 = Math.abs(n22 * (n10 - n)) * 4096;
                int n26 = Math.abs(n24 * (n12 - n7)) * 4096;
                if (Layer.isLandscape(2)) {
                    if (n10 > n) {
                        if (bl) {
                            n6 += (n21 - n22) * 4096;
                        }
                    } else {
                        n6 = -n6;
                    }
                } else {
                    n6 = Math.abs(n22 * (SEEDS[n9 + SEED_BANK_ROW] - n11)) * 4096;
                    if (n7 < n12) {
                        n26 = -n26;
                    } else if (bl && n7 > n12 && SEEDS[n9 + SEED_BANK_ROW] == n11) {
                        n26 += (n23 - n24) * 4096;
                    }
                    if (SEEDS[n9 + SEED_BANK_ROW] > n11) {
                        if (bl) {
                            n6 += (n21 - n22) * 4096;
                        }
                    } else {
                        n6 = -n6;
                    }
                }
                int n27 = n18 + n15 + n6 - SEEDS[n9 + SEED_FP_Y];
                int n28 = n19 + n16 + n26 + n17 - SEEDS[n9 + SEED_FP_X];
                if (Layer.isLandscape(2)) {
                    SeedBank.moveSeed(i, 0, n27);
                } else {
                    SeedBank.moveSeed(i, n28, n27);
                }
            }
            ++n8;
        }
    }

    static void moveAllSeeds(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        n2 *= 4096;
        n3 *= 4096;
        for (int i = 0; i < 7 && n4 < m_nSeeds; ++i) {
            if (!SeedBank.isSeedAtIndex(i)) continue;
            n6 = i * SEED_MAX_VALS;
            n5 = SEEDS[n6 + SEED_BANK_POS];
            if (n5 >= n) {
                SeedBank.moveSeed(i, n2, n3);
            }
            ++n4;
        }
    }

    static void moveSeed(int n, int n2, int n3) {
        if (n2 == 0 && n3 == 0) {
            return;
        }
        int n4 = Math.max(Math.abs(FP.fpDiv(n3, 20480)), 16384);
        int n5 = n * SEED_MAX_VALS;
        int n6 = SEEDS[n5 + SEED_FP_X];
        int n7 = SEEDS[n5 + SEED_FP_Y];
        int n8 = n6 + n2;
        int n9 = n7 + n3;
        int n10 = n8 - n6;
        int n11 = n9 - n7;
        SeedBank.SEEDS[n5 + SeedBank.SEED_FP_DEST_X] = n8;
        SeedBank.SEEDS[n5 + SeedBank.SEED_FP_DEST_Y] = n9;
        Vector.normalise(n10, n11);
        Vector.scale(Vector.vrx, Vector.vry, n4);
        SeedBank.SEEDS[n5 + SeedBank.SEED_FP_VX] = Vector.vrx;
        SeedBank.SEEDS[n5 + SeedBank.SEED_FP_VY] = Vector.vry;
        SeedBank.setFlag(1, n);
    }

    static void updateSeedZoomToDest(int n) {
        int n2 = SEED_MAX_VALS * n;
        int n3 = SEEDS[n2 + SEED_FP_X];
        int n4 = SEEDS[n2 + SEED_FP_Y];
        int n5 = SEEDS[n2 + SEED_FP_VX];
        int n6 = SEEDS[n2 + SEED_FP_VY];
        int n7 = SEEDS[n2 + SEED_FP_DEST_X];
        int n8 = SEEDS[n2 + SEED_FP_DEST_Y];
        int n9 = GModel.FP_80_PERCENT;
        if (n5 > 0) {
            n3 = Math.min(n3 + n5, n7);
            n5 = Math.max(FP.fpMul(n5, n9), 8192);
        } else {
            n3 = Math.max(n3 + n5, n7);
            n5 = Math.min(FP.fpMul(n5, n9), -8192);
        }
        if (n6 > 0) {
            n4 = Math.min(n4 + n6, n8);
            n6 = Math.max(FP.fpMul(n6, n9), 8192);
        } else {
            n4 = Math.max(n4 + n6, n8);
            n6 = Math.min(FP.fpMul(n6, n9), -8192);
        }
        SeedBank.SEEDS[n2 + SeedBank.SEED_FP_X] = n3;
        SeedBank.SEEDS[n2 + SeedBank.SEED_FP_Y] = n4;
        SeedBank.SEEDS[n2 + SeedBank.SEED_FP_VX] = n5;
        SeedBank.SEEDS[n2 + SeedBank.SEED_FP_VY] = n6;
        if (n3 == n7 && n4 == n8) {
            SeedBank.unSetFlag(1, n);
        }
    }

    static boolean getSeedCoords(int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < 7 && n2 < m_nSeeds; ++i) {
            if (!SeedBank.isSeedAtIndex(i)) continue;
            n3 = i * SEED_MAX_VALS;
            if (SEEDS[n3 + SEED_BANK_POS] == n) {
                m_nSeedTempPosX = FP.toInt(SEEDS[n3 + SEED_FP_X]);
                m_nSeedTempPosY = FP.toInt(SEEDS[n3 + SEED_FP_Y]);
                if (GModel.m_bConveyorLevel) {
                    m_nSeedTempPosY += i * 8;
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    static int countSeedTypes(int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < 7 && n2 < m_nSeeds; ++i) {
            if (!SeedBank.isSeedAtIndex(i)) continue;
            if (SEEDS[i * SEED_MAX_VALS + SEED_TYPE] == n) {
                ++n3;
            }
            ++n2;
        }
        return n3;
    }

    static void killSeed(int n) {
        SeedBank.SEEDS[n * SeedBank.SEED_MAX_VALS + SeedBank.SEED_TYPE] = -1;
        --m_nSeeds;
    }

    static void setSeedToHighlight(int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < 7 && n2 < m_nSeeds; ++i) {
            if (!SeedBank.isSeedAtIndex(i)) continue;
            n3 = SEEDS[i * SEED_MAX_VALS + SEED_BANK_POS];
            if (n == n3) {
                SeedBank.setFlag(2, i);
                continue;
            }
            SeedBank.unSetFlag(2, i);
        }
    }

    static void createAlphaFilteredPlantableReanims(int n) {
        int n2 = 2703;
        short s = (short)"\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e".charAt(n);
        short s2 = (short)"\u0013\u0014\u0015\"\u001b\"\"\u001d\u0017\u0016 \u0018$\u0019!\u001c\u001a\u001e\u001f#%&'()*+,-.0".charAt(s);
        if (s2 != -1) {
            int n3;
            int n4 = Reanim.getReanimIndexFromID(s2);
            short s3 = (short)"\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\u016a\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\u01be\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(s);
            if (s3 == -1) {
                s3 = (short)"\u0005\u001e\uffff\uffffNXku\uffff\u009c\u00a5\u00b4\u00bd\u00d3\uffff\u00f3\u011e\uffff\uffff\u0143\u0150\u0157\u0162\u016c\u0176\u017a\u017c\u0187\u018d\u0192\u0196\u019c\u01a6\u01ac\u01b1\u01b8\u01bb\u01c1\u01ce\u01d5\u01dc\u01e1\u01ee\u01f2\u01f7\u01fd\u0201\u0204\u0213\uffff\uffff".charAt(s2);
                if (s2 == -1 || s3 == -1) {
                    return;
                }
            }
            int n5 = Reanim.getTrackGlobalIndexFromTrackID(n4, s3);
            int n6 = Reanim.getTrackStartFrame(n4, n5);
            int n7 = Reanim.getStartTrackGlobalIndex(n4);
            int n8 = 0;
            if (s == 3) {
                n8 = Reanim.hideTrack(n4, n7, 439, n8);
                n8 = Reanim.hideTrack(n4, n7, 438, n8);
            } else if (s == 5) {
                n8 = Reanim.hideTrack(n4, n7, 437, n8);
                n8 = Reanim.hideTrack(n4, n7, 438, n8);
            } else if (s == 6) {
                n8 = Reanim.hideTrack(n4, n7, 439, n8);
                n8 = Reanim.hideTrack(n4, n7, 437, n8);
            } else if (s == 2) {
                n8 = Reanim.hideTrack(n4, n7, 348, n8);
                n8 = Reanim.hideTrack(n4, n7, 349, n8);
                n8 = Reanim.hideTrack(n4, n7, 350, n8);
            }
            SeedBank.SEED_SCALED_REANIM_IMG_INDEXES[n] = n3 = ReanimScaler.filterReanim(s2, s3, n8, n6, n2) - 1;
        }
    }

    static {
        SEED_TYPE = 0;
        SEED_BANK_POS = SEED_TYPE + 1;
        SEED_BANK_ROW = SEED_BANK_POS + 1;
        SEED_RECHARGE_COUNTDOWN = SEED_BANK_ROW + 1;
        SEED_FP_X = SEED_RECHARGE_COUNTDOWN + 1;
        SEED_FP_Y = SEED_FP_X + 1;
        SEED_FP_VX = SEED_FP_Y + 1;
        SEED_FP_VY = SEED_FP_VX + 1;
        SEED_FP_DEST_X = SEED_FP_VY + 1;
        SEED_FP_DEST_Y = SEED_FP_DEST_X + 1;
        SEED_ZONE_ID = SEED_FP_DEST_Y + 1;
        SEED_FLAGS = SEED_ZONE_ID + 1;
        SEED_MAX_VALS = SEED_FLAGS + 1;
        SEEDS = new int[7 * SEED_MAX_VALS];
        SEED_IMGS_SML = new Image[31];
        SEED_SCALED_REANIM_IMG_INDEXES = new int[31];
        SEED_SCALED_REQUIRED_REANIM_IDS = new boolean[31];
    }
}

