/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class SeedPicker
implements ConstantsTFC,
GameConstants,
Constants,
InputConstants,
ConstantsReanim {
    static final int[] ROOFTOP_SEED_OFF = new int[]{3, 5, 6, 10, 0, 1, 14, 8, 19, 20, 13, 29};
    static final int NIGHT_SEED_S = 21;
    static final int NIGHT_SEED_E = 28;
    public static int SUN_FLOWER_L = 10;
    public static int CACTUS_LEVEL_S = 32;
    public static int CACTUS_LEVEL_E = 38;
    public static int FLOWER_POT_S = 41;
    public static int[][] seedSBydefaultToBeAdded = new int[][]{{2}, {22}, {2, 29}, {22, 29, 20}, {2, 30}};
    static int SEED_PICKER_BANK_POS = 0;
    static int SEED_PICKER_LIBRARY_POS = SEED_PICKER_BANK_POS + 1;
    static int SEED_PICKER_SEED_TYPE = SEED_PICKER_LIBRARY_POS + 1;
    static int SEED_PICKER_FP_X = SEED_PICKER_SEED_TYPE + 1;
    static int SEED_PICKER_FP_Y = SEED_PICKER_FP_X + 1;
    static int SEED_PICKER_FP_VX = SEED_PICKER_FP_Y + 1;
    static int SEED_PICKER_FP_VY = SEED_PICKER_FP_VX + 1;
    static int SEED_PICKER_FP_DEST_X = SEED_PICKER_FP_VY + 1;
    static int SEED_PICKER_FP_DEST_Y = SEED_PICKER_FP_DEST_X + 1;
    static int SEED_PICKER_STATE = SEED_PICKER_FP_DEST_Y + 1;
    static int SEED_PICKER_MAX_VALS = SEED_PICKER_STATE + 1;
    static final int[] SEED_PICKER_SELECTION = new int[7 * SEED_PICKER_MAX_VALS];
    static int m_nSeeds;
    static int m_nSeedSelected;
    static boolean m_bStartZoomToDest;
    static boolean mRemoving;
    static int m_nSeedPickerGridType;
    static int m_nSeedPickerOnScreenRows;
    static int m_nSeedPickerRows;
    static int m_nSeedPickerCols;
    static int m_nSeedTempX;
    static int m_nSeedTempY;
    static long m_lSeedsSelected;
    static int m_nTooltipX;
    static int m_nTooltipY;
    static int m_nTooltipExpandPercent;
    static boolean m_bToolTipAboveSeed;
    static boolean m_bPlantReanimsLoadedForLevel;
    static int MAX_SEEDBANK_COLS;
    static int m_nfpLibraryOffsetY;
    static int m_nfpLibraryTotalOffsetY;
    static int m_nfpLibraryVY;
    static boolean scrollEnabled;
    static int prevRow;
    static int rowMovement;
    static boolean renderTopScrollArrow;
    static boolean renderBottomScrollArrow;
    static int scrollArrowUPTop;
    static int scrollArrowBottomTop;
    static boolean m_bIsSeedPickerInitialized;
    static int m_nSeedPickerLibraryX;
    static int m_nSeedPickerLibraryY;
    static int m_nSeedPickerLibraryW;
    static int m_nSeedPickerLibraryH;
    static int m_nfpSeedPickerLibraryVX;
    static int m_nfpSeedPickerLibraryDecel;
    static int m_nSeedPickerLibraryTotalX;
    static boolean m_bSeedPickerLibraryMovingOffScreen;
    static int[] SEED_LIBRARY_DIMS;
    static int SEED_LIBRARY_X;
    static int SEED_LIBRARY_Y;
    static int SEED_LIBRARY_W;
    static int SEED_LIBRARY_H;
    static int m_nSeedPickerBankX;
    static int m_nSeedPickerBankY;
    static int m_nSeedPickerBankW;
    static int m_nSeedPickerBankH;
    static int m_nfpSeedPickerBankVX;
    static int m_nfpSeedPickerBankDecel;
    static int m_nSeedPickerBankTotalX;
    static boolean m_bSeedPickerBankMovingOffScreen;
    static int m_nSeedLibraryDrawOffsetY;
    static int m_nSeedLibraryTotalDrawOffsetY;
    static int m_nfpSeedLibraryDrawVY;
    static int[] UNLOCKED_SEED_TYPES;
    static int m_nUnlockedSeedsCount;
    static int m_nSeedPickerBankXOffset;
    static int m_nSeedPickerBankYOffset;
    static int m_nMaxItems;
    static int m_nArrowFrame;

    public static boolean isDaySeedOff(int n) {
        if (GameController.m_nLevel < 40 && (GameController.m_nLevel < 20 || GameController.m_nLevel >= 30)) {
            return false;
        }
        return n >= 21 && n <= 28;
    }

    public static boolean isRooftopSeedOff(int n) {
        if (GameController.m_nLevel < 40) {
            return false;
        }
        if (SeedPicker.isDaySeedOff(n)) {
            return true;
        }
        for (int i = 0; i < ROOFTOP_SEED_OFF.length; ++i) {
            if (ROOFTOP_SEED_OFF[i] != n) continue;
            return true;
        }
        return false;
    }

    static void init() {
        if (!m_bIsSeedPickerInitialized) {
            Util.resetArray(UNLOCKED_SEED_TYPES, -1);
            SeedPicker.unlockSeed(3);
            m_nUnlockedSeedsCount = 1;
            m_bIsSeedPickerInitialized = true;
        }
    }

    static void resetVarsNewLevel() {
        m_bPlantReanimsLoadedForLevel = false;
    }

    static void resetVars() {
        m_nSeeds = 0;
        Util.resetArray(SEED_PICKER_SELECTION, -1);
        m_nSeedPickerGridType = 1;
        m_lSeedsSelected = 0L;
        m_nTooltipX = 0;
        m_nTooltipY = 0;
        m_nfpLibraryOffsetY = 0;
        m_nfpLibraryTotalOffsetY = 0;
        m_nfpLibraryVY = 0;
        scrollEnabled = false;
        prevRow = 0;
        rowMovement = 0;
        renderTopScrollArrow = false;
        renderBottomScrollArrow = false;
        scrollArrowUPTop = 0;
        scrollArrowBottomTop = 0;
        TouchGameController.m_bSeedsSelected = false;
        SeedPicker.resetVarsNewLevel();
    }

    static void initSeedPicker(int n) {
        SeedPicker.resetVars();
        GFUIState.UI_MENU_CURRENT_SELECTION[n] = 0;
        m_nMaxItems = SeedPicker.getNumOfUnlockedSeeds();
        int n2 = GFCanvas.getImageWidth("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(3));
        m_nSeedPickerLibraryW = 3 * n2 + 22 + 14;
        int n3 = GFCanvas.getImageHeight(374) + 16;
        int n4 = GFCanvas.getImageHeight(191) + 16;
        int n5 = GFCanvas.getImageHeight("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(3)) + 7;
        int n6 = Layer.getLayerProperty(2, 4);
        m_nSeedPickerOnScreenRows = (n6 - (n3 + n4)) / n5;
        m_nSeedPickerLibraryH = m_nSeedPickerOnScreenRows * n5 + (n3 + n4);
        m_nSeedPickerLibraryX = 60;
        m_nSeedPickerLibraryY = n6 - m_nSeedPickerLibraryH >> 1;
        m_nSeedPickerBankW = GFCanvas.getImageWidth("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(3)) + 7;
        m_nSeedPickerBankH = Layer.getLayerProperty(2, 4);
        m_nSeedPickerBankX = 0;
        m_nSeedPickerBankY = 0;
        m_nSeedPickerBankXOffset = 0;
        m_nSeedPickerBankYOffset = 0;
        SeedPicker.setSeedPickerRowsAndCols(m_nSeedPickerLibraryW, m_nSeedPickerLibraryH, -1, -1, m_nMaxItems);
        SeedPicker.createTooltipTextWindow(GFUIState.UI_MENU_CURRENT_SELECTION[n], UNLOCKED_SEED_TYPES[GFUIState.UI_MENU_CURRENT_SELECTION[n]], m_nSeedPickerGridType);
        int n7 = GFCanvas.getImageWidth("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(3));
        MAX_SEEDBANK_COLS = 3;
        if (n == 12) {
            SeedPicker.setWindowPanPos(false);
        } else {
            SeedPicker.setWindowPanPos(true);
        }
        m_nSeedLibraryDrawOffsetY = 0;
        m_nfpSeedLibraryDrawVY = 0;
        int n8 = GFCanvas.getImageHeight(365);
        SeedPicker.getSeedPos(0, 1, false, true);
        scrollArrowUPTop = m_nSeedPickerLibraryY + n3 - 16 - n8 - 2;
        scrollArrowBottomTop = m_nSeedPickerLibraryY + m_nSeedPickerLibraryH - n8 - 6;
        TouchGameController.setSeedPickerZones(m_nMaxItems);
        m_bStartZoomToDest = false;
        int n9 = GameController.m_nLevel / 10;
        int n10 = 0;
        for (int i = 0; i < m_nMaxItems && n10 < seedSBydefaultToBeAdded[n9].length; ++i) {
            if (GameController.m_nLevel < 11) {
                if (UNLOCKED_SEED_TYPES[i] != 2) continue;
                SeedPicker.addSeed(2, i, 0);
                ++n10;
                continue;
            }
            if (GameController.m_nLevel < 20) {
                if (UNLOCKED_SEED_TYPES[i] != 22) continue;
                SeedPicker.addSeed(22, i, 0);
                ++n10;
                continue;
            }
            if (GameController.m_nLevel < 30) {
                if (UNLOCKED_SEED_TYPES[i] == 2) {
                    SeedPicker.addSeed(2, i, 0);
                    ++n10;
                    continue;
                }
                if (UNLOCKED_SEED_TYPES[i] != 29) continue;
                SeedPicker.addSeed(29, i, 0);
                ++n10;
                continue;
            }
            if (GameController.m_nLevel < 40) {
                if (UNLOCKED_SEED_TYPES[i] == 22) {
                    SeedPicker.addSeed(22, i, 0);
                    ++n10;
                } else if (UNLOCKED_SEED_TYPES[i] == 29) {
                    SeedPicker.addSeed(29, i, 0);
                    ++n10;
                }
                if (GameController.m_nLevel >= CACTUS_LEVEL_S && GameController.m_nLevel <= CACTUS_LEVEL_E) {
                    if (UNLOCKED_SEED_TYPES[i] != 20) continue;
                    SeedPicker.addSeed(20, i, 0);
                    ++n10;
                    continue;
                }
                if (n10 != seedSBydefaultToBeAdded[n9].length - 1) continue;
                break;
            }
            if (UNLOCKED_SEED_TYPES[i] == 2) {
                SeedPicker.addSeed(2, i, 0);
                ++n10;
            }
            if (GameController.m_nLevel >= FLOWER_POT_S) {
                if (UNLOCKED_SEED_TYPES[i] != 30) continue;
                SeedPicker.addSeed(30, i, 0);
                ++n10;
                continue;
            }
            if (n10 == seedSBydefaultToBeAdded[n9].length - 1) break;
        }
        m_bStartZoomToDest = true;
    }

    public static void handleInput(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (m_nSeedPickerGridType != 1 && m_nSeedPickerGridType != 0) {
            return;
        }
        if (m_nfpSeedPickerLibraryVX != 0) {
            return;
        }
        int n8 = GFUIState.UI_MENU_CURRENT_SELECTION[n];
        if (n2 == 65536 && m_nSeedPickerGridType != 0 && n == 11 && (SeedPicker.isRooftopSeedOff(UNLOCKED_SEED_TYPES[n8]) || SeedPicker.isDaySeedOff(UNLOCKED_SEED_TYPES[n8]))) {
            return;
        }
        boolean bl = true;
        if (m_nSeedPickerGridType == 1) {
            int n9;
            int n10;
            n7 = m_nSeedPickerCols;
            n6 = m_nSeedPickerRows;
            n5 = n8 / n7;
            n4 = n8 % n7;
            n3 = n5--;
            if (n2 == 8192) {
                if (++n4 > n7 - 1) {
                    n4 = 0;
                }
            } else if (n2 == 4096) {
                if (--n4 < 0) {
                    if (m_nSeeds > 0) {
                        SeedPicker.switchGridType(0, 0, n);
                        bl = false;
                    } else {
                        n4 = n7 - 1;
                    }
                }
            } else if (n2 == 16384) {
                if (n5 < 0) {
                    n5 = n6 - 1;
                }
            } else if (n2 == 32768) {
                if (++n5 > n6 - 1) {
                    n4 = 0;
                    n5 = 0;
                }
            } else if (n2 == 65536) {
                if (m_nSeeds < SeedBank.m_nCurrMaxSeeds) {
                    n10 = SeedPicker.addSeed(UNLOCKED_SEED_TYPES[n8], n8, n) ? 1 : 0;
                    if (n10 != 0) {
                        if (++n4 > n7 - 1) {
                            n4 = 0;
                            if (n3 == (n5 = Math.min(n5 + 1, n6 - 1))) {
                                n4 = n7 - 1;
                            }
                        }
                    } else {
                        n9 = SeedPicker.getSeedBankPosFromLibPos(n8);
                        SeedPicker.deSelectSeed(n9);
                    }
                } else if ((m_lSeedsSelected & 1L << n8) != 0L) {
                    n10 = SeedPicker.getSeedBankPosFromLibPos(n8);
                    SeedPicker.deSelectSeed(n10);
                }
            }
            if (bl) {
                GFUIState.UI_MENU_CURRENT_SELECTION[n] = Math.min(n5 * n7 + n4, m_nMaxItems - 1);
                SeedPicker.setSeedLibraryDrawPos(GFUIState.UI_MENU_CURRENT_SELECTION[n], n2);
            }
            if (scrollEnabled && n3 != n5) {
                n10 = GFCanvas.getImageHeight("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(3));
                n9 = n10 + 7;
                if (n5 - prevRow >= m_nSeedPickerOnScreenRows) {
                    rowMovement = -((n5 - m_nSeedPickerOnScreenRows + 1) * n9);
                    ++prevRow;
                    renderTopScrollArrow = true;
                } else if (n5 - prevRow < 0) {
                    rowMovement = -(n5 * n9);
                    --prevRow;
                    renderBottomScrollArrow = true;
                }
            }
            if (n5 == 0) {
                prevRow = n5;
                renderTopScrollArrow = false;
            } else if (n5 == m_nSeedPickerRows - 1) {
                prevRow = n5 - m_nSeedPickerOnScreenRows + 1;
                renderBottomScrollArrow = false;
            }
        } else {
            if (n2 == 8192) {
                SeedPicker.switchGridType(1, GFUIState.UI_MENU_LAST_HIGHLIGHTED_ITEM[n], n);
                bl = false;
            } else if (n2 != 4096) {
                if (n2 == 16384) {
                    if (--n8 < 0) {
                        n8 = m_nSeeds - 1;
                    }
                } else if (n2 == 32768) {
                    if (++n8 > m_nSeeds - 1) {
                        n8 = 0;
                    }
                } else if (n2 == 65536) {
                    SeedPicker.deSelectSeed(n8);
                    n7 = SeedPicker.getRemainingSeeds();
                    if (n7 <= 0) {
                        SeedPicker.switchGridType(1, GFUIState.UI_MENU_LAST_HIGHLIGHTED_ITEM[n], n);
                        bl = false;
                    } else if (n7 <= n8) {
                        int n11 = n;
                        GFUIState.UI_MENU_CURRENT_SELECTION[n11] = GFUIState.UI_MENU_CURRENT_SELECTION[n11] - 1;
                        bl = false;
                    }
                }
            }
            if (bl) {
                GFUIState.UI_MENU_CURRENT_SELECTION[n] = n8;
            }
        }
        if (m_nSeedPickerGridType == 1) {
            SeedPicker.createTooltipTextWindow(GFUIState.UI_MENU_CURRENT_SELECTION[n], UNLOCKED_SEED_TYPES[GFUIState.UI_MENU_CURRENT_SELECTION[n]], m_nSeedPickerGridType);
        } else {
            n5 = 0;
            n4 = 0;
            for (n3 = 0; n3 < 7 && n5 < m_nSeeds; ++n3) {
                if (!SeedPicker.isSeedAtIndex(n3)) continue;
                n7 = n3 * SEED_PICKER_MAX_VALS;
                n6 = SEED_PICKER_SELECTION[n7 + SEED_PICKER_BANK_POS];
                if (n6 == GFUIState.UI_MENU_CURRENT_SELECTION[n]) {
                    n4 = SEED_PICKER_SELECTION[n7 + SEED_PICKER_SEED_TYPE];
                    break;
                }
                ++n5;
            }
            SeedPicker.createTooltipTextWindow(GFUIState.UI_MENU_CURRENT_SELECTION[n], n4, m_nSeedPickerGridType);
        }
    }

    static void switchGridType(int n, int n2, int n3) {
        m_nSeedPickerGridType = n;
        GFUIState.UI_MENU_LAST_HIGHLIGHTED_ITEM[n3] = GFUIState.UI_MENU_CURRENT_SELECTION[n3];
        GFUIState.UI_MENU_CURRENT_SELECTION[n3] = n2;
    }

    static void setSeedPickerRowsAndCols(int n, int n2, int n3, int n4, int n5) {
        m_nSeedPickerCols = 3;
        m_nSeedPickerRows = m_nMaxItems / m_nSeedPickerCols;
        scrollEnabled = (m_nSeedPickerRows += m_nMaxItems % m_nSeedPickerCols == 0 ? 0 : 1) > m_nSeedPickerOnScreenRows + 1;
        renderBottomScrollArrow = scrollEnabled;
    }

    static int getRemainingSeeds() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 7 && n2 < m_nSeeds; ++i) {
            if (!SeedPicker.isSeedAtIndex(i)) continue;
            ++n2;
            int n3 = i * SEED_PICKER_MAX_VALS;
            int n4 = SEED_PICKER_SELECTION[n3 + SEED_PICKER_STATE];
            int n5 = SEED_PICKER_SELECTION[n3 + SEED_PICKER_SEED_TYPE];
            if (n5 == -1 || n4 != 0 && n4 != 1) continue;
            ++n;
        }
        return n;
    }

    static boolean addSeed(int n, int n2, int n3) {
        if ((m_lSeedsSelected & 1L << n2) != 0L) {
            return false;
        }
        int n4 = 0;
        for (int i = 0; i < 7; ++i) {
            if (SeedPicker.isSeedAtIndex(i)) continue;
            int n5 = i * SEED_PICKER_MAX_VALS;
            SeedPicker.SEED_PICKER_SELECTION[n5 + SeedPicker.SEED_PICKER_LIBRARY_POS] = n2;
            SeedPicker.SEED_PICKER_SELECTION[n5 + SeedPicker.SEED_PICKER_BANK_POS] = n4 = SeedPicker.getRemainingSeeds();
            SeedPicker.SEED_PICKER_SELECTION[n5 + SeedPicker.SEED_PICKER_SEED_TYPE] = n;
            SeedPicker.startZoomToDest(i, n2, SEED_PICKER_SELECTION[n5 + SEED_PICKER_BANK_POS], 1, 0, 22);
            m_lSeedsSelected |= 1L << n2;
            ++m_nSeeds;
            break;
        }
        if (n4 >= MAX_SEEDBANK_COLS && n4 % MAX_SEEDBANK_COLS == 0) {
            m_nfpLibraryOffsetY = 0;
            m_nfpLibraryVY = 45056;
            m_nfpLibraryTotalOffsetY = GFCanvas.getImageHeight("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(3)) * 4096;
        }
        return true;
    }

    static void addSeedConveyorLevel(int n) {
        for (int i = 0; i < 7; ++i) {
            if (SeedPicker.isSeedAtIndex(i)) continue;
            int n2 = i * SEED_PICKER_MAX_VALS;
            SeedPicker.SEED_PICKER_SELECTION[n2 + SeedPicker.SEED_PICKER_SEED_TYPE] = n;
            ++m_nSeeds;
            break;
        }
    }

    static void deSelectSeed(int n) {
        if (n < 0) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < 7 && n3 < m_nSeeds; ++i) {
            if (!SeedPicker.isSeedAtIndex(i)) continue;
            int n4 = i * SEED_PICKER_MAX_VALS;
            n2 = SEED_PICKER_SELECTION[n4 + SEED_PICKER_BANK_POS];
            if (n2 == n) {
                SeedPicker.removeSeed(i, n2);
                break;
            }
            ++n3;
        }
    }

    static void removeSeed(int n, int n2) {
        mRemoving = true;
        if (m_nSeeds - 1 == MAX_SEEDBANK_COLS && (m_nSeeds - 1) % MAX_SEEDBANK_COLS == 0) {
            m_nfpLibraryOffsetY = GFCanvas.getImageHeight("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(3)) * 4096;
            m_nfpLibraryVY = -45056;
            m_nfpLibraryTotalOffsetY = 0;
        }
        SeedPicker.startZoomToDest(n, SEED_PICKER_SELECTION[n * SEED_PICKER_MAX_VALS + SEED_PICKER_BANK_POS], SEED_PICKER_SELECTION[n * SEED_PICKER_MAX_VALS + SEED_PICKER_LIBRARY_POS], 0, 1, 22);
        SeedPicker.SEED_PICKER_SELECTION[n * SeedPicker.SEED_PICKER_MAX_VALS + SeedPicker.SEED_PICKER_BANK_POS] = -1;
        int n3 = 0;
        for (int i = 0; i < 7 && n3 < m_nSeeds; ++i) {
            if (!SeedPicker.isSeedAtIndex(i)) continue;
            int n4 = i * SEED_PICKER_MAX_VALS;
            int n5 = SEED_PICKER_SELECTION[n4 + SEED_PICKER_BANK_POS];
            if (n5 > n2) {
                SeedPicker.startZoomToDest(i, n5, n5 - 1, 0, 0, 22);
                int n6 = n4 + SEED_PICKER_BANK_POS;
                SEED_PICKER_SELECTION[n6] = SEED_PICKER_SELECTION[n6] - 1;
            }
            ++n3;
        }
    }

    static boolean isSeedAtIndex(int n) {
        return SEED_PICKER_SELECTION[SEED_PICKER_MAX_VALS * n + SEED_PICKER_SEED_TYPE] != -1;
    }

    static void startZoomToDest(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = SEED_PICKER_MAX_VALS * n;
        SeedPicker.SEED_PICKER_SELECTION[n7 + SeedPicker.SEED_PICKER_STATE] = n5 == 0 ? 1 : 2;
        SeedPicker.getSeedPos(n2, n4, false, true);
        int n8 = m_nSeedTempX * 4096;
        SeedPicker.SEED_PICKER_SELECTION[n7 + SeedPicker.SEED_PICKER_FP_X] = n8;
        int n9 = n8;
        int n10 = m_nSeedTempY * 4096;
        SeedPicker.SEED_PICKER_SELECTION[n7 + SeedPicker.SEED_PICKER_FP_Y] = n10;
        int n11 = n10;
        SeedPicker.getSeedPos(n3, n5, false, true);
        int n12 = m_nSeedTempX * 4096;
        int n13 = m_nSeedTempY * 4096;
        int n14 = n12 - n9;
        int n15 = n13 - n11;
        SeedPicker.SEED_PICKER_SELECTION[n7 + SeedPicker.SEED_PICKER_FP_DEST_X] = n12;
        SeedPicker.SEED_PICKER_SELECTION[n7 + SeedPicker.SEED_PICKER_FP_DEST_Y] = n13;
        Vector.normalise(n14, n15);
        Vector.scale(Vector.vrx, Vector.vry, 4096 * n6);
        SeedPicker.SEED_PICKER_SELECTION[n7 + SeedPicker.SEED_PICKER_FP_VX] = Vector.vrx;
        SeedPicker.SEED_PICKER_SELECTION[n7 + SeedPicker.SEED_PICKER_FP_VY] = Vector.vry;
        if (!m_bStartZoomToDest) {
            SeedPicker.SEED_PICKER_SELECTION[n7 + SeedPicker.SEED_PICKER_FP_X] = n12;
            SeedPicker.SEED_PICKER_SELECTION[n7 + SeedPicker.SEED_PICKER_FP_Y] = n13;
        }
    }

    static void updateSeedsZoomToDest() {
        int n = 0;
        int n2 = GModel.FP_95_PERCENT;
        for (int i = 0; i < 7 && n < m_nSeeds; ++i) {
            int n3;
            int n4;
            if (!SeedPicker.isSeedAtIndex(i) || (n4 = SEED_PICKER_SELECTION[(n3 = SEED_PICKER_MAX_VALS * i) + SEED_PICKER_STATE]) != 1 && n4 != 2) continue;
            int n5 = SEED_PICKER_SELECTION[n3 + SEED_PICKER_FP_X];
            int n6 = SEED_PICKER_SELECTION[n3 + SEED_PICKER_FP_Y];
            int n7 = SEED_PICKER_SELECTION[n3 + SEED_PICKER_FP_VX];
            int n8 = SEED_PICKER_SELECTION[n3 + SEED_PICKER_FP_VY];
            int n9 = SEED_PICKER_SELECTION[n3 + SEED_PICKER_FP_DEST_X];
            int n10 = SEED_PICKER_SELECTION[n3 + SEED_PICKER_FP_DEST_Y];
            if (n7 > 0) {
                n5 = Math.min(n5 + n7, n9);
                if (n7 > n2) {
                    n7 = Math.max(FP.fpMul(n7, n2), 8192);
                }
            } else {
                n5 = Math.max(n5 + n7, n9);
                if (n7 < n2) {
                    n7 = Math.min(FP.fpMul(n7, n2), -8192);
                }
            }
            if (n8 > 0) {
                n6 = Math.min(n6 + n8, n10);
                if (n8 > n2) {
                    n8 = Math.max(FP.fpMul(n8, n2), 8192);
                }
            } else {
                n6 = Math.max(n6 + n8, n10);
                if (n8 < n2) {
                    n8 = Math.min(FP.fpMul(n8, n2), -8192);
                }
            }
            SeedPicker.SEED_PICKER_SELECTION[n3 + SeedPicker.SEED_PICKER_FP_X] = n5;
            SeedPicker.SEED_PICKER_SELECTION[n3 + SeedPicker.SEED_PICKER_FP_Y] = n6;
            SeedPicker.SEED_PICKER_SELECTION[n3 + SeedPicker.SEED_PICKER_FP_VX] = n7;
            SeedPicker.SEED_PICKER_SELECTION[n3 + SeedPicker.SEED_PICKER_FP_VY] = n8;
            SeedPicker.SEED_PICKER_SELECTION[n3 + SeedPicker.SEED_PICKER_FP_DEST_X] = n9;
            SeedPicker.SEED_PICKER_SELECTION[n3 + SeedPicker.SEED_PICKER_FP_DEST_Y] = n10;
            if (n5 != n9 || n6 != n10) continue;
            if (n4 == 2) {
                --m_nSeeds;
                m_lSeedsSelected &= 1L << SEED_PICKER_SELECTION[n3 + SEED_PICKER_LIBRARY_POS] ^ 0xFFFFFFFFFFFFFFFFL;
                SeedPicker.SEED_PICKER_SELECTION[n3 + SeedPicker.SEED_PICKER_SEED_TYPE] = -1;
            }
            SeedPicker.SEED_PICKER_SELECTION[n3 + SeedPicker.SEED_PICKER_STATE] = 0;
            mRemoving = false;
        }
    }

    static void updateLibraryNewRowPos() {
        if (m_nfpLibraryVY != 0) {
            int n = GModel.FP_95_PERCENT;
            int n2 = m_nfpLibraryOffsetY;
            int n3 = m_nfpLibraryVY;
            int n4 = m_nfpLibraryTotalOffsetY;
            if (n3 > 0) {
                n2 = Math.min(n2 + n3, n4);
                if (n3 > n) {
                    n3 = Math.max(FP.fpMul(n3, n), 8192);
                }
            } else {
                n2 = Math.max(n2 + n3, n4);
                if (n3 < n) {
                    n3 = Math.min(FP.fpMul(n3, n), -8192);
                }
            }
            m_nfpLibraryOffsetY = n2;
            if (n2 == n4) {
                m_nfpLibraryVY = 0;
            }
        }
    }

    static void getSeedPos(int n, int n2, boolean bl, boolean bl2) {
        MAX_SEEDBANK_COLS = 3;
        int n3 = GFCanvas.getImageWidth("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(3)) + 7;
        int n4 = GFCanvas.getImageHeight("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(3));
        int n5 = 0;
        int n6 = 0;
        if (n2 == 1) {
            int n7 = n / MAX_SEEDBANK_COLS;
            int n8 = n % MAX_SEEDBANK_COLS;
            n5 = SEED_LIBRARY_DIMS[SEED_LIBRARY_X] + n8 * n3 + 11;
            n6 = SEED_LIBRARY_DIMS[SEED_LIBRARY_Y] + rowMovement + n7 * (n4 + 7);
        } else {
            int n9 = MAX_SEEDBANK_COLS;
            int n10 = n % n9;
            int n11 = n / n9;
            n5 = m_nSeedPickerBankX;
            n6 = 5;
            n6 += (n11 * n9 + n10) * n4;
        }
        m_nSeedTempX = n5;
        m_nSeedTempY = n6;
    }

    static void getSeedLibraryDrawDims(int[] nArray) {
        nArray[SeedPicker.SEED_LIBRARY_X] = m_nSeedPickerLibraryX;
        nArray[SeedPicker.SEED_LIBRARY_W] = m_nSeedPickerLibraryW;
        int n = GFCanvas.getImageHeight(374);
        nArray[SeedPicker.SEED_LIBRARY_Y] = m_nSeedPickerLibraryY + n;
        nArray[SeedPicker.SEED_LIBRARY_Y] = m_nSeedPickerLibraryY + n;
        nArray[SeedPicker.SEED_LIBRARY_H] = m_nSeedPickerLibraryH - n;
    }

    static void createTooltipTextWindow(int n, int n2, int n3) {
        if (n2 < 0) {
            return;
        }
        short s = (short)"\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e".charAt(n2);
        SeedPicker.getSeedPos(n, n3, false, false);
        int n4 = m_nSeedTempY;
        if (n3 == 1) {
            n4 += m_nSeedLibraryTotalDrawOffsetY;
        }
        int n5 = GFCanvas.getImageHeight("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(3)) + 7;
        int n6 = GFCanvas.getImageHeight("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(3)) + 7;
        int n7 = n4;
        int n8 = Layer.getLayerProperty(2, 4) - (n4 + n5);
        Text.m_sTextBuffer.setLength(0);
        AlmanacScreen.appendTextID(Text.m_sTextBuffer, "\u00c1\u00c2\u00a5\u00a6\u00a7\u00aa\u00ab\u00a8\u00a9\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c4", s, false, 1);
        int n9 = GFUIDrawType.getFont1ID(GFUIState.m_nUIState);
        int n10 = Math.max(n7, n8);
        int n11 = Math.min(Layer.getLayerProperty(2, 3), 250);
        int n12 = 0;
        Text.m_nTextWindowVisibleLines = -1;
        Text.m_nTextWindowNumSeperateLines = 0;
        while (Text.m_nTextWindowVisibleLines < Text.m_nTextWindowNumSeperateLines) {
            Text.CreateTextWindow(Text.m_sTextBuffer, 0, Text.m_sTextBuffer.length(), n11, n10, n9, false, 1, true, 0, 0);
            n11 += 83;
            ++n12;
        }
        m_nTooltipX = m_nSeedTempX + n6 / 2 - Text.m_nTextWindowWidth / 2;
        m_nTooltipX = Math.min(Math.max(m_nTooltipX, 0), Layer.getLayerProperty(2, 3) - Text.m_nTextWindowWidth);
        if (n7 > n8) {
            m_nTooltipY = n4 - Text.m_nTextWindowHeight;
            m_bToolTipAboveSeed = true;
        } else {
            m_nTooltipY = n4 + n5;
            m_bToolTipAboveSeed = false;
        }
        m_nTooltipExpandPercent = 0;
        SeedPicker.createTooltipMarqueeText(s);
    }

    static void createTooltipMarqueeText(int n) {
        int n2 = GFUIDrawType.getFont1ID(GFUIState.m_nUIState);
        short s = (short)"\u00dd\u00d8\u00c6\u00c5\u00c7\u00ca\u00cb\u00c8\u00c9\u00cc\u00d7\u00d6\u00d9\u00da\u00db\u00dc\u00e0\u00e2\u00e3\u00df\u00de\u00cd\u00ce\u00cf\u00d0\u00d2\u00d3\u00d1\u00d4\u00d5\u00e1".charAt(n);
        int n3 = Layer.getLayerProperty(2, 3);
        int n4 = Layer.getLayerProperty(2, 4) - 5 - GFFont.getFontHeight(n2);
        Text.CreateMarqeeTextID(s, n3, n4, 0, n3, 3, n2, Layer.getLayerProperty(2, 3) / 10, 0, -1, 0);
    }

    static void updateTooltip() {
        if (m_nfpSeedPickerLibraryVX != 0) {
            return;
        }
        int n = Util.clampInt(m_nTooltipExpandPercent, 1, 50);
        m_nTooltipExpandPercent = Math.min(m_nTooltipExpandPercent + n, 100);
        Text.updateMarqeeText();
    }

    static void addSeedsToHUD() {
        TouchGameController.clearSeedBankZones();
        if (GModel.m_bConveyorLevel) {
            return;
        }
        if (m_nSeeds > 0) {
            int n = 0;
            for (int i = 0; i < 7 && n < m_nSeeds; ++i) {
                int n2;
                int n3;
                if (SeedPicker.isSeedAtIndex(i) && (n3 = SEED_PICKER_SELECTION[(n2 = i * SEED_PICKER_MAX_VALS) + SEED_PICKER_BANK_POS]) == n) {
                    SeedBank.addSeed(SEED_PICKER_SELECTION[n2 + SEED_PICKER_SEED_TYPE], SEED_PICKER_SELECTION[n2 + SEED_PICKER_BANK_POS]);
                    ++n;
                }
                if (i + 1 < 7 || n >= m_nSeeds) continue;
                i = -1;
            }
        } else {
            int n;
            boolean bl = false;
            int n4 = 0;
            for (n = 0; n < UNLOCKED_SEED_TYPES.length; ++n) {
                if (UNLOCKED_SEED_TYPES[n] != 2) continue;
                bl = true;
                SeedBank.addSeed(UNLOCKED_SEED_TYPES[n], n4);
                ++n4;
            }
            for (n = 0; n < UNLOCKED_SEED_TYPES.length && UNLOCKED_SEED_TYPES[n] != -1; ++n) {
                if (UNLOCKED_SEED_TYPES[n] == 2 && bl) continue;
                SeedBank.addSeed(UNLOCKED_SEED_TYPES[n], n4);
                ++n4;
            }
        }
        SeedBank.updatePositions(0, 0, Layer.getLayerProperty(2, 4), 0, Layer.getLayerProperty(2, 3), false);
    }

    static void updateCursor() {
        if (++Cursor.m_nCursorFrame > GraphicsUtil.getPingPongMaxFrame(5)) {
            Cursor.m_nCursorFrame = 0;
        }
    }

    static void update() {
        SeedPicker.updateSeedsZoomToDest();
        SeedPicker.updateLibraryNewRowPos();
        SeedPicker.updateTooltip();
        SeedPicker.updateSeedLibraryDrawPos();
        SeedPicker.updateWindowPan();
        if (GFUIState.m_nUIState == 11 && m_bSeedPickerLibraryMovingOffScreen && m_nfpSeedPickerLibraryVX == 0) {
            GFUITransitionManager.setTransitionComplete();
        }
        TouchGameController.updateSeedPickerBankZones();
        TouchGameController.updateSeedPickerLibraryZones(0, 0);
    }

    static void setSeedLibraryDrawPos(int n, int n2) {
        SeedPicker.getSeedPos(n, 1, false, true);
        SeedPicker.getSeedLibraryDrawDims(SEED_LIBRARY_DIMS);
        int n3 = m_nSeedTempY;
        int n4 = SEED_LIBRARY_DIMS[SEED_LIBRARY_Y] + SEED_LIBRARY_DIMS[SEED_LIBRARY_H];
        int n5 = GFCanvas.getImageHeight("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(3));
        int n6 = Util.clampInt(n3, SEED_LIBRARY_DIMS[SEED_LIBRARY_Y], n4 - n5);
        if ((m_nSeedLibraryTotalDrawOffsetY += n6 - n3) > m_nSeedLibraryDrawOffsetY) {
            int n7 = (m_nSeedLibraryTotalDrawOffsetY - m_nSeedLibraryDrawOffsetY) * 4096 / 4;
            m_nfpSeedLibraryDrawVY = Math.max(n7, 28672);
        } else if (m_nSeedLibraryTotalDrawOffsetY < m_nSeedLibraryDrawOffsetY) {
            int n8 = (m_nSeedLibraryTotalDrawOffsetY - m_nSeedLibraryDrawOffsetY) * 4096 / 4;
            m_nfpSeedLibraryDrawVY = Math.min(n8, -28672);
        } else {
            m_nfpSeedLibraryDrawVY = 0;
        }
    }

    static void updateSeedLibraryDrawPos() {
        if (m_nfpSeedLibraryDrawVY != 0) {
            GraphicsUtil.updateWidgetMovement(m_nfpSeedLibraryDrawVY, 4096, GModel.FP_90_PERCENT, m_nSeedLibraryDrawOffsetY * 4096, m_nSeedLibraryTotalDrawOffsetY * 4096);
            m_nSeedLibraryDrawOffsetY = FP.toInt(GraphicsUtil.m_nfpWidgetTempPos);
            m_nfpSeedLibraryDrawVY = GraphicsUtil.m_nfpWidgetTempVel;
        }
    }

    static void setWindowPanPos(boolean bl) {
        if (bl) {
            int n;
            m_bSeedPickerLibraryMovingOffScreen = false;
            m_nSeedPickerLibraryX = -m_nSeedPickerLibraryW;
            m_nfpSeedPickerLibraryVX = 143360;
            m_nSeedPickerLibraryTotalX = n = GFCanvas.getImageWidth("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(3)) + 7;
            m_nfpSeedPickerLibraryDecel = GModel.FP_110_PERCENT;
            m_nSeedPickerBankX = -m_nSeedPickerBankW;
            m_nfpSeedPickerBankVX = 143360;
            m_nSeedPickerBankTotalX = 0;
            m_nfpSeedPickerBankDecel = GModel.FP_110_PERCENT;
        } else {
            m_bSeedPickerLibraryMovingOffScreen = true;
            m_nSeedPickerLibraryX = 0;
            m_nfpSeedPickerLibraryVX = -81920;
            m_nSeedPickerLibraryTotalX = -m_nSeedPickerLibraryW;
            m_nfpSeedPickerLibraryDecel = GModel.FP_120_PERCENT;
        }
    }

    static void updateWindowPan() {
        if (m_nfpSeedPickerLibraryVX != 0) {
            GraphicsUtil.updateWidgetMovement(m_nfpSeedPickerLibraryVX, 4096, m_nfpSeedPickerLibraryDecel, m_nSeedPickerLibraryX * 4096, m_nSeedPickerLibraryTotalX * 4096);
            m_nSeedPickerLibraryX = FP.toInt(GraphicsUtil.m_nfpWidgetTempPos);
            m_nfpSeedPickerLibraryVX = GraphicsUtil.m_nfpWidgetTempVel;
        }
        if (m_nfpSeedPickerBankVX != 0) {
            GraphicsUtil.updateWidgetMovement(m_nfpSeedPickerBankVX, 4096, m_nfpSeedPickerBankDecel, m_nSeedPickerBankX * 4096, m_nSeedPickerBankTotalX * 4096);
            m_nSeedPickerBankX = FP.toInt(GraphicsUtil.m_nfpWidgetTempPos);
            m_nfpSeedPickerBankVX = GraphicsUtil.m_nfpWidgetTempVel;
        }
    }

    static int getNumOfUnlockedSeeds() {
        return m_nUnlockedSeedsCount;
    }

    static void unlockSeed(int n) {
        if (n >= 0 && n < UNLOCKED_SEED_TYPES.length) {
            for (int i = 0; i < UNLOCKED_SEED_TYPES.length; ++i) {
                if (UNLOCKED_SEED_TYPES[i] != -1) continue;
                SeedPicker.UNLOCKED_SEED_TYPES[i] = n;
                AlmanacScreenMenu.seedsUnlocked |= 1L << n;
                ++m_nUnlockedSeedsCount;
                return;
            }
        }
    }

    static void startTransition() {
        if (m_nSeeds == SeedBank.m_nCurrMaxSeeds) {
            SeedPicker.setWindowPanPos(false);
        }
    }

    static void drawSeedPickerScreen(Graphics graphics, int n) {
        GFCanvas.setClipFullScreen(graphics, 2);
        int n2 = m_nSeedPickerLibraryX;
        int n3 = m_nSeedPickerLibraryY;
        int n4 = Layer.getLayerProperty(2, 3);
        int n5 = Layer.getLayerProperty(2, 4);
        int n6 = GFUIDrawType.getTitleFontID(n);
        n2 = m_nSeedPickerLibraryX + m_nSeedPickerLibraryW / 2;
        n3 = m_nSeedPickerLibraryY + 10 - GFFont.getFontHeight(n6) / 2;
        SeedPicker.drawSeedPickerLibrary(graphics, n, 0, 0);
        SeedPicker.drawSeedPickerBank(graphics, n, m_nSeedPickerBankXOffset, m_nSeedPickerBankYOffset);
        GFCanvas.setClipFullScreen(graphics, 2);
    }

    static void drawSeedPickerBackground(Graphics graphics, int n, int n2) {
        if (Layer.isLandscape(2)) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10 = GFCanvas.getImageWidth(374);
            int n11 = GFCanvas.getImageHeight(374);
            int n12 = GFCanvas.getImageWidth(191);
            int n13 = GFCanvas.getImageHeight(191);
            int n14 = GFCanvas.getImageWidth(363);
            int n15 = GFCanvas.getImageHeight(363);
            int n16 = m_nSeedPickerLibraryW - (n10 << 1);
            int n17 = m_nSeedPickerLibraryH - (n11 + n13);
            int n18 = n16 / n14;
            int n19 = n17 / n15;
            n19 += n17 % n15 == 0 ? 0 : 1;
            int n20 = n + n10;
            int n21 = n2 + n11;
            for (n9 = 0; n9 <= n19; ++n9) {
                for (n8 = 0; n8 <= n18; ++n8) {
                    n7 = n20 + n8 * n14;
                    n6 = n21 + n9 * n15;
                    if (n7 + n14 > n + m_nSeedPickerLibraryW) {
                        n7 = n + m_nSeedPickerLibraryW - n14;
                    }
                    if (n6 + n15 > n2 + m_nSeedPickerLibraryH) {
                        n6 = n2 + m_nSeedPickerLibraryH - n15;
                    }
                    GFCanvas.drawImage(graphics, 363, n7, n6, 20, 2);
                }
            }
            GFCanvas.drawImage(graphics, 374, 0, n, n2, 20, 2);
            n9 = n + (m_nSeedPickerLibraryW - n10);
            GFCanvas.drawImage(graphics, 374, 1, n9, n2, 20, 2);
            n8 = m_nSeedPickerLibraryW - (n10 << 1);
            n7 = GFCanvas.getImageWidth(202);
            n6 = n8 / n7;
            n6 += n8 % n7 == 0 ? 0 : 1;
            int n22 = n + n10;
            GFCanvas.clipRect(graphics, n22, n2, n8, n11, 2);
            for (n5 = 0; n5 < n6; ++n5) {
                GFCanvas.drawImage(graphics, 202, n22 + n5 * n7, n2, 20, 2);
            }
            GFCanvas.setClipFullScreen(graphics, 2);
            n5 = GFFont.getFontHeight(6);
            int n23 = n + (m_nSeedPickerLibraryW >> 1);
            int n24 = n2 + (Math.abs(16 - n5) >> 1);
            GFText.drawString(graphics, 87, n23, n24, 6, 2, 2);
            int n25 = GFCanvas.getImageWidth(151);
            int n26 = GFCanvas.getImageHeight(151);
            int n27 = m_nSeedPickerLibraryH - (n11 + n13);
            int n28 = n27 / n26;
            n28 += n27 % n26 == 0 ? 0 : 1;
            int n29 = n2 + n11;
            int n30 = n + (m_nSeedPickerLibraryW - n25);
            for (n4 = 0; n4 < n28; ++n4) {
                GFCanvas.clipRect(graphics, n, n29, n25, n27, 2);
                GFCanvas.drawImage(graphics, 151, n, n29 + n4 * n26, 20, 2);
                GFCanvas.setClipFullScreen(graphics, 2);
                GFCanvas.clipRect(graphics, n30, n29, n25, n27, 2);
                GFCanvas.drawImage(graphics, 151, 1, n30, n29 + n4 * n26, 20, 2);
                GFCanvas.setClipFullScreen(graphics, 2);
            }
            n4 = n2 + (m_nSeedPickerLibraryH - n13);
            GFCanvas.drawImage(graphics, 191, n, n4, 20, 2);
            int n31 = n + (m_nSeedPickerLibraryW - n12);
            GFCanvas.drawImage(graphics, 191, 1, n31, n4, 20, 2);
            int n32 = GFCanvas.getImageHeight(151);
            int n33 = GFCanvas.getImageWidth(151);
            int n34 = m_nSeedPickerLibraryW - (n12 << 1);
            int n35 = n34 / n32;
            n35 += n34 % n32 == 0 ? 0 : 1;
            int n36 = n + n12;
            int n37 = n2 + (m_nSeedPickerLibraryH - n33);
            GFCanvas.clipRect(graphics, n36, n37, n34, n33, 2);
            for (n3 = 0; n3 < n35; ++n3) {
                GFCanvas.drawImage(graphics, 151, 0, 6, n36 + n3 * n32, n37, 20, 2);
            }
            GFCanvas.setClipFullScreen(graphics, 2);
            n3 = GFCanvas.getImageWidth(365);
            int n38 = n + (m_nSeedPickerLibraryW - n3 >> 1);
            if (renderTopScrollArrow) {
                GFCanvas.drawImage(graphics, 365, n38, scrollArrowUPTop, 20, 2);
            }
            if (renderBottomScrollArrow) {
                GFCanvas.drawImage(graphics, 296, n38, scrollArrowBottomTop, 20, 2);
            }
            int n39 = GFCanvas.getImageWidth(254);
            int n40 = GFCanvas.getImageHeight(254);
            int n41 = Layer.getLayerProperty(2, 3) - n39;
            int n42 = Layer.getLayerProperty(2, 4) - n40 >> 1;
            GFCanvas.drawImage(graphics, 254, n41, n42, 20, 2);
        }
    }

    static void drawSeedPickerToolTip(Graphics graphics, int n, int n2) {
        if (m_nfpSeedPickerLibraryVX != 0) {
            return;
        }
        int n3 = Util.getPercentage(m_nTooltipExpandPercent, 100, Text.m_nTextWindowHeight);
        int n4 = Util.getPercentage(m_nTooltipExpandPercent, 100, Text.m_nTextWindowWidth);
        int n5 = m_nTooltipX + (Text.m_nTextWindowWidth - n4) / 2 + n;
        if (m_bToolTipAboveSeed) {
            GFCanvas.setClip(graphics, n5, m_nTooltipY + Text.m_nTextWindowHeight - n3 + n2, n4, n3, 2);
        } else {
            GFCanvas.setClip(graphics, n5, m_nTooltipY + n2, n4, n3, 2);
        }
        GFCanvas.drawAlphaRegion(graphics, 60, m_nTooltipX + n, m_nTooltipY + n2, Text.m_nTextWindowWidth, Text.m_nTextWindowHeight, 2);
        Text.DrawTextWindow(graphics, m_nTooltipX + n, m_nTooltipY + n2, 1);
    }

    static void drawSeedPickerLibrary(Graphics graphics, int n, int n2, int n3) {
        int n4;
        int n5 = -1;
        int n6 = GFCanvas.getImageWidth("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(3));
        int n7 = GFCanvas.getImageHeight("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(3));
        int n8 = 0;
        int n9 = 0;
        boolean bl = true;
        SeedPicker.getSeedLibraryDrawDims(SEED_LIBRARY_DIMS);
        SeedPicker.drawSeedPickerBackground(graphics, m_nSeedPickerLibraryX + n2, m_nSeedPickerLibraryY + n3);
        GFCanvas.setClip(graphics, SEED_LIBRARY_DIMS[SEED_LIBRARY_X], SEED_LIBRARY_DIMS[SEED_LIBRARY_Y], SEED_LIBRARY_DIMS[SEED_LIBRARY_W], SEED_LIBRARY_DIMS[SEED_LIBRARY_H], 2);
        for (n4 = 0; n4 < m_nMaxItems; ++n4) {
            boolean bl2;
            SeedPicker.getSeedPos(n4, 1, false, true);
            if (m_nSeedTempY + n7 > SEED_LIBRARY_DIMS[SEED_LIBRARY_Y] + SEED_LIBRARY_DIMS[SEED_LIBRARY_H]) continue;
            n5 = UNLOCKED_SEED_TYPES[n4];
            boolean bl3 = bl2 = (m_lSeedsSelected & 1L << n4) != 0L;
            if (SeedPicker.isRooftopSeedOff(n5) || SeedPicker.isDaySeedOff(n5)) {
                bl2 = true;
            }
            if (n4 == GFUIState.UI_MENU_CURRENT_SELECTION[n]) {
                n8 = m_nSeedTempX + n2;
                n9 = m_nSeedTempY + n3;
                if (bl2) {
                    bl = false;
                }
            }
            HUDView.drawSeed(graphics, n5, -1, m_nSeedTempX, m_nSeedTempY, false, bl2, true, true, true);
        }
        GFCanvas.setClipFullScreen(graphics, 2);
        for (n4 = m_nMaxItems; n4 < "\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".length(); ++n4) {
            SeedPicker.getSeedPos(n4, 1, false, true);
            int n10 = m_nSeedTempX;
            int n11 = m_nSeedTempY;
            if (n11 + n7 > SEED_LIBRARY_DIMS[SEED_LIBRARY_Y] + SEED_LIBRARY_DIMS[SEED_LIBRARY_H]) continue;
            GFCanvas.drawImage(graphics, 279, n10, n11, 20, 2);
        }
        GFCanvas.setClipFullScreen(graphics, 2);
    }

    static void drawSeedPickerBank(Graphics graphics, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = GFCanvas.getImageWidth("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(3));
        int n9 = GFCanvas.getImageHeight("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(3));
        int n10 = 0;
        int n11 = -1;
        int n12 = -1;
        SeedPicker.getSeedPos(0, 0, false, true);
        SeedPicker.drawSeedPacketsFrame(graphics, m_nSeedTempX + --n2);
        long l = Util.setAllBits(SeedBank.m_nCurrMaxSeeds);
        for (n7 = 0; n7 < 7 && n10 < m_nSeeds; ++n7) {
            if (!SeedPicker.isSeedAtIndex(n7)) continue;
            n6 = n7 * SEED_PICKER_MAX_VALS;
            n5 = SEED_PICKER_SELECTION[n6 + SEED_PICKER_BANK_POS];
            n4 = SEED_PICKER_SELECTION[n6 + SEED_PICKER_SEED_TYPE];
            ++n10;
            if (SEED_PICKER_SELECTION[n6 + SEED_PICKER_STATE] != 0) continue;
            SeedPicker.getSeedPos(n5, 0, false, true);
            l &= 1L << n5 ^ 0xFFFFFFFFFFFFFFFFL;
            if (m_nSeedPickerGridType == 0 && n5 == GFUIState.UI_MENU_CURRENT_SELECTION[n]) {
                n11 = m_nSeedTempX;
                n12 = m_nSeedTempY;
            }
            GFCanvas.drawImage(graphics, "\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(n4), m_nSeedTempX + n2, m_nSeedTempY + n3, 20, 2);
            Text.DrawAlignedNumber(graphics, (short)"\u0000\u00192d2\u00c8\u00af\u0096\u0019\u0096\u01452}d\u00af}dd\u012c}}\u0000\u0019KK\u0019KK}\u0019\u0019".charAt(n4), m_nSeedTempX + 36 + n2, m_nSeedTempY + 23 + n2, 2, 2, false);
        }
        n5 = Util.findNextSetBit(l, 0);
        while (n5 != -1) {
            SeedPicker.getSeedPos(n5, 0, false, true);
            graphics.setColor(5975318);
            GFCanvas.fillRect(graphics, m_nSeedTempX + n2 + 4, m_nSeedTempY + n3 + 4, n8 - 8, n9 - 8, 2);
            n5 = Util.findNextSetBit(l, n5 + 1);
        }
        n10 = 0;
        for (n7 = 0; n7 < 7 && n10 < m_nSeeds; ++n7) {
            if (!SeedPicker.isSeedAtIndex(n7)) continue;
            n6 = n7 * SEED_PICKER_MAX_VALS;
            n4 = SEED_PICKER_SELECTION[n6 + SEED_PICKER_SEED_TYPE];
            ++n10;
            if (SEED_PICKER_SELECTION[n6 + SEED_PICKER_STATE] == 0) continue;
            m_nSeedTempX = FP.toInt(SEED_PICKER_SELECTION[n6 + SEED_PICKER_FP_X]);
            m_nSeedTempY = FP.toInt(SEED_PICKER_SELECTION[n6 + SEED_PICKER_FP_Y]);
            GFCanvas.drawImage(graphics, "\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(n4), m_nSeedTempX + n2, m_nSeedTempY + n3, 20, 2);
            Text.DrawAlignedNumber(graphics, (short)"\u0000\u00192d2\u00c8\u00af\u0096\u0019\u0096\u01452}d\u00af}dd\u012c}}\u0000\u0019KK\u0019KK}\u0019\u0019".charAt(n4), m_nSeedTempX + 36 + n2, m_nSeedTempY + 23 + n3, 2, 2, false);
        }
    }

    public static void drawSeedPacketsFrame(Graphics graphics, int n) {
        int n2 = GFCanvas.getImageWidth("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(3));
        int n3 = GFCanvas.getImageWidth(412);
        int n4 = GFCanvas.getImageHeight(412);
        int n5 = n - (n3 - n2 >> 1);
        int n6 = 0;
        GFCanvas.drawImage(graphics, 412, n5, n6, 20, 2);
        int n7 = Layer.getLayerProperty(2, 4);
        int n8 = n7 - n4;
        GFCanvas.drawImage(graphics, 412, 2, n5, n8, 20, 2);
        int n9 = n6 + n4;
        int n10 = GFCanvas.getImageHeight(463);
        int n11 = n8 - n9;
        int n12 = n11 / n10;
        n12 += n11 % n10 == 0 ? 0 : 1;
        GFCanvas.setClip(graphics, n5, n9, n3, n11, 2);
        for (int i = 0; i < n12; ++i) {
            GFCanvas.drawImage(graphics, 463, n5, n9 + i * n10, 20, 2);
        }
        GFCanvas.setClipFullScreen(graphics, 2);
    }

    static void drawSeedPickerCursor(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
    }

    static void handleInput(int n, int[] nArray) {
        if (GFUIState.wasPressed(1024)) {
            GFUIState.switchStateOrPerformAction(35, false, false);
            GFMain.clearKeysPressed();
        } else if (GFUIState.wasPressed(nArray[5])) {
            int n2 = SeedPicker.getRemainingSeeds();
            if (n2 < SeedBank.m_nCurrMaxSeeds) {
                GFMain.clearKeysPressed();
                return;
            }
            m_nSeedPickerGridType = -1;
        } else if (GFUIState.wasPressed(nArray[1])) {
            SeedPicker.handleInput(n, 32768);
        } else if (GFUIState.wasPressed(nArray[0])) {
            SeedPicker.handleInput(n, 16384);
        } else if (GFUIState.wasPressed(nArray[3])) {
            SeedPicker.handleInput(n, 8192);
        } else if (GFUIState.wasPressed(nArray[2])) {
            SeedPicker.handleInput(n, 4096);
        } else if (GFUIState.wasPressed(nArray[4])) {
            SeedPicker.handleInput(n, 65536);
        }
    }

    static int getNextLockedSeed() {
        int n = -1;
        for (int i = 0; i < "\u0002\u0007\u0004\b\u0006\t\u0005\u0015\u0016\u0017\u0018\u001b\u0019\u001a\u001c\u001d\u000b\n\u0001\f\r\u000e\u000f\u0000\u0014\u0013\u0010\u001e\u0011\u0012".length(); ++i) {
            n = (short)"\u0002\u0007\u0004\b\u0006\t\u0005\u0015\u0016\u0017\u0018\u001b\u0019\u001a\u001c\u001d\u000b\n\u0001\f\r\u000e\u000f\u0000\u0014\u0013\u0010\u001e\u0011\u0012".charAt(i);
            if (n >= UNLOCKED_SEED_TYPES.length || SeedPicker.bIsSeedUnlocked(n)) continue;
            return n;
        }
        return -1;
    }

    static boolean bIsSeedUnlocked(int n) {
        if (n >= 0 && n < UNLOCKED_SEED_TYPES.length) {
            for (int i = 0; i < UNLOCKED_SEED_TYPES.length; ++i) {
                if (UNLOCKED_SEED_TYPES[i] == n) {
                    return true;
                }
                if (UNLOCKED_SEED_TYPES[i] != -1) continue;
                return false;
            }
        }
        return false;
    }

    static int getSeedBankPosFromLibPos(int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < 7 && n2 < m_nSeeds; ++i) {
            if (!SeedPicker.isSeedAtIndex(i)) continue;
            n3 = i * SEED_PICKER_MAX_VALS;
            if (n == SEED_PICKER_SELECTION[n3 + SEED_PICKER_LIBRARY_POS]) {
                return SEED_PICKER_SELECTION[n3 + SEED_PICKER_BANK_POS];
            }
            ++n2;
        }
        return -1;
    }

    static void drawSeedPickerBankArrows(Graphics graphics) {
        GFCanvas.setClipFullScreen(graphics, 1);
        int n = GFUIState.getCurrentSelectionIndex();
        if (++m_nArrowFrame >= GraphicsUtil.getPingPongMaxFrame(6)) {
            m_nArrowFrame = 0;
        }
        int n2 = GraphicsUtil.getPingPongDrawFrame(6, m_nArrowFrame);
        GFCanvas.drawImage(graphics, 282, m_nSeedPickerBankX + GFCanvas.getImageWidth("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(3)) / 2, n2, 17, 2);
        int n3 = Layer.getLayerProperty(2, 4) - n2;
        GFCanvas.drawImage(graphics, 139, m_nSeedPickerBankX + GFCanvas.getImageWidth("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(3)) / 2, n3, 33, 2);
    }

    static {
        m_nSeedSelected = 3;
        m_bStartZoomToDest = false;
        mRemoving = false;
        scrollEnabled = false;
        prevRow = 0;
        rowMovement = 0;
        renderTopScrollArrow = false;
        renderBottomScrollArrow = false;
        scrollArrowUPTop = 0;
        scrollArrowBottomTop = 0;
        m_bIsSeedPickerInitialized = false;
        SEED_LIBRARY_DIMS = new int[4];
        SEED_LIBRARY_X = 0;
        SEED_LIBRARY_Y = 1;
        SEED_LIBRARY_W = 2;
        SEED_LIBRARY_H = 3;
        UNLOCKED_SEED_TYPES = new int[31];
    }
}

