/*
 * Decompiled with CFR 0.152.
 */
public class Zombies
implements GameConstants,
Constants,
ReanimAttributes,
ConstantsReanim {
    static int ZOMBIE_TYPE = 0;
    static int ZOMBIE_ROW = ZOMBIE_TYPE + 1;
    static int ZOMBIE_FP_CENTRE_X = ZOMBIE_ROW + 1;
    static int ZOMBIE_FP_TOP_Y = ZOMBIE_FP_CENTRE_X + 1;
    static int ZOMBIE_FP_VX = ZOMBIE_FP_TOP_Y + 1;
    static int ZOMBIE_FP_ALTITUDE = ZOMBIE_FP_VX + 1;
    static int ZOMBIE_REANIM_FRAME = ZOMBIE_FP_ALTITUDE + 1;
    static int ZOMBIE_REANIM_FP_FRAMES_PER_TICK = ZOMBIE_REANIM_FRAME + 1;
    static int ZOMBIE_REANIM_FP_TICKS_COUNTER = ZOMBIE_REANIM_FP_FRAMES_PER_TICK + 1;
    static int ZOMBIE_REANIM_INDEX = ZOMBIE_REANIM_FP_TICKS_COUNTER + 1;
    static int ZOMBIE_REANIM_CURR_TRACK_GLOBAL_INDEX = ZOMBIE_REANIM_INDEX + 1;
    static int ZOMBIE_REANIM_CURR_TRACK_ID = ZOMBIE_REANIM_CURR_TRACK_GLOBAL_INDEX + 1;
    static int ZOMBIE_REANIM_FP_FPS = ZOMBIE_REANIM_CURR_TRACK_ID + 1;
    static int ZOMBIE_REANIM_START_TRACK_INDEX = ZOMBIE_REANIM_FP_FPS + 1;
    static int ZOMBIE_REANIM_HIDDEN_TRACKS = ZOMBIE_REANIM_START_TRACK_INDEX + 1;
    static int ZOMBIE_REANIM_LOOP_TYPE = ZOMBIE_REANIM_HIDDEN_TRACKS + 1;
    static int ZOMBIE_REANIM_LOOP_COUNT = ZOMBIE_REANIM_LOOP_TYPE + 1;
    static int ZOMBIE_REANIM_COUNTDOWN_FRAMES = ZOMBIE_REANIM_LOOP_COUNT + 1;
    static int ZOMBIE_REANIM_HELM_TRACK_ID = ZOMBIE_REANIM_COUNTDOWN_FRAMES + 1;
    static int ZOMBIE_REANIM_SHIELD_TRACK_ID = ZOMBIE_REANIM_HELM_TRACK_ID + 1;
    static int ZOMBIE_WAVE = ZOMBIE_REANIM_SHIELD_TRACK_ID + 1;
    static int ZOMBIE_HEALTH_BODY = ZOMBIE_WAVE + 1;
    static int ZOMBIE_HEALTH_SHIELD = ZOMBIE_HEALTH_BODY + 1;
    static int ZOMBIE_HEALTH_HELM = ZOMBIE_HEALTH_SHIELD + 1;
    static int ZOMBIE_SHIELD_TYPE = ZOMBIE_HEALTH_HELM + 1;
    static int ZOMBIE_HELM_TYPE = ZOMBIE_SHIELD_TYPE + 1;
    static int ZOMBIE_STATE = ZOMBIE_HELM_TYPE + 1;
    static int ZOMBIE_FP_STATE_COUNTDOWN = ZOMBIE_STATE + 1;
    static int ZOMBIE_SECONDARY_STATE = ZOMBIE_FP_STATE_COUNTDOWN + 1;
    static int ZOMBIE_FLAGS = ZOMBIE_SECONDARY_STATE + 1;
    static int ZOMBIE_COUNTDOWN_FRAME = ZOMBIE_FLAGS + 1;
    static int ZOMBIE_CHILLED_COUNTDOWN = ZOMBIE_COUNTDOWN_FRAME + 1;
    static int ZOMBIE_BUTTERED_COUNTDOWN = ZOMBIE_CHILLED_COUNTDOWN + 1;
    static int ZOMBIE_FROZEN_COUNTDOWN = ZOMBIE_BUTTERED_COUNTDOWN + 1;
    static int ZOMBIE_PARAM_1 = ZOMBIE_FROZEN_COUNTDOWN + 1;
    static int ZOMBIE_PARAM_2 = ZOMBIE_PARAM_1 + 1;
    static int ZOMBIE_PARAM_3 = ZOMBIE_PARAM_2 + 1;
    static int ZOMBIE_PARAM_4 = ZOMBIE_PARAM_3 + 1;
    static int ZOMBIE_SUMMON_COUNTER = ZOMBIE_PARAM_4 + 1;
    static int ZOMBIE_GRID_LADDER_BOARD_POS = ZOMBIE_SUMMON_COUNTER + 1;
    static int ZOMBIE_MAX_VALS = ZOMBIE_GRID_LADDER_BOARD_POS + 1;
    static int[] ZOMBIES = new int[100 * ZOMBIE_MAX_VALS];
    static int[] ZOMBIE_SWAP_TEMP = new int[ZOMBIE_MAX_VALS];
    static int m_nZombies;
    static int ZOMBIE_OFFSET_CENTRE_X;
    static int ZOMBIE_OFFSET_TOP_Y;
    static int ZOMBIE_OFFSET_DRAW_X;
    static int ZOMBIE_OFFSET_DRAW_Y;
    static int ZOMBIE_OFFSET_BUTTER_X;
    static int ZOMBIE_OFFSET_BUTTER_Y;
    static int ZOMBIE_OFFSET_MIND_CONTROL_X;
    static int ZOMBIE_OFFSET_MIND_CONTROL_Y;
    static int ZOMBIE_OFFSET_CHILLLED_X;
    static int ZOMBIE_OFFSET_CHILLLED_Y;
    static int ZOMBIE_OFFSET_SHADOW_X;
    static int ZOMBIE_OFFSET_SHADOW_Y;
    static int ZOMBIE_OFFSET_BURN_X;
    static int ZOMBIE_OFFSET_BURN_Y;
    static int ZOMBIE_OFFSET_BOARD_X;
    static int ZOMBIE_OFFSET_MAX_VALS;
    static int[] ZOMBIE_OFFSETS;
    static int ZOMBIE_RECT_X;
    static int ZOMBIE_RECT_Y;
    static int ZOMBIE_RECT_W;
    static int ZOMBIE_RECT_H;
    static int[] ZOMBIE_RECT;
    static int FP1;
    static int RENDER_MODE_HIDDEN;
    static int RENDER_MODE_NORMAL;
    static int ZOMBIE_JACK_IN_THE_BOX_MAX_PX_BEFORE_EXPLODE_FP;
    static int ZOMBIE_JACK_IN_THE_BOX_MIN_PX_BEFORE_EXPLODE_FP;
    static int ZOMBIE_JACK_IN_THE_BOX_RAND_PX_BEFORE_EXPLODE_FP;
    static int ZOMBIE_CLIMB_INC_X_FP;
    static int ZOMBIE_CLIMB_INC_Y_FP;
    static final int NO_GROUND_TRACK_VEL = 9999;
    static int DANCER_WALK_LEFT_FRAMES;
    static int DANCER_RAISE_TO_WALK_FRAMES;
    static int DANCER_DANCE_FRAMES;
    static int DANCE_LEFT_ANIM_FRAMES;
    static int DANCE_RIGHT_1;
    static int DANCE_LEFT_1;
    static int DANCE_RIGHT_2;
    static int RAISE_TO_WALK_FRAMES;
    static final int IMP_THROWN = 1;

    static void init() {
        ZOMBIE_CLIMB_INC_Y_FP = FP.fpDiv(100 * FP1, 409600);
        ZOMBIE_CLIMB_INC_X_FP = FP.fpDiv(70 * FP1, 409600);
        Zombies.calcJackInTheBoxConstants();
    }

    static void resetVarsNewLevel() {
        Util.resetArray(ZOMBIES, -1);
        m_nZombies = 0;
    }

    static void calcJackInTheBoxConstants() {
        ZOMBIE_JACK_IN_THE_BOX_MAX_PX_BEFORE_EXPLODE_FP = GModel.scaleValueX((short)"\uffff\uffff\uffff\uffff\uffff\uffff\uffff\u0012\u02ee\u01c2\uffff\uffff\uffff\u0014\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(8), false);
        ZOMBIE_JACK_IN_THE_BOX_MIN_PX_BEFORE_EXPLODE_FP = FP.fpDiv(FP.fpMul(ZOMBIE_JACK_IN_THE_BOX_MAX_PX_BEFORE_EXPLODE_FP, FP1 * 60), 409600);
        ZOMBIE_JACK_IN_THE_BOX_RAND_PX_BEFORE_EXPLODE_FP = FP.fpDiv(FP.fpMul(ZOMBIE_JACK_IN_THE_BOX_MAX_PX_BEFORE_EXPLODE_FP, FP1 * 40), 409600);
    }

    static void calcDancerReanimConstants() {
        if (Reanim.LOADED_REANIMS[2]) {
            int n = Reanim.getReanimIndexFromID(2);
            int n2 = Reanim.getTrackAttributeFromTrackID(n, 47, 3);
            DANCER_DANCE_FRAMES = n2 * 3;
            DANCER_WALK_LEFT_FRAMES = Reanim.getTrackAttributeFromTrackID(n, 46, 3) * 2;
            DANCER_RAISE_TO_WALK_FRAMES = n2 - 1;
            DANCE_LEFT_ANIM_FRAMES = DANCER_WALK_LEFT_FRAMES;
            DANCE_RIGHT_1 = DANCE_LEFT_ANIM_FRAMES + n2;
            DANCE_LEFT_1 = DANCE_RIGHT_1 + n2;
            DANCE_RIGHT_2 = DANCE_LEFT_1 + n2;
            RAISE_TO_WALK_FRAMES = DANCE_RIGHT_2 + DANCER_RAISE_TO_WALK_FRAMES;
        }
    }

    static int addZombie(int n, int n2, int n3) {
        return Zombies.addZombie(n, n2, n3, -1, -1);
    }

    static int addZombie(int n, int n2, int n3, int n4, int n5) {
        if (n >= 0) {
            int n6 = 0;
            for (int i = 0; i < 100; ++i) {
                if (Zombies.isZombieAtIndex(i)) continue;
                n6 = ZOMBIE_MAX_VALS * i;
                if (n == 20) {
                    n2 = 3;
                }
                Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_TYPE] = n;
                Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_ROW] = n2;
                Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_FP_CENTRE_X] = Zombies.getZombieStartXFP(n);
                Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_FP_TOP_Y] = Zombies.getZombieStartYFP(n, n2);
                Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_FP_VX] = Zombies.getZombieSpeedFP(n, -1);
                Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_FP_ALTITUDE] = 0;
                Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_WAVE] = n3;
                Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_HEALTH_BODY] = Math.max((short)"\u010e\u010e\u010e\u010e\u010e\u010e\u01f4\u01f4\u01f4\u010e\u010e\u0bb8\u01f4\u0352\u01f4\u010e\u010e\u010e\u010e\u00c8\u2710\u7530\u7530".charAt(n), 0);
                Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_HEALTH_SHIELD] = Math.max((short)"\uffff\uffff\uffff\u0320\uffff\uffff\uffff\uffff\uffff\u0096\uffff\uffff\u01f4\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n), 0);
                Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_HEALTH_HELM] = Math.max((short)"\uffff\uffff\u0172\uffff\u0578\u0578\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffd\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n), 0);
                Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_HELM_TYPE] = (short)"\uffff\uffff\u0000\uffff\u0002\u0001\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\u0000\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n);
                Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_SHIELD_TYPE] = (short)"\uffff\uffff\uffff\u0000\uffff\uffff\uffff\uffff\uffff\u0001\uffff\uffff\u0002\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n);
                Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_STATE] = 35;
                Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_FP_STATE_COUNTDOWN] = 0;
                Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_SECONDARY_STATE] = 105;
                Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_FLAGS] = 0;
                Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_COUNTDOWN_FRAME] = 0;
                Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_CHILLED_COUNTDOWN] = 0;
                Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_BUTTERED_COUNTDOWN] = 0;
                Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_FROZEN_COUNTDOWN] = 0;
                Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_SUMMON_COUNTER] = 0;
                Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_GRID_LADDER_BOARD_POS] = -1;
                Zombies.setFlag(4, i);
                Zombies.setFlag(5, i);
                if (n == 22 || n == 21) {
                    Zombies.setReanim(n, i, n4, n5, false, 1);
                } else {
                    Zombies.setReanim(n, i, n4, n5, true, 0);
                }
                Zombies.setZombieUniqueAttribs(n, i);
                ++m_nZombies;
                if (n <= 20) {
                    AlmanacScreenMenu.zombiesUnlocked |= 1L << n;
                }
                return i;
            }
        }
        return -1;
    }

    static boolean isZombieAtIndex(int n) {
        return ZOMBIES[ZOMBIE_MAX_VALS * n + ZOMBIE_TYPE] != -1;
    }

    static boolean isFlagSet(int n, int n2) {
        return (ZOMBIES[n2 * ZOMBIE_MAX_VALS + ZOMBIE_FLAGS] & 1 << n) != 0;
    }

    static void setFlag(int n, int n2) {
        int n3 = n2 * ZOMBIE_MAX_VALS + ZOMBIE_FLAGS;
        ZOMBIES[n3] = ZOMBIES[n3] | 1 << n;
    }

    static void unSetFlag(int n, int n2) {
        int n3 = n2 * ZOMBIE_MAX_VALS + ZOMBIE_FLAGS;
        ZOMBIES[n3] = ZOMBIES[n3] & ~(1 << n);
    }

    static int getZombieSpeedFP(int n, int n2) {
        int n3 = n2 * FP1;
        if (n2 == -1) {
            n3 = FP.getRandFPValueAsFP(FP1 * (short)"\u00e6\u01c2\u00e6\u00e6\u01cc\u00e6\u00e6\u0406\u0294\u014a\u0082s\u0316\u00e6\u01c2\u0294\u00e6\u00e6\u00e6\u014a\n\u0258\u0258".charAt(n), FP1 * (short)"\u0172\u01c2\u0172\u0172\u01e0\u0172\u0172\u0406\u02a8\u01d6\u0082\u00a0\u032a\u0172\u01c2\u02a8\u0172\u0172\u0172\u01d6\n\u028a\u028a".charAt(n));
        }
        n3 = FP.fpMul(n3, GModel.FP_SPEED_SCALER_WIDTH);
        n3 = FP.fpMul(n3, GModel.FP_ZOMBIE_FPS_SCALER);
        n3 = FP.fpDiv(n3, FP1 * 1000);
        return -n3;
    }

    static int getGroundTrackVelFP(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = ZOMBIES[n2 + ZOMBIE_REANIM_INDEX];
        short s = (short)"\u0006\uffff2B\uffff\uffff\uffff\uffff\uffff\uffff\uffff\u00b5\u00c5\u00d9\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(Reanim.getReanimID(n3));
        if (s >= 0) {
            int n4 = ZOMBIES[n2 + ZOMBIE_REANIM_FRAME];
            int n5 = ZOMBIES[n2 + ZOMBIE_TYPE];
            int n6 = Reanim.getTrackAttributeFromTrackID(n3, ZOMBIES[n2 + ZOMBIE_REANIM_CURR_TRACK_ID], 2);
            if (n4 == n6) {
                return 0;
            }
            if (n4 > n6) {
                int n7 = Reanim.getTrackGlobalIndexFromTrackID(n3, s);
                int n8 = Reanim.nReanims[n3].nTracks[n7].nTrackFrames[n4].TRACK_FP_X;
                int n9 = Reanim.nReanims[n3].nTracks[n7].nTrackFrames[n4 - 1].TRACK_FP_X;
                int n10 = FP.fpDiv(n9 - n8, ZOMBIES[n2 + ZOMBIE_REANIM_FP_FRAMES_PER_TICK]);
                if (Zombies.isFlagSet(15, n)) {
                    n10 /= 2;
                }
                if (n5 == 16 && -n10 / 100000 > 0) {
                    n10 /= 300;
                }
                return n10;
            }
        }
        return 9999;
    }

    static int getZombieStartXFP(int n) {
        Zombies.getZombieOffsets(n, false);
        int n2 = GModel.getBoardOffsetX(Layer.getLayerProperty(2, 5)) + 270 + ZOMBIE_OFFSETS[ZOMBIE_OFFSET_CENTRE_X] + ZOMBIE_OFFSETS[ZOMBIE_OFFSET_BOARD_X] + Util.GetRandom(20);
        if (n == 20) {
            n2 = GModel.getBoardOffsetX(Layer.getLayerProperty(2, 5)) + 270 + ZOMBIE_OFFSETS[ZOMBIE_OFFSET_CENTRE_X] + ZOMBIE_OFFSETS[ZOMBIE_OFFSET_BOARD_X];
        }
        return n2 * FP1;
    }

    static int getZombieStartYFP(int n, int n2) {
        Zombies.getZombieOffsets(n, false);
        Cursor.getGridPosRect(n2 * 9, 0);
        int n3 = Cursor.GRID_POS[Cursor.GRID_POS_Y] + ZOMBIE_OFFSETS[ZOMBIE_OFFSET_TOP_Y];
        return n3 * FP1;
    }

    static void setReanim(int n, int n2, int n3, int n4, boolean bl, int n5) {
        if (n3 == -1) {
            n3 = (short)"\u0000\u0000\u0000\u0000\u0004\u0000\u0001\u0002\u0005\u0006\u0003\u0007\t\n\u000b\f\r\u0000\u000f\b\u0010\u0011\u0012".charAt(n);
        }
        if (n4 == -1 && (n4 = (int)((short)"\uffff\uffff\uffff\uffff\uffff\uffff\u001f,\uffff\uffff@\uffff\u009b\uffff\u00b0\u00c1\u00d3\uffff\uffff\uffff\u011e\u0133\u013a".charAt(n))) == -1) {
            n4 = (short)"\u0004!.AMYjv\u0089\u0098\u00a3\u00b3\u00be\u00d7\uffff\u00f2\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n3);
        }
        int n6 = n2 * ZOMBIE_MAX_VALS;
        if (n3 == -1 || n4 == -1) {
            Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_REANIM_INDEX] = -1;
            return;
        }
        Reanim.loadReanim(n3, n4);
        Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_REANIM_INDEX] = Reanim.REANIM_LOADED_TEMP_VALS[0];
        Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_REANIM_FRAME] = Reanim.REANIM_LOADED_TEMP_VALS[1];
        Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_REANIM_CURR_TRACK_GLOBAL_INDEX] = Reanim.REANIM_LOADED_TEMP_VALS[2];
        Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_REANIM_CURR_TRACK_ID] = n4;
        Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_REANIM_FP_FPS] = Reanim.REANIM_LOADED_TEMP_VALS[3] * FP1;
        Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_REANIM_START_TRACK_INDEX] = Reanim.REANIM_LOADED_TEMP_VALS[4];
        Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_REANIM_HIDDEN_TRACKS] = 0;
        Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_REANIM_LOOP_TYPE] = n5;
        Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_REANIM_LOOP_COUNT] = 0;
        Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_REANIM_HELM_TRACK_ID] = -1;
        Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_REANIM_SHIELD_TRACK_ID] = -1;
        if (bl) {
            Zombies.setReanimRandFrame(n2);
        }
        Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_REANIM_FP_FRAMES_PER_TICK] = FP.fpDiv(FP1 * 18, ZOMBIES[n6 + ZOMBIE_REANIM_FP_FPS]);
        Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_REANIM_FP_TICKS_COUNTER] = 0;
    }

    static void setReanimRandFrame(int n) {
        int n2 = n * ZOMBIE_MAX_VALS;
        int n3 = ZOMBIES[n2 + ZOMBIE_REANIM_INDEX];
        int n4 = ZOMBIES[n2 + ZOMBIE_REANIM_CURR_TRACK_ID];
        int n5 = Reanim.getTrackAttributeFromTrackID(n3, n4, 2);
        int n6 = Reanim.getTrackAttributeFromTrackID(n3, n4, 3);
        Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_REANIM_FRAME] = n5 + Util.GetRandom(n6);
    }

    static void setReanimFPS(int n, int n2, boolean bl) {
        int n3 = ZOMBIE_MAX_VALS * n;
        if (bl) {
            int n4 = ZOMBIES[n3 + ZOMBIE_REANIM_INDEX] * 3;
            n2 = Reanim.REANIM_DATA[n4 + 1] * FP1;
        }
        Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_REANIM_FP_FPS] = n2;
        Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_REANIM_FP_FRAMES_PER_TICK] = n2 <= 0 ? 0 : FP.fpDiv(FP1 * 18, ZOMBIES[n3 + ZOMBIE_REANIM_FP_FPS]);
        Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_REANIM_FP_TICKS_COUNTER] = 0;
    }

    static void getZombieOffsets(int n, boolean bl) {
        char c = "\u0000\u0001\u0002\u0000\u0003\u0004\u0005\u0006\b\t\u0007\n\f\r\u000e\u000f\u0010\u0000\u0011\u000b\u0012\u0013\u0014".charAt(n);
        if (c == '\uffffffff') {
            return;
        }
        Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_CENTRE_X] = (short)"\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uffb0\uffb0".charAt(c);
        Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_TOP_Y] = (short)"\ufff7\ufff7\ufff7\uffea\ufff7\ufffa\ufff6\ufff6\ufff6\ufff6\ufff1\ufff7\ufff7\ufffa\ufff7\ufff7\ufff1\uffec\u0000\uffd8\uffd8".charAt(c);
        if (bl) {
            Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_DRAW_X] = -((short)"\uffe4\uffe4\uffe4\uffe6\uffe4\uffc4\uffe6\uffe6\uffd3\uffe4\uffea\uffe4\uffda\uffde\uffe3\uffe3\uffe5\uffe0\uff24\uff9c\uff9c".charAt(c));
            Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_DRAW_Y] = (short)"\uffe4\uffe4\uffe4\u0000\uffe4\uffe9\ufff6\ufff1\uffe7\ufffc\ufff1\uffee\ufff9\ufff4\ufff9\ufff9\uffec\uffe7\uffba\uffce\uffce".charAt(c);
            Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_BUTTER_X] = -((short)"\u0001\u0001\uffff\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001".charAt(c));
            Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_BUTTER_Y] = (short)"\ufffb\ufffb\ufffb\ufffb\ufffb\ufffd\ufffb\ufffb\ufffb\ufffb\ufffb\ufffb\ufffb\ufffb\ufffb\ufffb\ufffb\ufff9\ufffb\ufffb\ufffb".charAt(c);
            Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_MIND_CONTROL_X] = -((short)"\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n".charAt(c));
            Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_MIND_CONTROL_Y] = (short)"\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n".charAt(c);
            Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_CHILLLED_X] = -((short)"\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\u00c8\n\n".charAt(c));
            Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_CHILLLED_Y] = (short)"\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n".charAt(c);
            Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_SHADOW_X] = -((short)"\ufff7\ufff7\ufff7\n\ufff7\u0000\ufff3\ufff2\ufffd\ufffd\ufff6\ufff7\ufff7\u0000\ufff7\ufff7\ufff8\ufff3\ufff6\ufff6\ufff6".charAt(c));
            Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_SHADOW_Y] = (short)"###1#\"%%%%/##\u0000##%-///".charAt(c);
            Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_BURN_X] = -((short)"\u0010\u0010\u0010\u001e\u00109\u0006\u0006$\u0014\uffff\u0010\t\uffff\u0010\u0010\u000f\u000e\uffff\uffff\uffff".charAt(c));
            Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_BURN_Y] = (short)"\u001b\u001b\u001b\r\u001b\u0014\u000b\u0012\u001b\u0004\uffff\u001b\u0005\uffff\r\u0005$\u0019\uffff\uffff\uffff".charAt(c);
        } else {
            Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_DRAW_X] = (short)"\uffe4\uffe4\uffe4\uffe6\uffe4\uffc4\uffe6\uffe6\uffd3\uffe4\uffea\uffe4\uffda\uffde\uffe3\uffe3\uffe5\uffe0\uff24\uff9c\uff9c".charAt(c);
            Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_DRAW_Y] = (short)"\uffe4\uffe4\uffe4\u0000\uffe4\uffe9\ufff6\ufff1\uffe7\ufffc\ufff1\uffee\ufff9\ufff4\ufff9\ufff9\uffec\uffe7\uffba\uffce\uffce".charAt(c);
            Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_BUTTER_X] = (short)"\u0001\u0001\uffff\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001".charAt(c);
            Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_BUTTER_Y] = (short)"\ufffb\ufffb\ufffb\ufffb\ufffb\ufffd\ufffb\ufffb\ufffb\ufffb\ufffb\ufffb\ufffb\ufffb\ufffb\ufffb\ufffb\ufff9\ufffb\ufffb\ufffb".charAt(c);
            Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_MIND_CONTROL_X] = (short)"\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n".charAt(c);
            Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_MIND_CONTROL_Y] = (short)"\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n".charAt(c);
            Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_CHILLLED_X] = (short)"\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\u00c8\n\n".charAt(c);
            Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_CHILLLED_Y] = (short)"\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n".charAt(c);
            Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_SHADOW_X] = (short)"\ufff7\ufff7\ufff7\n\ufff7\u0000\ufff3\ufff2\ufffd\ufffd\ufff6\ufff7\ufff7\u0000\ufff7\ufff7\ufff8\ufff3\ufff6\ufff6\ufff6".charAt(c);
            Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_SHADOW_Y] = (short)"###1#\"%%%%/##\u0000##%-///".charAt(c);
            Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_BURN_X] = (short)"\u0010\u0010\u0010\u001e\u00109\u0006\u0006$\u0014\uffff\u0010\t\uffff\u0010\u0010\u000f\u000e\uffff\uffff\uffff".charAt(c);
            Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_BURN_Y] = (short)"\u001b\u001b\u001b\r\u001b\u0014\u000b\u0012\u001b\u0004\uffff\u001b\u0005\uffff\r\u0005$\u0019\uffff\uffff\uffff".charAt(c);
        }
        Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_BOARD_X] = Math.max((short)"\u0019\u0005\u0019\u001e\u00190\u0019\u0019\u0019\u0019,\u0019\u0019\u001e\u0019\u000f\u000f%,,,".charAt(c), 0);
    }

    static void setZombieUniqueAttribs(int n, int n2) {
        int n3 = ZOMBIE_MAX_VALS * n2;
        int n4 = ZOMBIES[n3 + ZOMBIE_ROW];
        if (n == 0) {
            Zombies.hideReanimTrack(n2, 24);
            Zombies.hideReanimTrack(n2, 25);
            Zombies.hideReanimTrack(n2, 26);
            Zombies.hideReanimTrack(n2, 21);
            Zombies.hideReanimTrack(n2, 22);
            Zombies.hideReanimTrack(n2, 23);
            Zombies.hideReanimTrack(n2, 27);
            Zombies.hideReanimTrack(n2, 28);
            Zombies.hideReanimTrack(n2, 29);
            if (GModel.PLANT_ROW[n4] == 3) {
                Zombies.setFlag(14, n2);
            } else {
                Zombies.hideReanimTrack(n2, 16);
            }
            Zombies.hideReanimTrack(n2, 17);
            Zombies.hideReanimTrack(n2, 12);
            Zombies.hideReanimTrack(n2, 13);
            Zombies.hideReanimTrack(n2, 11);
        } else if (n == 5) {
            Zombies.hideReanimTrack(n2, 21);
            Zombies.hideReanimTrack(n2, 22);
            Zombies.hideReanimTrack(n2, 23);
            Zombies.hideReanimTrack(n2, 27);
            Zombies.hideReanimTrack(n2, 28);
            Zombies.hideReanimTrack(n2, 29);
            if (GModel.PLANT_ROW[n4] == 3) {
                Zombies.setFlag(14, n2);
            } else {
                Zombies.hideReanimTrack(n2, 16);
            }
            Zombies.hideReanimTrack(n2, 17);
            Zombies.hideReanimTrack(n2, 12);
            Zombies.hideReanimTrack(n2, 13);
            Zombies.hideReanimTrack(n2, 11);
            Zombies.hideReanimTrack(n2, 25);
            Zombies.hideReanimTrack(n2, 26);
            Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_REANIM_HELM_TRACK_ID] = 24;
        } else if (n == 3) {
            Zombies.hideReanimTrack(n2, 21);
            Zombies.hideReanimTrack(n2, 22);
            Zombies.hideReanimTrack(n2, 23);
            Zombies.hideReanimTrack(n2, 24);
            Zombies.hideReanimTrack(n2, 25);
            Zombies.hideReanimTrack(n2, 26);
            Zombies.hideReanimTrack(n2, 10);
            Zombies.hideReanimTrack(n2, 20);
            Zombies.hideReanimTrack(n2, 18);
            if (GModel.PLANT_ROW[n4] == 3) {
                Zombies.setFlag(14, n2);
            } else {
                Zombies.hideReanimTrack(n2, 16);
            }
            Zombies.hideReanimTrack(n2, 17);
            Zombies.hideReanimTrack(n2, 12);
            Zombies.hideReanimTrack(n2, 13);
            Zombies.hideReanimTrack(n2, 11);
            Zombies.hideReanimTrack(n2, 28);
            Zombies.hideReanimTrack(n2, 29);
            Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_REANIM_SHIELD_TRACK_ID] = 27;
        } else if (n == 2) {
            Zombies.hideReanimTrack(n2, 24);
            Zombies.hideReanimTrack(n2, 25);
            Zombies.hideReanimTrack(n2, 26);
            Zombies.hideReanimTrack(n2, 27);
            Zombies.hideReanimTrack(n2, 28);
            Zombies.hideReanimTrack(n2, 29);
            if (GModel.PLANT_ROW[n4] == 3) {
                Zombies.setFlag(14, n2);
            } else {
                Zombies.hideReanimTrack(n2, 16);
            }
            Zombies.hideReanimTrack(n2, 17);
            Zombies.hideReanimTrack(n2, 12);
            Zombies.hideReanimTrack(n2, 13);
            Zombies.hideReanimTrack(n2, 11);
            Zombies.hideReanimTrack(n2, 22);
            Zombies.hideReanimTrack(n2, 23);
            Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_REANIM_HELM_TRACK_ID] = 21;
        } else if (n == 1) {
            Zombies.hideReanimTrack(n2, 24);
            Zombies.hideReanimTrack(n2, 25);
            Zombies.hideReanimTrack(n2, 26);
            Zombies.hideReanimTrack(n2, 27);
            Zombies.hideReanimTrack(n2, 28);
            Zombies.hideReanimTrack(n2, 29);
            if (GModel.PLANT_ROW[n4] == 3) {
                Zombies.setFlag(14, n2);
            } else {
                Zombies.hideReanimTrack(n2, 16);
            }
            Zombies.hideReanimTrack(n2, 17);
            Zombies.hideReanimTrack(n2, 21);
            Zombies.hideReanimTrack(n2, 22);
            Zombies.hideReanimTrack(n2, 23);
            Zombies.hideReanimTrack(n2, 10);
            Zombies.hideReanimTrack(n2, 13);
        } else if (n == 4) {
            Zombies.hideReanimTrack(n2, 85);
            Zombies.hideReanimTrack(n2, 86);
            Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_REANIM_HELM_TRACK_ID] = 84;
        } else if (n == 9) {
            Zombies.hideReanimTrack(n2, 111);
            Zombies.hideReanimTrack(n2, 113);
        } else if (n == 6) {
            Zombies.setFlag(7, n2);
            Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_STATE] = 36;
        } else if (n == 7) {
            Zombies.setFlag(9, n2);
            Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_STATE] = 42;
            Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_FP_STATE_COUNTDOWN] = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(ZOMBIES[n3 + ZOMBIE_STATE]) * FP1;
            Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_PARAM_1] = -1;
            Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_PARAM_2] = -1;
            Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_PARAM_3] = -1;
            Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_PARAM_4] = -1;
            Zombies.calcDancerReanimConstants();
        } else if (n == 10) {
            Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_STATE] = 51;
            Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_FP_STATE_COUNTDOWN] = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(ZOMBIES[n3 + ZOMBIE_STATE]) * FP1;
        } else if (n == 8) {
            int n5 = FP.getRandFPValueAsFP(ZOMBIE_JACK_IN_THE_BOX_MIN_PX_BEFORE_EXPLODE_FP, ZOMBIE_JACK_IN_THE_BOX_MIN_PX_BEFORE_EXPLODE_FP + ZOMBIE_JACK_IN_THE_BOX_RAND_PX_BEFORE_EXPLODE_FP);
            if (Util.GetRandom(20) == 0) {
                n5 = FP.fpDiv(n5, FP1 * 3);
            }
            Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_FP_STATE_COUNTDOWN] = Math.abs(FP.fpDiv(n5, ZOMBIES[n3 + ZOMBIE_FP_VX]));
        } else if (n == 12) {
            Zombies.hideReanimTrack(n2, 161);
            Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_STATE] = 60;
        } else if (n == 13) {
            Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_PARAM_1] = (short)"\uffff\uffff\uffff\uffff\uffff\uffff\uffff\u0012\u02ee\u01c2\uffff\uffff\uffff\u0014\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n);
            Zombies.setFlag(8, n2);
        } else if (n == 14) {
            Zombies.setFlag(8, n2);
            Zombies.setState(n2, 64, true);
            Zombies.setReanimTrack(n2, 176, 0);
            Zombies.setReanimFPS(n2, 18 * FP1, false);
        } else if (n == 15) {
            Zombies.setFlag(8, n2);
            Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_REANIM_HELM_TRACK_ID] = 210;
            if (Zombies.bIsOnBoard(n2)) {
                Zombies.setState(n2, 67, true);
            } else {
                Zombies.setState(n2, 74, true);
            }
        } else if (n == 16) {
            Zombies.setFlag(8, n2);
            Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_PARAM_1] = 20;
            if (Zombies.bIsOnBoard(n2)) {
                Zombies.setState(n2, 75, true);
                int n6 = ZOMBIES[n3 + ZOMBIE_REANIM_INDEX] * 3;
                int n7 = Reanim.REANIM_DATA[n6 + 1] * FP1 / 2;
                Zombies.setReanimFPS(n2, n7, false);
                Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_FP_ALTITUDE] = -14 * FP1;
            }
        } else if (n == 17) {
            Zombies.hideReanimTrack(n2, 24);
            Zombies.hideReanimTrack(n2, 25);
            Zombies.hideReanimTrack(n2, 26);
            Zombies.hideReanimTrack(n2, 21);
            Zombies.hideReanimTrack(n2, 22);
            Zombies.hideReanimTrack(n2, 23);
            Zombies.hideReanimTrack(n2, 27);
            Zombies.hideReanimTrack(n2, 28);
            Zombies.hideReanimTrack(n2, 29);
            Zombies.hideReanimTrack(n2, 17);
            Zombies.hideReanimTrack(n2, 12);
            Zombies.hideReanimTrack(n2, 13);
            Zombies.hideReanimTrack(n2, 11);
            Zombies.setFlag(14, n2);
        } else if (n != 18) {
            if (n == 20) {
                Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_PARAM_1] = 0;
                Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_PARAM_2] = 0;
                Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_PARAM_3] = 0;
                Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_PARAM_4] = 0;
                int n8 = ZOMBIES[n3 + ZOMBIE_REANIM_INDEX] * 3;
                int n9 = Reanim.REANIM_DATA[n8 + 1] * FP1;
                int n10 = FP.fpMul(n9, FP.fpDiv(204800, 409600));
                Zombies.setReanimFPS(n2, n10, false);
                Zombies.setState(n2, 83, false);
                Zombies.setReanimTrack(n2, 285, 0);
                Zombies.hideReanimTrack(n2, 258);
                Zombies.hideReanimTrack(n2, 262);
                Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_SUMMON_COUNTER] = 5;
                Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_PARAM_1] = 83;
                Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_FLAGS] = 0;
            } else if (n == 21) {
                int n11 = ZOMBIES[n3 + ZOMBIE_REANIM_INDEX] * 3;
                int n12 = Reanim.REANIM_DATA[n11 + 1] * FP1;
                int n13 = FP.fpMul(n12, FP.fpDiv(204800, 409600));
                Zombies.setReanimFPS(n2, n13, false);
                int n14 = 97;
                Zombies.setState(n2, n14, true);
            } else if (n == 22) {
                int n15 = ZOMBIES[n3 + ZOMBIE_REANIM_INDEX] * 3;
                int n16 = Reanim.REANIM_DATA[n15 + 1] * FP1;
                int n17 = FP.fpMul(n16, FP.fpDiv(204800, 409600));
                Zombies.setReanimFPS(n2, n17, false);
                int n18 = 101;
                Zombies.setState(n2, n18, true);
            }
        }
    }

    static void update() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = m_nZombies;
        for (int i = 0; i < 100 && n < n5; ++i) {
            boolean bl;
            if (!Zombies.isZombieAtIndex(i)) continue;
            n2 = ZOMBIE_MAX_VALS * i;
            n3 = ZOMBIES[n2 + ZOMBIE_TYPE];
            n4 = ZOMBIES[n2 + ZOMBIE_STATE];
            if (n4 == 38) {
                Zombies.updateStateCountdown(i);
                bl = Zombies.updateDying(i);
                if (bl && i == 0 && GameController.m_nLevel == 49) {
                    AwardScreen.setAward(4, -1, 1);
                    break;
                }
            } else if (n4 == 39) {
                Zombies.updateStateCountdown(i);
                Zombies.updateBurned(i);
            } else if (!Zombies.bIsOnBoard(i)) {
                Zombies.updateReanim(i);
            } else {
                if (ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN] >= 0 && !Zombies.bIsImmobilized(i)) {
                    Zombies.updateStateCountdown(i);
                }
                bl = Zombies.isFlagSet(4, i);
                if (ZOMBIES[n2 + ZOMBIE_CHILLED_COUNTDOWN] > 0) {
                    Zombies.updateChilled(i);
                }
                if (ZOMBIES[n2 + ZOMBIE_BUTTERED_COUNTDOWN] > 0) {
                    Zombies.updateButtered(i);
                }
                if (ZOMBIES[n2 + ZOMBIE_FROZEN_COUNTDOWN] > 0) {
                    Zombies.updateFrozen(i);
                }
                if (n3 != 21 && n3 != 22 && !bl && Util.GetRandom(6) == 0) {
                    Zombies.updateBleeding(i);
                }
                if (n4 == 40) {
                    Zombies.updateRiseFromGrave(i);
                }
                if (!Zombies.bIsImmobilized(i) && n4 != 40) {
                    if (bl && !Zombies.isFlagSet(2, i)) {
                        if (CollisionHandler.checkAtBoardEdge(i) != -1) {
                            GModel.m_bGameOver = true;
                        } else if (!Zombies.isZombieAtIndex(i)) {
                            ++n;
                            break;
                        }
                    }
                    if (ZOMBIES[n2 + ZOMBIE_SECONDARY_STATE] == 111) {
                        Zombies.updateClimbingLadder(i);
                    } else if (ZOMBIES[n2 + ZOMBIE_SECONDARY_STATE] == 112) {
                        Zombies.updateFalling(i);
                    } else if (ZOMBIES[n2 + ZOMBIE_SECONDARY_STATE] == 107 || ZOMBIES[n2 + ZOMBIE_SECONDARY_STATE] == 106 || Zombies.isFlagSet(15, i)) {
                        Zombies.updatePool(i);
                    }
                    if (n3 == 6) {
                        Zombies.updatePoleVaulter(i);
                    } else if (n3 == 7) {
                        Zombies.updateDancer(i);
                    } else if (n3 == 10) {
                        Zombies.updateBackupDancer(i);
                    } else if (n3 == 8) {
                        Zombies.updateJackInTheBox(i);
                    } else if (n3 == 9) {
                        Zombies.updateNewsPaper(i);
                    } else if (n3 == 11) {
                        Zombies.updateGargantuar(i);
                    } else if (n3 == 19) {
                        Zombies.updateIMP(i);
                    } else if (n3 == 12) {
                        Zombies.updateLadder(i);
                    } else if (n3 == 13) {
                        Zombies.updateCatapult(i);
                    } else if (n3 == 14) {
                        Zombies.updatePogo(i);
                    } else if (n3 == 15) {
                        Zombies.updateDigger(i);
                    } else if (n3 == 16) {
                        Zombies.updateBalloon(i);
                    } else if (n3 == 18) {
                        Zombies.updateSnorkel(i);
                    } else if (n3 == 20) {
                        Zombies.updateReanim(i);
                        Zombies.updateZomboss(i);
                    } else if (n3 == 21) {
                        Zombies.updateZombossFireBall(i);
                    } else if (n3 == 22) {
                        Zombies.updateZombossIceBall(i);
                    }
                    if (n3 != 20) {
                        Zombies.updateWalking(i);
                        Zombies.checkIfEating(i);
                        Zombies.checkForPool(i);
                        if (n3 == 13 && !Zombies.isFlagSet(13, i)) {
                            Zombies.checkSquishPlants(i);
                        }
                        Zombies.updateReanim(i);
                    }
                }
            }
            ++n;
        }
    }

    static void updateStateCountdown(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        if (ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN] >= 0) {
            int n3 = FP1;
            if (ZOMBIES[n2 + ZOMBIE_CHILLED_COUNTDOWN] > 0) {
                n3 = 2048;
            }
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_STATE_COUNTDOWN] = Math.max(ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN] - n3, 0);
        }
    }

    static void checkIfEating(int n) {
        if (!Zombies.isFlagSet(4, n)) {
            return;
        }
        int n2 = n * ZOMBIE_MAX_VALS;
        if (ZOMBIES[n2 + ZOMBIE_STATE] == 61 || ZOMBIES[n2 + ZOMBIE_SECONDARY_STATE] == 111 || ZOMBIES[n2 + ZOMBIE_SECONDARY_STATE] == 112) {
            Zombies.unSetFlag(2, n);
            return;
        }
        int n3 = Zombies.checkEatingZombie(n);
        if (n3 != -1) {
            Zombies.eatZombie(n3, n);
            return;
        }
        int n4 = Zombies.checkEatingPlant(n);
        if (n4 != -1) {
            Zombies.eatPlant(n4, n);
            return;
        }
        if (Zombies.isFlagSet(2, n)) {
            Zombies.stopEating(n);
        }
    }

    static void startEating(int n) {
        if (Zombies.isFlagSet(2, n)) {
            return;
        }
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = ZOMBIES[n2 + ZOMBIE_TYPE];
        if (n3 == 19 && (ZOMBIES[n2 + ZOMBIE_STATE] == 58 || ZOMBIES[n2 + ZOMBIE_STATE] == 59)) {
            return;
        }
        Zombies.setFlag(2, n);
        Zombies.unSetFlag(1, n);
        if (n3 == 21 || n3 == 22) {
            return;
        }
        if (n3 == 12 && ZOMBIES[n2 + ZOMBIE_SHIELD_TYPE] == 2) {
            Zombies.setReanimTrack(n, 154, 0);
        } else {
            if (n3 == 15 && ZOMBIES[n2 + ZOMBIE_STATE] == 67) {
                return;
            }
            int n4 = Reanim.getReanimID(ZOMBIES[n2 + ZOMBIE_REANIM_INDEX]);
            Zombies.setReanimTrack(n, "\u0003#0?LZi\uffff\u0088\u0097\uffff\u00b2\u00bf\u00d6\uffff\u00ee\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n4), 0);
            if (Zombies.isFlagSet(15, n) && n4 == 0) {
                Zombies.hideReanimTrack(n, 14);
                Zombies.hideReanimTrack(n, 8);
                Zombies.showReanimTrack(n, 16);
            }
        }
        Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_STATE] = 37;
    }

    static void stopEating(int n) {
        if (!Zombies.isFlagSet(2, n)) {
            return;
        }
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = ZOMBIES[n2 + ZOMBIE_TYPE];
        Zombies.unSetFlag(2, n);
        if (n3 == 15 && ZOMBIES[n2 + ZOMBIE_STATE] == 67) {
            return;
        }
        if (n3 != 18) {
            Zombies.startWalking(n);
        }
        Zombies.updateAnimSpeed(n);
    }

    static void startWalking(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = ZOMBIES[n2 + ZOMBIE_TYPE];
        int n4 = Reanim.getReanimID(ZOMBIES[n2 + ZOMBIE_REANIM_INDEX]);
        int n5 = ZOMBIES[n2 + ZOMBIE_SECONDARY_STATE];
        boolean bl = Zombies.isFlagSet(15, n);
        if (Zombies.isFlagSet(4, n)) {
            if (n3 == 21) {
                Zombies.setReanimTrack(n, 308, 0);
            } else if (n3 == 22) {
                Zombies.setReanimTrack(n, 315, 0);
            } else if (n3 == 12 && ZOMBIES[n2 + ZOMBIE_SHIELD_TYPE] == 2) {
                Zombies.setReanimTrack(n, 155, 0);
            } else if (bl && n4 == 0 && n5 != 106 && n5 != 107) {
                Zombies.setReanimTrack(n, 1, 0);
            } else {
                Zombies.setReanimTrack(n, "\u0004!.AMYjv\u0089\u0098\u00a3\u00b3\u00be\u00d7\uffff\u00f2\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n4), 0);
            }
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_STATE] = 35;
        } else if (bl && n4 == 0 && n5 != 106 && n5 != 107) {
            Zombies.setReanimTrack(n, 1, 0);
        } else {
            Zombies.setReanimTrack(n, "\u0004!.AMYjv\u0089\u0098\u00a3\u00b3\u00be\u00d7\uffff\u00f2\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n4), 0);
        }
    }

    static int checkEatingPlant(int n) {
        int n2;
        int n3 = ZOMBIE_MAX_VALS * n;
        int n4 = ZOMBIES[n3 + ZOMBIE_TYPE];
        if (n4 == 11 || n4 == 20 || !Zombies.isFlagSet(4, n) || Zombies.isFlagSet(12, n) || !Zombies.bCanEatPlant(n)) {
            return -1;
        }
        int n5 = Zombies.findTargetPlant(n, 0);
        if (n5 != -1 && (n2 = Plants.PLANTS[Plants.PLANT_MAX_VALS * n5 + Plants.PLANT_TYPE]) == 27) {
            Plants.killPlant(n5);
            Zombies.setMindControlled(n);
            Zombies.bTrySpawnLevelAward(n);
            return -1;
        }
        return n5;
    }

    static int checkEatingZombie(int n) {
        if (!Zombies.isFlagSet(4, n)) {
            return -1;
        }
        int n2 = Zombies.findTargetZombie(n);
        return n2;
    }

    static boolean bCheckForLadder(int n, int n2) {
        int n3 = n2 * Plants.PLANT_MAX_VALS;
        int n4 = Plants.PLANTS[n3 + Plants.PLANT_POS];
        if (GridItem.getGridItemTypeAtPos(n4) == 0) {
            int n5 = ZOMBIE_MAX_VALS * n;
            int n6 = ZOMBIES[n5 + ZOMBIE_STATE];
            if (n6 != 35) {
                Zombies.startWalking(n);
            }
            Zombies.unSetFlag(2, n);
            if (ZOMBIES[n5 + ZOMBIE_SECONDARY_STATE] == 105 && ZOMBIES[n5 + ZOMBIE_GRID_LADDER_BOARD_POS] != n4) {
                Zombies.ZOMBIES[n5 + Zombies.ZOMBIE_SECONDARY_STATE] = 111;
                Zombies.ZOMBIES[n5 + Zombies.ZOMBIE_GRID_LADDER_BOARD_POS] = n4;
            }
            return true;
        }
        return false;
    }

    static boolean bCanEatPlant(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = ZOMBIES[n2 + ZOMBIE_STATE];
        int n4 = ZOMBIES[n2 + ZOMBIE_SECONDARY_STATE];
        int n5 = ZOMBIES[n2 + ZOMBIE_TYPE];
        return Zombies.isFlagSet(4, n) && !Zombies.isFlagSet(12, n) && !Zombies.isFlagSet(7, n) && ZOMBIES[n2 + ZOMBIE_BUTTERED_COUNTDOWN] <= 0 && n3 != 40 && n3 != 41 && n3 != 64 && n3 != 66 && n3 != 65 && n3 != 74 && n3 != 70 && n3 != 68 && n3 != 71 && n3 != 67 && n3 != 69 && n3 != 51 && n3 != 43 && n3 != 44 && n3 != 78 && (n3 != 35 || n5 != 18) && n4 != 111 && n4 != 112 && n5 != 13 && n5 != 11 && !Zombies.bIsFlying(n);
    }

    static void eatPlant(int n, int n2) {
        int n3 = ZOMBIE_MAX_VALS * n2;
        int n4 = ZOMBIES[n3 + ZOMBIE_TYPE];
        if (Zombies.bCheckForLadder(n2, n)) {
            return;
        }
        Zombies.startEating(n2);
        int n5 = n3 + ZOMBIE_COUNTDOWN_FRAME;
        ZOMBIES[n5] = ZOMBIES[n5] - 1;
        if (Zombies.isFlagSet(4, n2) && ZOMBIES[n3 + ZOMBIE_COUNTDOWN_FRAME] <= 0) {
            boolean bl = ZOMBIES[n3 + ZOMBIE_CHILLED_COUNTDOWN] > 0;
            Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_COUNTDOWN_FRAME] = bl ? (short)"\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t".charAt(n4) * 2 : (int)((short)"\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t".charAt(n4));
            Plants.takeDamage(n, 30, true);
        }
    }

    static void eatZombie(int n, int n2) {
        int n3 = ZOMBIE_MAX_VALS * n2;
        int n4 = ZOMBIES[n3 + ZOMBIE_TYPE];
        Zombies.startEating(n2);
        int n5 = n3 + ZOMBIE_COUNTDOWN_FRAME;
        ZOMBIES[n5] = ZOMBIES[n5] - 1;
        if (Zombies.isFlagSet(4, n2) && ZOMBIES[n3 + ZOMBIE_COUNTDOWN_FRAME] <= 0) {
            boolean bl = ZOMBIES[n3 + ZOMBIE_CHILLED_COUNTDOWN] > 0;
            Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_COUNTDOWN_FRAME] = bl ? (short)"\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t".charAt(n4) * 2 : (int)((short)"\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t".charAt(n4));
            Zombies.takeDamage(n, 30, -1, 2, false);
        }
    }

    static void updateChilled(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = n2 + ZOMBIE_CHILLED_COUNTDOWN;
        ZOMBIES[n3] = ZOMBIES[n3] - 1;
        if (ZOMBIES[n2 + ZOMBIE_CHILLED_COUNTDOWN] == 0) {
            Zombies.updateAnimSpeed(n);
        }
    }

    static void updateButtered(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = n2 + ZOMBIE_BUTTERED_COUNTDOWN;
        ZOMBIES[n3] = ZOMBIES[n3] - 1;
        if (!Zombies.isFlagSet(4, n)) {
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_BUTTERED_COUNTDOWN] = 0;
        }
        if (ZOMBIES[n2 + ZOMBIE_BUTTERED_COUNTDOWN] == 0) {
            Zombies.updateAnimSpeed(n);
        }
    }

    static void updateFrozen(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = n2 + ZOMBIE_FROZEN_COUNTDOWN;
        ZOMBIES[n3] = ZOMBIES[n3] - 1;
        if (ZOMBIES[n2 + ZOMBIE_FROZEN_COUNTDOWN] == 0) {
            Zombies.updateAnimSpeed(n);
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_STATE_COUNTDOWN] = "\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(ZOMBIES[n2 + ZOMBIE_STATE]) * FP1;
        }
    }

    static void updateAnimSpeed(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        if (Zombies.isFlagSet(12, n)) {
            int n3 = ZOMBIES[n2 + ZOMBIE_REANIM_INDEX] * 3;
            int n4 = Reanim.REANIM_DATA[n3 + 1] * FP1;
            int n5 = FP.fpMul(n4, FP.fpDiv(270336, 409600));
            Zombies.setReanimFPS(n, Math.max(4096, n5), false);
        } else if (ZOMBIES[n2 + ZOMBIE_FROZEN_COUNTDOWN] > 0 || ZOMBIES[n2 + ZOMBIE_BUTTERED_COUNTDOWN] > 0) {
            Zombies.setReanimFPS(n, 0, false);
            Zombies.setFlag(3, n);
        } else if (ZOMBIES[n2 + ZOMBIE_CHILLED_COUNTDOWN] > 0) {
            int n6 = ZOMBIES[n2 + ZOMBIE_REANIM_INDEX] * 3;
            int n7 = Reanim.REANIM_DATA[n6 + 1] * FP1 / 2;
            Zombies.setReanimFPS(n, Math.max(FP1, n7), false);
            Zombies.unSetFlag(3, n);
        } else {
            Zombies.setReanimFPS(n, 0, true);
            Zombies.unSetFlag(3, n);
        }
    }

    static void updateWalking(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = ZOMBIES[n2 + ZOMBIE_STATE];
        int n4 = ZOMBIES[n2 + ZOMBIE_TYPE];
        int n5 = ZOMBIES[n2 + ZOMBIE_ROW];
        int n6 = ZOMBIES[n2 + ZOMBIE_SECONDARY_STATE];
        if (n6 != 111 && n6 != 112 && (n3 == 37 || Zombies.isFlagSet(3, n))) {
            return;
        }
        if (n6 == 111 || n6 == 112 || n3 == 35 || n3 == 36 || n3 == 54 || n3 == 42 || n3 == 45 || n3 == 60 || n3 == 67 || n3 == 69 || n3 == 72 || n3 == 73 || n3 == 75 || n3 == 77 || n3 == 40 || n4 == 18 && Zombies.isFlagSet(15, n) || Zombies.bIsBouncingPogo(n)) {
            if (Zombies.isFlagSet(1, n)) {
                int n7 = n2 + ZOMBIE_COUNTDOWN_FRAME;
                ZOMBIES[n7] = ZOMBIES[n7] - 1;
                if (ZOMBIES[n2 + ZOMBIE_COUNTDOWN_FRAME] <= 0) {
                    Zombies.unSetFlag(1, n);
                }
            } else {
                int n8;
                if (ZOMBIES[n2 + ZOMBIE_BUTTERED_COUNTDOWN] <= 0) {
                    n8 = 0;
                    n8 = n4 == 13 || n3 == 67 || n3 == 69 || n3 == 75 || n3 == 79 || Zombies.bIsBouncingPogo(n) ? ZOMBIES[n2 + ZOMBIE_FP_VX] : Zombies.getGroundTrackVelFP(n);
                    if (n8 == 9999) {
                        n8 = ZOMBIES[n2 + ZOMBIE_FP_VX];
                    }
                    if (ZOMBIES[n2 + ZOMBIE_CHILLED_COUNTDOWN] > 0) {
                        n8 /= 2;
                    }
                    if (Zombies.isFlagSet(12, n)) {
                        n8 = FP.fpMul(n8, FP.fpDiv(270336, 409600));
                    }
                    if (Zombies.isFlagSet(9, n)) {
                        int n9 = n2 + ZOMBIE_FP_CENTRE_X;
                        ZOMBIES[n9] = ZOMBIES[n9] - n8;
                    } else {
                        int n10 = n2 + ZOMBIE_FP_CENTRE_X;
                        ZOMBIES[n10] = ZOMBIES[n10] + n8;
                    }
                }
                if (n3 != 36 && n3 != 42 && n3 != 45 && ZOMBIES[n2 + ZOMBIE_REANIM_FRAME] == (n8 = Reanim.getTrackStartFrame(ZOMBIES[n2 + ZOMBIE_REANIM_INDEX], ZOMBIES[n2 + ZOMBIE_REANIM_CURR_TRACK_GLOBAL_INDEX])) && (short)"\uffff\uffff\uffff\uffff\uffff\uffff\u0003\u0004\u0004\u0004\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n4) > 0) {
                    if (ZOMBIES[n2 + ZOMBIE_CHILLED_COUNTDOWN] > 0) {
                        int n11 = n2 + ZOMBIE_COUNTDOWN_FRAME;
                        ZOMBIES[n11] = ZOMBIES[n11] + (short)"\uffff\uffff\uffff\uffff\uffff\uffff\u0003\u0004\u0004\u0004\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n4) * 2;
                    } else {
                        int n12 = n2 + ZOMBIE_COUNTDOWN_FRAME;
                        ZOMBIES[n12] = ZOMBIES[n12] + (short)"\uffff\uffff\uffff\uffff\uffff\uffff\u0003\u0004\u0004\u0004\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n4);
                    }
                    Zombies.setFlag(1, n);
                }
            }
        }
    }

    static boolean updateDying(int n) {
        boolean bl = Zombies.updateReanim(n);
        Zombies.unSetFlag(1, n);
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = ZOMBIES[n2 + ZOMBIE_TYPE];
        if (n3 == 11 && ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN] <= 0 && !Zombies.isFlagSet(11, n)) {
            GCanvasController.shakeBoard(2, 4, 4);
            Zombies.setFlag(11, n);
        }
        if (n3 == 20 && ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN] <= 0 && !Zombies.isFlagSet(11, n)) {
            GCanvasController.shakeBoard(4, 4, 12);
            Zombies.setFlag(11, n);
        }
        if (bl) {
            if (n3 == 13) {
                GCanvasController.doCatapultExposion(n);
            }
            Zombies.killZombie(n, true);
        }
        return bl;
    }

    static void updateBleeding(int n) {
        int n2 = ZOMBIES[ZOMBIE_MAX_VALS * n + ZOMBIE_TYPE];
        int n3 = 3;
        if ((short)"\u010e\u010e\u010e\u010e\u010e\u010e\u01f4\u01f4\u01f4\u010e\u010e\u0bb8\u01f4\u0352\u01f4\u010e\u010e\u010e\u010e\u00c8\u2710\u7530\u7530".charAt(n2) >= 500) {
            n3 *= 3;
        }
        Zombies.takeDamage(n, n3, -1, 0, false);
    }

    static boolean updateReanim(int n) {
        boolean bl;
        if (Zombies.isFlagSet(1, n)) {
            return false;
        }
        int n2 = ZOMBIE_MAX_VALS * n;
        boolean bl2 = false;
        if (ZOMBIES[n2 + ZOMBIE_REANIM_FP_FPS] == 0) {
            return bl2;
        }
        Reanim.REANIM_UPDATE_VALS[0] = ZOMBIES[n2 + ZOMBIE_REANIM_INDEX];
        Reanim.REANIM_UPDATE_VALS[1] = ZOMBIES[n2 + ZOMBIE_REANIM_FRAME];
        Reanim.REANIM_UPDATE_VALS[2] = ZOMBIES[n2 + ZOMBIE_REANIM_CURR_TRACK_GLOBAL_INDEX];
        Reanim.REANIM_UPDATE_VALS[3] = ZOMBIES[n2 + ZOMBIE_REANIM_FP_FRAMES_PER_TICK];
        Reanim.REANIM_UPDATE_VALS[4] = ZOMBIES[n2 + ZOMBIE_REANIM_FP_TICKS_COUNTER];
        Reanim.REANIM_UPDATE_VALS[6] = ZOMBIES[n2 + ZOMBIE_REANIM_LOOP_TYPE];
        Reanim.REANIM_UPDATE_VALS[5] = ZOMBIES[n2 + ZOMBIE_REANIM_LOOP_COUNT];
        boolean bl3 = false;
        if (!Zombies.isFlagSet(0, n)) {
            bl3 = Reanim.updateReanim(Reanim.REANIM_UPDATE_VALS);
        }
        Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_REANIM_FRAME] = Reanim.REANIM_UPDATE_VALS[1];
        Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_REANIM_FP_FRAMES_PER_TICK] = Reanim.REANIM_UPDATE_VALS[3];
        Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_REANIM_FP_TICKS_COUNTER] = Reanim.REANIM_UPDATE_VALS[4];
        Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_REANIM_LOOP_COUNT] = Reanim.REANIM_UPDATE_VALS[5];
        boolean bl4 = bl = bl3 && ZOMBIES[n2 + ZOMBIE_REANIM_LOOP_TYPE] == 1 && !Zombies.isFlagSet(0, n);
        if (bl) {
            Zombies.setFlag(0, n);
        } else if (Zombies.isFlagSet(0, n)) {
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_REANIM_COUNTDOWN_FRAMES] = Math.max(0, ZOMBIES[n2 + ZOMBIE_REANIM_COUNTDOWN_FRAMES] - 1);
            if (ZOMBIES[n2 + ZOMBIE_REANIM_COUNTDOWN_FRAMES] <= 0) {
                bl2 = true;
            }
        }
        return bl2;
    }

    static void setReanimHoldCountdown(int n, int n2) {
        Zombies.ZOMBIES[Zombies.ZOMBIE_MAX_VALS * n + Zombies.ZOMBIE_REANIM_COUNTDOWN_FRAMES] = n2;
    }

    static void setReanimTrack(int n, int n2, int n3) {
        int n4 = ZOMBIE_MAX_VALS * n;
        Util.resetArray(Reanim.REANIM_LOADED_TEMP_VALS, -1);
        Reanim.setAnimTrack(Reanim.REANIM_LOADED_TEMP_VALS, ZOMBIES[n4 + ZOMBIE_REANIM_INDEX], n2);
        Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_REANIM_FRAME] = Reanim.REANIM_LOADED_TEMP_VALS[1];
        Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_REANIM_CURR_TRACK_GLOBAL_INDEX] = Reanim.REANIM_LOADED_TEMP_VALS[2];
        Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_REANIM_CURR_TRACK_ID] = n2;
        Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_REANIM_LOOP_TYPE] = n3;
        Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_REANIM_LOOP_COUNT] = 0;
        Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_REANIM_FP_TICKS_COUNTER] = 0;
        Zombies.unSetFlag(0, n);
    }

    static void incrementReanimTrack(int n, int n2) {
        int n3 = ZOMBIE_MAX_VALS * n;
        Util.resetArray(Reanim.REANIM_LOADED_TEMP_VALS, -1);
        int n4 = Reanim.incrementReanimAnimTrack(Reanim.REANIM_LOADED_TEMP_VALS, ZOMBIES[n3 + ZOMBIE_REANIM_INDEX], ZOMBIES[n3 + ZOMBIE_REANIM_CURR_TRACK_ID]);
        Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_REANIM_FRAME] = Reanim.REANIM_LOADED_TEMP_VALS[1];
        Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_REANIM_CURR_TRACK_GLOBAL_INDEX] = Reanim.REANIM_LOADED_TEMP_VALS[2];
        Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_REANIM_CURR_TRACK_ID] = n4;
        Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_REANIM_LOOP_TYPE] = n2;
        Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_REANIM_LOOP_COUNT] = 0;
    }

    static void hideReanimTrack(int n, int n2) {
        if (n2 < 0) {
            return;
        }
        int n3 = ZOMBIE_MAX_VALS * n;
        if (ZOMBIES[n3 + ZOMBIE_REANIM_CURR_TRACK_ID] == n2) {
            return;
        }
        Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_REANIM_HIDDEN_TRACKS] = Reanim.hideTrack(ZOMBIES[n3 + ZOMBIE_REANIM_INDEX], ZOMBIES[n3 + ZOMBIE_REANIM_START_TRACK_INDEX], n2, ZOMBIES[n3 + ZOMBIE_REANIM_HIDDEN_TRACKS]);
    }

    static void showReanimTrack(int n, int n2) {
        int n3 = ZOMBIE_MAX_VALS * n;
        Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_REANIM_HIDDEN_TRACKS] = Reanim.showTrack(ZOMBIES[n3 + ZOMBIE_REANIM_INDEX], ZOMBIES[n3 + ZOMBIE_REANIM_START_TRACK_INDEX], n2, ZOMBIES[n3 + ZOMBIE_REANIM_HIDDEN_TRACKS]);
    }

    static void takeDamage(int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6 = ZOMBIE_MAX_VALS * n;
        int n7 = ZOMBIES[n6 + ZOMBIE_TYPE];
        int n8 = ZOMBIES[n6 + ZOMBIE_STATE];
        if (n7 == 20 && n8 != 92 && n8 != 93 && n8 != 94) {
            return;
        }
        if (bl) {
            int n9 = n5 = n7 != 11 && n7 != 13 && n7 != 20 ? 1 : 0;
            if (n5 != 0) {
                Zombies.applyBurn(n);
                return;
            }
        }
        n5 = n2;
        if (Zombies.bIsFlying(n)) {
            n5 = Zombies.takeFlyingDamage(n, n5, n4);
        }
        if (n5 > 0 && ZOMBIES[n6 + ZOMBIE_SHIELD_TYPE] != -1) {
            n5 = Zombies.takeShieldDamage(n, n2, n4);
        }
        if (n5 > 0 && ZOMBIES[n6 + ZOMBIE_HELM_TYPE] != -1) {
            n5 = Zombies.takeHelmDamage(n, n2, n4);
        }
        if (n5 > 0) {
            Zombies.takeBodyDamage(n, n5, n4);
        }
        if (ZOMBIES[n6 + ZOMBIE_STATE] != 38) {
            if (n3 == 1) {
                Zombies.setChillZombie(n, false);
            } else if (n3 == 5) {
                Zombies.setButterZombie(n);
            }
        }
    }

    static void killZombie(int n, boolean bl) {
        int n2 = n * ZOMBIE_MAX_VALS;
        if (ZOMBIES[n2 + ZOMBIE_TYPE] == 7) {
            int n3 = -1;
            for (int i = 0; i < 4; ++i) {
                n3 = ZOMBIES[n2 + (ZOMBIE_PARAM_1 + i)];
                if (n3 == -1) continue;
                Zombies.ZOMBIES[n3 * Zombies.ZOMBIE_MAX_VALS + Zombies.ZOMBIE_PARAM_1] = -1;
            }
        } else if (ZOMBIES[n2 + ZOMBIE_TYPE] == 10) {
            int n4 = ZOMBIES[n2 + ZOMBIE_PARAM_1];
            int n5 = ZOMBIES[n2 + ZOMBIE_PARAM_2];
            if (n4 != -1 && ZOMBIES[n4 * ZOMBIE_MAX_VALS + ZOMBIE_TYPE] == 7) {
                Zombies.ZOMBIES[n4 * Zombies.ZOMBIE_MAX_VALS + (Zombies.ZOMBIE_PARAM_1 + n5)] = -1;
            }
        }
        Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_STATE] = 38;
        if (bl) {
            Zombies.dropLoot(n);
        }
        if (ZOMBIES[n2 + ZOMBIE_TYPE] != -1) {
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_TYPE] = -1;
            --m_nZombies;
        }
    }

    static void killAllZombies(int n) {
        for (int i = n; i < 100; ++i) {
            if (!Zombies.isZombieAtIndex(i)) continue;
            Zombies.killZombie(i, true);
        }
    }

    static boolean getHitRect(int n) {
        int n2 = n * ZOMBIE_MAX_VALS;
        int n3 = ZOMBIES[n2 + ZOMBIE_TYPE];
        if (n3 == -1) {
            return false;
        }
        char c = "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\t\n\b\u000b\r\u000e\u000f\u0010\u0011\u0000\u0012\f\u0013\u0014\u0015".charAt(n3);
        if (c == '\uffffffff') {
            return false;
        }
        Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_W] = (short)"\u0011\u0011\u0011\u0011\u0019\u0011\r\u0011\u0011\u0014\u00102\u0011\u0014/\u0014#\u0010(x=@".charAt(c);
        Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_H] = (short)"%%%%1%*((--7%%//%%72dd".charAt(c);
        Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_X] = Zombies.isFlagSet(9, n) ? FP.toInt(ZOMBIES[n2 + ZOMBIE_FP_CENTRE_X]) - (short)"\ufff8\ufff8\ufff8\ufff8\n\ufff8\u0002\ufff6\ufff6\ufffb\ufffb\uffdd\ufff8\ufff5\uffe9\ufff6\ufff6\ufffa\uffe1\uffb0\u0000\u0000".charAt(c) - ZOMBIE_RECT[ZOMBIE_RECT_W] : FP.toInt(ZOMBIES[n2 + ZOMBIE_FP_CENTRE_X]) + (short)"\ufff8\ufff8\ufff8\ufff8\n\ufff8\u0002\ufff6\ufff6\ufffb\ufffb\uffdd\ufff8\ufff5\uffe9\ufff6\ufff6\ufffa\uffe1\uffb0\u0000\u0000".charAt(c);
        Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_Y] = FP.toInt(ZOMBIES[n2 + ZOMBIE_FP_TOP_Y] + ZOMBIES[n2 + ZOMBIE_FP_ALTITUDE]) + (short)"\u0004\u0004\u0004\u0004\u0004\u0004\u0000\u0003\u0003\u0000\u0000\u0000\u0004\u0004\u0000\u0004\u0004\u0000\t\uffce\uffce\uffce".charAt(c);
        return true;
    }

    static boolean getAttackRect(int n) {
        int n2 = n * ZOMBIE_MAX_VALS;
        int n3 = ZOMBIES[n2 + ZOMBIE_TYPE];
        short s = (short)"\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\t\n\b\u000b\r\u000e\u000f\u0010\u0011\u0000\u0012\f\u0013\u0014\u0015".charAt(n3);
        if (s == -1) {
            return false;
        }
        Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_W] = (short)"\n\n\n\n\n\n\n\n\n\r\r(\u0011\r#\f\u0014\u000b\u0014\u00a0\r\r".charAt(s);
        Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_H] = (short)"%%%%/%*((--7%%/%%%7\u0118--".charAt(s);
        Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_X] = Zombies.isFlagSet(9, n) ? FP.toInt(ZOMBIES[n2 + ZOMBIE_FP_CENTRE_X]) - (short)"\ufff5\ufff5\ufff5\ufff5\u0004\ufff5\ufffb\ufffb\ufffb\ufff6\ufff6\uffd8\ufff5\ufff0\uffec\ufff4\ufff4\ufff6\uffe8\uff9c\ufff6\ufff6".charAt(s) - ZOMBIE_RECT[ZOMBIE_RECT_W] : FP.toInt(ZOMBIES[n2 + ZOMBIE_FP_CENTRE_X]) + (short)"\ufff5\ufff5\ufff5\ufff5\u0004\ufff5\ufffb\ufffb\ufffb\ufff6\ufff6\uffd8\ufff5\ufff0\uffec\ufff4\ufff4\ufff6\uffe8\uff9c\ufff6\ufff6".charAt(s);
        Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_Y] = FP.toInt(ZOMBIES[n2 + ZOMBIE_FP_TOP_Y] + ZOMBIES[n2 + ZOMBIE_FP_ALTITUDE]) + (short)"\u0004\u0004\u0004\u0004\u0004\u0004\u0000\u0003\u0003\u0000\u0000\u0000\u0004\u0004\u0000\u0000\u0000\u0000\t\uff74\u0000\u0000".charAt(s);
        return true;
    }

    static void dropHead(int n) {
        if (!Zombies.bCanLoseBodyParts(n)) {
            return;
        }
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = ZOMBIES[n2 + ZOMBIE_TYPE];
        Zombies.unSetFlag(4, n);
        int n4 = ZOMBIES[n2 + ZOMBIE_REANIM_INDEX];
        int n5 = Reanim.getReanimID(n4);
        short s = (short)"\u0013*:ISar\u0081\u0092\u00a0\u00ab\u00bb\u00cb\u00df\u00e7\u00fa\u0131\uffff\uffff\u014a\uffff\u015e\uffff\uffff\uffff\uffff\u017f\uffff\uffff\uffff\uffff\u01a0\u01ab\uffff\u01b7\uffff\uffff\uffff\uffff\uffff\u01de\u01e2\uffff\uffff\uffff\u0200\uffff\u020a\uffff\u0220\uffff".charAt(n5);
        if (s >= 0) {
            int n6;
            int n7;
            if (n3 == 6) {
                Zombies.hideReanimTrack(n, 38);
                Zombies.hideReanimTrack(n, 39);
                Zombies.hideReanimTrack(n, 40);
            } else if (n3 == 14) {
                Zombies.dropPogo(n, 0);
            }
            Zombies.hideReanimTrack(n, s);
            Reanim.getTrackDrawPos(n4, s, ZOMBIES[n2 + ZOMBIE_REANIM_FRAME], Zombies.isFlagSet(9, n));
            int n8 = Reanim.getTrackImgID(n4, s, ZOMBIES[n2 + ZOMBIE_REANIM_FRAME]);
            if (n8 > -1) {
                Zombies.getZombieOffsets(n3, Zombies.isFlagSet(9, n));
                n7 = FP.toInt(ZOMBIES[n2 + ZOMBIE_FP_CENTRE_X]) + ZOMBIE_OFFSETS[ZOMBIE_OFFSET_DRAW_X] + Reanim.m_nTrackPosX;
                n6 = FP.toInt(ZOMBIES[n2 + ZOMBIE_FP_TOP_Y]) + ZOMBIE_OFFSETS[ZOMBIE_OFFSET_DRAW_Y] + Reanim.m_nTrackPosY;
                boolean bl = false;
                if (Zombies.isFlagSet(15, n)) {
                    bl = true;
                }
                GFParticleEmitter.doParticleZombieDropItem(1, n7, n6, ZOMBIES[n2 + ZOMBIE_ROW], n8, Zombies.isFlagSet(9, n), bl);
            }
            if (n3 == 16) {
                Zombies.hideReanimTrack(n, 225);
                Reanim.getTrackDrawPos(n4, 225, ZOMBIES[n2 + ZOMBIE_REANIM_FRAME], Zombies.isFlagSet(9, n));
                n8 = Reanim.getTrackImgID(n4, 225, ZOMBIES[n2 + ZOMBIE_REANIM_FRAME]);
                if (n8 > -1) {
                    Zombies.getZombieOffsets(n3, Zombies.isFlagSet(9, n));
                    n7 = FP.toInt(ZOMBIES[n2 + ZOMBIE_FP_CENTRE_X]) + ZOMBIE_OFFSETS[ZOMBIE_OFFSET_DRAW_X] + Reanim.m_nTrackPosX;
                    n6 = FP.toInt(ZOMBIES[n2 + ZOMBIE_FP_TOP_Y]) + ZOMBIE_OFFSETS[ZOMBIE_OFFSET_DRAW_Y] + Reanim.m_nTrackPosY;
                    GFParticleEmitter.doParticleZombieDropItem(4, n7, n6, ZOMBIES[n2 + ZOMBIE_ROW], n8, Zombies.isFlagSet(9, n), false);
                }
            }
        }
    }

    static void dropArm(int n) {
        if (!Zombies.bCanLoseBodyParts(n)) {
            return;
        }
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = ZOMBIES[n2 + ZOMBIE_TYPE];
        int n4 = ZOMBIES[n2 + ZOMBIE_STATE];
        if (n4 == 78 || n4 == 53) {
            return;
        }
        Zombies.unSetFlag(5, n);
        int n5 = ZOMBIES[n2 + ZOMBIE_REANIM_INDEX];
        int n6 = Reanim.getReanimID(n5);
        int n7 = "\u0014+<JWcq\u0083\uffff\u00a2\uffff\u00bc\u00cc\u00e0\uffff\u00fb\uffff\uffff\uffff\uffff\uffff\uffff\u0167\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n6);
        if (n3 == 12) {
            n7 = 161;
        } else if (n3 == 1) {
            Zombies.hideReanimTrack(n, 12);
            Zombies.showReanimTrack(n, 13);
        }
        boolean bl = false;
        if (Zombies.isFlagSet(15, n) && n6 == 0) {
            n7 = 18;
            bl = true;
        }
        if (n7 >= 0) {
            Zombies.hideReanimTrack(n, n7);
            Reanim.getTrackDrawPos(n5, n7, ZOMBIES[n2 + ZOMBIE_REANIM_FRAME], Zombies.isFlagSet(9, n));
            int n8 = Reanim.getTrackImgID(n5, n7, ZOMBIES[n2 + ZOMBIE_REANIM_FRAME]);
            if (n8 > -1) {
                Zombies.getZombieOffsets(n3, Zombies.isFlagSet(9, n));
                int n9 = FP.toInt(ZOMBIES[n2 + ZOMBIE_FP_CENTRE_X]) + ZOMBIE_OFFSETS[ZOMBIE_OFFSET_DRAW_X] + Reanim.m_nTrackPosX;
                int n10 = FP.toInt(ZOMBIES[n2 + ZOMBIE_FP_TOP_Y]) + ZOMBIE_OFFSETS[ZOMBIE_OFFSET_DRAW_Y] + Reanim.m_nTrackPosY;
                GFParticleEmitter.doParticleZombieDropItem(2, n9, n10, ZOMBIES[n2 + ZOMBIE_ROW], n8, Zombies.isFlagSet(9, n), bl);
            }
        }
    }

    static void dropLootItem(int n, int n2, int n3, int n4) {
        int n5 = n * ZOMBIE_MAX_VALS;
        int n6 = ZOMBIES[n5 + ZOMBIE_ROW];
        Cursor.getGridPosRect(20, 0);
        int n7 = Cursor.GRID_POS[Cursor.GRID_POS_X];
        int n8 = Cursor.GRID_POS[Cursor.GRID_POS_Y];
        int n9 = n8 + Cursor.GRID_POS[Cursor.GRID_POS_H];
        int n10 = Coins.addCoin(n2, n7, n8, n9, -1, n4);
        if (n2 == 3) {
            Coins.COINS[Coins.COIN_MAX_VALS * n10 + Coins.COIN_SEED_TYPE] = n3;
        }
        GCanvasController.doAwardStars(n10, true);
    }

    static void dropHelm(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = ZOMBIES[n2 + ZOMBIE_TYPE];
        Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_HELM_TYPE] = -1;
        int n4 = ZOMBIES[n2 + ZOMBIE_REANIM_INDEX];
        int n5 = ZOMBIES[n2 + ZOMBIE_REANIM_HELM_TRACK_ID];
        if (n5 >= 0) {
            Zombies.hideReanimTrack(n, n5);
            Reanim.getTrackDrawPos(n4, n5, ZOMBIES[n2 + ZOMBIE_REANIM_FRAME], Zombies.isFlagSet(9, n));
            Zombies.getZombieOffsets(n3, Zombies.isFlagSet(9, n));
            int n6 = FP.toInt(ZOMBIES[n2 + ZOMBIE_FP_CENTRE_X]) + ZOMBIE_OFFSETS[ZOMBIE_OFFSET_DRAW_X] + Reanim.m_nTrackPosX;
            int n7 = FP.toInt(ZOMBIES[n2 + ZOMBIE_FP_TOP_Y]) + ZOMBIE_OFFSETS[ZOMBIE_OFFSET_DRAW_Y] + Reanim.m_nTrackPosY;
            int n8 = Reanim.getTrackImgID(n4, n5, ZOMBIES[n2 + ZOMBIE_REANIM_FRAME]);
            if (n8 != -1) {
                GFParticleEmitter.doParticleZombieDropItem(1, n6, n7, ZOMBIES[n2 + ZOMBIE_ROW], n8, Zombies.isFlagSet(9, n), false);
            }
        }
    }

    static void dropShield(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = ZOMBIES[n2 + ZOMBIE_TYPE];
        Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_SHIELD_TYPE] = -1;
        Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_HEALTH_SHIELD] = 0;
        if (n3 == 3) {
            Zombies.hideReanimTrack(n, ZOMBIES[n2 + ZOMBIE_REANIM_SHIELD_TRACK_ID]);
            Zombies.showReanimTrack(n, 10);
            Zombies.showReanimTrack(n, 20);
            Zombies.showReanimTrack(n, 18);
        } else if (n3 == 9) {
            Zombies.unSetFlag(2, n);
            Zombies.unSetFlag(1, n);
            Zombies.setState(n, 53, true);
            Zombies.setReanimTrack(n, 108, 0);
            Zombies.hideReanimTrack(n, 115);
            Zombies.showReanimTrack(n, 111);
            Zombies.showReanimTrack(n, 113);
        } else if (n3 == 12) {
            Zombies.unSetFlag(2, n);
            Zombies.setState(n, 35, true);
            Zombies.setReanimTrack(n, 152, 0);
            Zombies.hideReanimTrack(n, 162);
            Zombies.showReanimTrack(n, 161);
        }
    }

    static int findTargetPlant(int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = -1;
        int n11 = -1;
        Zombies.getAttackRect(n);
        int n12 = ZOMBIE_RECT[ZOMBIE_RECT_X];
        int n13 = ZOMBIE_RECT[ZOMBIE_RECT_Y];
        int n14 = ZOMBIE_RECT[ZOMBIE_RECT_W];
        int n15 = ZOMBIE_RECT[ZOMBIE_RECT_H];
        n12 += GCanvas.getAttackX();
        int n16 = ZOMBIE_MAX_VALS * n;
        int n17 = ZOMBIES[n16 + ZOMBIE_TYPE];
        int n18 = 0;
        for (n4 = 0; n4 < Plants.MAX_NUM_PLANTS && n5 < Plants.m_nPlants; ++n4) {
            if (!Plants.isPlantAtIndex(n4)) continue;
            if (!Zombies.bCanTargetPlant(n4, n, n2)) {
                ++n5;
                continue;
            }
            if (Plants.getHitRect(n4)) {
                n6 = Plants.PLANT_RECT[Plants.PLANT_RECT_X];
                n7 = Plants.PLANT_RECT[Plants.PLANT_RECT_Y];
                n8 = Plants.PLANT_RECT[Plants.PLANT_RECT_W];
                n9 = Plants.PLANT_RECT[Plants.PLANT_RECT_H];
                if (n17 == 6 && Zombies.isFlagSet(7, n)) {
                    n8 += n8 >> 1;
                }
                n3 = 0;
                if (n12 + (n14 >> 1) < n6) {
                    n3 = 1;
                }
                if (n3 == 0) {
                    n18 = CollisionHandler.getRectOverlap(n12, n13, n14, n15, n6, n7, n8, n9);
                }
                if (n18 < 0 || n3 != 0) {
                    ++n5;
                    continue;
                }
                if (n6 > n10) {
                    n10 = n6;
                    n11 = n4;
                }
            }
            ++n5;
        }
        if (n11 != -1 && n17 != 20 && n17 != 21 && n17 != 22 && (GModel.PLANT_ROW[n4 = Plants.getRow(n11)] == 3 || GameController.m_nLevel >= 40)) {
            n3 = Plants.PLANT_MAX_VALS * n11;
            int n19 = Plants.PLANTS[n3 + Plants.PLANT_POS];
            Plants.getPlantsOnLawn(n19);
            if (Plants.PLANT_POS_TYPES[Plants.PLANT_POS_TYPE_UNDER_PLANT] == 29 || Plants.PLANT_POS_TYPES[Plants.PLANT_POS_TYPE_UNDER_PLANT] == 30) {
                int n20 = Plants.PLANT_POS_TYPES[Plants.PLANT_POS_TYPE_NORMAL_PLANT];
                if (n20 == 11) {
                    int n21 = Plants.PLANT_POS_INDEXES[Plants.PLANT_POS_TYPE_NORMAL_PLANT];
                    int n22 = n21 * Plants.PLANT_MAX_VALS;
                    if (Plants.PLANTS[n22 + Plants.PLANT_STATE] < 14) {
                        n11 = n21;
                    }
                } else if (Plants.PLANT_POS_TYPES[Plants.PLANT_POS_TYPE_PUMPKIN_PLANT] != -1) {
                    n11 = Plants.PLANT_POS_INDEXES[Plants.PLANT_POS_TYPE_PUMPKIN_PLANT];
                } else if (Plants.PLANT_POS_TYPES[Plants.PLANT_POS_TYPE_NORMAL_PLANT] != -1) {
                    n11 = Plants.PLANT_POS_INDEXES[Plants.PLANT_POS_TYPE_NORMAL_PLANT];
                }
            }
        }
        return n11;
    }

    static int findTargetZombie(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = ZOMBIES[n2 + ZOMBIE_STATE];
        int n4 = ZOMBIES[n2 + ZOMBIE_ROW];
        boolean bl = Zombies.isFlagSet(12, n);
        if (n3 == 67) {
            return -1;
        }
        Zombies.getAttackRect(n);
        int n5 = ZOMBIE_RECT[ZOMBIE_RECT_X];
        int n6 = ZOMBIE_RECT[ZOMBIE_RECT_Y];
        int n7 = ZOMBIE_RECT[ZOMBIE_RECT_W];
        int n8 = ZOMBIE_RECT[ZOMBIE_RECT_H];
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        boolean bl2 = false;
        for (int i = 0; i < 100 && n10 < m_nZombies; ++i) {
            if (!Zombies.isZombieAtIndex(i)) continue;
            if (i == n) {
                ++n10;
                continue;
            }
            n11 = ZOMBIE_MAX_VALS * i;
            if (n4 != ZOMBIES[n11 + ZOMBIE_ROW]) {
                ++n10;
                continue;
            }
            bl2 = Zombies.isFlagSet(12, i);
            if (bl && bl2 || !bl && !bl2) {
                ++n10;
                continue;
            }
            n12 = ZOMBIES[n11 + ZOMBIE_STATE];
            n13 = ZOMBIES[n11 + ZOMBIE_TYPE];
            if (Zombies.bIsFlying(i) || !Zombies.isFlagSet(4, i) || n12 == 67 || n13 == 18 && n12 == 35) {
                ++n10;
                continue;
            }
            Zombies.getHitRect(i);
            n9 = CollisionHandler.getRectOverlap(n5, n6, n7, n8, ZOMBIE_RECT[ZOMBIE_RECT_X], ZOMBIE_RECT[ZOMBIE_RECT_Y], ZOMBIE_RECT[ZOMBIE_RECT_W], ZOMBIE_RECT[ZOMBIE_RECT_H]);
            if (n9 >= 0) {
                return i;
            }
            ++n10;
        }
        return -1;
    }

    static int getZombieLeadFPX(int n, int n2) {
        int n3 = ZOMBIE_MAX_VALS * n;
        int n4 = ZOMBIES[n3 + ZOMBIE_FP_VX];
        if (Zombies.bIsImmobilized(n) || Zombies.isFlagSet(2, n) || Zombies.isFlagSet(1, n)) {
            n4 = 0;
        } else {
            if (ZOMBIES[n3 + ZOMBIE_CHILLED_COUNTDOWN] > 0) {
                n4 /= 2;
            }
            if (Zombies.isFlagSet(12, n)) {
                n4 = FP.fpMul(n4, FP.fpDiv(270336, 409600));
            }
            if (Zombies.isFlagSet(9, n)) {
                n4 = -n4;
            }
        }
        int n5 = FP.fpMul(n4, FP1 * n2);
        Zombies.getHitRect(n);
        return ZOMBIE_RECT[ZOMBIE_RECT_X] * FP1 + n5;
    }

    static boolean bCanTargetPlant(int n, int n2, int n3) {
        int n4 = n * Plants.PLANT_MAX_VALS;
        int n5 = Plants.PLANTS[n4 + Plants.PLANT_STATE];
        int n6 = Plants.getRow(n);
        int n7 = Plants.PLANTS[n4 + Plants.PLANT_TYPE];
        int n8 = n2 * ZOMBIE_MAX_VALS;
        int n9 = ZOMBIES[n8 + ZOMBIE_TYPE];
        int n10 = ZOMBIES[n8 + ZOMBIE_ROW];
        int n11 = ZOMBIES[n8 + ZOMBIE_STATE];
        if (n10 != n6 && n9 != 20) {
            return false;
        }
        if (n5 == 15 || n5 == 17 || n5 == 18 || n5 == 16) {
            return false;
        }
        if (n3 == 3) {
            if (n7 == 7 || n7 == 12 || n7 == 11) {
                return false;
            }
            if (n7 == 28 || n7 == 26) {
                return false;
            }
        }
        if (n11 == 67) {
            return n7 == 8 && n5 == 8;
        }
        if (n7 == 13) {
            return n9 == 11;
        }
        if (n3 == 2) {
            if (n7 == 4 || n7 == 15) {
                return GridItem.getGridItemTypeAtPos(Plants.PLANTS[n4 + Plants.PLANT_POS]) != 0;
            }
            return false;
        }
        return true;
    }

    static void setChillZombie(int n, boolean bl) {
        if (!Zombies.bCanBeChilled(n)) {
            return;
        }
        int n2 = ZOMBIE_MAX_VALS * n;
        boolean bl2 = ZOMBIES[n2 + ZOMBIE_CHILLED_COUNTDOWN] > 0;
        int n3 = 180;
        if (bl) {
            n3 *= 2;
        }
        Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_CHILLED_COUNTDOWN] = Math.max(ZOMBIES[n2 + ZOMBIE_CHILLED_COUNTDOWN], n3);
        if (!bl2) {
            Zombies.updateAnimSpeed(n);
        }
    }

    static void setFreezeZombie(int n) {
        int n2 = n * ZOMBIE_MAX_VALS;
        Zombies.getHitRect(n);
        if (ZOMBIE_RECT[ZOMBIE_RECT_X] > Layer.getLayerProperty(2, 3)) {
            return;
        }
        boolean bl = false;
        if (ZOMBIES[n2 + ZOMBIE_CHILLED_COUNTDOWN] > 0 || Zombies.isFlagSet(3, n)) {
            bl = true;
        }
        Zombies.setChillZombie(n, true);
        if (!Zombies.bCanBeFrozen(n)) {
            return;
        }
        Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FROZEN_COUNTDOWN] = Zombies.isFlagSet(15, n) ? 54 : (bl ? Util.getRandValue(54, 72) : Util.getRandValue(72, 108));
        Zombies.setFlag(3, n);
        Zombies.takeDamage(n, 20, -1, 2, false);
        Zombies.updateAnimSpeed(n);
        GCanvasController.doIceTrap(n, ZOMBIES[n2 + ZOMBIE_FROZEN_COUNTDOWN]);
    }

    static void setButterZombie(int n) {
        boolean bl = Zombies.isFlagSet(4, n);
        if (bl) {
            int n2 = ZOMBIE_MAX_VALS * n;
            int n3 = ZOMBIES[n2 + ZOMBIE_TYPE];
            if (!Zombies.bCanBeFrozen(n) || n3 == 20 || n3 == 21 || n3 == 22) {
                return;
            }
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_BUTTERED_COUNTDOWN] = 72;
            Zombies.setFlag(3, n);
            Zombies.updateAnimSpeed(n);
        }
    }

    static void setZombieToDying(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = ZOMBIES[n2 + ZOMBIE_TYPE];
        int n4 = ZOMBIES[n2 + ZOMBIE_STATE];
        Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_STATE] = 38;
        if (Zombies.isFlagSet(3, n)) {
            Zombies.setReanimFPS(n, 18 * FP1, true);
            Zombies.unSetFlag(3, n);
        }
        int n5 = Reanim.getReanimID(ZOMBIES[n2 + ZOMBIE_REANIM_INDEX]);
        if (n3 == 13) {
            Zombies.setReanimTrack(n, 165, 1);
            Zombies.setReanimHoldCountdown(n, 18);
            if (ZOMBIES[n2 + ZOMBIE_BUTTERED_COUNTDOWN] > 0) {
                Zombies.killZombie(n, true);
            }
        } else if (ZOMBIES[n2 + ZOMBIE_TYPE] == 20) {
            Zombies.killAllZombies(1);
            Zombies.setReanimTrack(n, "\u0002\"1>K\\hy\u0087\u0099\uffff\u00b1\u00c0\u00d8\uffff\u00ed\u0132\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n5), 1);
            Zombies.setReanimHoldCountdown(n, 18);
        } else if (n5 >= 0 && (short)"\u0002\"1>K\\hy\u0087\u0099\uffff\u00b1\u00c0\u00d8\uffff\u00ed\u0132\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n5) >= 0) {
            if (Zombies.isFlagSet(15, n) && n5 == 0) {
                Zombies.setReanimTrack(n, 0, 1);
            } else {
                Zombies.setReanimTrack(n, "\u0002\"1>K\\hy\u0087\u0099\uffff\u00b1\u00c0\u00d8\uffff\u00ed\u0132\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n5), 1);
                if (n3 == 11 && ZOMBIES[n2 + ZOMBIE_PARAM_1] == 1) {
                    Zombies.hideReanimTrack(n, 124);
                }
                Zombies.setReanimHoldCountdown(n, 18);
            }
            if (ZOMBIES[n2 + ZOMBIE_FROZEN_COUNTDOWN] > 0) {
                Zombies.killZombie(n, true);
            }
        } else {
            Zombies.killZombie(n, true);
        }
        if (ZOMBIES[n2 + ZOMBIE_TYPE] == 11) {
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_STATE_COUNTDOWN] = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(57) * FP1;
        }
    }

    static void takeBodyDamage(int n, int n2, int n3) {
        int n4 = ZOMBIE_MAX_VALS * n;
        int n5 = ZOMBIES[n4 + ZOMBIE_TYPE];
        int n6 = n4 + ZOMBIE_HEALTH_BODY;
        ZOMBIES[n6] = ZOMBIES[n6] - n2;
        if (n5 == 13 && GModel.bCheckFlags(n3, 1)) {
            Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_HEALTH_BODY] = 0;
            Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_STATE] = 38;
            Zombies.setReanimTrack(n, 166, 1);
            Zombies.setReanimHoldCountdown(n, 9);
            Zombies.dropLoot(n);
            return;
        }
        if (n5 == 19 && GModel.bCheckFlags(n3, 1)) {
            return;
        }
        if (ZOMBIES[n4 + ZOMBIE_HEALTH_BODY] <= 0) {
            Zombies.setZombieToDying(n);
            Zombies.dropLoot(n);
        } else {
            short s = (short)"\u010e\u010e\u010e\u010e\u010e\u010e\u01f4\u01f4\u01f4\u010e\u010e\u0bb8\u01f4\u0352\u01f4\u010e\u010e\u010e\u010e\u00c8\u2710\u7530\u7530".charAt(ZOMBIES[n4 + ZOMBIE_TYPE]);
            boolean bl = Zombies.isFlagSet(4, n);
            boolean bl2 = Zombies.isFlagSet(5, n);
            if (bl && ZOMBIES[n4 + ZOMBIE_HEALTH_BODY] < s / 3) {
                if (n5 != 21 && n5 != 22) {
                    Zombies.dropHead(n);
                    Zombies.dropLoot(n);
                }
                if (GModel.m_bDroppedLevelAward) {
                    Zombies.setZombieToDying(n);
                }
            } else if (bl2 && ZOMBIES[n4 + ZOMBIE_HEALTH_BODY] < 2 * s / 3) {
                Zombies.dropArm(n);
            }
        }
    }

    static int takeHelmDamage(int n, int n2, int n3) {
        int n4 = ZOMBIE_MAX_VALS * n;
        int n5 = ZOMBIES[n4 + ZOMBIE_TYPE];
        int n6 = Zombies.GetHelmDamageIndex(n);
        int n7 = Math.min(ZOMBIES[n4 + ZOMBIE_HEALTH_HELM], n2);
        int n8 = n4 + ZOMBIE_HEALTH_HELM;
        ZOMBIES[n8] = ZOMBIES[n8] - n7;
        int n9 = n2 - n7;
        if (ZOMBIES[n4 + ZOMBIE_HEALTH_HELM] <= 0) {
            Zombies.dropHelm(n);
            return n9;
        }
        int n10 = Zombies.GetHelmDamageIndex(n);
        if (n6 != n10) {
            if (n5 == 2) {
                Zombies.hideReanimTrack(n, ZOMBIES[n4 + ZOMBIE_REANIM_HELM_TRACK_ID]);
                if (ZOMBIES[n4 + ZOMBIE_REANIM_HELM_TRACK_ID] == 21) {
                    Zombies.showReanimTrack(n, 22);
                    Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_REANIM_HELM_TRACK_ID] = 22;
                } else if (ZOMBIES[n4 + ZOMBIE_REANIM_HELM_TRACK_ID] == 22) {
                    Zombies.showReanimTrack(n, 23);
                    Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_REANIM_HELM_TRACK_ID] = 23;
                }
            } else if (n5 == 5) {
                Zombies.hideReanimTrack(n, ZOMBIES[n4 + ZOMBIE_REANIM_HELM_TRACK_ID]);
                if (ZOMBIES[n4 + ZOMBIE_REANIM_HELM_TRACK_ID] == 24) {
                    Zombies.showReanimTrack(n, 25);
                    Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_REANIM_HELM_TRACK_ID] = 25;
                } else if (ZOMBIES[n4 + ZOMBIE_REANIM_HELM_TRACK_ID] == 25) {
                    Zombies.showReanimTrack(n, 26);
                    Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_REANIM_HELM_TRACK_ID] = 26;
                }
            } else if (n5 == 4) {
                Zombies.hideReanimTrack(n, ZOMBIES[n4 + ZOMBIE_REANIM_HELM_TRACK_ID]);
                if (ZOMBIES[n4 + ZOMBIE_REANIM_HELM_TRACK_ID] == 84) {
                    Zombies.showReanimTrack(n, 85);
                    Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_REANIM_HELM_TRACK_ID] = 85;
                } else if (ZOMBIES[n4 + ZOMBIE_REANIM_HELM_TRACK_ID] == 85) {
                    Zombies.showReanimTrack(n, 86);
                    Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_REANIM_HELM_TRACK_ID] = 86;
                }
            }
        }
        return n9;
    }

    static int takeShieldDamage(int n, int n2, int n3) {
        int n4 = ZOMBIE_MAX_VALS * n;
        int n5 = ZOMBIES[n4 + ZOMBIE_TYPE];
        int n6 = Zombies.GetShieldDamageIndex(n);
        int n7 = Math.min(ZOMBIES[n4 + ZOMBIE_HEALTH_SHIELD], n2);
        int n8 = n4 + ZOMBIE_HEALTH_SHIELD;
        ZOMBIES[n8] = ZOMBIES[n8] - n7;
        int n9 = n2 - n7;
        if (ZOMBIES[n4 + ZOMBIE_HEALTH_SHIELD] <= 0) {
            Zombies.dropShield(n);
            return n9;
        }
        int n10 = Zombies.GetShieldDamageIndex(n);
        if (n6 != n10 && n5 == 3) {
            Zombies.hideReanimTrack(n, ZOMBIES[n4 + ZOMBIE_REANIM_SHIELD_TRACK_ID]);
            if (ZOMBIES[n4 + ZOMBIE_REANIM_SHIELD_TRACK_ID] == 27) {
                Zombies.showReanimTrack(n, 28);
                Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_REANIM_SHIELD_TRACK_ID] = 28;
            } else if (ZOMBIES[n4 + ZOMBIE_REANIM_SHIELD_TRACK_ID] == 28) {
                Zombies.showReanimTrack(n, 29);
                Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_REANIM_SHIELD_TRACK_ID] = 29;
            }
        }
        return n9;
    }

    static int takeFlyingDamage(int n, int n2, int n3) {
        int n4 = ZOMBIE_MAX_VALS * n;
        int n5 = Math.min(ZOMBIES[n4 + ZOMBIE_PARAM_1], n2);
        int n6 = n2 - n5;
        int n7 = n4 + ZOMBIE_PARAM_1;
        ZOMBIES[n7] = ZOMBIES[n7] - n5;
        if (ZOMBIES[n4 + ZOMBIE_PARAM_1] == 0) {
            Zombies.landFlyer(n, n3);
        }
        return n6;
    }

    static int GetHelmDamageIndex(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = ZOMBIES[n2 + ZOMBIE_HEALTH_HELM];
        int n4 = ZOMBIES[n2 + ZOMBIE_TYPE];
        if (n3 < (short)"\uffff\uffff\u0172\uffff\u0578\u0578\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffd\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n4) / 3) {
            return 2;
        }
        if (n3 < (short)"\uffff\uffff\u0172\uffff\u0578\u0578\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffd\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n4) * 2 / 3) {
            return 1;
        }
        return 0;
    }

    static int GetShieldDamageIndex(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = ZOMBIES[n2 + ZOMBIE_HEALTH_SHIELD];
        int n4 = ZOMBIES[n2 + ZOMBIE_TYPE];
        if (n3 < (short)"\uffff\uffff\uffff\u0320\uffff\uffff\uffff\uffff\uffff\u0096\uffff\uffff\u01f4\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n4) / 3) {
            return 2;
        }
        if (n3 < (short)"\uffff\uffff\uffff\u0320\uffff\uffff\uffff\uffff\uffff\u0096\uffff\uffff\u01f4\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n4) * 2 / 3) {
            return 1;
        }
        return 0;
    }

    static boolean bIsImmobilized(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        return ZOMBIES[n2 + ZOMBIE_BUTTERED_COUNTDOWN] > 0;
    }

    static boolean bDrawShadow(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = ZOMBIES[n2 + ZOMBIE_STATE];
        int n4 = ZOMBIES[n2 + ZOMBIE_TYPE];
        return n3 != 38 && n3 != 39 && n3 != 68 && n3 != 69 && n3 != 70 && n3 != 67 && n3 != 40 && n3 != 51 && n3 != 41 && n3 != 78 && n4 != 13 && n4 != 22 && n4 != 21 && !Zombies.isFlagSet(15, n);
    }

    static boolean bDrawHealthBar(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = ZOMBIES[n2 + ZOMBIE_STATE];
        int n4 = ZOMBIES[n2 + ZOMBIE_WAVE];
        return n3 != 41 && n3 != 38 && n4 != -1 && n4 != -2;
    }

    static void updatePoleVaulter(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        if (ZOMBIES[n2 + ZOMBIE_STATE] == 41) {
            int n3;
            int n4;
            if (Zombies.isFlagSet(10, n) && (n4 = ZOMBIES[n2 + ZOMBIE_REANIM_FRAME]) - (n3 = Reanim.getTrackAttributeFromTrackID(ZOMBIES[n2 + ZOMBIE_REANIM_INDEX], ZOMBIES[n2 + ZOMBIE_REANIM_CURR_TRACK_ID], 2)) == 5) {
                Zombies.unSetFlag(10, n);
                Zombies.setReanimTrack(n, 33, 0);
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_STATE] = 35;
                int n5 = n2 + ZOMBIE_FP_CENTRE_X;
                ZOMBIES[n5] = ZOMBIES[n5] - 18 * FP1;
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_ALTITUDE] = -18 * FP1;
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_SECONDARY_STATE] = 112;
            }
            if (ZOMBIES[n2 + ZOMBIE_REANIM_LOOP_COUNT] > 0) {
                int n6 = n2 + ZOMBIE_FP_CENTRE_X;
                ZOMBIES[n6] = ZOMBIES[n6] - 55 * FP1;
                Zombies.setReanimTrack(n, 33, 0);
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_STATE] = 35;
            }
        } else if (ZOMBIES[n2 + ZOMBIE_STATE] == 36) {
            int n7;
            int n8;
            if (ZOMBIES[n2 + ZOMBIE_SECONDARY_STATE] == 105 && (n8 = Zombies.findTargetPlant(n, 1)) != -1 && GridItem.getGridItemTypeAtPos(n7 = Plants.PLANTS[Plants.PLANT_MAX_VALS * n8 + Plants.PLANT_POS]) == 0) {
                if (ZOMBIES[n2 + ZOMBIE_GRID_LADDER_BOARD_POS] != n7) {
                    Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_SECONDARY_STATE] = 111;
                    Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_GRID_LADDER_BOARD_POS] = n7;
                }
                return;
            }
            if (Zombies.isFlagSet(7, n) && Zombies.isFlagSet(4, n) && ZOMBIES[n2 + ZOMBIE_SECONDARY_STATE] == 105 && (n8 = Zombies.findTargetPlant(n, 1)) != -1) {
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_STATE] = 41;
                Zombies.setReanimTrack(n, 32, 1);
                Zombies.unSetFlag(7, n);
                n7 = Plants.PLANTS[Plants.PLANT_MAX_VALS * n8 + Plants.PLANT_TYPE];
                if (n7 == 15) {
                    Zombies.setFlag(10, n);
                }
            }
        }
    }

    static void updateDancer(int n) {
        int n2;
        int n3 = ZOMBIE_MAX_VALS * n;
        int n4 = ZOMBIES[n3 + ZOMBIE_STATE];
        if (n4 == 37 || n4 == 38 || Zombies.isFlagSet(3, n)) {
            return;
        }
        boolean bl = Zombies.isFlagSet(4, n);
        if (ZOMBIES[n3 + ZOMBIE_SUMMON_COUNTER] > 0) {
            int n5 = n3 + ZOMBIE_SUMMON_COUNTER;
            ZOMBIES[n5] = ZOMBIES[n5] - 1;
            if (ZOMBIES[n3 + ZOMBIE_SUMMON_COUNTER] == 0 && n4 != 44) {
                n2 = Zombies.getGlobalDancerFrame(n);
                if (bl && n2 == DANCE_LEFT_ANIM_FRAMES) {
                    Zombies.setState(n, 43, true);
                    Zombies.setReanimTrack(n, 45, 1);
                    if (!Zombies.isFlagSet(12, n)) {
                        Zombies.unSetFlag(9, n);
                    }
                } else {
                    Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_SUMMON_COUNTER] = 1;
                }
            }
        }
        if (n4 == 42) {
            if (!bl) {
                return;
            }
            if (ZOMBIES[n3 + ZOMBIE_FP_STATE_COUNTDOWN] == 0) {
                Zombies.setState(n, 43, true);
                Zombies.setReanimTrack(n, 45, 1);
                if (!Zombies.isFlagSet(12, n)) {
                    Zombies.unSetFlag(9, n);
                }
            }
        } else if (n4 == 43) {
            if (ZOMBIES[n3 + ZOMBIE_REANIM_LOOP_COUNT] > 0 || ZOMBIES[n3 + ZOMBIE_FP_STATE_COUNTDOWN] <= 0) {
                Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_STATE] = 44;
                Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_FP_STATE_COUNTDOWN] = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(ZOMBIES[n3 + ZOMBIE_STATE]) * FP1;
                Zombies.setFlag(0, n);
                Zombies.setReanimHoldCountdown(n, FP.toInt(ZOMBIES[n3 + ZOMBIE_FP_STATE_COUNTDOWN]));
                if (bl) {
                    Zombies.summonBackupDancers(n);
                }
            }
        } else if (n4 == 44) {
            if (ZOMBIES[n3 + ZOMBIE_FP_STATE_COUNTDOWN] <= 0) {
                Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_STATE] = 48;
                Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_FP_STATE_COUNTDOWN] = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(ZOMBIES[n3 + ZOMBIE_STATE]) * FP1;
                Zombies.unSetFlag(0, n);
                if (!Zombies.isFlagSet(12, n)) {
                    Zombies.unSetFlag(9, n);
                }
                Zombies.setReanimTrack(n, 47, 0);
            }
        } else {
            n2 = Zombies.getDancerState(n);
            if (n2 != n4) {
                Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_STATE] = n2;
                if (n2 == 45) {
                    Zombies.setReanimTrack(n, 46, 0);
                    if (!Zombies.isFlagSet(12, n)) {
                        Zombies.unSetFlag(9, n);
                    }
                } else if (n2 == 48 || n2 == 50) {
                    Zombies.setReanimTrack(n, 47, 0);
                    Zombies.setFlag(9, n);
                } else if (n2 == 47 || n2 == 46) {
                    Zombies.setReanimTrack(n, 47, 0);
                    if (!Zombies.isFlagSet(12, n)) {
                        Zombies.unSetFlag(9, n);
                    }
                }
            }
        }
        if (bl && ZOMBIES[n3 + ZOMBIE_SUMMON_COUNTER] == 0 && ZOMBIES[n3 + ZOMBIE_STATE] != 42 && (ZOMBIES[n3 + ZOMBIE_PARAM_1] == -1 || ZOMBIES[n3 + ZOMBIE_PARAM_2] == -1 || ZOMBIES[n3 + ZOMBIE_PARAM_3] == -1 || ZOMBIES[n3 + ZOMBIE_PARAM_4] == -1)) {
            Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_SUMMON_COUNTER] = (short)"\uffff\uffff\uffff\uffff\uffff\uffff\uffff\u0012\u02ee\u01c2\uffff\uffff\uffff\u0014\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(7);
        }
    }

    static void updateBackupDancer(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = ZOMBIES[n2 + ZOMBIE_STATE];
        if (n3 == 37 || n3 == 38 || Zombies.isFlagSet(3, n)) {
            return;
        }
        if (n3 == 51) {
            int n4 = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(ZOMBIES[n2 + ZOMBIE_STATE]) * FP1;
            int n5 = n4 - ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN];
            int n6 = 60 * FP1;
            int n7 = Util.getFPPercentage(n5, n4, n6);
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_ALTITUDE] = n6 - n7;
            if (ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN] == 0) {
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_STATE] = 48;
                Zombies.setReanimTrack(n, 64, 0);
                Zombies.setFlag(9, n);
            }
        } else {
            int n8 = Zombies.getDancerState(n);
            if (n8 != n3) {
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_STATE] = n8;
                if (n8 == 45) {
                    Zombies.setReanimTrack(n, 65, 0);
                    if (!Zombies.isFlagSet(12, n)) {
                        Zombies.unSetFlag(9, n);
                    }
                } else if (n8 == 48 || n8 == 50) {
                    Zombies.setReanimTrack(n, 64, 0);
                    Zombies.setFlag(9, n);
                } else if (n8 == 47 || n8 == 46) {
                    Zombies.setReanimTrack(n, 64, 0);
                    if (!Zombies.isFlagSet(12, n)) {
                        Zombies.unSetFlag(9, n);
                    }
                }
            }
        }
    }

    static int getGlobalDancerFrame(int n) {
        int n2 = 0;
        int n3 = Reanim.getReanimIndexFromID(2);
        int n4 = n3 * 3;
        int n5 = (DANCER_WALK_LEFT_FRAMES + DANCER_DANCE_FRAMES + DANCER_RAISE_TO_WALK_FRAMES) * FP1;
        int n6 = Reanim.REANIM_DATA[n4 + 1];
        int n7 = FP.fpDiv(18 * FP1, n6 * FP1);
        int n8 = FP.toInt(FP.fpMul(n7, n5));
        n2 = GCanvasController.m_nGlobalAnimationFrame % n8 / FP.toInt(n7);
        return n2;
    }

    static int getDancerState(int n) {
        int n2 = Zombies.getGlobalDancerFrame(n);
        if (n2 <= DANCE_LEFT_ANIM_FRAMES) {
            return 45;
        }
        if (n2 <= DANCE_RIGHT_1) {
            return 48;
        }
        if (n2 <= DANCE_LEFT_1) {
            return 47;
        }
        if (n2 <= DANCE_RIGHT_2) {
            return 50;
        }
        return 46;
    }

    static void updateJackInTheBox(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        boolean bl = Zombies.isFlagSet(4, n);
        if (ZOMBIES[n2 + ZOMBIE_STATE] == 36 || ZOMBIES[n2 + ZOMBIE_STATE] == 35) {
            if (ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN] <= 0 && bl) {
                Zombies.setState(n, 52, true);
                Zombies.setReanimTrack(n, 91, 1);
            }
        } else if (ZOMBIES[n2 + ZOMBIE_STATE] == 52 && ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN] <= 0) {
            int n3 = 20;
            if (Zombies.isFlagSet(12, n)) {
                int n4 = 92;
                int n5 = 92;
                int n6 = FP.toInt(ZOMBIES[n2 + ZOMBIE_FP_CENTRE_X]) - n5 / 2;
                int n7 = FP.toInt(ZOMBIES[n2 + ZOMBIE_FP_TOP_Y]) - n4 / 2;
                CollisionHandler.hitAllZombiesInRect(-1, n6, n7, n5, n4, 1800, ZOMBIES[n2 + ZOMBIE_ROW], 1, n3, 127, false);
            } else {
                int n8 = 70;
                int n9 = 70;
                int n10 = FP.toInt(ZOMBIES[n2 + ZOMBIE_FP_CENTRE_X]) - n9 / 2;
                int n11 = FP.toInt(ZOMBIES[n2 + ZOMBIE_FP_TOP_Y]) + n8 / 2;
                CollisionHandler.hitAllPlantsInRect(n, n10, n11, n9, n8, 1800, ZOMBIES[n2 + ZOMBIE_ROW], 1);
                n8 = 92;
                n9 = 92;
                n10 = FP.toInt(ZOMBIES[n2 + ZOMBIE_FP_CENTRE_X]) - n9 / 2;
                n11 = FP.toInt(ZOMBIES[n2 + ZOMBIE_FP_TOP_Y]) - n8 / 2;
                CollisionHandler.hitAllZombiesInRect(-1, n10, n11, n9, n8, 1800, ZOMBIES[n2 + ZOMBIE_ROW], 1, 32, 127, false);
            }
            GCanvasController.doSproingExplosion(n);
            Zombies.killZombie(n, true);
        }
    }

    static void updateNewsPaper(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        if (ZOMBIES[n2 + ZOMBIE_STATE] == 53 && ZOMBIES[n2 + ZOMBIE_REANIM_LOOP_COUNT] > 0 && ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN] <= 0) {
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_STATE] = 54;
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_VX] = Zombies.getZombieSpeedFP(9, (short)"\uffff\uffff\uffff\uffff\uffff\uffff\uffff\u0012\u02ee\u01c2\uffff\uffff\uffff\u0014\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(9));
            Zombies.unSetFlag(0, n);
            Zombies.setReanimTrack(n, 103, 0);
        }
    }

    static void summonBackupDancers(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = ZOMBIES[n2 + ZOMBIE_ROW];
        int n4 = ZOMBIES[n2 + ZOMBIE_FP_CENTRE_X];
        int n5 = ZOMBIES[n2 + ZOMBIE_PARAM_1];
        int n6 = ZOMBIES[n2 + ZOMBIE_PARAM_2];
        int n7 = ZOMBIES[n2 + ZOMBIE_PARAM_3];
        int n8 = ZOMBIES[n2 + ZOMBIE_PARAM_4];
        Zombies.getZombieOffsets(10, false);
        if (n5 == -1) {
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_PARAM_1] = Zombies.summonBackupDancer(n, n3, n4 + (ZOMBIE_OFFSETS[ZOMBIE_OFFSET_CENTRE_X] - 40) * FP1, 0);
        }
        if (n6 == -1) {
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_PARAM_2] = Zombies.summonBackupDancer(n, n3, n4 + (ZOMBIE_OFFSETS[ZOMBIE_OFFSET_CENTRE_X] + 40) * FP1, 1);
        }
        if (n7 == -1) {
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_PARAM_3] = Zombies.summonBackupDancer(n, n3 - 1, n4 + ZOMBIE_OFFSETS[ZOMBIE_OFFSET_CENTRE_X] * FP1, 2);
        }
        if (n8 == -1) {
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_PARAM_4] = Zombies.summonBackupDancer(n, n3 + 1, n4 + ZOMBIE_OFFSETS[ZOMBIE_OFFSET_CENTRE_X] * FP1, 3);
        }
    }

    static int summonBackupDancer(int n, int n2, int n3, int n4) {
        if (ZombieController.bRowCanHaveZombies(n2)) {
            int n5;
            int n6 = ZOMBIE_MAX_VALS * n;
            Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_PARAM_1] = n5 = Zombies.addZombie(10, n2, ZombieController.m_nCurrentWave);
            int n7 = ZOMBIE_MAX_VALS * n5;
            Zombies.ZOMBIES[n7 + Zombies.ZOMBIE_FP_CENTRE_X] = n3;
            Zombies.ZOMBIES[n7 + Zombies.ZOMBIE_FP_ALTITUDE] = 60 * FP1;
            Zombies.ZOMBIES[n7 + Zombies.ZOMBIE_PARAM_1] = n;
            Zombies.ZOMBIES[n7 + Zombies.ZOMBIE_PARAM_2] = n4;
            if (Zombies.isFlagSet(12, n)) {
                Zombies.setFlag(12, n5);
                Zombies.updateAnimSpeed(n5);
            }
            return n5;
        }
        return -1;
    }

    static int getLeftMostZombie(boolean bl) {
        int n = 0;
        int n2 = -1;
        int n3 = 5000;
        for (int i = 0; i < 100 && n < m_nZombies; ++i) {
            int n4;
            if (!Zombies.isZombieAtIndex(i) || bl && GModel.PLANT_ROW[n4 = ZOMBIES[i * ZOMBIE_MAX_VALS + ZOMBIE_ROW]] != 3) continue;
            if (Zombies.isFlagSet(4, i)) {
                Zombies.getHitRect(i);
                if (ZOMBIE_RECT[ZOMBIE_RECT_X] < n3) {
                    n3 = ZOMBIE_RECT[ZOMBIE_RECT_X];
                    n2 = i;
                }
            }
            ++n;
        }
        if (n2 > -1) {
            return n2;
        }
        return 0;
    }

    static boolean bIsOnBoard(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = ZOMBIES[n2 + ZOMBIE_WAVE];
        return n3 != -1 && n3 != -2;
    }

    static void setState(int n, int n2, boolean bl) {
        int n3 = ZOMBIE_MAX_VALS * n;
        Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_STATE] = n2;
        if (bl) {
            Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_FP_STATE_COUNTDOWN] = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(n2) * FP1;
        }
    }

    static void swapZombieIndexes(int n, int n2) {
        if (Zombies.isZombieAtIndex(n) && Zombies.isZombieAtIndex(n2)) {
            int n3 = ZOMBIE_MAX_VALS * n;
            int n4 = ZOMBIE_MAX_VALS * n2;
            System.arraycopy(ZOMBIES, n3, ZOMBIE_SWAP_TEMP, 0, ZOMBIE_MAX_VALS);
            System.arraycopy(ZOMBIES, n4, ZOMBIES, n3, ZOMBIE_MAX_VALS);
            System.arraycopy(ZOMBIE_SWAP_TEMP, 0, ZOMBIES, n4, ZOMBIE_MAX_VALS);
        }
    }

    static void dropLoot(int n) {
        if (!Zombies.bIsOnBoard(n)) {
            return;
        }
        Zombies.bTrySpawnLevelAward(n);
        if (Zombies.isFlagSet(6, n)) {
            return;
        }
    }

    static boolean bTrySpawnLevelAward(int n) {
        if (ZombieController.m_nRiseFromGraveCounter > 0) {
            return false;
        }
        if (!Zombies.bIsOnBoard(n)) {
            return false;
        }
        if (GModel.m_bDroppedLevelAward) {
            return false;
        }
        if (Zombies.isFlagSet(6, n)) {
            return false;
        }
        if (ZombieController.m_nCurrentWave < ZombieController.m_nNumWaves) {
            return false;
        }
        if (Zombies.bAreEnemyZombiesOnScreen()) {
            return false;
        }
        GModel.m_bDroppedLevelAward = true;
        int n2 = AwardScreen.getNextLockedAwardType();
        int n3 = AwardScreen.getCoinTypeForAward(n2);
        if (n3 != -1) {
            int n4 = -1;
            if (n3 == 3) {
                n4 = SeedPicker.getNextLockedSeed();
            }
            if (GameController.m_nLevel == 49) {
                AwardScreen.setAward(4, -1, 1);
            } else if (n4 != -1 || n3 != -1) {
                Zombies.dropLootItem(n, n3, n4, n2);
            } else {
                ++GameController.m_nLevel;
                RMS.softSave(false);
                RMS.hardSave(RMS.SAVE_GAME_NAME, RMS.SOFT_SAVE_DATA_BUFFER);
                PVZActions.handleAction(62);
            }
        }
        Zombies.setFlag(6, n);
        return true;
    }

    static boolean bAreEnemyZombiesOnScreen() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 100 && n < m_nZombies; ++i) {
            if (!Zombies.isZombieAtIndex(i)) continue;
            n2 = ZOMBIE_MAX_VALS * i;
            ++n;
            if (!Zombies.isFlagSet(4, i) || ZOMBIES[n2 + ZOMBIE_STATE] == 38 || ZOMBIES[n2 + ZOMBIE_STATE] == 39 || Zombies.isFlagSet(12, i)) continue;
            return true;
        }
        return false;
    }

    static void updateGargantuar(int n) {
        int n2;
        int n3 = ZOMBIE_MAX_VALS * n;
        int n4 = ZOMBIES[n3 + ZOMBIE_STATE];
        int n5 = Math.max((short)"\u010e\u010e\u010e\u010e\u010e\u010e\u01f4\u01f4\u01f4\u010e\u010e\u0bb8\u01f4\u0352\u01f4\u010e\u010e\u010e\u010e\u00c8\u2710\u7530\u7530".charAt(11), 0) >> 1;
        if (ZOMBIES[n3 + ZOMBIE_HEALTH_BODY] > n5) {
            Zombies.hideReanimTrack(n, 132);
        } else {
            Zombies.showReanimTrack(n, 132);
        }
        if (n4 == 55) {
            if (ZOMBIES[n3 + ZOMBIE_FP_STATE_COUNTDOWN] <= 0 && ZOMBIES[n3 + ZOMBIE_FROZEN_COUNTDOWN] <= 0) {
                int n6 = Zombies.findTargetPlant(n, 0);
                if (n6 != -1) {
                    int n7 = Plants.PLANTS[n6 * Plants.PLANT_MAX_VALS + Plants.PLANT_POS];
                    Zombies.squishAllPlantsAtPos(n7, 0);
                }
                GCanvasController.shakeBoard(0, 3, 3);
            }
            if (ZOMBIES[n3 + ZOMBIE_REANIM_LOOP_COUNT] > 0) {
                Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_STATE] = 35;
                n4 = 35;
                Zombies.setReanimTrack(n, 118, 0);
                if (ZOMBIES[n3 + ZOMBIE_PARAM_1] == 1) {
                    Zombies.hideReanimTrack(n, 124);
                }
            }
            return;
        }
        if (n4 == 56) {
            if (ZOMBIES[n3 + ZOMBIE_REANIM_LOOP_COUNT] > 0) {
                Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_STATE] = 35;
                n4 = 35;
                Zombies.setReanimTrack(n, 118, 0);
                Zombies.hideReanimTrack(n, 124);
                Zombies.summonIMP(n, ZOMBIES[n3 + ZOMBIE_ROW], ZOMBIES[n3 + ZOMBIE_FP_CENTRE_X], ZOMBIES[n3 + ZOMBIE_CHILLED_COUNTDOWN]);
            }
            return;
        }
        if (Zombies.bIsImmobilized(n) || !Zombies.isFlagSet(4, n)) {
            return;
        }
        if (ZOMBIES[n3 + ZOMBIE_PARAM_1] != 1) {
            boolean bl;
            n2 = ZOMBIES[n3 + ZOMBIE_FP_CENTRE_X] / FP1;
            int n8 = 148 + GModel.getBoardOffsetX(Layer.getLayerProperty(2, 5));
            int n9 = Math.max((short)"\u010e\u010e\u010e\u010e\u010e\u010e\u01f4\u01f4\u01f4\u010e\u010e\u0bb8\u01f4\u0352\u01f4\u010e\u010e\u010e\u010e\u00c8\u2710\u7530\u7530".charAt(11), 0) / 2;
            boolean bl2 = bl = n4 != 38;
            if (bl && n2 > n8 && ZOMBIES[n3 + ZOMBIE_HEALTH_BODY] < n9) {
                System.out.println("Imp Thrown gX " + n2 + " cx " + n8 + " he " + ZOMBIES[n3 + ZOMBIE_HEALTH_BODY] + " checkH " + n9);
                Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_STATE] = 56;
                Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_PARAM_1] = 1;
                Zombies.setReanimTrack(n, 120, 1);
                return;
            }
        }
        if (ZOMBIES[n3 + ZOMBIE_REANIM_LOOP_COUNT] > 0 && (n2 = Zombies.findTargetPlant(n, 0)) != -1) {
            Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_STATE] = 55;
            Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_FP_STATE_COUNTDOWN] = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(ZOMBIES[n3 + ZOMBIE_STATE]) * FP1;
            Zombies.setReanimTrack(n, 119, 0);
            if (ZOMBIES[n3 + ZOMBIE_PARAM_1] == 1) {
                Zombies.hideReanimTrack(n, 124);
            }
        }
    }

    static int summonIMP(int n, int n2, int n3, int n4) {
        int n5 = Zombies.addZombie(19, n2, ZombieController.m_nCurrentWave);
        int n6 = ZOMBIE_MAX_VALS * n5;
        Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_FP_CENTRE_X] = n3 - 100 * FP1;
        System.out.println("Imp throwing anim start at pt " + ZOMBIES[n6 + ZOMBIE_FP_CENTRE_X] / FP1);
        Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_CHILLED_COUNTDOWN] = n4;
        Zombies.setReanimFPS(n5, 18 * FP1, false);
        Zombies.ZOMBIES[n6 + Zombies.ZOMBIE_STATE] = 58;
        Zombies.setReanimTrack(n5, 134, 1);
        return n5;
    }

    static void updateIMP(int n) {
        int n2 = n * ZOMBIE_MAX_VALS;
        int n3 = ZOMBIES[n2 + ZOMBIE_STATE];
        if (n3 == 58) {
            if (ZOMBIES[n2 + ZOMBIE_REANIM_LOOP_COUNT] > 0) {
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_STATE] = 59;
                n3 = 59;
                Zombies.setReanimTrack(n, 133, 1);
            } else {
                int n4 = n2 + ZOMBIE_FP_CENTRE_X;
                ZOMBIES[n4] = ZOMBIES[n4] - 20 * FP1 / 10;
            }
        } else if (n3 == 59 && ZOMBIES[n2 + ZOMBIE_REANIM_LOOP_COUNT] > 0) {
            System.out.println("Imp Landing at pt " + ZOMBIES[n2 + ZOMBIE_FP_CENTRE_X] / FP1);
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_STATE] = 35;
            n3 = 35;
            Zombies.setReanimTrack(n, 137, 0);
        }
    }

    static void updateZomboss(int n) {
        int n2;
        int n3;
        int n4 = n * ZOMBIE_MAX_VALS;
        int n5 = n3 = ZOMBIES[n4 + ZOMBIE_STATE];
        boolean bl = true;
        boolean bl2 = true;
        switch (n3) {
            case 83: {
                if (ZOMBIES[n4 + ZOMBIE_REANIM_LOOP_COUNT] <= 0) break;
                n3 = 84;
                Zombies.setState(n, n3, true);
                if (ZOMBIES[n4 + ZOMBIE_PARAM_1] == 83) {
                    int n6 = n4 + ZOMBIE_FP_STATE_COUNTDOWN;
                    ZOMBIES[n6] = ZOMBIES[n6] * 3;
                }
                Zombies.setReanimTrack(n, 286, 0);
                break;
            }
            case 84: {
                if (ZOMBIES[n4 + ZOMBIE_FP_STATE_COUNTDOWN] > 0) break;
                n2 = Zombies.findTargetPlant(n, 0);
                if (n2 != -1) {
                    n3 = 85;
                    Zombies.setState(n, n3, true);
                    int n7 = Plants.getRow(n2);
                    int n8 = -1;
                    n8 = n7 == 0 || n7 == 1 ? 298 : (n7 == 2 || n7 == 3 ? 299 : 300);
                    Zombies.setReanimTrack(n, n8, 1);
                    break;
                }
                if (ZOMBIES[n4 + ZOMBIE_PARAM_1] == 87) {
                    n3 = 90;
                    Zombies.setState(n, n3, true);
                    Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_PARAM_1] = 91;
                    Zombies.setReanimTrack(n, 297, 1);
                    break;
                }
                Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_PARAM_1] = 87;
                n3 = 87;
                Zombies.setState(n, n3, true);
                Zombies.setReanimTrack(n, 295 - ZOMBIES[n4 + ZOMBIE_PARAM_2] * 2, 1);
                break;
            }
            case 87: {
                if (ZOMBIES[n4 + ZOMBIE_FP_STATE_COUNTDOWN] > 0) break;
                n3 = 89;
                Zombies.setState(n, n3, true);
                Zombies.setReanimTrack(n, 296 - ZOMBIES[n4 + ZOMBIE_PARAM_2] * 2, 1);
                if (bl && (n2 = Zombies.addZombie(ZOMBIES[n4 + ZOMBIE_PARAM_3], ZOMBIES[n4 + ZOMBIE_PARAM_2], ZombieController.m_nCurrentWave)) != -1) {
                    int n9 = n2 * ZOMBIE_MAX_VALS;
                    int n10 = n9 + ZOMBIE_FP_CENTRE_X;
                    ZOMBIES[n10] = ZOMBIES[n10] - 110 * FP1;
                }
                int n11 = n4 + ZOMBIE_SUMMON_COUNTER;
                ZOMBIES[n11] = ZOMBIES[n11] - 1;
                break;
            }
            case 89: {
                if (ZOMBIES[n4 + ZOMBIE_FP_STATE_COUNTDOWN] > 0) break;
                if (ZOMBIES[n4 + ZOMBIE_SUMMON_COUNTER] > 0) {
                    Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_PARAM_3] = Zombies.spawnZombieEndLevel(ZOMBIES[n4 + ZOMBIE_PARAM_3], ZOMBIES[n4 + ZOMBIE_HEALTH_BODY]);
                    Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_PARAM_2] = ZombieController.pickRowForNewZombie(0);
                    n3 = 87;
                    Zombies.setState(n, n3, true);
                    Zombies.setReanimTrack(n, 295 - ZOMBIES[n4 + ZOMBIE_PARAM_2] * 2, 1);
                    break;
                }
                ++ZombieController.m_nCurrentWave;
                Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_SUMMON_COUNTER] = 5 + Util.GetRandom(3);
                Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_PARAM_2] = ZombieController.pickRowForNewZombie(0);
                Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_PARAM_3] = 0;
                n3 = 84;
                Zombies.setState(n, n3, true);
                Zombies.setReanimTrack(n, 286, 0);
                break;
            }
            case 90: {
                if (ZOMBIES[n4 + ZOMBIE_FP_STATE_COUNTDOWN] > 0) break;
                n3 = 91;
                Zombies.setState(n, n3, false);
                Zombies.setReanimTrack(n, 301, 0);
                break;
            }
            case 91: {
                if (ZOMBIES[n4 + ZOMBIE_REANIM_LOOP_COUNT] <= 0) break;
                n3 = 92;
                Zombies.setState(n, n3, false);
                Zombies.setReanimTrack(n, 302, 0);
                break;
            }
            case 92: {
                if (ZOMBIES[n4 + ZOMBIE_REANIM_LOOP_COUNT] <= 0) break;
                n3 = 93;
                Zombies.setState(n, n3, true);
                Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_PARAM_4] = Util.GetRandom(10) > 5 ? 21 : 22;
                Zombies.setReanimTrack(n, 303, 1);
                if (ZOMBIES[n4 + ZOMBIE_PARAM_4] == 21) {
                    Zombies.hideReanimTrack(n, 275);
                    Zombies.hideReanimTrack(n, 274);
                } else {
                    Zombies.showReanimTrack(n, 275);
                    Zombies.showReanimTrack(n, 274);
                }
                Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_GRID_LADDER_BOARD_POS] = 0;
                break;
            }
            case 93: {
                int n12;
                if (ZOMBIES[n4 + ZOMBIE_GRID_LADDER_BOARD_POS] == 0 && ZOMBIES[n4 + ZOMBIE_FP_STATE_COUNTDOWN] < 60 * FP1) {
                    Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_GRID_LADDER_BOARD_POS] = 1;
                }
                if (ZOMBIES[n4 + ZOMBIE_FP_STATE_COUNTDOWN] <= 0) {
                    n3 = 94;
                    Zombies.setState(n, n3, false);
                    Zombies.setReanimTrack(n, 304, 0);
                    if (ZOMBIES[n4 + ZOMBIE_GRID_LADDER_BOARD_POS] == 0) {
                        Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_GRID_LADDER_BOARD_POS] = 1;
                    }
                }
                if (ZOMBIES[n4 + ZOMBIE_GRID_LADDER_BOARD_POS] != 1) break;
                n2 = ZombieController.pickRowForNewZombie(0);
                if (bl2 && (n12 = Zombies.addZombie(ZOMBIES[n4 + ZOMBIE_PARAM_4], n2, ZombieController.m_nCurrentWave)) != -1) {
                    int n13 = n12 * ZOMBIE_MAX_VALS;
                    int n14 = n13 + ZOMBIE_FP_CENTRE_X;
                    ZOMBIES[n14] = ZOMBIES[n14] - 50 * FP1;
                }
                Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_GRID_LADDER_BOARD_POS] = 2;
                break;
            }
            case 94: {
                if (ZOMBIES[n4 + ZOMBIE_REANIM_LOOP_COUNT] <= 0) break;
                n3 = 95;
                Zombies.setState(n, n3, false);
                Zombies.setReanimTrack(n, 305, 0);
                break;
            }
            case 95: {
                if (ZOMBIES[n4 + ZOMBIE_REANIM_LOOP_COUNT] <= 0) break;
                n3 = 83;
                Zombies.setState(n, n3, false);
                Zombies.setReanimTrack(n, 285, 0);
                break;
            }
            case 85: {
                if (ZOMBIES[n4 + ZOMBIE_FP_STATE_COUNTDOWN] > 0) break;
                n2 = Zombies.findTargetPlant(n, 0);
                if (n2 != -1) {
                    int n15 = Plants.PLANTS[n2 * Plants.PLANT_MAX_VALS + Plants.PLANT_POS];
                    Zombies.squishAllPlantsAtPos(n15, 0);
                }
                GCanvasController.shakeBoard(0, 3, 3);
                n3 = 84;
                Zombies.setState(n, n3, true);
                Zombies.setReanimTrack(n, 286, 0);
            }
        }
        if (n3 != n5) {
            n2 = Math.max((short)"\u010e\u010e\u010e\u010e\u010e\u010e\u01f4\u01f4\u01f4\u010e\u010e\u0bb8\u01f4\u0352\u01f4\u010e\u010e\u010e\u010e\u00c8\u2710\u7530\u7530".charAt(20), 0) / 2;
            if (ZOMBIES[n4 + ZOMBIE_HEALTH_BODY] > n2) {
                Zombies.hideReanimTrack(n, 258);
                Zombies.hideReanimTrack(n, 262);
                Zombies.hideReanimTrack(n, 282);
                Zombies.hideReanimTrack(n, 283);
                Zombies.hideReanimTrack(n, 284);
            } else {
                Zombies.showReanimTrack(n, 258);
                Zombies.showReanimTrack(n, 262);
                Zombies.showReanimTrack(n, 282);
                Zombies.showReanimTrack(n, 283);
                Zombies.showReanimTrack(n, 284);
            }
        }
    }

    static int spawnZombieEndLevel(int n, int n2) {
        int n3;
        int[] nArray = new int[]{0, 2, 6, 5, 3, 14, 12, 11};
        int[] nArray2 = new int[]{15, 15, 10, 10, 10, 10, 10, 20};
        int[] nArray3 = new int[]{100, 100, 80, 90, 70, 50, 60, 50};
        boolean bl = false;
        int n4 = -1;
        for (n3 = 0; n3 < nArray.length; ++n3) {
            n4 = nArray[n3];
            short s = (short)"\u010e\u010e\u010e\u010e\u010e\u010e\u01f4\u01f4\u01f4\u010e\u010e\u0bb8\u01f4\u0352\u01f4\u010e\u010e\u010e\u010e\u00c8\u2710\u7530\u7530".charAt(20);
            if (nArray3[n3] < n2 * 100 / s) {
                nArray2[n3] = 0;
            }
            if (n4 != n || nArray2[n3] == 0) continue;
            int n5 = n3;
            nArray2[n5] = nArray2[n5] / 2;
        }
        n3 = ZombieController.selectWeightedItem(nArray, nArray2, nArray.length);
        if (n3 == -1) {
            n3 = 2;
        }
        return n3;
    }

    static void updateZombossFireBall(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = ZOMBIES[n2 + ZOMBIE_STATE];
        if (n3 == 97) {
            n3 = 98;
            Zombies.setState(n, n3, true);
            Zombies.setReanimTrack(n, 307, 1);
        } else if (n3 == 98) {
            if (ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN] <= 0) {
                Zombies.setReanimFPS(n, 0, true);
                n3 = 35;
                Zombies.setState(n, n3, false);
                Zombies.setReanimTrack(n, 308, 0);
            }
        } else if (n3 == 35) {
            int n4 = Zombies.findTargetPlant(n, 0);
            if (n4 != -1) {
                int n5 = Plants.PLANTS[n4 * Plants.PLANT_MAX_VALS + Plants.PLANT_POS];
                Zombies.squishAllPlantsAtPos(n5, 0);
            }
            return;
        }
    }

    static void updateZombossIceBall(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = ZOMBIES[n2 + ZOMBIE_STATE];
        if (n3 == 101) {
            n3 = 102;
            Zombies.setState(n, n3, true);
            Zombies.setReanimTrack(n, 314, 1);
        } else if (n3 == 102) {
            if (ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN] <= 0) {
                Zombies.setReanimFPS(n, 0, true);
                n3 = 35;
                Zombies.setState(n, n3, false);
                Zombies.setReanimTrack(n, 315, 0);
            }
        } else if (n3 == 35) {
            int n4 = Zombies.findTargetPlant(n, 0);
            if (n4 != -1) {
                int n5 = Plants.PLANTS[n4 * Plants.PLANT_MAX_VALS + Plants.PLANT_POS];
                Zombies.squishAllPlantsAtPos(n5, 0);
            }
            return;
        }
    }

    static void updateLadder(int n) {
        int n2 = n * ZOMBIE_MAX_VALS;
        boolean bl = Zombies.isFlagSet(4, n);
        int n3 = ZOMBIES[n2 + ZOMBIE_STATE];
        if (!bl || n3 == 38 || Zombies.isFlagSet(12, n)) {
            return;
        }
        int n4 = ZOMBIES[n2 + ZOMBIE_HEALTH_SHIELD];
        if (n3 != 61 && n4 > 0 && ZOMBIES[n2 + ZOMBIE_SHIELD_TYPE] == 2) {
            int n5 = Zombies.findTargetPlant(n, 2);
            if (n5 != -1) {
                Zombies.unSetFlag(2, n);
                n3 = 61;
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_STATE] = 61;
                Zombies.setReanimTrack(n, 150, 0);
            }
        } else if (n3 == 61 && ZOMBIES[n2 + ZOMBIE_REANIM_LOOP_COUNT] > 0) {
            int n6 = Zombies.findTargetPlant(n, 2);
            if (n6 != -1) {
                int n7 = n6 * Plants.PLANT_MAX_VALS;
                int n8 = Plants.PLANTS[n7 + Plants.PLANT_POS];
                GridItem.addGridItem(0, n8, 1, 0);
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_GRID_LADDER_BOARD_POS] = n8;
                Plants.PLANTS[n7 + Plants.PLANT_LADDER_POS] = n8;
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_SECONDARY_STATE] = 111;
                Zombies.dropShield(n);
            } else {
                n3 = 60;
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_STATE] = 60;
                Zombies.setReanimTrack(n, 155, 0);
            }
        }
    }

    static void updateClimbingLadder(int n) {
        int n2 = n * ZOMBIE_MAX_VALS;
        int n3 = ZOMBIES[n2 + ZOMBIE_GRID_LADDER_BOARD_POS];
        if (GridItem.getGridItemTypeAtPos(n3) != 0) {
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_SECONDARY_STATE] = 112;
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_ALTITUDE] = 30 * FP1;
            return;
        }
        int n4 = n2 + ZOMBIE_FP_ALTITUDE;
        ZOMBIES[n4] = ZOMBIES[n4] - ZOMBIE_CLIMB_INC_Y_FP;
        int n5 = n2 + ZOMBIE_FP_CENTRE_X;
        ZOMBIES[n5] = ZOMBIES[n5] - ZOMBIE_CLIMB_INC_X_FP;
        if (ZOMBIES[n2 + ZOMBIE_FP_ALTITUDE] <= -30 * FP1) {
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_SECONDARY_STATE] = 112;
        }
    }

    static void updateFalling(int n) {
        int n2 = n * ZOMBIE_MAX_VALS;
        int n3 = n2 + ZOMBIE_FP_ALTITUDE;
        ZOMBIES[n3] = ZOMBIES[n3] + 1 * FP1;
        if (ZOMBIES[n2 + ZOMBIE_FP_ALTITUDE] >= 0) {
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_ALTITUDE] = 0;
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_SECONDARY_STATE] = 105;
        }
    }

    static boolean bCanLoseBodyParts(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = ZOMBIES[n2 + ZOMBIE_TYPE];
        if (n3 == 11 || n3 == 13) {
            return false;
        }
        return !Zombies.bIsFlying(n);
    }

    static boolean bIsDeadOrDying(int n) {
        int n2 = ZOMBIES[ZOMBIE_MAX_VALS * n + ZOMBIE_STATE];
        return n2 == 38 || n2 == 39;
    }

    static boolean bCanBeChilled(int n) {
        int n2 = n * ZOMBIE_MAX_VALS;
        int n3 = ZOMBIES[n2 + ZOMBIE_STATE];
        int n4 = ZOMBIES[n2 + ZOMBIE_TYPE];
        if (n3 == 67 || n3 == 68 || n3 == 69 || n3 == 70 || n3 == 51 || n3 == 40 || Zombies.isFlagSet(12, n) || Zombies.bIsDeadOrDying(n)) {
            return false;
        }
        if (n4 == 20) {
            if (n3 != 92 && n3 != 93 && n3 != 94) {
                return false;
            }
            if (ZOMBIES[n2 + ZOMBIE_HEALTH_BODY] <= 20) {
                return false;
            }
        }
        return true;
    }

    static boolean bCanBeFrozen(int n) {
        int n2 = n * ZOMBIE_MAX_VALS;
        int n3 = ZOMBIES[n2 + ZOMBIE_STATE];
        return n3 != 41 && n3 != 78 && n3 != 52 && !Zombies.bIsFlying(n) && !Zombies.bIsBouncingPogo(n) && Zombies.bCanBeChilled(n);
    }

    static void updateCatapult(int n) {
        int n2 = n * ZOMBIE_MAX_VALS;
        int n3 = ZOMBIES[n2 + ZOMBIE_STATE];
        int n4 = ZOMBIES[n2 + ZOMBIE_PARAM_1];
        if (n3 == 35) {
            Zombies.getHitRect(n);
            if (n4 > 0 && ZOMBIE_RECT[ZOMBIE_RECT_X] <= 270 && Zombies.findCatapultTarget(n) != -1) {
                Zombies.setState(n, 62, true);
                Zombies.setReanimTrack(n, 164, 1);
            }
        } else if (n3 == 62) {
            if (ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN] <= 0 && Zombies.isFlagSet(8, n)) {
                int n5 = Zombies.findCatapultTarget(n);
                Zombies.catapultFire(n, n5);
                Zombies.unSetFlag(8, n);
            }
            if (ZOMBIES[n2 + ZOMBIE_REANIM_LOOP_COUNT] > 0) {
                int n6 = n2 + ZOMBIE_PARAM_1;
                ZOMBIES[n6] = ZOMBIES[n6] - 1;
                n4 = ZOMBIES[n2 + ZOMBIE_PARAM_1];
                if (n4 == 0) {
                    Zombies.setReanimTrack(n, 163, 0);
                    n3 = 35;
                    Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_STATE] = 35;
                } else {
                    Zombies.setReanimTrack(n, 165, 0);
                    Zombies.setState(n, 63, true);
                    Zombies.setFlag(8, n);
                }
            }
        } else if (n3 == 63 && ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN] <= 0) {
            int n7 = Zombies.findCatapultTarget(n);
            if (n7 != -1) {
                Zombies.setState(n, 62, true);
                Zombies.setReanimTrack(n, 164, 1);
            } else {
                Zombies.setReanimTrack(n, 163, 0);
                n3 = 35;
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_STATE] = 35;
            }
        }
    }

    static int findCatapultTarget(int n) {
        int n2 = n * ZOMBIE_MAX_VALS;
        int n3 = ZOMBIES[n2 + ZOMBIE_ROW];
        Zombies.getHitRect(n);
        int n4 = ZOMBIE_RECT[ZOMBIE_RECT_X];
        int n5 = -1;
        int n6 = 0;
        int n7 = -1;
        for (int i = 0; i < Plants.MAX_NUM_PLANTS && n6 < Plants.m_nPlants; ++i) {
            if (!Plants.isPlantAtIndex(i)) continue;
            int n8 = i * Plants.PLANT_MAX_VALS;
            int n9 = Plants.PLANTS[n8 + Plants.PLANT_TYPE];
            int n10 = Plants.PLANTS[n8 + Plants.PLANT_POS] / 9;
            if (n9 == 13) {
                ++n6;
                continue;
            }
            if (n10 != n3) {
                ++n6;
                continue;
            }
            if (Plants.getHitRect(i)) {
                if (n4 - Plants.PLANT_RECT[Plants.PLANT_RECT_X] < 32) {
                    ++n6;
                    continue;
                }
            } else {
                ++n6;
                continue;
            }
            int n11 = Plants.PLANTS[n8 + Plants.PLANT_POS] % 9;
            if (n5 == -1 || n11 < n7) {
                n7 = n11;
                n5 = i;
            }
            ++n6;
        }
        return n5;
    }

    static void catapultFire(int n, int n2) {
        int n3;
        int n4;
        int n5 = n * ZOMBIE_MAX_VALS;
        Projectiles.getProjectileOffsets(8);
        int n6 = ZOMBIES[n5 + ZOMBIE_FP_CENTRE_X] + Projectiles.PROJECTILE_OFFSETS[Projectiles.PROJECTILE_OFFSET_X] * FP1;
        int n7 = ZOMBIES[n5 + ZOMBIE_FP_TOP_Y] + Projectiles.PROJECTILE_OFFSETS[Projectiles.PROJECTILE_OFFSET_Y] * FP1;
        if (n2 >= 0) {
            Plants.getHitRect(n2);
            n4 = Plants.PLANT_RECT[Plants.PLANT_RECT_X] * FP1;
            n3 = Plants.PLANT_RECT[Plants.PLANT_RECT_Y] * FP1;
        } else {
            n4 = n6 - 120 * FP1;
            n3 = 0;
        }
        int n8 = Math.abs(n6 - n4);
        int n9 = Math.abs(n7 - n3);
        int n10 = FP.fpDiv(n8, -Projectiles.PROJECTILE_LOB_SPEED);
        int n11 = FP.fpDiv(n9, Projectiles.PROJECTILE_LOB_SPEED) + Projectiles.PROJECTILE_LOB_SPEED_OFFSET_Y;
        int n12 = Projectiles.addProjectile(8, FP.toInt(n6), FP.toInt(n7), ZOMBIES[n5 + ZOMBIE_ROW], n, 2, 0);
        int n13 = Projectiles.PROJECTILE_MAX_VALS * n12;
        Projectiles.PROJECTILES[n13 + Projectiles.PROJECTILE_FP_VX] = n10;
        Projectiles.PROJECTILES[n13 + Projectiles.PROJECTILE_FP_VY] = n11;
    }

    static void checkSquishPlants(int n) {
        Zombies.getAttackRect(n);
        int n2 = ZOMBIES[n * ZOMBIE_MAX_VALS + ZOMBIE_ROW];
        int n3 = 0;
        for (int i = 0; i < Plants.MAX_NUM_PLANTS && n3 < Plants.m_nPlants; ++i) {
            if (!Plants.isPlantAtIndex(i)) continue;
            int n4 = i * Plants.PLANT_MAX_VALS;
            int n5 = Plants.PLANTS[n4 + Plants.PLANT_POS] / 9;
            int n6 = Plants.PLANTS[n4 + Plants.PLANT_TYPE];
            if (n5 == n2 && n6 != 13 && Zombies.bCanTargetPlant(i, n, 3) && Plants.getHitRect(i) && Geometry.rectIntersect(Plants.PLANT_RECT[Plants.PLANT_RECT_X], Plants.PLANT_RECT[Plants.PLANT_RECT_Y], Plants.PLANT_RECT[Plants.PLANT_RECT_W], Plants.PLANT_RECT[Plants.PLANT_RECT_H], ZOMBIE_RECT[ZOMBIE_RECT_X], ZOMBIE_RECT[ZOMBIE_RECT_Y], ZOMBIE_RECT[ZOMBIE_RECT_W], ZOMBIE_RECT[ZOMBIE_RECT_H])) {
                Zombies.squishAllPlantsAtPos(Plants.PLANTS[n4 + Plants.PLANT_POS], 3);
                break;
            }
            ++n3;
        }
    }

    static void squishAllPlantsAtPos(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < Plants.MAX_NUM_PLANTS; ++i) {
            if (!Plants.isPlantAtIndex(i)) continue;
            int n4 = i * Plants.PLANT_MAX_VALS;
            if (Plants.PLANTS[n4 + Plants.PLANT_POS] == n) {
                GCanvasController.doDirt(i, 19);
                Plants.squish(i);
            }
            ++n3;
        }
    }

    static boolean bIsBouncingPogo(int n) {
        int n2 = ZOMBIES[n * ZOMBIE_MAX_VALS + ZOMBIE_STATE];
        return n2 == 64 || n2 == 66 || n2 == 65;
    }

    static void updatePogo(int n) {
        int n2;
        int n3;
        if (Zombies.bIsDeadOrDying(n) || Zombies.bIsImmobilized(n) || !Zombies.bIsBouncingPogo(n)) {
            return;
        }
        int n4 = n * ZOMBIE_MAX_VALS;
        int n5 = ZOMBIES[n4 + ZOMBIE_STATE];
        int n6 = 20 * FP1;
        if (n5 == 65) {
            n6 = 28 * FP1;
        } else if (n5 == 66) {
            n6 = 35 * FP1;
        }
        int n7 = FP.toInt(ZOMBIES[n4 + ZOMBIE_FP_STATE_COUNTDOWN]);
        Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_FP_ALTITUDE] = -FP.fpAnimateCurve(18, 0, n7, 0, n6, 4);
        if (n7 == 1) {
            Zombies.setReanimTrack(n, 176, 1);
        }
        if (n5 == 66 && n7 == 16 && (n3 = Zombies.findTargetPlant(n, 1)) != -1 && (n2 = Plants.PLANTS[n3 * Plants.PLANT_MAX_VALS + Plants.PLANT_TYPE]) == 15) {
            Zombies.dropPogo(n, 0);
            Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_FP_VX] = Zombies.getGroundTrackVelFP(n);
            return;
        }
        if (ZOMBIES[n4 + ZOMBIE_FP_STATE_COUNTDOWN] != 0) {
            return;
        }
        n3 = -1;
        if (Zombies.bIsOnBoard(n)) {
            n3 = Zombies.findTargetPlant(n, 1);
        }
        if (n3 == -1) {
            Zombies.setState(n, 64, true);
            Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_FP_VX] = Zombies.isFlagSet(8, n) ? Zombies.getZombieSpeedFP(14, -1) : Zombies.getGroundTrackVelFP(n);
        } else if (n5 == 65) {
            Zombies.setState(n, 66, true);
            Zombies.getHitRect(n);
            Plants.getHitRect(n3);
            n2 = -(ZOMBIE_RECT[ZOMBIE_RECT_X] - Plants.PLANT_RECT[Plants.PLANT_RECT_X] + 12) * FP1;
            int n8 = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(n5) * FP1;
            Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_FP_VX] = FP.fpDiv(n2, n8);
        } else {
            Zombies.setState(n, 65, true);
            Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_FP_VX] = 0;
        }
    }

    static void dropPogo(int n, int n2) {
        if (!Zombies.isFlagSet(8, n)) {
            return;
        }
        if (Zombies.bIsDeadOrDying(n)) {
            return;
        }
        int n3 = ZOMBIE_MAX_VALS * n;
        Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_STATE] = 35;
        Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_SECONDARY_STATE] = 112;
        Zombies.setReanimTrack(n, 179, 0);
        Zombies.updateAnimSpeed(n);
        Zombies.unSetFlag(8, n);
    }

    static void updateDigger(int n) {
        int n2 = n * ZOMBIE_MAX_VALS;
        int n3 = ZOMBIES[n2 + ZOMBIE_STATE];
        if (n3 == 67) {
            if (ZOMBIES[n2 + ZOMBIE_FP_CENTRE_X] < (GModel.getBoardOffsetX(Layer.getLayerProperty(2, 5)) + 27) * FP1) {
                Zombies.setState(n, 68, false);
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_STATE_COUNTDOWN] = 27 * FP1;
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_ALTITUDE] = 50 * FP1;
                Zombies.setReanimTrack(n, 194, 0);
                Zombies.setReanimFPS(n, 6 * FP1, false);
                GCanvasController.doDiggerRiseDirt(n);
            } else {
                int n4 = Util.GetRandom(2);
                if (n4 > 0) {
                    GCanvasController.doDiggerTunnelDirt(n, 15, n4);
                }
            }
        } else if (n3 == 68) {
            int n5 = FP.toInt(ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN]);
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_ALTITUDE] = ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN] > 9 * FP1 ? FP.fpAnimateCurve(27, 9, n5, 50 * FP1, -8 * FP1, 3) : FP.fpAnimateCurve(9, 0, n5, -8 * FP1, 0, 2);
            if (ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN] == 9 * FP1) {
                Zombies.setReanimTrack(n, 195, 0);
                Zombies.setReanimFPS(n, 0, true);
                Zombies.setFlag(9, n);
            }
            if (ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN] == 0) {
                Zombies.setState(n, 71, true);
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_ALTITUDE] = 0;
                Zombies.setReanimTrack(n, 196, 0);
            }
        } else if (n3 == 69) {
            if (ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN] == 0) {
                Zombies.setState(n, 70, false);
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_STATE_COUNTDOWN] = 27 * FP1;
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_ALTITUDE] = -50 * FP1;
                Zombies.setReanimTrack(n, 195, 1);
            }
        } else if (n3 == 70) {
            int n6 = FP.toInt(ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN]);
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_ALTITUDE] = ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN] > 40 * FP1 ? FP.fpAnimateCurve(130, 40, n6, -120, 20, 3) : FP.fpAnimateCurve(30, 0, n6, 20, 0, 2);
            if (ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN] == 30 * FP1) {
                Zombies.setReanimTrack(n, 195, 0);
                Zombies.setFlag(9, n);
            }
            if (ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN] == 0) {
                Zombies.setState(n, 73, true);
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_ALTITUDE] = 0;
                Zombies.setReanimTrack(n, 190, 0);
            }
        } else if (n3 == 71 && ZOMBIES[n2 + ZOMBIE_REANIM_LOOP_COUNT] >= 2) {
            Zombies.setState(n, 72, true);
            Zombies.setReanimTrack(n, 190, 0);
        }
    }

    static void dropAxe(int n) {
        int n2 = n * ZOMBIE_MAX_VALS;
        if (ZOMBIES[n2 + ZOMBIE_STATE] == 67) {
            Zombies.setState(n, 69, true);
        }
        Zombies.unSetFlag(8, n);
        Zombies.hideReanimTrack(n, 201);
    }

    static int getZombieAltitudeClipH(int n) {
        int n2 = n * ZOMBIE_MAX_VALS;
        int n3 = ZOMBIES[n2 + ZOMBIE_TYPE];
        if (n3 == 10) {
            return 60;
        }
        if (n3 == 15) {
            return 50;
        }
        if (ZOMBIES[n2 + ZOMBIE_STATE] == 40) {
            return 72;
        }
        if (ZOMBIES[n2 + ZOMBIE_STATE] == 78) {
            if (Zombies.isFlagSet(15, n)) {
                return 95;
            }
        } else if (Zombies.isFlagSet(15, n)) {
            return 84;
        }
        return 0;
    }

    static boolean bEffectedByDamage(int n, int n2) {
        boolean bl;
        boolean bl2;
        int n3 = n * ZOMBIE_MAX_VALS;
        int n4 = ZOMBIES[n3 + ZOMBIE_TYPE];
        int n5 = ZOMBIES[n3 + ZOMBIE_STATE];
        if (!GModel.bCheckFlags(n2, 16) && Zombies.bIsDeadOrDying(n)) {
            return false;
        }
        if (GModel.bCheckFlags(n2, 64) ? !Zombies.isFlagSet(12, n) : Zombies.isFlagSet(12, n)) {
            return false;
        }
        if (n5 == 41 || n5 == 68 || n5 == 69 || n5 == 70 || n5 == 76 || n5 == 40 || n5 == 78 || n5 == 51) {
            return GModel.bCheckFlags(n2, 8);
        }
        boolean bl3 = bl2 = n4 == 18 && Zombies.isFlagSet(15, n) && !Zombies.isFlagSet(2, n);
        if (GModel.bCheckFlags(n2, 4)) {
            return true;
        }
        boolean bl4 = bl = n5 == 67;
        if (GModel.bCheckFlags(n2, 32) && bl) {
            return true;
        }
        if (GModel.bCheckFlags(n2, 2) && Zombies.bIsFlying(n)) {
            return true;
        }
        return GModel.bCheckFlags(n2, 1) && !bl && !Zombies.bIsFlying(n) && !bl2;
    }

    static void updateBalloon(int n) {
        int n2 = n * ZOMBIE_MAX_VALS;
        int n3 = ZOMBIES[n2 + ZOMBIE_STATE];
        if (n3 == 76 && ZOMBIES[n2 + ZOMBIE_REANIM_LOOP_COUNT] >= 1) {
            Zombies.startWalking(n);
            Zombies.setState(n, 77, false);
        }
    }

    static void landFlyer(int n, int n2) {
        int n3 = n * ZOMBIE_MAX_VALS;
        if (!GModel.bCheckFlags(n2, 16) && ZOMBIES[n3 + ZOMBIE_STATE] == 75) {
            Zombies.setState(n, 76, false);
            Zombies.setReanimTrack(n, 213, 1);
        }
        Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_SECONDARY_STATE] = 112;
        if (GModel.PLANT_ROW[ZOMBIES[n3 + ZOMBIE_ROW]] == 3) {
            Zombies.killZombie(n, true);
        }
    }

    static boolean bIsFlying(int n) {
        int n2 = ZOMBIES[n * ZOMBIE_MAX_VALS + ZOMBIE_STATE];
        return n2 == 75 || n2 == 76;
    }

    static void riseFromGrave(int n, int n2) {
        int n3 = n * ZOMBIE_MAX_VALS;
        int n4 = ZOMBIES[n3 + ZOMBIE_TYPE];
        Zombies.getZombieOffsets(n4, false);
        Cursor.getGridPosRect(n2, 0);
        Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_FP_CENTRE_X] = (Cursor.GRID_POS[Cursor.GRID_POS_X] + ZOMBIE_OFFSETS[ZOMBIE_OFFSET_CENTRE_X] + 18) * FP1;
        Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_FP_TOP_Y] = (Cursor.GRID_POS[Cursor.GRID_POS_Y] + ZOMBIE_OFFSETS[ZOMBIE_OFFSET_TOP_Y]) * FP1;
        Zombies.setState(n, 40, true);
        Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_FP_ALTITUDE] = 57 * FP1;
        Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_PARAM_1] = n2;
        if (GModel.m_bPoolLevel) {
            Zombies.setFlag(15, n);
            Zombies.startWalking(n);
            Zombies.setState(n, 40, true);
            Zombies.hideReanimTrack(n, 16);
            Zombies.showReanimTrack(n, 17);
            GCanvasController.doPoolSplash(n, 0, 0);
            return;
        }
    }

    static void updateRiseFromGrave(int n) {
        int n2 = n * ZOMBIE_MAX_VALS;
        int n3 = FP.toInt(ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN]);
        short s = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(40);
        Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_ALTITUDE] = Zombies.isFlagSet(15, n) ? FP.fpAnimateCurve(s, 0, n3, 57 * FP1, 13 * FP1, 1) : FP.fpAnimateCurve(s, 0, n3, 57 * FP1, 0, 1);
        if (ZOMBIES[n2 + ZOMBIE_FP_STATE_COUNTDOWN] <= 0) {
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_STATE] = 35;
        } else if (!GModel.m_bPoolLevel) {
            GCanvasController.doZombieGraveRiseDirt(n, 15, 1);
        }
    }

    static void setMindControlled(int n) {
        int n2 = n * ZOMBIE_MAX_VALS;
        int n3 = ZOMBIES[n2 + ZOMBIE_TYPE];
        Zombies.setFlag(12, n);
        Zombies.setFlag(9, n);
        Zombies.unSetFlag(3, n);
        Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_CHILLED_COUNTDOWN] = 0;
        Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_BUTTERED_COUNTDOWN] = 0;
        Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FROZEN_COUNTDOWN] = 0;
        if (n3 == 7) {
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_PARAM_1] = -1;
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_PARAM_2] = -1;
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_PARAM_3] = -1;
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_PARAM_4] = -1;
            for (int i = 0; i < 4; ++i) {
                int n4 = ZOMBIES[n2 + (ZOMBIE_PARAM_1 + i)];
                if (n4 == -1) continue;
                Zombies.ZOMBIES[n4 * Zombies.ZOMBIE_MAX_VALS + Zombies.ZOMBIE_PARAM_1] = -1;
            }
        } else if (n3 == 10) {
            int n5 = ZOMBIES[n2 + ZOMBIE_PARAM_1];
            int n6 = ZOMBIES[n2 + ZOMBIE_PARAM_2];
            if (n5 != -1 && ZOMBIES[n5 * ZOMBIE_MAX_VALS + ZOMBIE_TYPE] == 7) {
                Zombies.ZOMBIES[n5 * Zombies.ZOMBIE_MAX_VALS + (Zombies.ZOMBIE_PARAM_1 + n6)] = -1;
            }
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_PARAM_1] = -1;
        }
        Zombies.updateAnimSpeed(n);
    }

    static void applyBurn(int n) {
        int n2 = n * ZOMBIE_MAX_VALS;
        int n3 = ZOMBIES[n2 + ZOMBIE_TYPE];
        int n4 = ZOMBIES[n2 + ZOMBIE_STATE];
        if (n4 == 38 || n4 == 39) {
            return;
        }
        if (n3 != 22 && ZOMBIES[n2 + ZOMBIE_HEALTH_BODY] >= 1800) {
            Zombies.takeDamage(n, 1800, -1, 20, false);
            return;
        }
        if (n4 == 41 || n4 == 40 || n4 == 51 || n4 == 67 || n4 == 69 || n4 == 68 || n4 == 70 || n3 == 18 || Zombies.isFlagSet(15, n) || !Zombies.isFlagSet(4, n) || Zombies.bIsFlying(n)) {
            Zombies.killZombie(n, true);
        } else {
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FROZEN_COUNTDOWN] = 0;
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_CHILLED_COUNTDOWN] = 0;
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_BUTTERED_COUNTDOWN] = 0;
            Zombies.setState(n, 39, false);
            Zombies.setReanim(n3, n, 14, 228, false, 1);
            Zombies.setReanimHoldCountdown(n, 9);
            Zombies.dropLoot(n);
        }
    }

    static void updateBurned(int n) {
        boolean bl = Zombies.updateReanim(n);
        Zombies.killZombie(n, false);
    }

    static boolean bZombieTypeCanGoInPool(int n) {
        return n == 0 || n == 2 || n == 5 || n == 1 || n == 16 || n == 18;
    }

    static boolean bIsZombieTypePoolOnly(int n) {
        return n == 18;
    }

    static void checkForPool(int n) {
        int n2 = n * ZOMBIE_MAX_VALS;
        int n3 = ZOMBIES[n2 + ZOMBIE_TYPE];
        if (!Zombies.bZombieTypeCanGoInPool(n3)) {
            return;
        }
        if (Zombies.bIsFlying(n)) {
            return;
        }
        if (n3 == 18) {
            return;
        }
        int n4 = ZOMBIES[n2 + ZOMBIE_SECONDARY_STATE];
        if (n4 == 106 || n4 == 107) {
            return;
        }
        int n5 = ZOMBIES[n2 + ZOMBIE_ROW];
        int n6 = (GModel.getBoardOffsetX(Layer.getLayerProperty(2, 5)) + 0) * 4096;
        int n7 = n6 + 0x104000;
        int n8 = ZOMBIES[n2 + ZOMBIE_FP_CENTRE_X];
        boolean bl = false;
        if (GModel.PLANT_ROW[n5] == 3) {
            if (n8 < n6) {
                bl = false;
            } else if (n8 < n7) {
                bl = true;
            }
        }
        if (!Zombies.isFlagSet(15, n) && bl) {
            if (GModel.m_nIceTrapCounter > 0) {
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FROZEN_COUNTDOWN] = GModel.m_nIceTrapCounter;
                Zombies.setChillZombie(n, true);
                return;
            }
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_SECONDARY_STATE] = 106;
            Zombies.setFlag(15, n);
            GCanvasController.doPoolSplash(n, 0, 0);
        } else if (Zombies.isFlagSet(15, n) && !bl) {
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_SECONDARY_STATE] = 107;
            Zombies.setReanimTrack(n, 4, 0);
            Zombies.hideReanimTrack(n, 17);
            Zombies.showReanimTrack(n, 16);
            Zombies.showReanimTrack(n, 14);
            Zombies.showReanimTrack(n, 8);
            Zombies.updateAnimSpeed(n);
            GCanvasController.doPoolSplash(n, 0, 0);
        }
    }

    static void updatePool(int n) {
        int n2 = n * ZOMBIE_MAX_VALS;
        int n3 = ZOMBIES[n2 + ZOMBIE_SECONDARY_STATE];
        if (n3 == 107) {
            if (ZOMBIES[n2 + ZOMBIE_TYPE] == 18) {
                int n4 = n2 + ZOMBIE_FP_ALTITUDE;
                ZOMBIES[n4] = ZOMBIES[n4] - 4 * FP1;
            } else {
                int n5 = n2 + ZOMBIE_FP_ALTITUDE;
                ZOMBIES[n5] = ZOMBIES[n5] - 1 * FP1;
            }
            if (ZOMBIES[n2 + ZOMBIE_FP_ALTITUDE] <= 0) {
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_ALTITUDE] = 0;
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_SECONDARY_STATE] = 105;
                Zombies.unSetFlag(15, n);
            }
        } else if (n3 == 106) {
            int n6 = n2 + ZOMBIE_FP_ALTITUDE;
            ZOMBIES[n6] = ZOMBIES[n6] + 1 * FP1;
            if (ZOMBIES[n2 + ZOMBIE_FP_ALTITUDE] >= 53248) {
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_ALTITUDE] = 53248;
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_SECONDARY_STATE] = 105;
                Zombies.startWalking(n);
                Zombies.hideReanimTrack(n, 16);
                Zombies.showReanimTrack(n, 17);
                Zombies.updateAnimSpeed(n);
            }
        }
        if (ZOMBIES[n2 + ZOMBIE_FP_ALTITUDE] <= 0) {
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_ALTITUDE] = 0;
            Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_SECONDARY_STATE] = 105;
        }
    }

    static void updateSnorkel(int n) {
        int n2 = ZOMBIE_MAX_VALS * n;
        int n3 = ZOMBIES[n2 + ZOMBIE_STATE];
        boolean bl = Zombies.isFlagSet(9, n);
        boolean bl2 = Zombies.isFlagSet(2, n);
        if (n3 == 35 && !bl) {
            int n4 = (GModel.getBoardOffsetX(Layer.getLayerProperty(2, 5)) + 260 + 8 + 0) * FP1;
            if (ZOMBIES[n2 + ZOMBIE_FP_CENTRE_X] <= n4 && ZOMBIES[n2 + ZOMBIE_FP_CENTRE_X] > n4 - Cursor.getCursorGameW() * FP1) {
                Zombies.setState(n, 78, true);
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_VX] = Zombies.getZombieSpeedFP(18, 400);
                Zombies.setReanimTrack(n, 241, 1);
            }
        } else if (n3 == 78) {
            int n5 = ZOMBIES[n2 + ZOMBIE_REANIM_INDEX];
            int n6 = ZOMBIES[n2 + ZOMBIE_REANIM_CURR_TRACK_GLOBAL_INDEX];
            int n7 = Reanim.getTrackStartFrame(n5, n6) + Reanim.getTrackFrameCount(n5, n6) - 2;
            if (ZOMBIES[n2 + ZOMBIE_REANIM_FRAME] == n7 && !Zombies.isFlagSet(16, n) && ZOMBIES[n2 + ZOMBIE_REANIM_FP_TICKS_COUNTER] + FP1 >= ZOMBIES[n2 + ZOMBIE_REANIM_FP_FRAMES_PER_TICK]) {
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_ALTITUDE] = 1 * FP1;
                Zombies.setFlag(15, n);
                GCanvasController.doPoolSplash(n, -10, 0);
                Zombies.setFlag(16, n);
            }
            if (ZOMBIES[n2 + ZOMBIE_REANIM_LOOP_COUNT] > 0) {
                Zombies.setState(n, 79, false);
                Zombies.setReanimTrack(n, 240, 0);
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_ALTITUDE] = 0;
            }
        } else if (n3 == 79) {
            int n8 = (GModel.getBoardOffsetX(Layer.getLayerProperty(2, 5)) + 30 + 0) * 4096;
            if (!Zombies.isFlagSet(4, n)) {
                Zombies.takeDamage(n, 1800, -1, 2, false);
            } else if (ZOMBIES[n2 + ZOMBIE_FP_CENTRE_X] <= n8 && !bl) {
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_SECONDARY_STATE] = 107;
                Zombies.setReanimTrack(n, 242, 0);
                Zombies.updateAnimSpeed(n);
                int n9 = n2 + ZOMBIE_FP_CENTRE_X;
                ZOMBIES[n9] = ZOMBIES[n9] - 20 * FP1;
                GCanvasController.doPoolSplash(n, 10, 0);
                Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_ALTITUDE] = 80 * FP1;
                Zombies.startWalking(n);
            } else if (bl) {
                int n10 = (GModel.getBoardOffsetX(Layer.getLayerProperty(2, 5)) + 260 + 0 - 30) * FP1;
                if (ZOMBIES[n2 + ZOMBIE_FP_CENTRE_X] > n10) {
                    Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_SECONDARY_STATE] = 107;
                    Zombies.setReanimTrack(n, 242, 0);
                    Zombies.updateAnimSpeed(n);
                    int n11 = n2 + ZOMBIE_FP_CENTRE_X;
                    ZOMBIES[n11] = ZOMBIES[n11] + 20 * FP1;
                    GCanvasController.doPoolSplash(n, -10, 0);
                    Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_ALTITUDE] = 80 * FP1;
                    Zombies.startWalking(n);
                }
            } else if (bl2) {
                Zombies.setState(n, 80, false);
                Zombies.setReanimTrack(n, 239, 1);
            }
        } else if (n3 == 80) {
            if (!bl2) {
                Zombies.setState(n, 82, false);
                Zombies.setReanimTrack(n, 239, 1);
            } else if (ZOMBIES[n2 + ZOMBIE_REANIM_LOOP_COUNT] > 0) {
                Zombies.setState(n, 37, false);
                Zombies.setReanimTrack(n, 238, 0);
            }
        } else if (n3 == 37) {
            if (!bl2) {
                Zombies.setState(n, 82, false);
                Zombies.setReanimTrack(n, 239, 1);
            }
        } else if (n3 == 82 && ZOMBIES[n2 + ZOMBIE_REANIM_LOOP_COUNT] > 0) {
            Zombies.setState(n, 79, false);
            Zombies.setReanimTrack(n, 240, 0);
        }
    }

    static {
        ZOMBIE_OFFSET_CENTRE_X = 0;
        ZOMBIE_OFFSET_TOP_Y = ZOMBIE_OFFSET_CENTRE_X + 1;
        ZOMBIE_OFFSET_DRAW_X = ZOMBIE_OFFSET_TOP_Y + 1;
        ZOMBIE_OFFSET_DRAW_Y = ZOMBIE_OFFSET_DRAW_X + 1;
        ZOMBIE_OFFSET_BUTTER_X = ZOMBIE_OFFSET_DRAW_Y + 1;
        ZOMBIE_OFFSET_BUTTER_Y = ZOMBIE_OFFSET_BUTTER_X + 1;
        ZOMBIE_OFFSET_MIND_CONTROL_X = ZOMBIE_OFFSET_BUTTER_Y + 1;
        ZOMBIE_OFFSET_MIND_CONTROL_Y = ZOMBIE_OFFSET_MIND_CONTROL_X + 1;
        ZOMBIE_OFFSET_CHILLLED_X = ZOMBIE_OFFSET_MIND_CONTROL_Y + 1;
        ZOMBIE_OFFSET_CHILLLED_Y = ZOMBIE_OFFSET_CHILLLED_X + 1;
        ZOMBIE_OFFSET_SHADOW_X = ZOMBIE_OFFSET_CHILLLED_Y + 1;
        ZOMBIE_OFFSET_SHADOW_Y = ZOMBIE_OFFSET_SHADOW_X + 1;
        ZOMBIE_OFFSET_BURN_X = ZOMBIE_OFFSET_SHADOW_Y + 1;
        ZOMBIE_OFFSET_BURN_Y = ZOMBIE_OFFSET_BURN_X + 1;
        ZOMBIE_OFFSET_BOARD_X = ZOMBIE_OFFSET_BURN_Y + 1;
        ZOMBIE_OFFSET_MAX_VALS = ZOMBIE_OFFSET_BOARD_X + 1;
        ZOMBIE_OFFSETS = new int[ZOMBIE_OFFSET_MAX_VALS];
        ZOMBIE_RECT_X = 0;
        ZOMBIE_RECT_Y = 1;
        ZOMBIE_RECT_W = 2;
        ZOMBIE_RECT_H = 3;
        ZOMBIE_RECT = new int[4];
        FP1 = 4096;
        RENDER_MODE_HIDDEN = 0;
        RENDER_MODE_NORMAL = RENDER_MODE_HIDDEN + 1;
    }
}

