/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class GFFont {
    private static String FONT_FILE = "/f";
    private static final int FONT_DATA_SIZE = 3;
    static int OFFSET_DATA_X = 0;
    static int OFFSET_DATA_Y = 1;
    static int OFFSET_DATA_WIDTH = 2;
    private static final int SPACE_WIDTH = 4;
    private static int m_nNumFonts;
    static String[] FONTS;
    private static String[] FONT_HASHING;
    private static int[] m_nFontImages;
    private static int[] m_nFontHeights;
    private static boolean[] m_bFontUpperCase;

    public static void init() {
        try {
            Runtime.getRuntime().gc();
            InputStream inputStream = FONT_FILE.getClass().getResourceAsStream(FONT_FILE);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            m_nNumFonts = dataInputStream.readByte() & 0xFF;
            if (m_nNumFonts > 0) {
                FONTS = new String[m_nNumFonts];
                FONT_HASHING = new String[m_nNumFonts];
                m_nFontImages = new int[m_nNumFonts];
                m_nFontHeights = new int[m_nNumFonts];
                m_bFontUpperCase = new boolean[m_nNumFonts];
                for (int i = 0; i < m_nNumFonts; ++i) {
                    GFFont.m_nFontImages[i] = 0xFFFF & dataInputStream.readShort();
                    GFFont.m_nFontHeights[i] = 0xFF & dataInputStream.readByte();
                    GFFont.m_bFontUpperCase[i] = (0xFF & dataInputStream.readByte()) != 0;
                    GFFont.FONTS[i] = dataInputStream.readUTF();
                    GFFont.FONT_HASHING[i] = dataInputStream.readUTF();
                }
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static int getCharHash(char c, int n) {
        if (m_bFontUpperCase[n] && c != '#') {
            c = Character.toUpperCase(c);
        }
        String string = FONT_HASHING[n];
        int n2 = string.length();
        int n3 = 0;
        for (int i = 0; i < n2; i += 2) {
            char c2 = string.charAt(i);
            char c3 = string.charAt(i + 1);
            if (c >= c2 && c <= c3) {
                return (n3 + c - c2) * 3;
            }
            n3 += c3 - c2 + 1;
        }
        return -1;
    }

    public static int getFontHeight(int n) {
        return m_nFontHeights[n];
    }

    public static int getCharWidth(char c, int n) {
        int n2 = 0;
        int n3 = GFFont.getCharHash(c, n);
        if (n3 >= 0) {
            n2 = FONTS[n].charAt(n3 + OFFSET_DATA_WIDTH);
        } else if (c == ' ') {
            n2 = 4;
        }
        return n2;
    }

    public static int getCharsWidth(char[] cArray, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n + n2;
        for (int i = n; i < n5; ++i) {
            n4 += GFFont.getCharWidth(cArray[i], n3);
        }
        return n4;
    }

    public static void drawChar(Graphics graphics, char c, int n, int n2, int n3, int n4) {
        int n5 = GFFont.getCharHash(c, n3);
        if (n5 >= 0) {
            int n6 = graphics.getClipX();
            int n7 = graphics.getClipY();
            int n8 = graphics.getClipWidth();
            int n9 = graphics.getClipHeight();
            char c2 = FONTS[n3].charAt(n5 + OFFSET_DATA_WIDTH);
            GFCanvas.clipRect(graphics, n, n2, c2, m_nFontHeights[n3], n4);
            GFCanvas.drawImage(graphics, m_nFontImages[n3], n - FONTS[n3].charAt(n5 + OFFSET_DATA_X), n2 - FONTS[n3].charAt(n5 + OFFSET_DATA_Y), 20, n4);
            graphics.setClip(n6, n7, n8, n9);
        }
    }
}

