/*
 * Decompiled with CFR 0.152.
 */
public class GameController
implements GameConstants,
ConstantsTFC {
    static int m_nGameState = -1;
    static int m_nPostLoadingGameState = -1;
    static int m_nGameStateFrame;
    static int m_nGameMode;
    static boolean isInGameLoading;
    static boolean isGamePaused;
    public static boolean m_bStopProgressflag;
    static int m_nLevel;
    static int[] INPUT_MAPPINGS_RIGHT;
    static int[] INPUT_MAPPINGS_LEFT;
    public static boolean m_bSetStateAfterInterrupt;

    static void init() {
        GFHint.init();
        GCanvas.init();
        GCanvasController.init();
        GModel.init();
        GFBoardTexts.init();
        ZombieController.init();
        Reanim.init();
        SeedBank.init();
        LevelIntro.init();
        SeedPicker.init();
    }

    static void resetAllVarsNewGame() {
        GameController.resetVars();
        GFHint.resetVars();
        ScoreController.resetVars();
        GameController.resetAllVarsNewLevel(0);
        SeedBank.init();
        Plants.init();
        Zombies.init();
        Projectiles.init();
        Coins.init();
        Mowers.init();
        Reanim.resetVars();
        ReanimScaler.resetVars();
        SeedPicker.init();
        SeedPicker.resetVars();
    }

    static void resetAllVarsNewLevel(int n) {
        GameController.resetVarsNewLevel();
        GModel.resetVars();
        GCanvas.resetVars();
        GCanvasController.resetVarsNewLevel();
        ScoreController.resetVarsNewLevel();
        HUDModel.resetVarsNewLevel();
        GFBoardTexts.resetVars();
        GFParticleEngine.resetVars();
        SeedBank.resetVarsNewLevel();
        Plants.resetVarsNewLevel();
        Zombies.resetVarsNewLevel();
        Projectiles.resetVarsNewLevel();
        Coins.resetVarsNewLevel();
        Mowers.resetVarsNewLevel();
        GridItem.resetVarsNewLevel();
        ViewPort.resetViewPort();
        LevelIntro.resetVarsNewLevel();
        AwardScreen.resetVarsNewLevel();
        Hints.resetVarsNewLevel(n);
        SodRoll.resetVars();
        CrazyDave.resetVarsNewLevel();
        SeedPicker.resetVarsNewLevel();
    }

    static void resetVars() {
        m_nLevel = 0;
        m_nGameMode = -1;
        isGamePaused = false;
    }

    static void resetVarsNewLevel() {
        m_nGameStateFrame = 0;
    }

    static void destroyApp() {
    }

    static void updateGame() {
        ++m_nGameStateFrame;
        GCanvasController.updateAnims();
        if (m_nGameState == 0) {
            GModel.update();
        } else if (m_nGameState == 2 && m_nLevel <= 49) {
            LevelIntro.update();
            GModel.update();
        } else if (m_nGameState == 3) {
            LevelIntro.update();
            GModel.update();
        } else if (m_nGameState == 5) {
            GModel.update();
        }
    }

    static void nextLevel(boolean bl) {
        if (bl) {
            ++m_nLevel;
        }
        GameController.loadLevel(m_nLevel);
        m_bStopProgressflag = false;
        GameController.setStatePostLoading(2);
    }

    public static void loadLevel(int n) {
        m_nLevel = n;
        GameController.resetAllVarsNewLevel(n);
        GModel.setLevelVars(n, m_nGameMode);
        isInGameLoading = true;
        if (SeedPicker.getNumOfUnlockedSeeds() > SeedBank.m_nCurrMaxSeeds) {
            Reanim.resetLoadedReanims();
        }
        Loader.startLoadingLoadLevel();
    }

    static void changeState(int n) {
        m_nGameState = n;
        m_nGameStateFrame = -1;
        GameController.initGameState(n);
        GFHint.showHints(false);
        if (n == 1) {
            TouchController.clearTouchZone(279);
            TouchController.clearTouchZone(280);
            TouchController.clearTouchZone(281);
            HandlerButton.clearButton(GFMain.m_LeftGameSoftkeyButton);
            HandlerButton.clearButton(GFMain.m_RightGameSoftkeyButton);
            HandlerButton.clearButton(GFMain.m_LeftHighlightedGameSoftkeyButton);
            HandlerButton.clearButton(GFMain.m_RightHighlightedGameSoftkeyButton);
            int n2 = 4;
            int n3 = Layer.getLayerProperty(2, 4) - 4;
            int n4 = 36;
            HandlerButton.create(GFMain.m_LeftGameSoftkeyButton, 0, -1, n2, n3, 93, -1, n4, -1);
            HandlerButton.create(GFMain.m_LeftHighlightedGameSoftkeyButton, 0, -1, n2, n3, 508, -1, n4, -1);
        }
    }

    static void setStatePostLoading(int n) {
        if (GFLoader.m_bLoading) {
            m_nPostLoadingGameState = n;
        } else {
            GameController.changeState(n);
        }
    }

    static void initGameState(int n) {
        if (n == 0) {
            Hints.flagStartLevelHints();
            Zombies.killAllZombies(0);
            TouchGameController.setInGameZones(m_nLevel);
            if (!GModel.m_bShovelTutorialLevel) {
                for (int i = 0; i < GModel.PLANT_ROW.length; ++i) {
                    if (GModel.PLANT_ROW[i] != 1) {
                        if (m_nLevel >= 40) {
                            Mowers.addMower(1, i, 3 * (GModel.m_nGameBoardRows - i));
                        } else {
                            Mowers.addMower(0, i, 3 * (GModel.m_nGameBoardRows - i));
                        }
                    }
                    if (m_nLevel < 40 || i >= 5) continue;
                    int n2 = GameConstants.ROOF_TOP_LEVELS_POT_PLACEMENT_PER_COLUMN[m_nLevel - 40];
                    for (int j = 0; j < n2; ++j) {
                        Plants.addPlant(30, i * 9 + j);
                    }
                }
                HUDModel.setHudComponentsPanPositions();
                GModel.m_bEnableGraveStones = true;
            }
        } else if (n == 2) {
            LevelIntro.startLevelIntro();
        } else if (n == 3) {
            SeedPicker.addSeedsToHUD();
            LevelIntro.startLevelOutro();
        } else if (n == 5) {
            if (m_nLevel == 0) {
                SodRoll.addNewSodRoll(2);
            } else if (m_nLevel == 1) {
                SodRoll.addNewSodRoll(1);
                SodRoll.addNewSodRoll(3);
            } else {
                GameController.changeState(0);
            }
        }
    }

    static int getLevelTextID(int n) {
        return 0;
    }

    static void newGame(int n, int n2) {
        GameController.resetAllVarsNewGame();
        m_nGameMode = n;
        GameController.loadLevel(n2);
        GameController.setStatePostLoading(2);
    }

    static void resumeGame(int n) {
        GameController.resetAllVarsNewGame();
        m_nGameMode = n;
        RMS.loadGameData(false);
        Hints.resetVarsNewLevel(m_nLevel);
        GameController.loadLevel(m_nLevel);
        GameController.setStatePostLoading(2);
    }

    static void handleInput(int[] nArray) {
        if (m_nGameState == 0) {
            if (GFMain.m_nHeldFrameCounter > 5) {
                GFMain.m_nHeldFrameCounter = 0;
            }
            if (GFMain.m_nHeldFrameCounter == 0) {
                Cursor.handleCursor(nArray, GFMain.m_nHeldKeys);
            }
        } else if (m_nGameState == 1 && ((GFMain.m_nLastPressed & nArray[4]) != 0 || (GFMain.m_nLastPressed & nArray[5]) != 0)) {
            GFUIState.gotoStateOrPerformAction(24);
        }
        if ((GFMain.m_nLastPressed & nArray[6]) != 0) {
            HandlerButton.handleButtonPress(GFMain.m_RightGameSoftkeyButton);
        } else if ((GFMain.m_nLastPressed & nArray[5]) != 0) {
            HandlerButton.handleButtonPress(GFMain.m_LeftGameSoftkeyButton);
        }
    }

    static void doGameOver() {
        GameController.changeState(1);
        GCanvasController.m_nGameOverFadeFrame = 0;
    }

    static void setGameSoftkeys() {
        HandlerButton.clearButton(GFMain.m_LeftGameSoftkeyButton);
        HandlerButton.clearButton(GFMain.m_RightGameSoftkeyButton);
        HandlerButton.clearButton(GFMain.m_LeftHighlightedGameSoftkeyButton);
        HandlerButton.clearButton(GFMain.m_RightHighlightedGameSoftkeyButton);
        int n = 4;
        int n2 = Layer.getLayerProperty(2, 4) - 4;
        int n3 = 36;
        int n4 = Layer.getLayerProperty(2, 3) - 4;
        int n5 = Layer.getLayerProperty(2, 4) - 4;
        int n6 = 40;
        int n7 = n3 - n - 4 - 3;
        if (m_nLevel >= 4) {
            short s = (short)"]\u015d\u01fb\u00fa\u013c".charAt(4);
            short s2 = (short)"\u01fca\u019f\u00b6\u01c8".charAt(4);
            HandlerButton.create(GFMain.m_LeftGameSoftkeyButton, 0, -1, Graphic.m_nDeviceHeight - n7, n7, s, 1000, n3, -1);
            HandlerButton.create(GFMain.m_LeftHighlightedGameSoftkeyButton, 0, -1, n, n2, s2, 1000, n3, -1);
        }
        HandlerButton.create(GFMain.m_RightGameSoftkeyButton, 0, -1, n4, n5, 349, 999, n6, -1);
        HandlerButton.create(GFMain.m_RightHighlightedGameSoftkeyButton, 0, -1, n4, n5, 349, 999, n6, -1);
    }

    static int[] getInputMappings() {
        if ((Layer.getLayerProperty(2, 5) & 2) != 0) {
            return INPUT_MAPPINGS_LEFT;
        }
        if ((Layer.getLayerProperty(2, 5) & 4) != 0) {
            return INPUT_MAPPINGS_RIGHT;
        }
        return InputConstants.INPUT_MAPPINGS_DEFAULT;
    }

    static void finishedLoading() {
        if (m_bSetStateAfterInterrupt) {
            GFUIState.m_nUIState = -1;
            PVZActions.m_bRestartGameLoadingFlag = false;
            PVZActions.m_bRestartLevelFlag = false;
            m_bSetStateAfterInterrupt = false;
        }
        if (GFUIState.m_nUIState != -1) {
            return;
        }
        if (m_nPostLoadingGameState != -1) {
            GameController.changeState(m_nPostLoadingGameState);
        }
    }

    static {
        isInGameLoading = false;
        isGamePaused = false;
        m_bStopProgressflag = false;
        INPUT_MAPPINGS_RIGHT = new int[]{8192, 4096, 16384, 32768, 65536, 0x400000, 0x800000};
        INPUT_MAPPINGS_LEFT = new int[]{4096, 8192, 32768, 16384, 65536, 0x400000, 0x800000};
        m_bSetStateAfterInterrupt = false;
    }
}

