/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;

public class SplitFileInputStream
implements Constants {
    static int dataPointer = 0;
    static int nCurrentFile = 0;
    static int startPointer = 0;
    static int endPointer = 0;
    public static byte[] DATA_WINDOW = new byte[32768];
    public static byte[] FIELD_WINDOW = new byte[8];
    static final String IMAGE_PREFIX = "/i";

    public static void init() {
        nCurrentFile = 0;
        dataPointer = 0;
        try {
            SplitFileInputStream.loadNextImageFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadNextImageFile() throws IOException {
        InputStream inputStream = Graphic.STANDARD_GRAPHICS_FILE.getClass().getResourceAsStream(IMAGE_PREFIX + nCurrentFile);
        inputStream.read(DATA_WINDOW, 0, 32768);
        inputStream.close();
        inputStream = null;
        startPointer = 32768 * nCurrentFile;
        endPointer = startPointer + 32768;
        ++nCurrentFile;
        System.gc();
    }

    public static byte[] updateWindow(int n, boolean bl) throws IOException {
        int n2;
        boolean bl2 = false;
        int n3 = 0;
        while (!bl2) {
            n2 = dataPointer + n;
            if (n2 >= endPointer) {
                int n4 = n2 - endPointer;
                int n5 = n - n4;
                int n6 = dataPointer % 32768;
                if (!bl) {
                    System.arraycopy(DATA_WINDOW, n6, FIELD_WINDOW, n3, n5);
                }
                dataPointer += n5;
                n -= n5;
                SplitFileInputStream.loadNextImageFile();
                n3 += n5;
                continue;
            }
            bl2 = !bl2;
        }
        n2 = dataPointer % 32768;
        if (!bl) {
            System.arraycopy(DATA_WINDOW, n2, FIELD_WINDOW, n3, n);
        }
        dataPointer += n;
        return FIELD_WINDOW;
    }

    public static byte readByte() throws IOException {
        return SplitFileInputStream.updateWindow(1, false)[0];
    }

    public static char readChar() throws IOException {
        char c = Util.readBytesAsChar(SplitFileInputStream.updateWindow(2, false), 0);
        return c;
    }

    public static void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        boolean bl = false;
        while (!bl) {
            n3 = dataPointer + n2;
            if (n3 >= endPointer) {
                int n4 = n3 - endPointer;
                int n5 = n2 - n4;
                int n6 = dataPointer % 32768;
                System.arraycopy(DATA_WINDOW, n6, byArray, n, n5);
                dataPointer += n5;
                n2 -= n5;
                SplitFileInputStream.loadNextImageFile();
                n += n5;
                continue;
            }
            bl = !bl;
        }
        n3 = dataPointer % 32768;
        System.arraycopy(DATA_WINDOW, n3, byArray, n, n2);
        dataPointer += n2;
    }

    public static int readInt() throws IOException {
        return Util.readBytesAsInt(SplitFileInputStream.updateWindow(4, false), 0, 4);
    }

    public static long readLong() throws IOException {
        return Util.readBytesAsLong(SplitFileInputStream.updateWindow(8, false), 0, 8);
    }

    public static short readShort() throws IOException {
        return Util.readShort(SplitFileInputStream.updateWindow(2, false), 0);
    }

    public static int readUnsignedByte() throws IOException {
        return Util.readBytesAsInt(SplitFileInputStream.updateWindow(1, false), 0, 1);
    }

    public static int readUnsignedShort() throws IOException {
        return Util.readBytesAsInt(SplitFileInputStream.updateWindow(2, false), 0, 2);
    }

    public static int skipBytes(int n) throws IOException {
        SplitFileInputStream.updateWindow(n, true);
        return n;
    }
}

