/*
 * Decompiled with CFR 0.152.
 */
public class ViewPort
implements GameConstants,
Constants,
ConstantsTFC {
    static int m_nViewX;
    static int m_nViewY;
    static int m_nViewW;
    static int m_nViewH;
    static int m_nZoomDecelThresX;
    static int m_nZoomX;
    static int m_nZoomY;
    static int m_nfpZoomVX;
    static int m_nZoomDecelPercentage;
    static int m_nZoomAccelPercentage;

    static void resetViewPort() {
        m_nViewW = Layer.getLayerProperty(2, 3);
        m_nViewH = Layer.getLayerProperty(2, 4);
        m_nViewX = 0;
        m_nViewY = 0;
        m_nZoomX = 0;
        m_nZoomY = 0;
        m_nZoomDecelThresX = 0;
        m_nfpZoomVX = 0;
    }

    static void changeOrientation() {
        ViewPort.resetViewPort();
        ViewPort.checkViewPort();
    }

    static void checkViewPort() {
        boolean bl;
        boolean bl2 = bl = (Cursor.m_nCursorType == 0 || Cursor.m_nCursorType == 3) && m_nfpZoomVX == 0 && Layer.isPortrait(2);
        if (bl) {
            Cursor.getGridPosRect(Cursor.m_nCursorPos, Cursor.m_nCursorType);
            int n = Cursor.GRID_POS[Cursor.GRID_POS_X];
            int n2 = Cursor.GRID_POS[Cursor.GRID_POS_W];
            int n3 = m_nViewW - -37;
            if (n + 2 * n2 > m_nViewW) {
                m_nZoomX = 320 - n3;
                m_nfpZoomVX = 4096;
            } else if (n < m_nViewX) {
                m_nZoomX = 0;
                m_nfpZoomVX = -4096;
            }
            if (m_nfpZoomVX != 0) {
                m_nZoomDecelPercentage = GModel.FP_30_PERCENT;
                m_nZoomAccelPercentage = GModel.FP_30_PERCENT;
                m_nZoomDecelThresX = m_nZoomX * 70 / 100;
            }
        }
    }

    static void startLevel() {
        ViewPort.resetViewPort();
        if (!GModel.m_bShovelTutorialLevel) {
            m_nViewX = GModel.getDrawAreaOffsetX();
        }
    }

    static void startLevelIntroMoving() {
        ViewPort.resetViewPort();
        m_nViewX = GModel.getDrawAreaOffsetX();
        m_nZoomX = GFCanvas.getImageWidth(GModel.m_nBackgroundImgID) - m_nViewW + GModel.getDrawAreaOffsetX();
        m_nZoomDecelThresX = m_nZoomX / 2;
        m_nfpZoomVX = 4096;
        if (Layer.isPortrait(2)) {
            m_nZoomDecelPercentage = FP.fpDiv(102400, 409600);
            m_nZoomAccelPercentage = FP.fpDiv(81920, 409600);
        } else {
            m_nZoomDecelPercentage = FP.fpDiv(102400, 409600);
            m_nZoomAccelPercentage = FP.fpDiv(81920, 409600);
        }
    }

    static void startLevelOutroMoving() {
        m_nZoomX = 0;
        m_nZoomDecelThresX = m_nViewX / 2;
        m_nfpZoomVX = -4096;
        if (Layer.isPortrait(2)) {
            m_nZoomDecelPercentage = FP.fpDiv(81920, 409600);
            m_nZoomAccelPercentage = FP.fpDiv(81920, 409600);
        } else {
            m_nZoomDecelPercentage = FP.fpDiv(81920, 409600);
            m_nZoomAccelPercentage = FP.fpDiv(81920, 409600);
        }
    }

    static void updateViewPort() {
        if (m_nfpZoomVX != 0) {
            m_nViewX += FP.toInt(m_nfpZoomVX);
            int n = FP.fpMul(m_nfpZoomVX, m_nZoomAccelPercentage);
            int n2 = FP.fpMul(m_nfpZoomVX, m_nZoomDecelPercentage);
            if (m_nZoomX > 0) {
                if (m_nViewX >= m_nZoomX) {
                    m_nViewX = m_nZoomX;
                    m_nfpZoomVX = 0;
                } else {
                    m_nfpZoomVX = m_nViewX > m_nZoomDecelThresX ? Util.clampInt(m_nfpZoomVX - n2, 8192, m_nfpZoomVX) : (m_nfpZoomVX += n);
                }
            } else if (m_nViewX <= m_nZoomX) {
                m_nViewX = m_nZoomX;
                m_nfpZoomVX = 0;
            } else {
                m_nfpZoomVX = m_nViewX < m_nZoomDecelThresX ? Util.clampInt(m_nfpZoomVX - n2, m_nfpZoomVX, -8192) : (m_nfpZoomVX += n);
            }
        }
    }

    static boolean bFinishedZoom() {
        return m_nfpZoomVX == 0;
    }
}

