/*
 * Decompiled with CFR 0.152.
 */
public class Coins
implements GameConstants,
Constants {
    static int MAX_NUM_COINS = 100;
    static int COIN_TYPE = 0;
    static int COIN_FRAME = COIN_TYPE + 1;
    static int COIN_FP_X = COIN_FRAME + 1;
    static int COIN_FP_Y = COIN_FP_X + 1;
    static int COIN_FP_VX = COIN_FP_Y + 1;
    static int COIN_FP_VY = COIN_FP_VX + 1;
    static int COIN_FP_ZOOM_LEN = COIN_FP_VY + 1;
    static int COIN_FP_ZOOM_LEN_TOT = COIN_FP_ZOOM_LEN + 1;
    static int COIN_FP_ZOOM_SPEED = COIN_FP_ZOOM_LEN_TOT + 1;
    static int COIN_FP_DEST_Y = COIN_FP_ZOOM_SPEED + 1;
    static int COIN_STATE = COIN_FP_DEST_Y + 1;
    static int COIN_COUNTDOWN_FRAME = COIN_STATE + 1;
    static int COIN_AWARD_TYPE = COIN_COUNTDOWN_FRAME + 1;
    static int COIN_ZONE_ID = COIN_AWARD_TYPE + 1;
    static int COIN_SEED_TYPE = COIN_ZONE_ID + 1;
    static int COIN_MAX_VALS = COIN_SEED_TYPE + 1;
    static int[] COINS = new int[MAX_NUM_COINS * COIN_MAX_VALS];
    static int m_nCoins;
    static int FP1000;

    static void init() {
    }

    static void resetVarsNewLevel() {
        Util.resetArray(COINS, -1);
        m_nCoins = 0;
    }

    static int addCoin(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n >= 0) {
            int n7 = 0;
            for (int i = 0; i < MAX_NUM_COINS; ++i) {
                if (Coins.isCoinAtIndex(i)) continue;
                n7 = COIN_MAX_VALS * i;
                Coins.COINS[n7 + Coins.COIN_TYPE] = n;
                Coins.COINS[n7 + Coins.COIN_FP_X] = n2 * 4096;
                Coins.COINS[n7 + Coins.COIN_FP_Y] = n3 * 4096;
                Coins.COINS[n7 + Coins.COIN_FP_VX] = Coins.getCoinFpVx(n);
                Coins.COINS[n7 + Coins.COIN_FP_VY] = Coins.getCoinFpVy(n);
                Coins.COINS[n7 + Coins.COIN_FP_DEST_Y] = 4096 * n4;
                Coins.COINS[n7 + Coins.COIN_COUNTDOWN_FRAME] = -1;
                Coins.COINS[n7 + Coins.COIN_AWARD_TYPE] = n6;
                Coins.COINS[n7 + Coins.COIN_SEED_TYPE] = -1;
                Coins.COINS[n7 + Coins.COIN_STATE] = n5 == -1 ? (int)((short)"\u0000\u0002\u0002\u0002\u0002\u0002".charAt(n)) : n5;
                Coins.COINS[n7 + Coins.COIN_ZONE_ID] = TouchGameController.createNewCoinZone(n2, n3, n);
                ++m_nCoins;
                return i;
            }
        }
        return -1;
    }

    static boolean isCoinAtIndex(int n) {
        return COINS[COIN_MAX_VALS * n + COIN_TYPE] != -1;
    }

    static int getCoinFpVx(int n) {
        int n2 = FP.fpDiv(4096 * (short)"\u0000\u05dc\u05dc\u05dc\u05dc\u05dc".charAt(n), FP1000);
        if (n == 1 || n == 2) {
            n2 = FP.getRandFPValueAsFP(-n2, n2);
        }
        return n2;
    }

    static int getCoinFpVy(int n) {
        int n2 = FP.fpDiv(4096 * (short)"\u0bb8\uf060\uf060\uf060\uf060\uf060".charAt(n), FP1000);
        return n2;
    }

    static void update() {
        int n = 0;
        for (int i = 0; i < MAX_NUM_COINS && n < m_nCoins; ++i) {
            if (!Coins.isCoinAtIndex(i)) continue;
            Coins.updateCoin(i);
            ++n;
        }
        CollisionHandler.checkCursorCoinCollision();
    }

    static void updateCoin(int n) {
        int n2 = COIN_MAX_VALS * n;
        int n3 = COINS[n2 + COIN_TYPE];
        int n4 = COINS[n2 + COIN_STATE];
        if (n4 == 3) {
            AwardScreen.setAward(COINS[n2 + COIN_AWARD_TYPE], COINS[n2 + COIN_SEED_TYPE], 1);
            if (GameController.m_nGameStateFrame % 2 == 0) {
                GCanvasController.doAwardStars(n, false);
            }
        } else if (n4 == 0 || n4 == 2) {
            Coins.updateSun(n);
        } else if (n4 == 1) {
            Coins.updateStateZoomToDest(n);
        }
    }

    static void scoreCoin(int n) {
        int n2 = COIN_MAX_VALS * n;
        int n3 = COINS[n2 + COIN_TYPE];
        if (n3 == 0 || n3 == 1 || n3 == 2) {
            ScoreController.m_nSun += "\u0019\u0019\u000f\uffff\uffff\uffff".charAt(n3);
        }
        Coins.killCoin(n);
    }

    static int getCoinIndexFromAttribute(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < MAX_NUM_COINS && n3 < m_nCoins; ++i) {
            if (!Coins.isCoinAtIndex(i)) continue;
            n4 = COIN_MAX_VALS * i;
            if (COINS[n4 + n] == n2) {
                return i;
            }
            ++n3;
        }
        return -1;
    }

    static void killCoin(int n) {
        TouchGameController.updateCoinZone(n, true);
        Coins.COINS[n * Coins.COIN_MAX_VALS + Coins.COIN_TYPE] = -1;
        --m_nCoins;
    }

    static void updateSun(int n) {
        int n2 = COIN_MAX_VALS * n;
        int n3 = COINS[n2 + COIN_TYPE];
        int n4 = COINS[n2 + COIN_STATE];
        int n5 = COINS[n2 + COIN_AWARD_TYPE];
        if (n4 == 2) {
            int n6 = n2 + COIN_FP_X;
            COINS[n6] = COINS[n6] + COINS[n2 + COIN_FP_VX];
            int n7 = n2 + COIN_FP_Y;
            COINS[n7] = COINS[n7] + (COINS[n2 + COIN_FP_VY] + 8192);
            Coins.COINS[n2 + Coins.COIN_FP_Y] = Math.min(COINS[n2 + COIN_FP_Y], COINS[n2 + COIN_FP_DEST_Y]);
            Coins.COINS[n2 + Coins.COIN_FP_VX] = FP.fpMul(GModel.FP_90_PERCENT, COINS[n2 + COIN_FP_VX]);
            Coins.COINS[n2 + Coins.COIN_FP_VY] = FP.fpMul(GModel.FP_90_PERCENT, COINS[n2 + COIN_FP_VY]);
        } else {
            int n8 = n2 + COIN_FP_X;
            COINS[n8] = COINS[n8] + COINS[n2 + COIN_FP_VX];
            int n9 = n2 + COIN_FP_Y;
            COINS[n9] = COINS[n9] + COINS[n2 + COIN_FP_VY];
        }
        Coins.COINS[n2 + Coins.COIN_FP_Y] = Math.min(COINS[n2 + COIN_FP_Y], COINS[n2 + COIN_FP_DEST_Y]);
        if (COINS[n2 + COIN_FP_Y] == COINS[n2 + COIN_FP_DEST_Y] && n5 == -1) {
            if (COINS[n2 + COIN_COUNTDOWN_FRAME] == -1) {
                Coins.COINS[n2 + Coins.COIN_COUNTDOWN_FRAME] = 126;
            } else if (COINS[n2 + COIN_COUNTDOWN_FRAME] >= 0) {
                int n10 = n2 + COIN_COUNTDOWN_FRAME;
                COINS[n10] = COINS[n10] - 1;
                if (COINS[n2 + COIN_COUNTDOWN_FRAME] == 0) {
                    Coins.killCoin(n);
                }
            }
        }
        TouchGameController.updateCoinZone(n, false);
    }

    static void startZoomToDest(int n) {
        int n2;
        int n3;
        int n4 = COIN_MAX_VALS * n;
        int n5 = COINS[n4 + COIN_TYPE];
        int n6 = COINS[n4 + COIN_SEED_TYPE];
        int n7 = COINS[n4 + COIN_AWARD_TYPE];
        if (n7 != -1) {
            GCanvasController.doAwardStars(n, true);
        }
        Coins.COINS[n4 + Coins.COIN_STATE] = 1;
        Coins.COINS[n4 + Coins.COIN_COUNTDOWN_FRAME] = -1;
        if (Layer.isLandscape(2)) {
            n3 = "<<<\u00a0\u00a0\u00a0".charAt(n5);
            n2 = "\t\t\txxx".charAt(n5);
        } else {
            n3 = (short)"\n\n\nxxx".charAt(n5);
            n2 = (short)"\t\t\t\u00a0\u00a0\u00a0".charAt(n5);
        }
        if (n6 >= 0) {
            n3 -= GFCanvas.getImageWidth((short)"\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(n6)) / 2;
            n2 -= GFCanvas.getImageHeight((short)"\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(n6)) / 2;
        } else if (n5 >= 0) {
            n3 -= GFCanvas.getImageWidth((short)"\u01c6\u01c6\u0197\u019b\u00e6\u014e".charAt(n5)) / 2;
            n2 -= GFCanvas.getImageHeight((short)"\u01c6\u01c6\u0197\u019b\u00e6\u014e".charAt(n5)) / 2;
        }
        int n8 = (n3 + ViewPort.m_nViewX) * 4096 - COINS[n4 + COIN_FP_X];
        int n9 = (n2 + ViewPort.m_nViewY) * 4096 - COINS[n4 + COIN_FP_Y];
        Coins.COINS[n4 + Coins.COIN_FP_ZOOM_LEN_TOT] = Vector.length(n8, n9);
        Coins.COINS[n4 + Coins.COIN_FP_ZOOM_LEN] = 0;
        Vector.normalise(n8, n9);
        Coins.COINS[n4 + Coins.COIN_FP_ZOOM_SPEED] = n7 != -1 ? 40960 : 81920;
        Vector.scale(Vector.vrx, Vector.vry, COINS[n4 + COIN_FP_ZOOM_SPEED]);
        Coins.COINS[n4 + Coins.COIN_FP_VX] = Vector.vrx;
        Coins.COINS[n4 + Coins.COIN_FP_VY] = Vector.vry;
    }

    static void updateStateZoomToDest(int n) {
        int n2 = COIN_MAX_VALS * n;
        int n3 = COINS[n2 + COIN_TYPE];
        int n4 = COINS[n2 + COIN_FP_X];
        int n5 = COINS[n2 + COIN_FP_Y];
        int n6 = COINS[n2 + COIN_FP_VX];
        int n7 = COINS[n2 + COIN_FP_VY];
        int n8 = COINS[n2 + COIN_FP_ZOOM_LEN];
        int n9 = COINS[n2 + COIN_FP_ZOOM_LEN_TOT];
        int n10 = COINS[n2 + COIN_FP_ZOOM_SPEED];
        int n11 = COINS[n2 + COIN_AWARD_TYPE];
        int n12 = 4096;
        if (n11 != -1) {
            if (Math.abs(n6) > 4096 && Math.abs(n7) > 4096) {
                n12 = GModel.FP_95_PERCENT;
            }
        } else if (Math.abs(n6) + Math.abs(n7) > n10 / 2) {
            n12 = GModel.FP_95_PERCENT;
            if (n8 > n9 / 3 && Math.abs(n6) > 4096 && Math.abs(n7) > 4096) {
                n12 = GModel.FP_80_PERCENT;
            }
        }
        if (n12 != 4096) {
            Vector.scale(n6, n7, n12);
            n7 = Vector.vry;
            n6 = Vector.vrx;
        }
        int n13 = Vector.length(n6, n7);
        n8 = Math.min(n8 + n13, n9);
        boolean bl = false;
        if (n3 == 1 || n3 == 0 || n3 == 2) {
            int n14 = ((short)"<<<\u00a0\u00a0\u00a0".charAt(n3) - GFCanvas.getImageWidth((short)"\u01c6\u01c6\u0197\u019b\u00e6\u014e".charAt(n3)) / 2) * 4096;
            int n15 = ((short)"\t\t\txxx".charAt(n3) - GFCanvas.getImageHeight((short)"\u01c6\u01c6\u0197\u019b\u00e6\u014e".charAt(n3)) / 2) * 4096;
            if (n6 < 0 && n4 <= n14 && n7 < 0 && n5 <= n15) {
                bl = true;
            }
        }
        if (n8 < n9 && !bl) {
            Coins.COINS[n2 + Coins.COIN_FP_X] = n4 += n6;
            Coins.COINS[n2 + Coins.COIN_FP_Y] = n5 += n7;
            Coins.COINS[n2 + Coins.COIN_FP_VX] = n6;
            Coins.COINS[n2 + Coins.COIN_FP_VY] = n7;
            Coins.COINS[n2 + Coins.COIN_FP_ZOOM_LEN] = n8;
            Coins.COINS[n2 + Coins.COIN_FP_ZOOM_LEN_TOT] = n9;
        } else if (n11 != -1) {
            Coins.COINS[n2 + Coins.COIN_STATE] = 3;
        } else {
            Coins.scoreCoin(n);
        }
    }

    static {
        FP1000 = 4096000;
    }
}

