/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class Text
implements Constants {
    private static final int TOP_LEFT = 20;
    static String[] GAME_STRINGS = new String[293];
    static final String STANARD_RESOURCE_NAME_TEXTS = "/t";
    static final int TEXT_ALIGNMENT_LEFT = 1;
    static final int TEXT_ALIGNMENT_CENTER = 2;
    static final int TEXT_ALIGNMENT_RIGHT = 3;
    static int m_nTextWindowScrollerColor = 0xFFFFFF;
    static final int MAX_TEXT_WINDOW_LENGTH = 2800;
    static final int MAX_NUMBER_LENGTH = 64;
    static StringBuffer m_sTextBuffer = new StringBuffer(2800);
    public static StringBuffer m_sbTextWindowText = new StringBuffer(2800);
    static StringBuffer m_NumberAsText = new StringBuffer(64);
    static int[] m_TextWindowIntegers = new int[16];
    static int m_nTextWindowLinesCount;
    static int m_nTextWindowNumSeperateLines;
    static int m_nTextWindowFirstLine;
    static int m_nTextWindowVisibleLines;
    static int m_nNumPages;
    static int m_nCurrPage;
    static int m_nTextWindowWidth;
    static int m_nMaxLineWidth;
    static int m_nTextWindowHeight;
    private static int m_nTextWindowFont;
    private static int m_nTextWindowTextOffset;
    private static int m_nTextWindowTextLength;
    private static int m_nTextWindowFontHeight;
    private static int[] m_nTextWindowLines;
    private static int[] m_nTextWindowLineAlignment;
    private static boolean m_bTextWindowScrolling;
    public static int m_nMaxTextWidth;
    static int m_nTextWindowLineGap;
    public static int m_nCurrLang;
    static int m_nMarqueeX;
    static int m_nMarqueeY;
    static int m_nMarqueeBorderLeft;
    static int m_nMarqueeBorderRight;
    static int m_nMarqueeSpeed;
    static int m_nMarqueeFontID;
    static int m_nMarqueeGap;
    static int m_nMarqueeDirection;
    static int m_nMarqueeIterations;
    static int m_nMarqueeW;
    static StringBuffer m_strMarqueeText;
    static final int MARQUEE_INFINITE = -1;
    static final int MARQUEE_DIR_LEFT = 0;
    static final int MARQUEE_DIR_RIGHT = 1;
    static final char CUSTOM_LINEBREAK_DELIMITER = '@';
    static final char ALIGMENT_CHANGE_RIGHT_DELIMITER = '^';
    static final char TEXT_MARKER_CHAR = '~';
    static final int MAX_TEXT_WINDOW_MARKERS = 5;
    static int m_nTextWindowMarkerCount;
    static int[] m_TextWindowMarkerX;
    static int[] m_TextWindowMarkerY;
    static int[] m_TextWindowMarkerCharPos;
    static int m_nTextWindowScrollerWidth;
    static final int SCROLLER_SIDE_GAP = 1;

    static void Init() {
        GFFont.init();
    }

    static void LoadTexts() {
        Text.LoadTexts(STANARD_RESOURCE_NAME_TEXTS);
    }

    static void LoadTexts(int n) {
        m_nCurrLang = n;
        if (n == -1) {
            n = 0;
        }
        if (GAME_STRINGS[0] == null) {
            Text.LoadTexts(STANARD_RESOURCE_NAME_TEXTS, 0, 12);
        }
        Text.LoadTexts("/t-" + GAME_STRINGS["\u0006\u0007\b\t\n\u000b".charAt(n)], 12, 281);
    }

    static void LoadTexts(String string) {
        if (GAME_STRINGS[0] == null) {
            Text.LoadTexts(string, 0, 293);
        }
    }

    static void LoadTexts(String string, int n, int n2) {
        try {
            InputStream inputStream = string.getClass().getResourceAsStream(string);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            for (int i = 0; i < n2; ++i) {
                byte[] byArray = dataInputStream.readUTF().getBytes();
                Text.GAME_STRINGS[n + i] = new String(byArray, "UTF-8");
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static int CreateTextWindow(int n, int n2, int n3, int n4, boolean bl, int n5, boolean bl2, int n6, int n7) {
        m_sTextBuffer.setLength(0);
        return Text.CreateTextWindow(m_sTextBuffer.append(GAME_STRINGS[n]), 0, GAME_STRINGS[n].length(), n2, n3, n4, bl, n5, bl2, n6, n7);
    }

    static int CreateTextWindow(String string, int n, int n2, int n3, boolean bl, int n4, boolean bl2, int n5, int n6) {
        m_sTextBuffer.setLength(0);
        return Text.CreateTextWindow(m_sTextBuffer.append(string), 0, string.length(), n, n2, n3, bl, n4, bl2, n5, n6);
    }

    static int CreateTextWindow(StringBuffer stringBuffer, int n, int n2, int n3, int n4, int n5, boolean bl, int n6, boolean bl2, int n7, int n8) {
        int n9;
        int n10;
        m_sbTextWindowText.setLength(0);
        m_sbTextWindowText.append((Object)stringBuffer);
        int n11 = 0;
        if (n7 > 0) {
            for (n10 = 0; n10 < m_sbTextWindowText.length() && n11 != n7; ++n10) {
                if (m_sbTextWindowText.charAt(n10) != '%' || m_sbTextWindowText.charAt(n10 + 1) != 'd') continue;
                m_sbTextWindowText.delete(n10, n10 + 2);
                m_sbTextWindowText.insert(n10, m_TextWindowIntegers[n11++]);
            }
            n2 = m_sbTextWindowText.length() - n11;
        }
        Text.setTextMarkerPos(n8);
        m_sbTextWindowText.ensureCapacity(2800);
        n10 = 0;
        if (m_sbTextWindowText.charAt(0) == '@') {
            n10 = m_sbTextWindowText.charAt(1);
            n += 2;
            n2 -= 2;
        }
        m_nTextWindowTextOffset = n;
        m_nTextWindowTextLength = n2;
        m_nTextWindowWidth = n3;
        m_nTextWindowHeight = n4;
        m_nTextWindowFont = n5;
        m_nTextWindowFontHeight = GFFont.getFontHeight(n5);
        m_nTextWindowLineGap = n6;
        m_nTextWindowLinesCount = 0;
        m_nTextWindowFirstLine = 0;
        m_nTextWindowVisibleLines = (m_nTextWindowHeight + m_nTextWindowLineGap) / (m_nTextWindowFontHeight + m_nTextWindowLineGap);
        m_nTextWindowHeight = m_nTextWindowVisibleLines * (m_nTextWindowFontHeight + m_nTextWindowLineGap) - m_nTextWindowLineGap;
        m_nMaxTextWidth = m_nTextWindowWidth;
        m_nMaxLineWidth = 0;
        m_bTextWindowScrolling = bl;
        int n12 = 16;
        if (bl) {
            m_nMaxTextWidth -= n12;
        }
        int n13 = 0;
        int n14 = n;
        int n15 = n;
        int n16 = 0;
        int n17 = n + n2 + n11;
        int n18 = n;
        int n19 = n;
        for (n9 = n; n9 < n17; ++n9) {
            char c = m_sbTextWindowText.charAt(n9);
            if (!Text.isNewLine(c) && c != n10 && !Text.isChangeAlignmentChar(c)) {
                int n20 = GFFont.getCharWidth(c, n5);
                int n21 = n13 + n20;
                if (Text.isWhiteSpace(c)) {
                    if (n19 < n9 - 1) {
                        n18 = n9;
                    }
                    n15 = n9 + 1;
                    n16 = 0;
                    n19 = n9;
                    n13 = n21;
                    continue;
                }
                if (n21 > m_nMaxTextWidth) {
                    if (n15 > n14) {
                        Text.setPossibleNewAlignment(c, m_nTextWindowLinesCount);
                        Text.m_nTextWindowLines[Text.m_nTextWindowLinesCount++] = n14 << 16 | n18 - n14;
                        n14 = n15;
                        n13 = n16 + n20;
                        if (n21 - n16 - n20 <= m_nMaxLineWidth) continue;
                        m_nMaxLineWidth = n21 - n16 - n20;
                        continue;
                    }
                    Text.setPossibleNewAlignment(c, m_nTextWindowLinesCount);
                    Text.m_nTextWindowLines[Text.m_nTextWindowLinesCount++] = n14 << 16 | n9 - n14;
                    n14 = n9;
                    n13 = n20;
                    n15 = n9;
                    n16 = n20;
                    if (n21 - n20 <= m_nMaxLineWidth) continue;
                    m_nMaxLineWidth = n21 - n20;
                    continue;
                }
                n13 = n21;
                n16 += n20;
                continue;
            }
            Text.setPossibleNewAlignment(c, m_nTextWindowLinesCount);
            Text.m_nTextWindowLines[Text.m_nTextWindowLinesCount++] = n14 << 16 | n9 - n14;
            n14 = n9 + 1;
            if (n13 > m_nMaxLineWidth) {
                m_nMaxLineWidth = n13;
            }
            n13 = 0;
            n15 = n9 + 1;
            n16 = 0;
        }
        if (n13 > 0) {
            Text.m_nTextWindowLineAlignment[Text.m_nTextWindowLinesCount] = -1;
            Text.m_nTextWindowLines[Text.m_nTextWindowLinesCount++] = n14 << 16 | n17 - n14;
            if (m_nMaxLineWidth == 0 || n13 > m_nMaxLineWidth) {
                m_nMaxLineWidth = n13;
            }
        }
        if (bl2) {
            if (m_bTextWindowScrolling) {
                m_nTextWindowWidth = m_nMaxLineWidth + n12;
                m_nMaxTextWidth = m_nMaxLineWidth;
            } else {
                m_nMaxTextWidth = m_nTextWindowWidth = m_nMaxLineWidth;
            }
        }
        m_nTextWindowNumSeperateLines = 0;
        for (n9 = 0; n9 < m_nTextWindowLinesCount; ++n9) {
            if (m_nTextWindowLineAlignment[n9] != -1) continue;
            ++m_nTextWindowNumSeperateLines;
        }
        if (m_nTextWindowNumSeperateLines < m_nTextWindowVisibleLines) {
            m_nTextWindowVisibleLines = m_nTextWindowNumSeperateLines;
            if (bl2) {
                m_nTextWindowHeight = m_nTextWindowVisibleLines * (m_nTextWindowFontHeight + m_nTextWindowLineGap) - m_nTextWindowLineGap;
            }
        }
        return m_nTextWindowVisibleLines;
    }

    static void createMultiPageTextScreen(int n, int n2, int n3, int n4, int n5) {
        m_sTextBuffer.setLength(0);
        m_sTextBuffer.append(GAME_STRINGS[n]);
        Text.createMultiPageTextScreen(m_sTextBuffer, n2, n3, n4, n5);
    }

    static void createMultiPageTextScreen(StringBuffer stringBuffer, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = 0;
        int n7 = stringBuffer.length();
        m_sbTextWindowText.setLength(0);
        m_sbTextWindowText.append((Object)stringBuffer);
        m_sbTextWindowText.ensureCapacity(2800);
        char c = '\u0000';
        if (m_sbTextWindowText.charAt(0) == '@') {
            c = m_sbTextWindowText.charAt(1);
            n6 += 2;
            n7 -= 2;
        }
        m_nTextWindowTextOffset = 0;
        m_nTextWindowTextLength = n7;
        m_nTextWindowWidth = n;
        m_nTextWindowHeight = n2;
        m_nTextWindowFont = n3;
        m_nTextWindowFontHeight = GFFont.getFontHeight(n3);
        m_nTextWindowLineGap = n4;
        m_nTextWindowLinesCount = 0;
        m_nTextWindowFirstLine = 0;
        m_nTextWindowVisibleLines = (m_nTextWindowHeight + m_nTextWindowLineGap) / (m_nTextWindowFontHeight + m_nTextWindowLineGap);
        m_nTextWindowHeight = m_nTextWindowVisibleLines * (m_nTextWindowFontHeight + m_nTextWindowLineGap) - m_nTextWindowLineGap;
        m_nMaxTextWidth = m_nTextWindowWidth;
        m_nMaxLineWidth = 0;
        int n8 = 0;
        int n9 = n6;
        int n10 = n6;
        int n11 = 0;
        int n12 = n6 + n7;
        int n13 = n6;
        int n14 = n6;
        for (n5 = n6; n5 < n12; ++n5) {
            char c2 = m_sbTextWindowText.charAt(n5);
            if (!Text.isNewLine(c2) && c2 != c && !Text.isChangeAlignmentChar(c2)) {
                int n15 = GFFont.getCharWidth(c2, n3);
                int n16 = n8 + n15;
                if (Text.isWhiteSpace(c2)) {
                    if (n14 < n5 - 1) {
                        n13 = n5;
                    }
                    n10 = n5 + 1;
                    n11 = 0;
                    n14 = n5;
                    n8 = n16;
                    continue;
                }
                if (n16 > m_nMaxTextWidth) {
                    if (n10 > n9) {
                        Text.setPossibleNewAlignment(c2, m_nTextWindowLinesCount);
                        Text.m_nTextWindowLines[Text.m_nTextWindowLinesCount++] = n9 << 16 | n13 - n9;
                        n9 = n10;
                        n8 = n11 + n15;
                        if (n16 - n11 - n15 <= m_nMaxLineWidth) continue;
                        m_nMaxLineWidth = n16 - n11 - n15;
                        continue;
                    }
                    Text.setPossibleNewAlignment(c2, m_nTextWindowLinesCount);
                    Text.m_nTextWindowLines[Text.m_nTextWindowLinesCount++] = n9 << 16 | n5 - n9;
                    n9 = n5;
                    n8 = n15;
                    n10 = n5;
                    n11 = n15;
                    if (n16 - n15 <= m_nMaxLineWidth) continue;
                    m_nMaxLineWidth = n16 - n15;
                    continue;
                }
                n8 = n16;
                n11 += n15;
                continue;
            }
            Text.setPossibleNewAlignment(c2, m_nTextWindowLinesCount);
            Text.m_nTextWindowLines[Text.m_nTextWindowLinesCount++] = n9 << 16 | n5 - n9;
            n9 = n5 + 1;
            if (n8 > m_nMaxLineWidth) {
                m_nMaxLineWidth = n8;
            }
            n8 = 0;
            n10 = n5 + 1;
            n11 = 0;
        }
        if (n8 > 0) {
            Text.m_nTextWindowLineAlignment[Text.m_nTextWindowLinesCount] = -1;
            Text.m_nTextWindowLines[Text.m_nTextWindowLinesCount++] = n9 << 16 | n12 - n9;
            if (m_nMaxLineWidth == 0 || n8 > m_nMaxLineWidth) {
                m_nMaxLineWidth = n8;
            }
        }
        m_nTextWindowNumSeperateLines = 0;
        for (n5 = 0; n5 < m_nTextWindowLinesCount; ++n5) {
            if (m_nTextWindowLineAlignment[n5] != -1) continue;
            ++m_nTextWindowNumSeperateLines;
        }
        if (m_nTextWindowNumSeperateLines < m_nTextWindowVisibleLines) {
            m_nTextWindowVisibleLines = m_nTextWindowNumSeperateLines;
        }
        m_nNumPages = m_nTextWindowLinesCount % m_nTextWindowVisibleLines == 0 ? m_nTextWindowLinesCount / m_nTextWindowVisibleLines : m_nTextWindowLinesCount / m_nTextWindowVisibleLines + 1;
        m_nCurrPage = 0;
    }

    public static final boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t';
    }

    private static boolean isNewLine(char c) {
        return c == '\n';
    }

    private static boolean isChangeAlignmentChar(char c) {
        return c == '^';
    }

    private static void setPossibleNewAlignment(char c, int n) {
        Text.m_nTextWindowLineAlignment[n] = -1;
        if (Text.isChangeAlignmentChar(c) && c == '^') {
            Text.m_nTextWindowLineAlignment[n] = 3;
        }
    }

    static void DrawTextWindow(Graphics graphics, int n, int n2, int n3) {
        if (m_bTextWindowScrolling && m_nTextWindowLinesCount > m_nTextWindowVisibleLines) {
            n += 8;
        }
        if (m_nTextWindowLinesCount > 0) {
            int n4 = n2;
            int n5 = n3;
            int n6 = m_nTextWindowFirstLine;
            int n7 = 0;
            while (n7 < m_nTextWindowVisibleLines) {
                int n8 = n;
                if (n5 == 2) {
                    n8 += m_nMaxTextWidth / 2;
                } else if (n5 == 3) {
                    n8 += m_nMaxTextWidth;
                }
                if (m_bTextWindowScrolling && m_nTextWindowLinesCount <= m_nTextWindowVisibleLines) {
                    n8 += 4;
                }
                int n9 = m_nTextWindowLines[n6] >> 16 & 0xFFFF;
                int n10 = m_nTextWindowLines[n6] & 0xFFFF;
                if (m_nTextWindowMarkerCount > 0) {
                    for (int i = 0; i < m_nTextWindowMarkerCount; ++i) {
                        if (m_TextWindowMarkerCharPos[i] < n9 || m_TextWindowMarkerCharPos[i] > n9 + n10) continue;
                        int n11 = GFText.getSubStringWidth(m_sbTextWindowText, n9, n10, m_nTextWindowFont);
                        int n12 = GFText.getSubStringWidth(m_sbTextWindowText, n9, m_TextWindowMarkerCharPos[i] - n9, m_nTextWindowFont);
                        Text.m_TextWindowMarkerX[i] = n8 - n11 / 2 + n12;
                        Text.m_TextWindowMarkerY[i] = n4;
                    }
                }
                if (n10 > 0) {
                    Text.DrawAlignedText(graphics, m_sbTextWindowText, n9, n10, n8, n4, m_nTextWindowFont, n5);
                }
                if (m_nTextWindowLineAlignment[n6] == -1) {
                    n4 += m_nTextWindowFontHeight + m_nTextWindowLineGap;
                    ++n7;
                    n5 = n3;
                } else if (m_nTextWindowLineAlignment[n6] == 3) {
                    n5 = 3;
                }
                ++n6;
            }
            if (m_bTextWindowScrolling && m_nTextWindowLinesCount > m_nTextWindowVisibleLines) {
                Text.drawScrollBar(graphics, n, n2);
            }
        }
    }

    static void drawScrollBar(Graphics graphics, int n, int n2) {
        int n3 = n + m_nMaxTextWidth + 4;
        int n4 = n2;
        int n5 = m_nTextWindowHeight;
        int n6 = m_nTextWindowFirstLine * 100 / (m_nTextWindowLinesCount - m_nTextWindowVisibleLines);
        if (!UICallback.drawCustomScrollBar(graphics, n3, n4, n5, n6)) {
            graphics.setColor(m_nTextWindowScrollerColor);
            boolean bl = true;
            int n7 = m_nTextWindowScrollerWidth / 2;
            GraphicsUtil.drawShadedUpTriangle(graphics, n3, n2 + 1, n7, 16379186, 3, 20, 1253152);
            GraphicsUtil.drawShadedDownTriangle(graphics, n3, n2 + m_nTextWindowHeight - 1 - n7, n7, 16379186, 3, 20, 1253152);
            int n8 = m_nTextWindowHeight - 2 * n7 - 4;
            int n9 = Text.getScrollbarScrollerHeight(n8);
            n4 = n2 + n7 + 2 + Text.getScrollbarScrollerDrawYOffset(n8);
            GraphicsUtil.drawShadedRect(graphics, n3, n4, m_nTextWindowScrollerWidth, n9, 16379186, 4, 20, 1253152);
        }
        TouchController.setScrollbarZone(n, n2, m_nMaxTextWidth + m_nTextWindowScrollerWidth, m_nTextWindowHeight);
    }

    static int getScrollbarScrollerHeight(int n) {
        return Math.min(m_nTextWindowVisibleLines * n / m_nTextWindowLinesCount, m_nTextWindowHeight);
    }

    static int getScrollbarScrollerDrawYOffset(int n) {
        int n2 = Text.getScrollbarScrollerHeight(n);
        int n3 = m_nTextWindowFirstLine * (n - n2) / (m_nTextWindowLinesCount - m_nTextWindowVisibleLines);
        return n3;
    }

    static void drawMultiPageTextScreen(Graphics graphics, int n, int n2, int n3, boolean bl) {
        if (m_nTextWindowLinesCount > 0) {
            int n4 = 0;
            int n5 = 0;
            int n6 = n2;
            int n7 = n3;
            int n8 = 0;
            for (int i = m_nTextWindowFirstLine; n8 < m_nTextWindowVisibleLines && i < m_nTextWindowNumSeperateLines; ++i) {
                int n9 = n;
                if (n7 == 2) {
                    n9 += m_nMaxTextWidth / 2;
                } else if (n7 == 3) {
                    n9 += m_nMaxTextWidth;
                }
                n4 = m_nTextWindowLines[i] >> 16 & 0xFFFF;
                n5 = m_nTextWindowLines[i] & 0xFFFF;
                if (m_nTextWindowMarkerCount > 0) {
                    for (int j = 0; j < m_nTextWindowMarkerCount; ++j) {
                        if (m_TextWindowMarkerCharPos[j] < n4 || m_TextWindowMarkerCharPos[j] > n4 + n5) continue;
                        int n10 = GFText.getSubStringWidth(m_sbTextWindowText, n4, n5, m_nTextWindowFont);
                        int n11 = GFText.getSubStringWidth(m_sbTextWindowText, n4, m_TextWindowMarkerCharPos[j] - n4, m_nTextWindowFont);
                        Text.m_TextWindowMarkerX[j] = n9 - n10 / 2 + n11;
                        Text.m_TextWindowMarkerY[j] = n6;
                    }
                }
                if (n5 > 0) {
                    Text.DrawAlignedText(graphics, m_sbTextWindowText, n4, n5, n9, n6, m_nTextWindowFont, n7);
                }
                if (m_nTextWindowLineAlignment[i] == -1) {
                    n6 += m_nTextWindowFontHeight + m_nTextWindowLineGap;
                    ++n8;
                    n7 = n3;
                    continue;
                }
                if (m_nTextWindowLineAlignment[i] != 3) continue;
                n7 = 3;
            }
            if (bl) {
                Text.m_TextWindowIntegers[0] = m_nCurrPage + 1;
                Text.m_TextWindowIntegers[1] = m_nNumPages;
                Text.drawAlignedTextWithInts(graphics, 287, Layer.getXCenter(1), Layer.getLayerProperty(1, 4) - GFFont.getFontHeight(m_nTextWindowFont), 2, true, m_nTextWindowFont, n7);
            }
        }
    }

    static void scrollTextWindow(int n) {
        m_nTextWindowFirstLine = n < 0 ? Math.max(0, m_nTextWindowFirstLine + n) : Math.min(m_nTextWindowNumSeperateLines - m_nTextWindowVisibleLines, m_nTextWindowFirstLine + n);
    }

    static void turnPage(int n) {
        if (n < 0 && m_nCurrPage > 0) {
            m_nTextWindowFirstLine = Math.max(0, m_nTextWindowFirstLine + n * m_nTextWindowVisibleLines);
            m_nCurrPage = Math.max(0, m_nTextWindowFirstLine / m_nTextWindowVisibleLines);
        } else if (n > 0 && m_nCurrPage < m_nNumPages - 1) {
            m_nTextWindowFirstLine = Math.min(m_nTextWindowFirstLine + m_nTextWindowVisibleLines, m_nTextWindowFirstLine + n * m_nTextWindowVisibleLines);
            m_nCurrPage = Math.min(m_nTextWindowFirstLine / m_nTextWindowVisibleLines, m_nNumPages - 1);
        }
    }

    static void DrawAlignedNumber(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        m_NumberAsText.setLength(0);
        m_NumberAsText.append(n);
        int n6 = m_NumberAsText.length();
        if (bl && n6 >= 4) {
            for (int i = n6 - 3; i >= 1; i -= 3) {
                m_NumberAsText.insert(i, ',');
            }
        }
        m_NumberAsText.ensureCapacity(64);
        Text.DrawAlignedText(graphics, m_NumberAsText, 0, m_NumberAsText.length(), n2, n3, n4, n5);
    }

    static StringBuffer insertNumberCommas(int n) {
        m_NumberAsText.setLength(0);
        m_NumberAsText.append(n);
        int n2 = m_NumberAsText.length();
        if (n2 >= 4) {
            for (int i = n2 - 3; i >= 1; i -= 3) {
                m_NumberAsText.insert(i, ',');
            }
        }
        m_NumberAsText.ensureCapacity(64);
        return m_NumberAsText;
    }

    static int getNumberWidth(int n, int n2) {
        return Text.getNumberWidth(n, n2, false);
    }

    static int getNumberWidth(int n, int n2, boolean bl) {
        m_NumberAsText.setLength(0);
        m_NumberAsText.append(n);
        int n3 = m_NumberAsText.length();
        if (bl && n3 >= 4) {
            for (int i = n3 - 3; i >= 1; i -= 3) {
                m_NumberAsText.insert(i, ',');
            }
        }
        m_NumberAsText.ensureCapacity(64);
        return GFText.getStringWidth(m_NumberAsText, n2);
    }

    static void drawAlignedTextWithInts(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        m_sTextBuffer.setLength(0);
        m_sTextBuffer.append(GAME_STRINGS[n]);
        Text.FormatStringWithInts(m_sTextBuffer, n4, bl);
        Text.DrawAlignedText(graphics, m_sTextBuffer, 0, m_sTextBuffer.length(), n2, n3, n5, n6);
    }

    static void DrawAlignedText(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        String string = GAME_STRINGS[n];
        Text.DrawAlignedText(graphics, string, 0, string.length(), n2, n3, n4, n5);
        TouchZones.checkForZone(TouchController.m_nTouchState, 0, n, graphics, n2, n3, n4, n5);
    }

    static void DrawAlignedText(Graphics graphics, StringBuffer stringBuffer, int n, int n2, int n3, int n4, int n5, int n6) {
        Text.DrawAlignedText(graphics, stringBuffer, n, n2, n3, n4, n5, n6, true);
    }

    static void DrawAlignedText(Graphics graphics, StringBuffer stringBuffer, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (bl) {
            if (n6 == 2) {
                n3 -= GFText.getSubStringWidth(stringBuffer, n, n2, n5) / 2;
            } else if (n6 == 3) {
                n3 -= GFText.getSubStringWidth(stringBuffer, n, n2, n5);
            }
        } else if (n6 == 2) {
            if ((Layer.getLayerProperty(1, 5) & 2) != 0) {
                n4 += GFText.getSubStringWidth(stringBuffer, n, n2, n5) / 2;
            } else if ((Layer.getLayerProperty(1, 5) & 4) != 0) {
                n4 -= GFText.getSubStringWidth(stringBuffer, n, n2, n5) / 2;
            } else {
                n3 -= GFText.getSubStringWidth(stringBuffer, n, n2, n5) / 2;
            }
        } else if (n6 == 3) {
            if ((Layer.getLayerProperty(1, 5) & 2) != 0) {
                n4 += GFText.getSubStringWidth(stringBuffer, n, n2, n5);
            } else if ((Layer.getLayerProperty(1, 5) & 4) != 0) {
                n4 -= GFText.getSubStringWidth(stringBuffer, n, n2, n5);
            } else {
                n3 -= GFText.getSubStringWidth(stringBuffer, n, n2, n5);
            }
        }
    }

    static void DrawAlignedText(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5, int n6) {
        Text.DrawAlignedText(graphics, string, n, n2, n3, n4, n5, n6, true);
    }

    static void DrawAlignedText(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (n6 == 2) {
            n3 -= GFText.getSubStringWidth(string, n, n2, n5) / 2;
        } else if (n6 == 3) {
            n3 -= GFText.getSubStringWidth(string, n, n2, n5);
        }
        GFText.drawSubString(graphics, string, n, n2, n3, n4, n5, 1, n6);
    }

    static void resetMarquee() {
        m_nMarqueeX = 0;
        m_nMarqueeY = 0;
        m_nMarqueeBorderLeft = 0;
        m_nMarqueeBorderRight = 0;
        m_nMarqueeSpeed = 0;
        m_nMarqueeFontID = 0;
        m_nMarqueeGap = 0;
        m_nMarqueeDirection = 0;
        m_nMarqueeIterations = 0;
        m_nMarqueeW = 0;
        m_strMarqueeText.setLength(0);
    }

    static void CreateMarqeeTextID(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        Text.CreateMarqeeText(null, null, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11);
    }

    static void CreateMarqeeTextStr(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        Text.CreateMarqeeText(string, null, -1, n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
    }

    static void CreateMarqeeTextStrBuf(StringBuffer stringBuffer, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        Text.CreateMarqeeText(null, stringBuffer, -1, n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
    }

    private static void CreateMarqeeText(String string, StringBuffer stringBuffer, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        m_nMarqueeX = n2;
        m_nMarqueeY = n3;
        m_nMarqueeBorderLeft = n4;
        m_nMarqueeBorderRight = n5;
        m_nMarqueeSpeed = Math.abs(n6);
        m_nMarqueeFontID = n7;
        m_nMarqueeGap = n8;
        m_nMarqueeDirection = n9;
        m_nMarqueeIterations = n10;
        m_strMarqueeText.setLength(0);
        if (n != -1) {
            m_strMarqueeText.append(GAME_STRINGS[n]);
        } else if (string != null) {
            m_strMarqueeText.append(string);
        } else if (stringBuffer != null) {
            m_strMarqueeText.append((Object)stringBuffer);
        }
        if (n11 > 0) {
            m_strMarqueeText = Text.FormatStringWithInts(m_strMarqueeText, n11, true);
        }
        m_nMarqueeW = GFText.getStringWidth(m_strMarqueeText, m_nMarqueeFontID);
        if (m_nMarqueeDirection == 0) {
            m_nMarqueeSpeed = -m_nMarqueeSpeed;
        }
    }

    static void updateMarqeeText() {
        if (m_strMarqueeText.length() > 0) {
            m_nMarqueeX += m_nMarqueeSpeed;
            if (m_nMarqueeDirection == 0) {
                if (m_nMarqueeX + m_nMarqueeW + m_nMarqueeGap < m_nMarqueeBorderLeft) {
                    if (--m_nMarqueeIterations == 0) {
                        Text.resetMarquee();
                    } else {
                        m_nMarqueeX = m_nMarqueeBorderRight;
                    }
                }
            } else if (m_nMarqueeDirection == 1 && m_nMarqueeX - m_nMarqueeGap > m_nMarqueeBorderRight) {
                if (--m_nMarqueeIterations == 0) {
                    Text.resetMarquee();
                } else {
                    m_nMarqueeX = m_nMarqueeBorderLeft - m_nMarqueeW;
                }
            }
        }
    }

    static void DrawMarqeeText(Graphics graphics, int n) {
        if (m_strMarqueeText.length() > 0) {
            boolean bl;
            boolean bl2 = m_nMarqueeDirection == 0 && m_nMarqueeX + m_nMarqueeW < m_nMarqueeBorderLeft;
            boolean bl3 = bl = m_nMarqueeDirection == 1 && m_nMarqueeX > m_nMarqueeBorderRight;
            if (!bl2 || !bl) {
                int n2 = m_nMarqueeY;
                if (n != -1) {
                    n2 = n;
                }
                Text.DrawAlignedText(graphics, m_strMarqueeText, 0, m_strMarqueeText.length(), m_nMarqueeX, n2, m_nMarqueeFontID, 1);
            }
        }
    }

    static StringBuffer FormatTextIDWithInts(int n, int n2, boolean bl) {
        m_sTextBuffer.setLength(0);
        m_sTextBuffer.append(GAME_STRINGS[n]);
        return Text.FormatStringWithInts(m_sTextBuffer, n2, bl);
    }

    static StringBuffer FormatStringWithInts(StringBuffer stringBuffer, int n, boolean bl) {
        if (n > 0) {
            int n2 = 0;
            for (int i = 0; i < stringBuffer.length() && n2 != n; ++i) {
                if (stringBuffer.charAt(i) != '%' || stringBuffer.charAt(i + 1) != 'd') continue;
                stringBuffer.delete(i, i + 2);
                if (bl) {
                    stringBuffer.insert(i, (Object)Text.insertNumberCommas(m_TextWindowIntegers[n2++]));
                    continue;
                }
                stringBuffer.insert(i, m_TextWindowIntegers[n2++]);
            }
        }
        return stringBuffer;
    }

    static final int strBufIndexOf(StringBuffer stringBuffer, char c, int n) {
        int n2 = stringBuffer.length();
        if (n >= n2) {
            return -1;
        }
        for (int i = n; i < n2; ++i) {
            if (stringBuffer.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    static final boolean strBufReplace(StringBuffer stringBuffer, int n, int n2, int n3) {
        int n4 = stringBuffer.length();
        if (n >= n4 || n2 >= n4 || n > n2) {
            return false;
        }
        stringBuffer.delete(n, n2);
        stringBuffer.insert(n, n3);
        return true;
    }

    static final int getNumberStripW(StringBuffer stringBuffer, String string, boolean bl) {
        int n = 0;
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            int n2 = c == ',' ? 10 : stringBuffer.charAt(i) - 48;
            n += string.charAt(n2 * 2 + 1);
        }
        return n;
    }

    static final void drawNumberStrip(Graphics graphics, StringBuffer stringBuffer, String string, int n, boolean bl, int n2, int n3, int n4, int n5, int n6) {
        int n7 = graphics.getClipX();
        int n8 = graphics.getClipY();
        int n9 = graphics.getClipWidth();
        int n10 = graphics.getClipHeight();
        int n11 = Graphic.GetImageHeight(n) / n4;
        int n12 = Text.getNumberStripW(stringBuffer, string, bl);
        if (n6 == 2) {
            n2 -= n12 / 2;
        } else if (n6 == 3) {
            n2 -= n12;
        }
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            int n13 = c == ',' ? 10 : stringBuffer.charAt(i) - 48;
            char c2 = string.charAt(n13 * 2 + 1);
            char c3 = string.charAt(n13 * 2);
            graphics.setClip(n7, n8, n9, n10);
            graphics.clipRect(n2, n3, (int)c2, n11);
            GFCanvas.drawImage(graphics, n, n2 - c3, n3 - n11 * n5, 20, 1);
            n2 += c2;
        }
        graphics.setClip(n7, n8, n9, n10);
    }

    static void setTextMarkerPos(int n) {
        m_nTextWindowMarkerCount = 0;
        if (n > 0) {
            for (int i = 0; i < m_sbTextWindowText.length(); ++i) {
                if (m_sbTextWindowText.charAt(i) != '~') continue;
                Text.m_TextWindowMarkerCharPos[Text.m_nTextWindowMarkerCount] = i;
                ++m_nTextWindowMarkerCount;
                m_sbTextWindowText.setCharAt(i, ' ');
            }
        }
    }

    static {
        m_nTextWindowLines = new int[256];
        m_nTextWindowLineAlignment = new int[256];
        m_nCurrLang = -1;
        m_nMarqueeX = 0;
        m_nMarqueeY = 0;
        m_nMarqueeBorderLeft = 0;
        m_nMarqueeBorderRight = 0;
        m_nMarqueeSpeed = 0;
        m_nMarqueeFontID = 0;
        m_nMarqueeGap = 0;
        m_nMarqueeDirection = 0;
        m_nMarqueeIterations = 0;
        m_nMarqueeW = 0;
        m_strMarqueeText = new StringBuffer(500);
        m_TextWindowMarkerX = new int[5];
        m_TextWindowMarkerY = new int[5];
        m_TextWindowMarkerCharPos = new int[5];
        m_nTextWindowScrollerWidth = 6;
    }
}

