/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Random;

public class Util
implements Constants,
ImageConstants {
    static final Random RANDOM = new Random();
    static int m_nNumShowNotifyCalls = 0;
    static int m_nRMSPos = 0;
    private static int[] CRC_Table;
    public static boolean m_stopSplash;

    public static int safeRead(InputStream inputStream, byte[] byArray, int n, int n2) {
        int n3;
        int n4 = 0;
        try {
            if (inputStream != null && byArray != null && n2 + n <= byArray.length) {
                for (n3 = 0; n3 < n2 && (n4 = inputStream.read(byArray, n + n3, n2 - n3)) > 0; n3 += n4) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n3 > 0 ? n3 : -1;
    }

    public static final int readInt(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public static final short readShort(byte[] byArray, int n) {
        return (short)((byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF);
    }

    static int GetRandom(int n, Random random) {
        return (random.nextInt() & Integer.MAX_VALUE) % n;
    }

    static int GetRandom(int n) {
        return Util.GetRandom(n, RANDOM);
    }

    static String GetSeparatedString(int n, int n2) {
        String string = Text.GAME_STRINGS[n];
        int n3 = 0;
        while (n2-- > 0) {
            if ((n3 = string.indexOf(124, n3) + 1) != 0) continue;
            return null;
        }
        int n4 = string.indexOf(124, n3);
        if (n4 == -1) {
            n4 = string.length();
        }
        return string.substring(n3, n4);
    }

    static int GetSeparatedStringCount(int n) {
        int n2 = 0;
        int n3 = 0;
        String string = Text.GAME_STRINGS[n];
        do {
            ++n3;
        } while ((n2 = string.indexOf(124, n2 + 1)) != -1);
        return n3;
    }

    public static final int readRMSBytesAsInt(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n |= (byArray[m_nRMSPos + i] & 0xFF) << 24 - 8 * i;
        }
        m_nRMSPos += 4;
        return n;
    }

    public static void writeRMSBytesFromInt(byte[] byArray, int n) {
        for (int i = 0; i < 4; ++i) {
            byArray[Util.m_nRMSPos + i] = (byte)(n >> 24 - 8 * i & 0xFF);
        }
        m_nRMSPos += 4;
    }

    public static void writeRMSBytesFromBoolean(byte[] byArray, boolean bl) {
        byArray[Util.m_nRMSPos] = (byte)(bl ? 1 : 0);
        ++m_nRMSPos;
    }

    public static final boolean readRMSBytesAsBoolean(byte[] byArray) {
        boolean bl = byArray[m_nRMSPos] == 1;
        ++m_nRMSPos;
        return bl;
    }

    public static final long readRMSBytesAsLong(byte[] byArray) {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l |= ((long)byArray[m_nRMSPos + i] & 0xFFL) << 56 - 8 * i;
        }
        m_nRMSPos += 8;
        return l;
    }

    public static void writeRMSBytesFromLong(byte[] byArray, long l) {
        for (int i = 0; i < 8; ++i) {
            byArray[Util.m_nRMSPos + i] = (byte)(l >> 56 - 8 * i & 0xFFL);
        }
        m_nRMSPos += 8;
    }

    public static char readRMSBytesAsChar(byte[] byArray) {
        char c = (char)(byArray[m_nRMSPos] & 0xFF | byArray[m_nRMSPos + 1] << 8);
        m_nRMSPos += 2;
        return c;
    }

    public static void writeRMSBytesFromChar(byte[] byArray, char c) {
        byArray[Util.m_nRMSPos] = (byte)(c & 0xFF);
        byArray[Util.m_nRMSPos + 1] = (byte)(c >> 8 & 0xFF);
        m_nRMSPos += 2;
    }

    public static final int readBytesAsInt(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = (n2 - 1) * 8;
        for (int i = 0; i < n2; ++i) {
            n3 |= (byArray[n + i] & 0xFF) << n4 - 8 * i;
        }
        return n3;
    }

    public static void writeBytesFromInt(byte[] byArray, int n, int n2, int n3) {
        int n4 = (n3 - 1) * 8;
        for (int i = 0; i < n3; ++i) {
            byArray[n2 + i] = (byte)(n >> n4 - 8 * i & 0xFF);
        }
    }

    public static final long readBytesAsLong(byte[] byArray, int n, int n2) {
        long l = 0L;
        int n3 = (n2 - 1) * 8;
        for (int i = 0; i < n2; ++i) {
            l |= ((long)byArray[n + i] & 0xFFL) << n3 - 8 * i;
        }
        return l;
    }

    public static void writeBytesFromLong(byte[] byArray, long l, int n, int n2) {
        int n3 = (n2 - 1) * 8;
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = (byte)(l >> n3 - 8 * i & 0xFFL);
        }
    }

    public static char readBytesAsChar(byte[] byArray, int n) {
        return (char)(byArray[n] & 0xFF | byArray[n + 1] << 8);
    }

    public static void writeBytesFromChar(byte[] byArray, char c, int n) {
        byArray[n] = (byte)(c & 0xFF);
        byArray[n + 1] = (byte)(c >> 8 & 0xFF);
    }

    public static final int crc32(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (CRC_Table == null) {
            CRC_Table = new int[256];
            for (n5 = 0; n5 <= 255; ++n5) {
                n4 = n5;
                for (n3 = 8; n3 > 0; --n3) {
                    if ((n4 & 1) == 1) {
                        n4 = n4 >>> 1 ^ 0xEDB88320;
                        continue;
                    }
                    n4 >>>= 1;
                }
                Util.CRC_Table[n5] = n4;
            }
        }
        int n6 = -1;
        n4 = n;
        while (n2-- != 0) {
            n5 = n6 >>> 8;
            n3 = CRC_Table[(n6 ^ byArray[n4++]) & 0xFF];
            n6 = n5 ^ n3;
        }
        return ~n6;
    }

    static int alder32(byte[] byArray, int n, int n2) {
        int n3 = 1;
        int n4 = 0;
        int n5 = n + n2;
        while (n < n5) {
            n3 = (n3 + (byArray[n++] & 0xFF)) % 65521;
            n4 = (n3 + n4) % 65521;
        }
        return (n4 << 16) + n3;
    }

    static int countSetBits(int n) {
        int n2 = 0;
        if (n < 0) {
            ++n2;
            n &= Integer.MAX_VALUE;
        }
        while (n != 0) {
            n = n - 1 & n;
            ++n2;
        }
        return n2;
    }

    static int countSetBits(long l) {
        int n = 0;
        if (l < 0L) {
            ++n;
            l &= Long.MAX_VALUE;
        }
        while (l != 0L) {
            l = l - 1L & l;
            ++n;
        }
        return n;
    }

    static int findNextSetBit(long l, int n) {
        if (n >= 64) {
            return -1;
        }
        l >>= n;
        int n2 = 0;
        while (l != 0L) {
            if ((l & 1L) == 1L) {
                return n + n2;
            }
            l >>= 1;
            ++n2;
        }
        return -1;
    }

    static int findNextSetBit(int n, int n2) {
        if (n2 >= 32) {
            return -1;
        }
        n >>= n2;
        int n3 = 0;
        while (n != 0) {
            if ((n & 1) == 1) {
                return n2 + n3;
            }
            n >>= 1;
            ++n3;
        }
        return -1;
    }

    static int findLastSetBit(long l) {
        if (l == 0L) {
            return -1;
        }
        l |= l >> 1;
        l |= l >> 2;
        l |= l >> 4;
        l |= l >> 8;
        l |= l >> 16;
        if (((l |= l >> 32) & Long.MIN_VALUE) != 0L) {
            return 63;
        }
        return Util.bitsSetLong(l >> 1);
    }

    static int bitsSetLong(long l) {
        l -= l >>> 1 & 0x5555555555555555L;
        l = (l >>> 2 & 0x3333333333333333L) + (l & 0x3333333333333333L);
        l = (l >>> 4) + l & 0xF0F0F0F0F0F0F0FL;
        return (int)((l *= 0x101010101010101L) >>> 56);
    }

    static int findRandSetBit(long l) {
        int n = Util.GetRandom(Util.bitsSetLong(l));
        int n2 = -1;
        for (int i = 0; i <= n; ++i) {
            n2 = Util.findNextSetBit(l, n2 + 1);
        }
        return n2;
    }

    static long setAllBits(long l) {
        return (1L << (int)l) - 1L;
    }

    static void showNotifyResume() {
        boolean bl = true;
        if (m_nNumShowNotifyCalls >= 2) {
            Game.showNotifyRestartScreen();
        }
        ++m_nNumShowNotifyCalls;
        if (!Graphic.m_bHideNotifyPause) {
            if (bl) {
                Game.me.showNotifyResume();
            }
            Input.releaseAllKeys();
            Graphic.m_bPaused = false;
            Graphic.m_bWasPaused = true;
        }
    }

    public static int readBits(int n, int n2, byte[] byArray) {
        int n3;
        int n4 = n >> 3;
        int n5 = n4 << 3;
        int n6 = n - n5;
        long l = 0L;
        int n7 = byArray.length - n4;
        if (n7 < 5) {
            n3 = 0;
            for (int i = 0; i < n7; ++i) {
                l += (long)(byArray[n4 + i] << n3) & 255L << n3;
                n3 += 8;
            }
        } else {
            l = ((long)byArray[n4] & 0xFFL) + ((long)(byArray[n4 + 1] << 8) & 0xFF00L) + ((long)(byArray[n4 + 2] << 16) & 0xFF0000L) + ((long)(byArray[n4 + 3] << 24) & 0xFF000000L) + ((long)(byArray[n4 + 4] << 32) & 0xFF00000000L);
        }
        n3 = (1 << n2) - 1;
        return (int)(l >>>= n6) & n3;
    }

    static void pauseApp() {
        Graphic.m_bHideNotifyPause = true;
        Audio.hideNotifyAudio();
        Graphic.m_bPaused = true;
        if (GFUIState.m_nUIState == 2) {
            GFMain.splashScreenStartTime = 123L;
            m_stopSplash = true;
        }
    }

    static void resetArray(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n;
        }
    }

    static void resetArray(long[] lArray, long l) {
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = l;
        }
    }

    static void resetArray(Object[] objectArray) {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = null;
            }
        }
    }

    static void resetArray(boolean[] blArray, boolean bl) {
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = bl;
        }
    }

    static void resetArray(char[] cArray, char c) {
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = c;
        }
    }

    static void resetArray(byte[] byArray, byte by) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = by;
        }
    }

    static void resetArray(short[] sArray, short s) {
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = s;
        }
    }

    static int clampInt(int n, int n2, int n3) {
        if (n <= n2) {
            return n2;
        }
        if (n >= n3) {
            return n3;
        }
        return n;
    }

    static int getPercentage(int n, int n2, int n3) {
        int n4 = n * 100 / n2;
        if (n3 > 0) {
            int n5 = n4 * n3 / 100;
            return n5;
        }
        return n4;
    }

    static int getFPPercentage(int n, int n2, int n3) {
        int n4 = FP.fpDiv(FP.fpMul(n, 409600), n2);
        if (n3 > 0) {
            int n5 = FP.fpDiv(FP.fpMul(n4, n3), 409600);
            return n5;
        }
        return n4;
    }

    static int getPercentageOf(int n, int n2) {
        return n2 * n / 100;
    }

    static int getRandValue(int n, int n2) {
        int n3;
        if (n > n2) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        n3 = Util.GetRandom(Math.abs(n2 - n));
        return n + n3;
    }

    static {
        m_stopSplash = false;
    }
}

