/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

public final class BImage {
    private BAnim[] anim = null;
    private final Image image;
    private int numAnimations = 0;

    public static BImage CreateColumnByRow(String filename, int cols, int rows) {
        return BImage.CreateColumnByRow(filename, null, cols, rows, -1, -1, -1, -1, 1);
    }

    public static BImage CreateColumnByRow(String filename, String title, int cols, int rows, int x, int y, int w, int h) {
        return BImage.CreateColumnByRow(filename, title, cols, rows, x, y, w, h, 1);
    }

    public static BImage CreateColumnByRow(String filename, String title, int cols, int rows, int x, int y, int w, int h, int repeat) {
        BImage image = new BImage(filename);
        if (image.getImageWidth() == 0) {
            return null;
        }
        image.createColumnByRow(title, cols, rows, x, y, w, h, repeat);
        return image;
    }

    public BImage(String filename) {
        this.image = OptionsViscount.createImage(filename);
    }

    public int addAnimation() {
        if (this.anim == null) {
            return -1;
        }
        int index = this.numAnimations++;
        this.anim[index] = new BAnim();
        return index;
    }

    public void setAnimationCount(int animationCount) {
        this.anim = new BAnim[animationCount];
    }

    public int createColumnByRow(String title, int cols, int rows, int x, int y, int w, int h) {
        return this.createColumnByRow(title, cols, rows, x, y, w, h, 1);
    }

    public int createColumnByRow(String title, int cols, int rows, int x, int y, int w, int h, int repeat) {
        if (cols < 1) {
            return -1;
        }
        if (-1 == x && -1 == y && -1 == w && -1 == h) {
            x = 0;
            y = 0;
            w = this.image.getWidth() / cols;
            h = this.image.getHeight() / rows;
        }
        if (this.anim == null) {
            this.anim = new BAnim[1];
        }
        int index = this.addAnimation();
        this.anim[index].setFrameCount(repeat * rows * cols);
        for (int k = 0; k < repeat; ++k) {
            for (int j = 0; j < rows; ++j) {
                for (int i = 0; i < cols; ++i) {
                    this.addFrame(index, x + i * w, y + j * h, w, h);
                }
            }
        }
        return index;
    }

    public void adjustAllFrameDimensions(int x, int y) {
        for (int i = 0; i < this.numAnimations; ++i) {
            for (int j = 0; j < this.anim[i].num; ++j) {
                this.anim[i].frames[j].w += x;
                this.anim[i].frames[j].h += y;
            }
        }
    }

    public int addFrame(int index, int x, int y, int w, int h) {
        if (index >= 0 && index < this.numAnimations) {
            return this.anim[index].addFrame(x, y, w, h);
        }
        return -1;
    }

    public int maxFrame(int index) {
        if (index >= 0 && index < this.numAnimations) {
            return this.anim[index].numFrames() - 1;
        }
        return 0;
    }

    public void paint(GraphicsHelper gh, int x, int y, int index, int frame) {
        if (index >= 0 && index < this.numAnimations) {
            this.anim[index].paint(gh, this.image, x, y, frame);
        } else {
            gh.drawImage(this.image, x, y);
        }
    }

    public void paintSprite(GraphicsHelper gh, int x, int y, int index, int frame) {
        if (index >= 0 && index < this.numAnimations) {
            this.anim[index].paintSprite(gh, this.image, x, y, frame);
        } else {
            gh.drawImage(this.image, x - this.getImageWidth() / 2, y - this.getImageHeight() / 2);
        }
    }

    public int getWidth(int index, int frame) {
        if (index >= 0 && index < this.numAnimations) {
            return this.anim[index].getWidth(frame);
        }
        return this.getImageWidth();
    }

    public int getHeight(int index, int frame) {
        if (index >= 0 && index < this.numAnimations) {
            return this.anim[index].getHeight(frame);
        }
        return this.getImageHeight();
    }

    public int getImageWidth() {
        if (this.image != null) {
            return this.image.getWidth();
        }
        return 0;
    }

    public int getImageHeight() {
        if (this.image != null) {
            return this.image.getHeight();
        }
        return 0;
    }
}

