/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Vector;

final class BSongInfo {
    private String[] venueNames = null;
    private boolean[] isMainstr = null;
    private BSongData[][] venueSongs = null;

    BSongInfo() {
    }

    public void load(InputStream in, GameProgress gp) {
        int curVenue = -1;
        if (null != this.venueNames) {
            curVenue = this.venueNames.length - 1;
        }
        try {
            StringBuffer st = new StringBuffer();
            int b = in.read();
            while (-1 != b) {
                char c = (char)b;
                if (c != '\u0000') {
                    st.append(c);
                }
                b = in.read();
            }
            if (st.length() == 0) {
                return;
            }
            Vector s = Util.magicSplit(st.toString(), '\n');
            int sSize = s.size();
            for (int i = 0; i < sSize; ++i) {
                Vector a;
                String line = (String)s.elementAt(i);
                if (line.indexOf(124) != -1) {
                    a = Util.magicSplit(line, '|');
                    if (a.size() != 2) continue;
                    boolean isMain = curVenue + 1 < 3;
                    this.addVenue(curVenue + 1, (String)a.elementAt(1), isMain);
                    ++curVenue;
                    continue;
                }
                a = Util.magicSplit(line, ',');
                if (-1 == curVenue || 4 != a.size() && 5 != a.size()) continue;
                boolean isEncore = a.size() >= 5 ? "encore".equals(a.elementAt(4)) : false;
                BSongData songData = new BSongData((String)a.elementAt(0), (String)a.elementAt(1), (String)a.elementAt(2), Integer.parseInt((String)a.elementAt(3)), null, null, false, isEncore, gp);
                this.addSongData(curVenue, songData);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    public void addVenue(int venueID, String title, boolean isMainstream) {
        if (null == this.venueNames) {
            this.venueNames = new String[venueID + 1];
            this.isMainstr = new boolean[venueID + 1];
            this.venueSongs = new BSongData[venueID + 1][];
        } else if (venueID >= this.venueNames.length) {
            String[] tmpNames = this.venueNames;
            boolean[] tmpIsMainstream = this.isMainstr;
            BSongData[][] tmpSongs = this.venueSongs;
            this.venueNames = new String[venueID + 1];
            this.isMainstr = new boolean[venueID + 1];
            this.venueSongs = new BSongData[venueID + 1][];
            for (int i = 0; i < tmpNames.length; ++i) {
                this.venueNames[i] = tmpNames[i];
                this.isMainstr[i] = tmpIsMainstream[i];
                this.venueSongs[i] = tmpSongs[i];
            }
        }
        this.venueNames[venueID] = title;
        this.isMainstr[venueID] = isMainstream;
    }

    public boolean isMainstream(int venueID) {
        if (null == this.isMainstr || venueID < 0 || venueID >= this.isMainstr.length) {
            return false;
        }
        return this.isMainstr[venueID];
    }

    public void addSongData(int venueID, BSongData songData) {
        if (null == this.venueSongs || 0 > venueID || venueID >= this.venueSongs.length) {
            return;
        }
        if (null == this.venueSongs[venueID]) {
            this.venueSongs[venueID] = new BSongData[1];
        } else {
            BSongData[] tmp = this.venueSongs[venueID];
            this.venueSongs[venueID] = new BSongData[this.venueSongs[venueID].length + 1];
            for (int i = 0; i < tmp.length; ++i) {
                this.venueSongs[venueID][i] = tmp[i];
            }
        }
        this.venueSongs[venueID][this.venueSongs[venueID].length - 1] = songData;
    }

    public int getNumSongs(int venueID) {
        if (null == this.venueSongs || 0 > venueID || venueID >= this.venueSongs.length) {
            return 0;
        }
        BSongData[] songs = this.venueSongs[venueID];
        if (null == songs) {
            return 0;
        }
        return songs.length;
    }

    public BSongData getSong(int venueID, int songInVenueID) {
        if (null == this.venueSongs || 0 > venueID || venueID >= this.venueSongs.length) {
            return null;
        }
        BSongData[] songs = this.venueSongs[venueID];
        if (null == songs || 0 > songInVenueID || songInVenueID >= songs.length) {
            return null;
        }
        BSongData song = songs[songInVenueID];
        return song;
    }

    public String getTitle(int venueID, int songInVenueID) {
        BSongData song = this.getSong(venueID, songInVenueID);
        if (null == song) {
            return null;
        }
        return song.title;
    }

    private String getArtist(int venueID, int songInVenueID) {
        BSongData song = this.getSong(venueID, songInVenueID);
        if (null == song) {
            return null;
        }
        return song.artist;
    }

    private int getYear(int venueID, int songInVenueID) {
        BSongData song = this.getSong(venueID, songInVenueID);
        if (null == song) {
            return 0;
        }
        return song.year;
    }

    public String getFile(int venueID, int songInVenueID) {
        BSongData song = this.getSong(venueID, songInVenueID);
        if (null == song) {
            return null;
        }
        return song.resID_or_jciID;
    }

    public int getNumVenues() {
        if (null == this.venueNames) {
            return 0;
        }
        return this.venueNames.length;
    }

    public String getVenueTitle(int venueID) {
        if (null != this.venueNames && 0 <= venueID && venueID < this.venueNames.length) {
            return this.venueNames[venueID];
        }
        return RealioCanvas.my_bab(39);
    }

    public String getFamousTitle(int venueID, int songInVenueID) {
        return this.getTitle(venueID, songInVenueID) + "\n" + RealioCanvas.my_bab(40) + "\n" + this.getArtist(venueID, songInVenueID) + ", " + this.getYear(venueID, songInVenueID);
    }

    public int findVenueID_byID(String songID) {
        for (int i = 0; i < this.venueSongs.length; ++i) {
            for (int j = 0; j < this.venueSongs[i].length; ++j) {
                BSongData songData = this.venueSongs[i][j];
                if (!songID.equals(songData.resID_or_jciID)) continue;
                return i;
            }
        }
        return -1;
    }

    public int findSongInVenueID_byID(String songID) {
        for (int i = 0; i < this.venueSongs.length; ++i) {
            for (int j = 0; j < this.venueSongs[i].length; ++j) {
                BSongData songData = this.venueSongs[i][j];
                if (!songID.equals(songData.resID_or_jciID)) continue;
                return j;
            }
        }
        return -1;
    }

    public int findVenueID_byTitle(String songTitle) {
        for (int i = 0; i < this.venueSongs.length; ++i) {
            for (int j = 0; j < this.venueSongs[i].length; ++j) {
                BSongData songData = this.venueSongs[i][j];
                if (!songTitle.equals(songData.title)) continue;
                return i;
            }
        }
        return -1;
    }

    public int findSongInVenueID_byTitle(String songTitle) {
        for (int i = 0; i < this.venueSongs.length; ++i) {
            for (int j = 0; j < this.venueSongs[i].length; ++j) {
                BSongData songData = this.venueSongs[i][j];
                if (!songTitle.equals(songData.title)) continue;
                return j;
            }
        }
        return -1;
    }
}

