/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GraphicsHelper {
    public final int WIDTH;
    public final int HEIGHT;
    public final int CX;
    public final int CY;
    private Graphics graphics = null;
    private HFont hFont = null;
    private HFont defaultHFont = null;
    private int curClipX = 0;
    private int curClipY = 0;
    private int curClipWidth = 0;
    private int curClipHeight = 0;
    private boolean bltObeyCurrentClip = false;
    private int scrollSpacer = 10;
    private int xScrollOffset = 0;
    private int nextStringX = 0;

    public GraphicsHelper(int WIDTH, int HEIGHT) {
        this.WIDTH = WIDTH;
        this.HEIGHT = HEIGHT;
        this.CX = WIDTH / 2;
        this.CY = HEIGHT / 2;
        this.scrollSpacer = this.WIDTH / 10;
    }

    public void setDefaultFont(HFont hf) {
        this.defaultHFont = hf;
    }

    public void useDefaultFont() {
        this.hFont = this.defaultHFont;
    }

    public void setFont(HFont hf) {
        this.hFont = hf;
    }

    public HFont getFont() {
        return this.hFont;
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    public void setGraphics(Graphics g) {
        this.graphics = g;
    }

    public void bltObeyClip(boolean obey) {
        this.bltObeyCurrentClip = obey;
    }

    public void blt(Image img, int x, int y, int w, int h, int sx, int sy) {
        boolean verbose = false;
        if (null == img || null == this.graphics) {
            return;
        }
        if (!this.isOnScreen(x, y, w, h)) {
            return;
        }
        if (!this.bltObeyCurrentClip) {
            this.graphics.setClip(x, y, w, h);
        } else {
            this.pushCurrentClip();
            this.graphics.clipRect(x, y, w, h);
        }
        this.graphics.drawImage(img, x - sx, y - sy, 0);
        if (this.bltObeyCurrentClip) {
            this.popCurrentClip();
        }
    }

    public void pushCurrentClip() {
        this.curClipX = this.graphics.getClipX();
        this.curClipY = this.graphics.getClipY();
        this.curClipWidth = this.graphics.getClipWidth();
        this.curClipHeight = this.graphics.getClipHeight();
    }

    public void popCurrentClip() {
        this.graphics.setClip(this.curClipX, this.curClipY, this.curClipWidth, this.curClipHeight);
    }

    private void drawImage(Image img, int x, int y, int w, int h) {
        if (null == img || null == this.graphics) {
            return;
        }
        if (!this.isOnScreen(x, y, w, h)) {
            return;
        }
        this.graphics.drawImage(img, x, y, 0);
    }

    public void drawImage(Image img, int x, int y) {
        if (null == img || null == this.graphics) {
            return;
        }
        this.graphics.drawImage(img, x, y, 0);
    }

    public void drawImage(Image img, int y) {
        if (null == img || null == this.graphics) {
            return;
        }
        this.graphics.drawImage(img, this.CX - img.getWidth() / 2, y, 0);
    }

    public void drawImage(Image img, boolean useFloor) {
        if (null == img || null == this.graphics) {
            return;
        }
        int width = this.CX - img.getWidth() / 2;
        int height = this.CY - img.getHeight() / 2;
        if (useFloor) {
            if (width < 0) {
                width = 0;
            }
            if (height < 0) {
                height = 0;
            }
        }
        this.graphics.drawImage(img, width, height, 0);
    }

    public void drawFillRect(int color) {
        if (null == this.graphics) {
            return;
        }
        this.drawFillRect(color, 0, 0, this.WIDTH, this.HEIGHT);
    }

    public void drawFillRect(int color, int x, int y, int w, int h) {
        if (null == this.graphics) {
            return;
        }
        int oldColor = this.graphics.getColor();
        this.graphics.setColor(color);
        this.graphics.fillRect(x, y, w, h);
        this.graphics.setColor(oldColor);
    }

    public void drawFillTriangle(int color, int x1, int y1, int x2, int y2, int x3, int y3) {
        this.graphics.setColor(color);
        this.graphics.fillTriangle(x1, y1, x2, y2, x3, y3);
    }

    public void drawRect(int color, int x, int y, int w, int h) {
        if (null == this.graphics) {
            return;
        }
        int oldColor = this.graphics.getColor();
        this.graphics.setColor(color);
        this.graphics.drawRect(x, y, w, h);
        this.graphics.setColor(oldColor);
    }

    public void drawGradLine(int x1, int y1, int x2, int y2, int color, int width) {
        this.drawGradLine(x1, y1, x2, y2, color, width, 255);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (null == this.graphics) {
            return;
        }
        this.graphics.drawLine(x1, y1, x2, y2);
    }

    public void drawLine(int x1, int y1, int x2, int y2, int color) {
        if (null == this.graphics) {
            return;
        }
        int oldColor = this.graphics.getColor();
        this.graphics.setColor(color);
        this.graphics.drawLine(x1, y1, x2, y2);
        this.graphics.setColor(oldColor);
    }

    public void drawGradLine(int x1, int y1, int x2, int y2, int color, int width, int intensity) {
        int oldColor = this.graphics.getColor();
        int h = Math.abs(y1 - y2);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int w = width / 2;
        int p = intensity / w;
        for (int i = 0; i < w; ++i) {
            this.graphics.setColor(r, g, b);
            r = Util.clamp(r - p, 0, 255);
            g = Util.clamp(g - p, 0, 255);
            b = Util.clamp(b - p, 0, 255);
            this.graphics.drawLine(x1 - i, y1, x2 - i, y2);
            this.graphics.drawLine(x1 + i, y1, x2 + i, y2);
        }
        this.graphics.setColor(oldColor);
    }

    public void setClip(int x, int y, int w, int h) {
        this.graphics.setClip(x, y, w, h);
    }

    private boolean isOnScreen(int x, int y, int w, int h) {
        return x >= -w && x <= this.WIDTH + w && y >= -h && y <= this.HEIGHT + h;
    }

    public void setColor(int color) {
        if (null == this.graphics) {
            return;
        }
        this.graphics.setColor(color);
    }

    public void clearClip() {
        if (null == this.graphics) {
            return;
        }
        this.graphics.setClip(0, 0, this.WIDTH, this.HEIGHT);
    }

    public boolean wBound(int x) {
        return x < this.WIDTH;
    }

    public boolean hBound(int y) {
        return y < this.HEIGHT;
    }

    public void drawText(String text, int y) {
        this.drawText(text, this.CX, y, 1);
    }

    public void drawText(String text, int x, int y, int align) {
        if (null == this.hFont) {
            return;
        }
        this.hFont.drawStringWrapped(this.graphics, text, x, y, this.WIDTH, align);
    }

    public void drawScrollingText(String text, int x, int y, int w, int align) {
        if (null == this.hFont) {
            return;
        }
        int textWidth = this.hFont.stringWidth(text);
        if (textWidth < w) {
            this.hFont.drawString(this.graphics, text, x, y, align);
        } else {
            this.graphics.setClip(x, y, w, this.hFont.getHeight());
            this.nextStringX = x + textWidth + this.xScrollOffset + this.scrollSpacer;
            this.hFont.drawString(this.graphics, text, x + this.xScrollOffset, y, align);
            this.hFont.drawString(this.graphics, text, this.nextStringX, y, align);
            --this.xScrollOffset;
            if (-this.xScrollOffset >= textWidth + this.scrollSpacer) {
                this.xScrollOffset = 0;
            }
        }
    }

    public int drawText(byte[] text, int x, int y, int align) {
        if (null == this.hFont) {
            return 0;
        }
        int hfontSez = this.hFont.drawText(this.graphics, text, x, y, -1, -1, 0, align);
        return hfontSez;
    }

    public int drawText(byte[] text, int y) {
        return this.drawText(text, this.CX, y, 1);
    }

    public int getFontHeight() {
        return this.getFontHeight(1);
    }

    public int getFontHeight(int numLines) {
        if (null == this.hFont) {
            return 0;
        }
        return numLines * this.hFont.getHeight();
    }

    public int textWidth(String text) {
        if (null == this.hFont) {
            return 0;
        }
        return this.hFont.stringWidth(text);
    }

    public int textWidth(byte[] text) {
        if (null == this.hFont) {
            return 0;
        }
        return this.hFont.getMaxWidth(text);
    }

    public byte[] getFromString(String text) {
        if (null == this.hFont) {
            return null;
        }
        return this.hFont.getFromString(text);
    }

    public int doLinebreaks(byte[] string, int width) {
        if (null == this.hFont) {
            return 0;
        }
        return this.hFont.doLinebreaks(string, width);
    }
}

