/*
 * Decompiled with CFR 0.152.
 */
public class Interpolator {
    private static final long[] decayIsOverThisManys = new long[]{250L, 500L, 750L, 1000L};
    private static final boolean tryBackFill = true;
    private long lastLastMediaTime = -1L;
    private long lastMediaTime = -1L;
    private long lastLastAbsolTimeWhenMediaTimeChanged = 0L;
    private long lastAbsolTimeWhenMediaTimeChanged = 0L;
    private long lastDesiredValue = 0L;
    private long lastOldEmittedValue = 0L;
    private long backFill_prevAbsolTime = 0L;
    private long backFill_prevMediaTime = 0L;
    private boolean backFill_havePrevData = false;
    public static final int TYPE_CURRENT_TIME = 0;
    public static final int TYPE_MEDIA_TIME = 1;
    public static final int TYPE_ORIGIN_SLOPE = 2;
    public static final int TYPE_ORIGIN_SLOPE_MONOTONIC = 3;
    public static final int TYPE_ORIGIN_SLOPE_250 = 4;
    public static final int TYPE_ORIGIN_SLOPE_500 = 5;
    public static final int TYPE_ORIGIN_SLOPE_750 = 6;
    public static final int TYPE_ORIGIN_SLOPE_1000 = 7;
    public static final int NUM_TYPES = 8;

    public void interpolate(long absolTime, long mediaTime, long[] out_debug) {
        this.interpolate(absolTime, mediaTime, out_debug, 0);
    }

    private void interpolate(long absolTime, long mediaTime, long[] out_debug, int recursionDepth) {
        long desiredValue;
        if (recursionDepth == 0) {
            if (this.backFill_havePrevData && this.backFill_prevMediaTime != mediaTime) {
                long bf_at = (absolTime + this.backFill_prevAbsolTime) / 2L;
                long bf_mt = mediaTime;
                this.interpolate(bf_at, bf_mt, null, recursionDepth + 1);
            }
            this.backFill_havePrevData = true;
            this.backFill_prevAbsolTime = absolTime;
            this.backFill_prevMediaTime = mediaTime;
        }
        if (0L == mediaTime && this.lastMediaTime > mediaTime) {
            mediaTime = this.lastMediaTime;
        }
        if (null != out_debug && out_debug.length > 0) {
            out_debug[0] = absolTime;
        }
        if (null != out_debug && out_debug.length > 1) {
            out_debug[1] = mediaTime;
        }
        if (mediaTime != this.lastMediaTime) {
            if (-1L == this.lastMediaTime) {
                this.lastLastAbsolTimeWhenMediaTimeChanged = absolTime;
                this.lastLastMediaTime = mediaTime;
            } else {
                this.lastLastAbsolTimeWhenMediaTimeChanged = this.lastAbsolTimeWhenMediaTimeChanged;
                this.lastLastMediaTime = this.lastMediaTime;
            }
            this.lastAbsolTimeWhenMediaTimeChanged = absolTime;
            this.lastMediaTime = mediaTime;
            desiredValue = mediaTime;
        } else {
            desiredValue = this.lastMediaTime + (absolTime - this.lastAbsolTimeWhenMediaTimeChanged);
        }
        long oldEmittedValue = desiredValue < this.lastOldEmittedValue ? this.lastOldEmittedValue : desiredValue;
        this.lastOldEmittedValue = oldEmittedValue;
        if (null != out_debug && out_debug.length > 2) {
            out_debug[2] = oldEmittedValue;
        }
        this.lastDesiredValue = desiredValue;
        if (null != out_debug && out_debug.length > 3) {
            out_debug[3] = desiredValue;
        }
        long timeSinceLastChange = absolTime - this.lastAbsolTimeWhenMediaTimeChanged;
        int out_idx = 4;
        for (int i = 0; i < decayIsOverThisManys.length; ++i) {
            long newEmittedValue;
            long decayIsOverThisMany = decayIsOverThisManys[i];
            if (timeSinceLastChange >= decayIsOverThisMany) {
                newEmittedValue = desiredValue;
            } else {
                long oldProjection = this.lastLastMediaTime + (absolTime - this.lastLastAbsolTimeWhenMediaTimeChanged);
                newEmittedValue = ((decayIsOverThisMany - timeSinceLastChange) * oldProjection + timeSinceLastChange * desiredValue) / decayIsOverThisMany;
            }
            if (null == out_debug || out_debug.length <= out_idx) continue;
            out_debug[out_idx++] = newEmittedValue;
        }
    }

    public static String type2name(int type) {
        switch (type) {
            case 0: {
                return "sys";
            }
            case 1: {
                return "media";
            }
            case 2: {
                return "os";
            }
            case 3: {
                return "mono";
            }
            case 4: {
                return "250";
            }
            case 5: {
                return "500";
            }
            case 6: {
                return "750";
            }
            case 7: {
                return "1000";
            }
        }
        return "bogus";
    }
}

