/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Screen {
    public static int manualClip = 0;
    public static HFont[] hfontRefs = null;
    private static int[] hfontBaseSizes = null;
    private int[] hfontLineSpacing = new int[]{0, 0, 0};
    private int[] hfontMapping = new int[]{0, 1, 2};
    public static final int FONT_TYPE_TITLE = 0;
    public static final int FONT_TYPE_MENU = 1;
    public static final int FONT_TYPE_CHAT = 2;
    public static final int TYPE_SCREEN_MENU = 0;
    public static final int TYPE_SCREEN_GAMEPLAY = 1;
    public static final int TYPE_SCREEN_SPLASH = 2;
    public static final int POPUP_TYPE_NONE = 0;
    public static final int POPUP_TYPE_SUB_MENU = 1;
    public static final int POPUP_TYPE_INFO_DISPLAY = 2;
    public static final int POPUP_TYPE_TEXT_FIELD = 3;
    public static final int POPUP_TYPE_BATTLE_CHAT_ENTRY = 4;
    private int lastDrawTextWidth = 0;
    private int lastDrawMenuX = 0;
    private int lastDrawMenuY = 0;
    private static final int OFFSCREEN_COORDINATE = -1234;
    final int screenID;
    Screen prevScreen = null;
    int typeScreen = 0;
    int popUpType = 0;
    boolean toleratesLowPriorityActions = false;
    int bgImageHandle = -1;
    int bgAssetType = 0;
    int bgColor = 0;
    int softkeyHeight = 0;
    boolean hasHeader = false;
    private static final Object headerBoundary = new Object();
    private static final Object footerBoundary = new Object();
    private final Vector items = new Vector();
    private final Vector decorations = new Vector();
    private Sprite sprSoftKey = null;
    private int lskSpriteFrame = -1;
    private int rskSpriteFrame = -1;
    private String LSKText = null;
    private String RSKText = null;
    public Action RSKAction = null;
    public Action LSKAction = null;
    public Action scrollLeftAction = null;
    public Action scrollRightAction = null;
    public Action animationMonitorActon = null;
    private static final int BANNER_TEXT_BACKGROUND_COLOR = 0xAAAAAA;
    private int QVGA_BANNER_TEXT_POS_X = 10;
    private int QVGA_BANNER_TEXT_WIDTH = 220;
    private int QVGA_BANNER_TEXT_POS_Y = 65;
    private int QVGA_BANNER_TEXT_HEIGHT = 25;
    private String bannerText = null;
    private int hfontBannerTextColor = 0;
    private int hfontChatTextColor = 0;
    private String infoBannerText = null;
    private int hfontInfoBannerTextColor = 0;
    private Image infoBannerBackground = null;
    private Image standardBannerBackground = null;
    private Vector chatTextVector = null;
    private int flags = 0;
    public static final int FLAG_UPDATE_EVERY_FRAME = 1;
    public static final int FLAG_KEEP_SCROLLING_UNTIL_SELECTION_VISIBLE = 2;
    public static final int ITEM_FLAG_NO_HIGHLIGHT = 1;
    public static final int ITEM_FLAG_TEXT_CENTER = 2;
    public static final int ITEM_FLAG_TEXT_LEFT = 4;
    public static final int ITEM_FLAG_IS_VENU_NAME_retired = 8;
    public static final int ITEM_FLAG_DRAW_AT_END_OF_LAST_TEXT = 16;
    public static final int ITEM_FLAG_DRAW_IN_FRONT_OF_LAST_TEXT = 32;
    public static final int ITEM_FLAG_DRAW_BELOW_LAST_TEXT = 64;
    public static final int ITEM_FLAG_DRAW_IF_LAST_TEXT_HAS_HIGHLIGHT = 128;
    public static final int ITEM_FLAG_USE_OFFSETS_AS_ABSOLUTE = 256;
    public static final int ITEM_FLAG_OVERLAY_ALTERNATE_IF_HIGHLIGHT = 512;
    public static final int ITEM_FLAG_NO_TEXT_WRAP = 1024;
    public static final int ITEM_FLAG_DRAW_AT_END_OF_LAST_TEXT_RIGHT_COLUMN = 2048;
    public static final int ITEM_FLAG_SELECTED = 4096;
    public static final int ITEM_FLAG_DRAW_TO_RIGHT_OF_NEXT_IMAGE = 8192;
    HFont paintTitleFont = null;
    HFont paintMenuItemFont = null;
    HFont paintChatTextFont = null;
    int hfontDefaultIndex = 0;
    int hfontHighlightIndex = 0;
    int hfontHeaderDefaultIndex = 0;
    int titleFontLineSpacing = 0;
    int menuFontLineSpacing = -2;
    int chatFontLineSpacing = -1;
    private String freeRangeText = null;
    private int freeRangeTextX = 0;
    private int freeRangeTextY = 0;
    private int freeRangeTextAlign = 20;
    public int exceptionFlagsHandled = 0;
    private int totalHeaderSectionHeight = 0;
    private int totalMainSectionHeight = 0;
    private int totalMainSectionFilledHeight = 0;
    private int firstMainSectionItemPtr = 0;
    private int lastMainSectionItemPtr = 0;
    private int highlightPtr = 0;
    private int scrollPixels = 0;
    Action defaultAction = null;
    Action backAction = null;
    private long defaultActionTimeout = -1L;
    private long lengthOfTimeout = -1L;
    boolean bIsTimeoutVisible = false;
    boolean bIsChildOfTimeoutScreen = false;
    public long timeRemaining = -1L;
    boolean shareScrollingOverNetwork = false;
    boolean suppressUserScrollingAndSelecting = false;
    boolean sendJCIDisconnectOnHide = false;
    int TEXT_X = 0;
    int TEXT_Y = 0;
    int TEXT_WIDTH = 0;
    int TEXT_HEIGHT = 0;
    int SCREEN_X = 0;
    int SCREEN_Y = 0;
    int SCREEN_WIDTH = 0;
    int SCREEN_HEIGHT = 0;
    int menuTopY = 0;
    int menuLeftX = 0;
    int menuBottomY = 0;
    int sprSelectionHandle = -1;
    int imgSelectionHandle = -1;
    int sprScrollArrowUpHandle = -1;
    int sprScrollArrowDownHandle = -1;
    int scrollArrowTop = 0;
    int scrollArrowBottom = 0;
    int scrollArrowXPos = 0;
    static Scene scene = null;

    void setFonts(int titleFontChoice, int menuFontChoice, int chatFontChoice, int headerColorIndex, int normal, int highlight) {
        this.hfontMapping[0] = titleFontChoice;
        this.hfontMapping[1] = menuFontChoice;
        this.hfontMapping[2] = chatFontChoice;
        this.hfontHeaderDefaultIndex = headerColorIndex;
        this.hfontDefaultIndex = normal;
        this.hfontHighlightIndex = highlight;
    }

    public static void setupInitialHFonts(HFont title, HFont menu, HFont chat) {
        hfontRefs = new HFont[3];
        Screen.hfontRefs[0] = title;
        Screen.hfontRefs[1] = menu;
        Screen.hfontRefs[2] = chat;
        hfontBaseSizes = new int[3];
        Screen.hfontBaseSizes[0] = hfontRefs[0].getHeight();
        Screen.hfontBaseSizes[1] = hfontRefs[1].getHeight();
        Screen.hfontBaseSizes[2] = hfontRefs[2].getHeight();
    }

    public Screen(int screenID) {
        this.screenID = screenID;
    }

    public void setSelectionSprite(int sprHandle, int sprImage) {
    }

    public void setScrollSprites(int spriteUpHandle, int spriteDownHandle, int top, int bottom, int xpos) {
        this.sprScrollArrowUpHandle = spriteUpHandle;
        this.sprScrollArrowDownHandle = spriteDownHandle;
        this.scrollArrowTop = top;
        this.scrollArrowBottom = bottom;
        this.scrollArrowXPos = xpos;
    }

    public void setMenuTextArea(int left, int top, int width, int height) {
        this.menuLeftX = left;
        this.menuTopY = top;
        this.TEXT_HEIGHT = height;
        this.TEXT_WIDTH = width;
    }

    public void setMenuTop(int x, int y) {
        this.menuLeftX = x;
        this.menuTopY = y;
    }

    void noHeader() {
        this.addHeader("");
    }

    void addHeader(String text) {
        this.addHeaderWithSpacer(text, 0);
    }

    void addHeaderWithSpacer(String text, int spacing) {
        this.hasHeader = true;
        for (int i = 0; i < this.items.size(); ++i) {
            Object obj = ((Item)this.items.elementAt((int)i)).item;
            if (headerBoundary != obj) continue;
            this.items.insertElementAt(new Item(text), i);
            return;
        }
        if (spacing != 0) {
            Item spacer = new Item(null, null);
            spacer.setHeight(spacing);
            this.items.insertElementAt(new Item(text), 0);
            this.items.insertElementAt(spacer, 1);
            this.items.insertElementAt(new Item(headerBoundary), 2);
        } else {
            this.items.insertElementAt(new Item(text), 0);
            this.items.insertElementAt(new Item(headerBoundary), 1);
        }
    }

    void addFooter(String text) {
        if (null == text) {
            return;
        }
        for (int i = this.items.size() - 1; i >= 0; --i) {
            Object obj = ((Item)this.items.elementAt((int)i)).item;
            if (footerBoundary != obj) continue;
            this.items.addElement(new Item(text));
            return;
        }
        this.items.addElement(new Item(footerBoundary));
        this.items.addElement(new Item(text));
    }

    void addSpacer(int height) {
        Item spacer = new Item(null, null);
        spacer.setHeight(height);
        spacer.setFlags(1);
        this.items.addElement(spacer);
    }

    void add(String text, Action action) {
        if (null == text) {
            return;
        }
        this.items.addElement(new Item(text, action));
    }

    void add(String text, Action action, int flags) {
        if (null == text) {
            return;
        }
        Item myItem = new Item(text, action);
        myItem.setFlags(flags);
        this.items.addElement(myItem);
    }

    void add(String text) {
        if (null == text) {
            return;
        }
        this.items.addElement(new Item(text));
    }

    void add(String text, int flags) {
        if (null == text) {
            return;
        }
        Item myItem = new Item(text);
        myItem.setFlags(flags);
        this.items.addElement(myItem);
    }

    void add(int sprHandle) {
        boolean verbose = false;
        if (-1 == sprHandle) {
            return;
        }
        this.decorations.addElement(new Integer(sprHandle));
    }

    void add(MenuTextImage embeddedImage, int flags) {
        if (null == embeddedImage) {
            return;
        }
        Item myItem = new Item(embeddedImage);
        myItem.setFlags(flags);
        this.items.addElement(myItem);
    }

    void completeSetup(GraphicsHelper gh, int textHPos, MAM mam) {
        int i;
        if (this.bgImageHandle == -1 && this.popUpType != 4 && this.typeScreen != 2) {
            return;
        }
        Image bgImage = null;
        if (this.bgImageHandle != -1) {
            bgImage = (Image)mam.getRefFromHandle(this.bgAssetType, this.bgImageHandle);
        }
        for (int i2 = 0; i2 < this.decorations.size(); ++i2) {
            Integer sprHandle = (Integer)this.decorations.elementAt(i2);
            mam.getSpriteRefFromHandle(sprHandle);
        }
        Sprite scrollSprite = null;
        if (this.sprScrollArrowUpHandle != -1) {
            scrollSprite = mam.getSpriteRefFromHandle(this.sprScrollArrowUpHandle);
        }
        if (this.sprScrollArrowDownHandle != -1) {
            scrollSprite = mam.getSpriteRefFromHandle(this.sprScrollArrowUpHandle);
        }
        if (scrollSprite != null && scrollSprite.speed > 0) {
            this.setFlag(1);
        }
        this.setUpFontSpacing();
        this.TEXT_X = this.menuLeftX;
        this.TEXT_Y = this.menuTopY;
        if (this.TEXT_HEIGHT == 0) {
            this.TEXT_HEIGHT = gh.HEIGHT - this.menuTopY - 4;
        }
        if (this.TEXT_WIDTH == 0) {
            this.TEXT_WIDTH = gh.WIDTH;
        }
        this.SCREEN_X = 0;
        this.SCREEN_Y = 0;
        this.SCREEN_WIDTH = gh.WIDTH;
        this.SCREEN_HEIGHT = gh.HEIGHT;
        if (this.popUpType != 0) {
            switch (this.popUpType) {
                case 1: {
                    this.SCREEN_X = gh.WIDTH - bgImage.getWidth();
                    this.SCREEN_Y = gh.HEIGHT - bgImage.getHeight();
                    if (OptionsViscount.SCREEN_SIZE_CATEGORY != 0) {
                        this.SCREEN_Y -= 20;
                    }
                    this.SCREEN_WIDTH = bgImage.getWidth();
                    this.SCREEN_HEIGHT = bgImage.getHeight();
                    this.TEXT_X = this.SCREEN_X + 4;
                    this.TEXT_Y = this.SCREEN_Y + 4;
                    this.TEXT_HEIGHT = this.SCREEN_HEIGHT;
                    if (OptionsViscount.SCREEN_SIZE_CATEGORY != 0) break;
                    this.TEXT_HEIGHT -= 20;
                    break;
                }
                case 3: {
                    this.SCREEN_X = gh.WIDTH / 2 - bgImage.getWidth() / 2;
                    this.SCREEN_Y = gh.HEIGHT / 2 - bgImage.getHeight() / 2;
                    this.SCREEN_WIDTH = bgImage.getWidth();
                    this.SCREEN_HEIGHT = bgImage.getHeight();
                    this.TEXT_X = this.SCREEN_X + 4;
                    this.TEXT_Y = this.SCREEN_Y + 4 + 10;
                    break;
                }
                case 4: {
                    for (int i3 = 0; i3 < this.items.size(); ++i3) {
                        Item item = (Item)this.items.elementAt(i3);
                        Object obj = item.item;
                    }
                    this.TEXT_X = this.SCREEN_X + 4;
                    this.TEXT_Y = this.SCREEN_Y + 4;
                    break;
                }
                case 2: {
                    this.QVGA_BANNER_TEXT_POS_Y = OptionsViscount.getBatSkullMenuTop() + this.getFontHeight(0) - 8;
                    this.SCREEN_X = gh.WIDTH / 2 - bgImage.getWidth() / 2;
                    this.SCREEN_Y = this.QVGA_BANNER_TEXT_POS_Y + this.QVGA_BANNER_TEXT_HEIGHT;
                    this.SCREEN_WIDTH = bgImage.getWidth();
                    this.SCREEN_HEIGHT = bgImage.getHeight();
                    this.TEXT_X = this.SCREEN_X + 16;
                    this.TEXT_Y = this.SCREEN_Y + 4 + 15;
                    this.TEXT_WIDTH = this.SCREEN_WIDTH - 16 - 16;
                    this.TEXT_HEIGHT = this.SCREEN_HEIGHT - 4;
                }
            }
        }
        if (this.TEXT_WIDTH > this.SCREEN_WIDTH) {
            this.TEXT_WIDTH = this.SCREEN_WIDTH;
        }
        this.menuBottomY = this.TEXT_Y + this.TEXT_HEIGHT - 4 - this.getFontHeight(1);
        this.totalHeaderSectionHeight = 0;
        this.totalMainSectionHeight = 0;
        this.totalMainSectionFilledHeight = 0;
        this.firstMainSectionItemPtr = 0;
        this.lastMainSectionItemPtr = -1;
        boolean inHeaderSection = this.hasHeader;
        boolean inMainSection = !inHeaderSection;
        int heightInSection = 0;
        boolean isHeaderEmpty = false;
        int i4 = 0;
        while (i4 < this.items.size()) {
            int h;
            Item item = (Item)this.items.elementAt(i4);
            Object obj = item.item;
            if (obj instanceof String) {
                int textHSpace = this.TEXT_WIDTH - textHPos - 4;
                int extra_x = item.isFlagSet(8192) ? this.nextItemWidthFor_ITEM_FLAG_DRAW_TO_RIGHT_OF_NEXT_IMAGE(i4) + 4 : 0;
                String s = (String)obj;
                byte[] b = gh.getFromString(s);
                int nl = 0;
                if (inHeaderSection) {
                    if (s.length() > 0) {
                        nl = this.getFontRef(0).doLinebreaks(b, gh.WIDTH);
                        h = this.getFontHeight(0) * nl;
                    } else {
                        isHeaderEmpty = true;
                        h = 0;
                    }
                } else if (item.isFlagSet(1024)) {
                    byte[] byteStr;
                    HFont curFont = null;
                    curFont = this.getFontRef(1);
                    int strWidth = curFont.getMaxWidth(byteStr = curFont.getFromString(s));
                    if (strWidth > this.TEXT_WIDTH) {
                        int strLen = curFont.getSubstringIndexForWidth(s, textHSpace - curFont.stringWidth("..."));
                        s = s.substring(0, strLen) + "...";
                    }
                    b = curFont.getFromString(s);
                    h = this.getFontHeight(1);
                } else {
                    nl = this.getFontRef(1).doLinebreaks(b, textHSpace - extra_x);
                    h = this.getFontHeight(1) * nl;
                }
                item.item = b;
                if (inHeaderSection) {
                    this.totalHeaderSectionHeight += h;
                } else if (inMainSection) {
                    this.totalMainSectionHeight += h;
                }
            } else if (obj instanceof MenuTextImage) {
                h = 0;
            } else if (obj == null && item.action == null) {
                h = item.getHeight();
                if (inHeaderSection) {
                    this.totalHeaderSectionHeight += h;
                } else if (inMainSection) {
                    this.totalMainSectionHeight += h;
                }
            } else if (inHeaderSection) {
                h = isHeaderEmpty ? 0 : 5;
                this.totalHeaderSectionHeight += h;
            } else if (inMainSection) {
                h = 5;
                this.totalMainSectionHeight += h;
            } else {
                h = 5;
            }
            item.setHeight(h);
            heightInSection += h;
            if (headerBoundary == obj) {
                inHeaderSection = false;
                inMainSection = true;
                this.firstMainSectionItemPtr = i4 + 1;
                heightInSection = 0;
            }
            this.lastMainSectionItemPtr = i4++;
        }
        int ptr = 0;
        for (i = 0; i < this.items.size(); ++i) {
            Item item = (Item)this.items.elementAt(i);
            if (!item.isFlagSet(4096)) continue;
            ptr = i;
            break;
        }
        this.highlightPtr = this.setHighlightPtr(ptr);
        this.flags &= 0xFFFFFFFD;
        this.totalMainSectionFilledHeight = this.totalMainSectionHeight;
        for (i = this.items.size() - 1; i >= 0; --i) {
            Item tempItem = (Item)this.items.elementAt(i);
            if ((tempItem.item != null || tempItem.action != null) && !tempItem.isFlagSet(1)) break;
            this.totalMainSectionFilledHeight -= tempItem.getHeight();
        }
    }

    private void setUpFontSpacing() {
        this.setUpFontMappingForPaint();
        if (this.paintTitleFont != null) {
            this.paintTitleFont.setLineSpacing(this.titleFontLineSpacing);
        }
        if (this.paintMenuItemFont != null) {
            this.paintMenuItemFont.setLineSpacing(this.menuFontLineSpacing);
        }
        if (this.paintChatTextFont != null) {
            this.paintChatTextFont.setLineSpacing(this.chatFontLineSpacing);
        }
    }

    private void setUpFontMappingForPaint() {
        this.paintTitleFont = hfontRefs[this.hfontMapping[0]];
        this.paintMenuItemFont = hfontRefs[this.hfontMapping[1]];
        this.paintChatTextFont = hfontRefs[this.hfontMapping[2]];
    }

    void updateVectorHeights(GraphicsHelper gh, int textHPos) {
        int textHSpace = this.TEXT_WIDTH - textHPos - 4;
        for (int i = 0; i < this.items.size(); ++i) {
            Item currentItem = (Item)this.items.elementAt(i);
            Object obj = currentItem.item;
            if (!(obj instanceof Vector)) continue;
            Vector v = (Vector)obj;
            int currentHeight = currentItem.getHeight();
            int height = 0;
            for (int j = 0; j < v.size(); ++j) {
                String s = (String)v.elementAt(j);
                byte[] b = gh.getFromString(s);
                int nl = gh.doLinebreaks(b, textHSpace);
                height += gh.getFontHeight(nl) + 4;
            }
            this.totalMainSectionHeight += height - currentHeight;
            this.totalMainSectionFilledHeight += height - currentHeight;
            currentItem.setHeight(height);
        }
    }

    void paint(GraphicsHelper gh, TimeLord tl, int textHPos, MAM mam) {
        this.paint(gh, tl, textHPos, mam, true);
    }

    void paint(GraphicsHelper gh, TimeLord tl, int textHPos, MAM mam, boolean paintSoftKeys) {
        boolean debug = false;
        if (0 != this.popUpType && null != this.prevScreen) {
            this.prevScreen.paint(gh, tl, textHPos, mam, false);
        }
        this.setUpFontSpacing();
        this.lastDrawMenuX = 0;
        this.lastDrawMenuY = 0;
        this.lastDrawTextWidth = 0;
        switch (this.typeScreen) {
            case 1: {
                if (null != scene && !RealioCanvas.gsCreatingScene && !RealioCanvas.gsKillingScene) {
                    scene.paint(gh);
                    this.displayRuntimeStats(gh);
                }
                return;
            }
        }
        Graphics g = gh.getGraphics();
        boolean usingDefaultFont = true;
        gh.useDefaultFont();
        if (this.paintTitleFont != null || this.paintMenuItemFont != null) {
            usingDefaultFont = false;
        }
        gh.setClip(this.SCREEN_X, this.SCREEN_Y, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        g.setColor(this.bgColor);
        g.fillRect(this.SCREEN_X, this.SCREEN_Y, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        if (OptionsViscount.NO_BACKGROUNDS && (1 == this.bgImageHandle || 0 == this.bgImageHandle || 2 == this.bgImageHandle)) {
            g.setColor(0);
            g.fillRect(this.SCREEN_X, this.SCREEN_Y, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        } else if (-1 != this.bgImageHandle) {
            Image img = (Image)mam.getRefFromHandle(this.bgAssetType, this.bgImageHandle);
            if (img != null) {
                g.drawImage(img, this.SCREEN_X + this.SCREEN_WIDTH / 2, this.SCREEN_Y + this.SCREEN_HEIGHT / 2, 3);
            } else {
                g.setColor(0);
                g.fillRect(this.SCREEN_X, this.SCREEN_Y, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
            }
        }
        if (this.sprSelectionHandle != -1) {
            // empty if block
        }
        boolean inHeaderSection = this.hasHeader;
        boolean inMainSection = !inHeaderSection;
        boolean needScrollUp = this.scrollPixels < 0;
        boolean needScrollDown = false;
        boolean allowPaintAfterLastText = true;
        int currentMenuY = this.TEXT_Y;
        int menuClipBottom = 0;
        int verticalSpaceAvailableForMenuDisplay = this.menuBottomY - (this.TEXT_Y + this.totalHeaderSectionHeight) - (this.TEXT_Y + this.totalHeaderSectionHeight);
        for (int curItem = 0; curItem < this.items.size(); ++curItem) {
            Item item = (Item)this.items.elementAt(curItem);
            Object obj = item.item;
            if (obj == null && item.action == null) {
                this.lastDrawMenuY = currentMenuY += item.getHeight();
                continue;
            }
            if (headerBoundary == obj) {
                inHeaderSection = false;
                inMainSection = true;
                currentMenuY = this.TEXT_Y + this.totalHeaderSectionHeight + this.scrollPixels;
                continue;
            }
            if (inMainSection) {
                if (this.paintMenuItemFont != null) {
                    gh.setFont(this.paintMenuItemFont);
                } else {
                    gh.useDefaultFont();
                }
                menuClipBottom = this.menuBottomY - (this.TEXT_Y + this.totalHeaderSectionHeight);
                manualClip = this.TEXT_Y + this.totalHeaderSectionHeight + this.menuBottomY - (this.TEXT_Y + this.totalHeaderSectionHeight);
                verticalSpaceAvailableForMenuDisplay = this.menuBottomY - (this.TEXT_Y + this.totalHeaderSectionHeight);
                if (!allowPaintAfterLastText) {
                    if (item.isFlagSet(1)) continue;
                    needScrollDown = true;
                    continue;
                }
                if (currentMenuY + gh.getFontHeight() >= this.menuBottomY && this.highlightPtr != curItem - 1 && this.screenID != 3 && !item.isFlagSet(48)) {
                    if (!item.isFlagSet(1)) {
                        needScrollDown = true;
                    }
                    allowPaintAfterLastText = false;
                    continue;
                }
            }
            int x = Math.max(this.TEXT_X + textHPos - 4, this.SCREEN_X);
            int h = item.getHeight();
            if (this.screenID != 86) {
                manualClip = gh.HEIGHT;
            }
            if (obj instanceof byte[]) {
                if (!inHeaderSection) {
                    g.setClip(0, this.TEXT_Y + this.totalHeaderSectionHeight, 240, this.menuBottomY - (this.TEXT_Y + this.totalHeaderSectionHeight));
                }
                this.drawTextByteArray(gh, g, usingDefaultFont, inHeaderSection, inMainSection, currentMenuY, curItem, obj, x, h, item, mam);
            } else if (obj instanceof MenuTextImage) {
                this.drawMenuTextImage(gh, currentMenuY, curItem, item, obj);
            }
            currentMenuY += item.getHeight();
        }
        for (int curDecoration = 0; curDecoration < this.decorations.size(); ++curDecoration) {
            Integer sprHandle = (Integer)this.decorations.elementAt(curDecoration);
            Sprite spr = mam.getSpriteRefFromHandle(sprHandle);
            if (spr == null) continue;
            spr.paint(gh);
        }
        if (paintSoftKeys) {
            boolean x = false;
            boolean y = false;
            if (this.lskSpriteFrame != -1 && this.sprSoftKey != null) {
                this.sprSoftKey.setFrame(this.lskSpriteFrame);
                this.sprSoftKey.paint(gh, this.sprSoftKey.image.getWidth(0, 0) / 2, gh.HEIGHT - this.sprSoftKey.image.getImageHeight() / 2);
            } else if (this.LSKText != null) {
                gh.setColor(0xFFFFFF);
                gh.setClip(0, 0, gh.WIDTH, gh.HEIGHT);
                if (this.RSKText == null) {
                    this.RSKText = "";
                }
                gh.drawText(this.RSKText, gh.WIDTH - gh.textWidth(this.RSKText) - 4, gh.HEIGHT - gh.getFontHeight() - 4, 4);
            }
            if (this.rskSpriteFrame != -1 && this.sprSoftKey != null) {
                this.sprSoftKey.setFrame(this.rskSpriteFrame);
                this.sprSoftKey.paint(gh, gh.WIDTH - this.sprSoftKey.image.getWidth(0, 0) / 2, gh.HEIGHT - this.sprSoftKey.image.getImageHeight() / 2);
            } else if (this.RSKText != null) {
                gh.setColor(0xFFFFFF);
                gh.setClip(0, 0, gh.WIDTH, gh.HEIGHT);
                if (this.LSKText == null) {
                    this.LSKText = "";
                }
                gh.drawText(this.LSKText, 4, gh.HEIGHT - gh.getFontHeight() - 4, 0);
            }
        }
        gh.setClip(0, 0, gh.WIDTH, gh.HEIGHT);
        this.drawFreeRangeText(gh);
        try {
            if (verticalSpaceAvailableForMenuDisplay - this.scrollPixels < this.totalMainSectionFilledHeight) {
                needScrollDown = true;
            }
            int scrollSpriteXPos = this.TEXT_X + this.TEXT_WIDTH;
            Sprite spr = mam.getSpriteRefFromHandle(6);
            int scrollSpriteUpperY = 0;
            if (spr != null) {
                scrollSpriteUpperY = this.TEXT_Y + this.totalHeaderSectionHeight + mam.getSpriteRefFromHandle(6).getHeight();
            } else {
                System.out.println("spr= nullll");
            }
            int scrollSpriteLowerY = 0;
            spr = mam.getSpriteRefFromHandle(7);
            if (spr != null) {
                scrollSpriteLowerY = this.menuBottomY - spr.getHeight();
            }
            if (this.scrollArrowXPos != 0) {
                scrollSpriteXPos = this.scrollArrowXPos;
            }
            if (this.scrollArrowTop != 0) {
                scrollSpriteUpperY = this.scrollArrowTop;
            }
            if (this.scrollArrowBottom != 0) {
                scrollSpriteLowerY = this.scrollArrowBottom;
            }
            if (needScrollUp && (spr = mam.getSpriteRefFromHandle(6)) != null) {
                mam.getSpriteRefFromHandle(6).paint(gh, this.scrollArrowXPos, scrollSpriteUpperY);
            }
            if (needScrollDown && (spr = mam.getSpriteRefFromHandle(7)) != null) {
                spr.paint(gh, this.scrollArrowXPos, scrollSpriteLowerY);
            }
        }
        catch (Exception e) {
            System.out.println("aaaaaaaaaaaa");
            e.printStackTrace();
        }
        if (this.bIsTimeoutVisible && this.lengthOfTimeout > 0L || this.bIsChildOfTimeoutScreen) {
            gh.clearClip();
            long timeElapsed = this.lengthOfTimeout - (this.defaultActionTimeout - System.currentTimeMillis()) % 60000L;
            this.timeRemaining = (this.defaultActionTimeout - System.currentTimeMillis()) % 60000L;
            int percentComplete = Util.PERCENT((int)timeElapsed, (int)this.lengthOfTimeout);
            int x = gh.WIDTH * 3 / 4;
            int y = 5;
            int width = gh.WIDTH / 4;
            int height = 10;
            if (!this.bIsChildOfTimeoutScreen) {
                gh.drawFillRect(0xFFFFFF, x, y, width, height);
                gh.drawFillRect(0xFF0000, x + 1, y + 1, percentComplete * width / 100 - 2, height - 2);
            }
        }
        this.displayRuntimeStats(gh);
    }

    private int drawMenuTextImage(GraphicsHelper gh, int currentMenuY, int curItem, Item item, Object obj) {
        MenuTextImage embeddedImage = (MenuTextImage)obj;
        Item myItem = item;
        boolean useAlternateImage = false;
        boolean previousItemHasHighlight = false;
        gh.bltObeyClip(true);
        if (this.highlightPtr == curItem - 1) {
            useAlternateImage = true;
            previousItemHasHighlight = true;
        }
        if (!myItem.isFlagSet(128) || myItem.isFlagSet(128) && previousItemHasHighlight) {
            if (myItem.isFlagSet(256)) {
                embeddedImage.drawTextImage(gh, 0, 0, useAlternateImage, true);
            } else if (myItem.isFlagSet(16)) {
                if (myItem.isFlagSet(2048)) {
                    embeddedImage.drawTextImage(gh, OptionsViscount.getBatSkullPageRight() - embeddedImage.getWidth() * 5 - embeddedImage.getXSpacing() * 4 - 2, this.lastDrawMenuY + 4, useAlternateImage, false);
                } else {
                    embeddedImage.drawTextImage(gh, this.lastDrawMenuX + this.lastDrawTextWidth, this.lastDrawMenuY, useAlternateImage, false);
                }
            } else if (myItem.isFlagSet(32)) {
                if (myItem.isFlagSet(4)) {
                    embeddedImage.drawTextImage(gh, this.TEXT_X, this.lastDrawMenuY, useAlternateImage, false);
                } else if (myItem.isFlagSet(512) && previousItemHasHighlight) {
                    embeddedImage.drawTextImage(gh, this.lastDrawMenuX - embeddedImage.getHalfSizeX(), this.lastDrawMenuY, false, false);
                    embeddedImage.drawTextImage(gh, this.lastDrawMenuX - embeddedImage.getHalfSizeX(), this.lastDrawMenuY, true, false);
                } else {
                    embeddedImage.drawTextImage(gh, this.lastDrawMenuX - embeddedImage.getHalfSizeX(), this.lastDrawMenuY, useAlternateImage, false);
                }
            } else if (myItem.isFlagSet(64)) {
                if (myItem.isFlagSet(2)) {
                    embeddedImage.drawTextImage(gh, gh.WIDTH / 2 - embeddedImage.getPrimaryWidth() / 2, currentMenuY + embeddedImage.getHalfSizeY(), false, false);
                } else {
                    embeddedImage.drawTextImage(gh, this.lastDrawMenuX, currentMenuY + embeddedImage.getHalfSizeY(), false, false);
                }
            }
        }
        gh.bltObeyClip(false);
        return currentMenuY;
    }

    private void drawFreeRangeText(GraphicsHelper gh) {
        if (null != this.freeRangeText) {
            gh.setFont(this.paintMenuItemFont);
            int w = gh.getFont().stringWidth(this.freeRangeText);
            gh.getFont().setCurrentColor(this.hfontDefaultIndex);
            gh.drawText(this.freeRangeText, this.freeRangeTextX, this.freeRangeTextY, this.freeRangeTextAlign);
        }
    }

    private void drawFreeRangeText(GraphicsHelper gh, int align) {
        if (null != this.freeRangeText) {
            gh.setFont(this.paintMenuItemFont);
            int w = gh.getFont().stringWidth(this.freeRangeText);
            gh.getFont().setCurrentColor(this.hfontDefaultIndex);
            gh.drawText(this.freeRangeText, 240 - w - 10, this.freeRangeTextY, align);
        }
    }

    private void drawTextByteArray(GraphicsHelper gh, Graphics g, boolean usingDefaultFont, boolean inHeaderSection, boolean inMainSection, int currentMenuY, int curItem, Object obj, int x, int h, Item item, MAM mam) {
        try {
            int extra_x = item.isFlagSet(8192) ? this.nextItemWidthFor_ITEM_FLAG_DRAW_TO_RIGHT_OF_NEXT_IMAGE(curItem) + 4 : 0;
            int textHOffset = 0;
            int drawTextWidth = 0;
            byte[] b = (byte[])obj;
            textHOffset = item.isFlagSet(4) ? this.TEXT_X + extra_x : gh.WIDTH / 2 - gh.textWidth(b) / 2;
            gh.getFont().setCurrentColor(this.hfontDefaultIndex);
            if (curItem == this.highlightPtr) {
                if (this.isSelectableItem(curItem)) {
                    gh.getFont().setCurrentColor(this.hfontHighlightIndex);
                    if (this.sprSelectionHandle != -1) {
                        Sprite sprSelection = mam.getSpriteRefFromHandle(this.sprSelectionHandle);
                        int off = 130;
                        if (sprSelection != null) {
                            sprSelection.setPos(textHOffset - sprSelection.lcduiImage.getWidth() + OptionsViscount.getSelectionSpriteOffsetX(), currentMenuY + gh.getFontHeight() / 2 + OptionsViscount.getSelectionSpriteOffsetY());
                        }
                    }
                }
            } else {
                gh.getFont().setCurrentColor(this.hfontDefaultIndex);
            }
            if (inHeaderSection) {
                if (this.paintTitleFont != null) {
                    gh.setFont(this.paintTitleFont);
                    gh.getFont().setCurrentColor(this.hfontHeaderDefaultIndex);
                }
                gh.drawText(b, gh.WIDTH / 2, currentMenuY, 1);
            } else if (inMainSection) {
                drawTextWidth = gh.drawText(b, textHOffset, currentMenuY, 4);
                this.lastDrawTextWidth = drawTextWidth >> 10 & 0xFF;
                this.lastDrawMenuY = currentMenuY;
                this.lastDrawMenuX = this.TEXT_X + textHOffset;
            }
        }
        catch (Exception e) {
            Util.out("error in DrawTBA:) " + e);
        }
    }

    void displayRuntimeStats(GraphicsHelper gh) {
    }

    public int getHighlightPtr() {
        return this.highlightPtr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setHighlightPtr(int hp) {
        boolean increasing;
        boolean requestedItemOutOfRange;
        int size = this.items.size();
        if (size <= 0) {
            return this.highlightPtr;
        }
        int lowestHighlightableItemIndex = -1;
        int highestHighlightableItemIndex = -1;
        for (int i = 0; i < size; ++i) {
            if (!this.isHighlightableItem(i)) continue;
            if (lowestHighlightableItemIndex == -1) {
                lowestHighlightableItemIndex = i;
            }
            if (i <= highestHighlightableItemIndex) continue;
            highestHighlightableItemIndex = i;
        }
        boolean bl = requestedItemOutOfRange = hp > highestHighlightableItemIndex || hp < lowestHighlightableItemIndex;
        if (requestedItemOutOfRange) {
            int newHP = -1;
            if (hp > highestHighlightableItemIndex) {
                newHP = highestHighlightableItemIndex;
                this.fixScroll(true);
            } else {
                newHP = lowestHighlightableItemIndex;
                this.fixScroll(false);
                this.scrollPixels = 0;
            }
            hp = newHP;
        }
        boolean bl2 = increasing = hp > this.highlightPtr;
        if (this.isHighlightableItem(this.highlightPtr) && this.fixScroll(increasing)) {
            return this.highlightPtr;
        }
        try {
            while (hp < 0) {
                hp += size;
            }
            int explicitChoiceHP = hp % size;
            if (this.isHighlightableItem(explicitChoiceHP)) {
                int n = this.highlightPtr = explicitChoiceHP;
                return n;
            }
            int oldHP = this.highlightPtr;
            int increment = increasing ? 1 : -1;
            this.highlightPtr = explicitChoiceHP;
            for (int numExamined = 0; numExamined < size; ++numExamined) {
                if (this.isHighlightableItem(this.highlightPtr)) {
                    int n = this.highlightPtr;
                    return n;
                }
                this.highlightPtr = (this.highlightPtr + increment + size) % size;
            }
            int n = this.highlightPtr = oldHP;
            return n;
        }
        finally {
            this.fixScroll(increasing);
        }
    }

    private boolean isHighlightableItem(int hp) {
        if (hp < 0 || hp >= this.items.size()) {
            return false;
        }
        if (hp < this.firstMainSectionItemPtr || hp > this.lastMainSectionItemPtr) {
            return false;
        }
        Item menuItem = (Item)this.items.elementAt(hp);
        return !menuItem.isFlagSet(1);
    }

    private boolean isSelectableItem(int hp) {
        if (!this.isHighlightableItem(hp)) {
            return false;
        }
        Item item = (Item)this.items.elementAt(hp);
        Object obj = item.item;
        return null != item.action;
    }

    private boolean fixScroll(boolean increasing) {
        int delta;
        int mainAreaHeight = this.menuBottomY - (this.TEXT_Y + this.totalHeaderSectionHeight);
        int maxScroll = mainAreaHeight / 3;
        int pixelOffset = 0;
        boolean headerLimitReached = false;
        for (int i = 0; i < this.highlightPtr; ++i) {
            Item temp = (Item)this.items.elementAt(i);
            if (temp.item == headerBoundary) {
                headerLimitReached = true;
            }
            if (!headerLimitReached) continue;
            pixelOffset += temp.getHeight();
        }
        Item item = (Item)this.items.elementAt(this.highlightPtr);
        if (increasing) {
            int bottomEdge = this.TEXT_Y + this.totalHeaderSectionHeight + pixelOffset + item.getHeight() + this.scrollPixels + 4;
            if (this.screenID == 161 || this.screenID == 67) {
                bottomEdge += 20;
            }
            delta = bottomEdge > this.menuBottomY ? -(bottomEdge - this.menuBottomY) : 0;
        } else {
            int headerAreaBottom = this.TEXT_Y + this.totalHeaderSectionHeight;
            int topEdge = headerAreaBottom + pixelOffset + this.scrollPixels;
            if (this.screenID == 161 || this.screenID == 67) {
                topEdge -= 20;
            }
            delta = topEdge < headerAreaBottom ? headerAreaBottom - topEdge : 0;
        }
        if (0 == delta) {
            return false;
        }
        this.scrollPixels = (this.flags & 2) != 0 ? (this.scrollPixels += delta) : (delta < -maxScroll ? (this.scrollPixels -= maxScroll) : (delta > maxScroll ? (this.scrollPixels += maxScroll) : (this.scrollPixels += delta)));
        if (this.scrollPixels > 0) {
            this.scrollPixels = 0;
        }
        if (this.scrollPixels < -this.totalMainSectionHeight) {
            this.scrollPixels = -this.totalMainSectionHeight;
        }
        return true;
    }

    public Action getActiveAction() {
        int hp = this.getHighlightPtr();
        if (hp < 0 || hp >= this.items.size()) {
            return null;
        }
        Item item = (Item)this.items.elementAt(hp);
        Action action = item.action;
        if (null != action) {
            return action;
        }
        return this.defaultAction;
    }

    public boolean handleKeyPress(int keyCode, KeyMaster km) {
        RealioCanvas.debug = "keyCode = " + keyCode;
        int hp = this.getHighlightPtr();
        if (hp < 0 || hp >= this.items.size()) {
            return false;
        }
        Item myItem = (Item)this.items.elementAt(hp);
        if (myItem == null) {
            return false;
        }
        Object obj = myItem.item;
        return false;
    }

    public Item getItem(int idx) {
        return (Item)this.items.elementAt(idx);
    }

    public String getInputValueByKey(int id) {
        int count = this.items.size();
        for (int i = 0; i < count; ++i) {
            Item temp = (Item)this.items.elementAt(i);
            Object obj = temp.item;
        }
        return "";
    }

    public void clearField(int id) {
        int count = this.items.size();
        for (int i = 0; i < count; ++i) {
            Item temp = (Item)this.items.elementAt(i);
            Object obj = temp.item;
        }
    }

    public void setFlag(int flag) {
        this.flags |= flag;
    }

    public boolean isFlagSet(int flag) {
        return (this.flags & flag) > 0;
    }

    public void setLSK(String lsk, Action act) {
        this.LSKText = lsk;
        this.LSKAction = act;
    }

    public boolean hasLSK() {
        return this.lskSpriteFrame > -1;
    }

    public String getRSKText() {
        return this.RSKText;
    }

    public String getLSKText() {
        return this.LSKText;
    }

    public void setRSKSpriteFrame(int rsk, Action act) {
        this.rskSpriteFrame = rsk;
        this.RSKAction = act;
    }

    public void setLSKSpriteFrame(int lsk, Action act) {
        this.lskSpriteFrame = lsk;
        this.LSKAction = act;
    }

    public void setRSK(String rsk, Action act) {
        this.RSKText = rsk;
        this.RSKAction = act;
    }

    public void setSoftKeySprite(Sprite skSprite) {
        this.sprSoftKey = skSprite;
    }

    public void setLSKSpriteFrame(int frame) {
        this.lskSpriteFrame = frame;
    }

    public void setRSKSpriteFrame(int frame) {
        this.rskSpriteFrame = frame;
    }

    public void setSoftkeyHeight(int h) {
        this.softkeyHeight = h;
    }

    public void setPopUpType(int type) {
        this.popUpType = type;
    }

    public int getPopUpType() {
        return this.popUpType;
    }

    public void setFreeRangeText(String str, int x, int y) {
        this.freeRangeText = str;
        this.freeRangeTextX = x;
        this.freeRangeTextY = y;
        this.freeRangeTextAlign = 20;
    }

    public void setFreeRangeText(String str, int x, int y, int align) {
        this.setFreeRangeText(str, x, y);
        this.freeRangeTextAlign = align;
    }

    public void moveDecorations(MAM mam) {
        int size = this.decorations.size();
        for (int i = 0; i < size; ++i) {
            Integer sprHandle = (Integer)this.decorations.elementAt(i);
            Sprite spr = mam.getSpriteRefFromHandle(sprHandle);
            if (spr == null) continue;
            spr.move();
        }
    }

    public void setFontSpacing(int titleSpacing, int menuSpacing, int chatSpacing) {
        this.titleFontLineSpacing = titleSpacing;
        this.menuFontLineSpacing = menuSpacing;
        this.chatFontLineSpacing = chatSpacing;
        this.hfontLineSpacing[0] = titleSpacing;
        this.hfontLineSpacing[1] = menuSpacing;
        this.hfontLineSpacing[2] = chatSpacing;
    }

    public int getFontHeight(int fontType) {
        return hfontBaseSizes[this.hfontMapping[fontType]] + this.hfontLineSpacing[this.hfontMapping[fontType]];
    }

    private HFont getFontRef(int fontType) {
        return hfontRefs[this.hfontMapping[fontType]];
    }

    public void setChatTextColor(int hfontChatTextColor) {
        this.hfontChatTextColor = hfontChatTextColor;
    }

    public void setBannerText(int color, String text, Image bannerImage) {
        this.hfontBannerTextColor = color;
        this.bannerText = text;
        this.standardBannerBackground = bannerImage;
        if (bannerImage == null) {
            Util.out(">>>>WARNING NULL BANNER IMAGE");
        }
    }

    public void setInfoBannerText(int color, String text, Image bannerBkd) {
        this.hfontInfoBannerTextColor = color;
        this.infoBannerText = text;
        this.infoBannerBackground = bannerBkd;
    }

    public void setChatTextArea(Vector msgVector, int textColorIndex) {
        this.chatTextVector = msgVector;
    }

    public void setDefaultActionTimeout(long millis) {
        this.defaultActionTimeout = millis == -1L ? -1L : System.currentTimeMillis() + millis;
        this.lengthOfTimeout = millis;
    }

    public long getDefaultActionTimeout() {
        return this.defaultActionTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyScene(Object mutex) {
        boolean doGC = false;
        Object object = mutex;
        synchronized (object) {
            if (scene != null) {
                scene.destroy();
                scene = null;
                doGC = true;
            }
        }
        if (doGC) {
            Util.maybeGC();
        }
    }

    private int nextItemWidthFor_ITEM_FLAG_DRAW_TO_RIGHT_OF_NEXT_IMAGE(int i) {
        if (null == this.items) {
            return 0;
        }
        if (i < 0) {
            return 0;
        }
        if (i >= this.items.size()) {
            return 0;
        }
        Item nextItem = (Item)this.items.elementAt(i + 1);
        Object nextObj = nextItem.item;
        if (nextObj instanceof MenuTextImage) {
            int width = ((MenuTextImage)nextObj).getWidth();
            return width;
        }
        return 0;
    }
}

