/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;
import javax.microedition.media.Player;

public class MAM {
    private GraphicsHelper gh = null;
    public static final int IMG_HNDL_NONE = -1;
    public static final int IMG_HNDL_BKD_SETLIST = 0;
    public static final int IMG_HNDL_BKD_INTRO = 1;
    public static final int IMG_HNDL_BKD_MAIN = 2;
    public static final int IMG_HNDL_BKD_SPLASH_HOM = 3;
    public static final int IMG_HNDL_BKD_SPLASH_ACTIVISION = 4;
    public static final int IMG_HNDL_BKD_SPLASH_ATT = 5;
    private static final int NUM_CACHABLE_BKD_IMAGES = 6;
    private static final String[] imgBkdFileNames = new String[]{"setlist", "bg_intro", "bg_main", "logo_ho", "logo_av", "outro"};
    public static final int IMG_HNDL_NEWSONG_ICON = 0;
    public static final int IMG_HNDL_AXEL_ICON = 1;
    public static final int IMG_HNDL_JUDY_ICON = 2;
    public static final int IMG_HNDL_DRUM_ICON = 3;
    public static final int IMG_HNDL_GUITAR_ICON = 4;
    public static final int IMG_HNDL_POPUP_ACTION = 5;
    public static final int IMG_HNDL_POPUP_WAIT = 6;
    public static final int IMG_HNDL_POPUP_SYSTEM = 7;
    public static final int IMG_HNDL_TEXT_MSG = 8;
    public static final int IMG_HNDL_TEXT_OPTION = 9;
    public static final int IMG_HNDL_VS_BATTLE = 10;
    public static final int IMG_HNDL_FRAT_VENUE_ICON = 11;
    public static final int IMG_HNDL_METAL_VENUE_ICON = 12;
    public static final int IMG_HNDL_CATHEDRAL_VENU_ICON = 13;
    public static final int IMG_HNDL_LOGO = 14;
    public static final int IMG_HNDL_ARROW = 15;
    public static final int IMG_HNDL_AXEL_SILHOUTTE = 16;
    public static final int IMG_HNDL_JUDY_SILHOUTTE = 17;
    public static final int IMG_HNDL_AXEL_AVATAR = 18;
    public static final int IMG_HNDL_JUDY_AVATAR = 19;
    public static final int IMG_HNDL_SCROLL_UP = 20;
    public static final int IMG_HNDL_SCROLL_DOWN = 21;
    public static final int IMG_HNDL_CHOOSE = 22;
    public static final int IMG_HNDL_CHOOSE_LEFT = 23;
    public static final int IMG_HNDL_CHOOSE_RIGHT = 24;
    public static final int IMG_HNDL_GUITAR_1 = 25;
    public static final int IMG_HNDL_GUITAR_2 = 26;
    public static final int IMG_HNDL_GUITAR_3 = 27;
    public static final int IMG_HNDL_GUITAR_4 = 28;
    public static final int IMG_HNDL_FIRE_ATLAS = 29;
    public static final int IMG_HNDL_SPEAKER_LEFT_ATLAS = 30;
    public static final int IMG_HNDL_SPEAKER_RIGHT_ATLAS = 31;
    public static final int IMG_HNDL_PICK_ATLAS = 32;
    public static final int IMG_HNDL_DOWNLOADS_VENUE_ICON = 33;
    private static final int NUM_CACHABLE_IMAGES = 34;
    private static final String[] imgFileNames = new String[]{"arrow_newsong", "char01_icon", "char02_icon", "drum_icon", "guitar_icon", "popup_action", "popup_wait", "popup_system", "text_messages", "text_option", "vs_battle_popup", "venue_icon_0", "venue_icon_1", "venue_icon_2", "gh4_logo", "arrow", "bg_intro_left", "bg_intro_right", "char1_bg", "char2_bg", "scrollup", "scrolldn", "choose", "choose_left", "choose_right", "guitar1_bg", "guitar2_bg", "guitar3_bg", "guitar4_bg", "fire", "UI_speaker_l", "UI_speaker_r", "picks", "venue_icon_3"};
    private static final int NUM_CACHABLE_B_IMAGES = 1;
    public static final int SPR_HNDL_LOGO = 0;
    public static final int SPR_HNDL_ARROW = 1;
    public static final int SPR_HNDL_AXEL_SILHOUTTE = 2;
    public static final int SPR_HNDL_JUDY_SILHOUTTE = 3;
    public static final int SPR_HNDL_AXEL_AVATAR = 4;
    public static final int SPR_HNDL_JUDY_AVATAR = 5;
    public static final int SPR_HNDL_SCROLL_UP = 6;
    public static final int SPR_HNDL_SCROLL_DOWN = 7;
    public static final int SPR_HNDL_CHOOSE = 8;
    public static final int SPR_HNDL_CHOOSE_LEFT = 9;
    public static final int SPR_HNDL_CHOOSE_RIGHT = 10;
    public static final int SPR_HNDL_GUITAR_1 = 11;
    public static final int SPR_HNDL_GUITAR_2 = 12;
    public static final int SPR_HNDL_GUITAR_3 = 13;
    public static final int SPR_HNDL_GUITAR_4 = 14;
    public static final int SPR_HNDL_FIRE_ANIM = 15;
    public static final int SPR_HNDL_SPEAKER_LEFT_ANIM = 16;
    public static final int SPR_HNDL_SPEAKER_RIGHT_ANIM = 17;
    public static final int SPR_HNDL_PICK_FRAMES = 18;
    private static final int NUM_CACHABLE_SPRITES = 19;
    public static final int MAM_ASSET_TYPE_IMAGE_BKD = 0;
    public static final int MAM_ASSET_TYPE_IMAGE = 1;
    public static final int MAM_ASSET_TYPE_B_IMAGE = 2;
    public static final int MAM_ASSET_TYPE_FONT = 3;
    public static final int MAM_ASSET_TYPE_SPRITE = 4;
    public static final int MAM_ASSET_TYPE_MENU_SFX = 5;
    public static final int MAM_ASSET_TYPE_GAME_SFX = 6;
    private static final int MAM_NUM_ASSET_TYPES = 7;
    public static final int MAM_PURGE_TYPE_NEVER = 1;
    public static final int MAM_PURGE_TYPE_ON_REQUEST = 2;
    public static final int MAM_PRELOAD_TYPE_NEVER = 1;
    public static final int MAM_PRELOAD_TYPE_ON_REQUEST = 2;
    private int[] assetTypePurgeMethod = null;
    private int[] assetTypePreloadMethod = null;
    private final boolean allVerbose;
    BImage[] loadedBImages = null;
    Image[] loadedBkdImages = null;
    Image[] loadedImages = null;
    Sprite[] loadedSprites = null;
    long[] assetNotPresentInFileSystem;
    private static boolean cacheLocked = false;
    public static MAM instance;
    private final boolean USE_NEW_GETTERS;
    private final boolean VERBOSE_NEW_GETTERS;
    private final boolean verboseMeasurements;

    MAM(GraphicsHelper ghelp) {
        this.allVerbose = false;
        this.USE_NEW_GETTERS = true;
        this.VERBOSE_NEW_GETTERS = false;
        this.verboseMeasurements = false;
        this.gh = ghelp;
        this.initializeDefaults();
        instance = this;
    }

    private void initializeDefaults() {
        boolean verbose = false;
        this.loadedBkdImages = new Image[6];
        this.loadedImages = new Image[34];
        this.loadedBImages = new BImage[1];
        this.loadedSprites = new Sprite[19];
        this.assetNotPresentInFileSystem = new long[7];
        this.assetTypePurgeMethod = new int[7];
        this.assetTypePreloadMethod = new int[7];
        boolean purgeMenuAssetsOnRequest = Util.getBooleanParam("MAM-Purge-GFX-On-Request", true);
        int purgeType = purgeMenuAssetsOnRequest ? 2 : 1;
        for (int i = 0; i < 7; ++i) {
            this.assetTypePreloadMethod[i] = 2;
            this.assetTypePurgeMethod[i] = purgeType;
        }
        purgeMenuAssetsOnRequest = Util.getBooleanParam("MAM-Purge-SFX-On-Request", true);
        this.assetTypePurgeMethod[5] = purgeType = purgeMenuAssetsOnRequest ? 2 : 1;
    }

    private void debugOut(String output, boolean verbose) {
        if (verbose | false) {
            Util.out(output);
        }
    }

    private boolean couldAssetBeInFileSystem(int assetType, int assetHandle) {
        boolean verbose = false;
        boolean val = false;
        val = (this.assetNotPresentInFileSystem[assetType] & (long)(1 << assetHandle)) == 0L;
        return val;
    }

    private void markAssetAsNotInFileSystem(int assetType, int assetHandle) {
        boolean verbose = false;
        int n = assetType;
        this.assetNotPresentInFileSystem[n] = this.assetNotPresentInFileSystem[n] | (long)(1 << assetHandle);
    }

    private boolean isBkdImageLoaded(int imgHandle) {
        boolean verbose = false;
        return this.loadedBkdImages[imgHandle] != null;
    }

    private boolean isImageLoaded(int imgHandle) {
        return this.loadedImages[imgHandle] != null;
    }

    private boolean isSpriteLoaded(int sprHandle) {
        return this.loadedSprites[sprHandle] != null;
    }

    private Image loadBkdImage(int imgHandle) {
        boolean verbose = true;
        if (!this.isBkdImageLoaded(imgHandle)) {
            this.debugOut(">>>MAM: loading bkd image: handle, name " + imgHandle + " " + imgBkdFileNames[imgHandle], true);
            if (this.couldAssetBeInFileSystem(0, imgHandle)) {
                this.loadedBkdImages[imgHandle] = OptionsViscount.createImage(imgBkdFileNames[imgHandle]);
                if (this.loadedBkdImages[imgHandle] == null) {
                    this.markAssetAsNotInFileSystem(0, imgHandle);
                }
            }
        }
        return this.loadedBkdImages[imgHandle];
    }

    public void unLoadBkdImages() {
        for (int i = 0; i < this.loadedBkdImages.length; ++i) {
            this.loadedBkdImages[i] = null;
        }
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image getSynchronizedLoad(int assetType, int handle, String[] names, Image[] imgs) {
        boolean verbose = false;
        if (cacheLocked) {
            return null;
        }
        Image curValue = imgs[handle];
        if (null != curValue) {
            return curValue;
        }
        String string = names[handle];
        synchronized (string) {
            Image curValue2 = imgs[handle];
            if (null != curValue2) {
                return curValue2;
            }
            if (cacheLocked) {
                return null;
            }
            if (this.couldAssetBeInFileSystem(assetType, handle)) {
                Image newImage = OptionsViscount.createImage(names[handle]);
                if (cacheLocked) {
                    return null;
                }
                imgs[handle] = newImage;
                if (imgs[handle] == null) {
                    this.markAssetAsNotInFileSystem(assetType, handle);
                }
                return newImage;
            }
            return null;
        }
    }

    public Image getBkdImageRefFromHandle(int imgHandle) {
        return this.getSynchronizedLoad(0, imgHandle, imgBkdFileNames, this.loadedBkdImages);
    }

    private Image loadImage(int imgHandle) {
        boolean verbose = false;
        if (!this.isImageLoaded(imgHandle)) {
            this.loadedImages[imgHandle] = this.getImageRefFromHandle(imgHandle);
            if (this.loadedImages[imgHandle] == null) {
                // empty if block
            }
        }
        return this.loadedImages[imgHandle];
    }

    public Image getImageRefFromHandle(int imgHandle) {
        return this.getSynchronizedLoad(1, imgHandle, imgFileNames, this.loadedImages);
    }

    public Object getRefFromHandle(int assetType, int handle) {
        boolean verbose = false;
        Image assetRef = null;
        if (!cacheLocked) {
            switch (assetType) {
                case 0: {
                    assetRef = this.getBkdImageRefFromHandle(handle);
                    break;
                }
                case 1: {
                    assetRef = this.getImageRefFromHandle(handle);
                }
            }
        }
        return assetRef;
    }

    private Sprite loadSprite(int sprHandle, int imgHandle, int posX, int posY) {
        boolean verbose = false;
        if (!this.isSpriteLoaded(sprHandle)) {
            if (!this.isImageLoaded(imgHandle)) {
                this.loadedImages[imgHandle] = OptionsViscount.createImage(imgFileNames[imgHandle]);
            }
            if (this.loadedImages[imgHandle] != null) {
                this.loadedSprites[sprHandle] = new Sprite(this.loadedImages[imgHandle], posX, posY);
            }
            this.debugOut(">>>MAM: returning sprite " + this.loadedSprites[sprHandle], false);
        }
        return this.loadedSprites[sprHandle];
    }

    public Sprite getSpriteRefFromHandle(int sprHandle, int imgHandle, int posX, int posY) {
        boolean verbose = false;
        return cacheLocked ? null : this.loadSprite(sprHandle, imgHandle, posX, posY);
    }

    public Sprite getSpriteRefFromHandle(int sprHandle, String name, int cols, int rows) {
        BImage img;
        boolean verbose = false;
        Object createdSprite = null;
        if (this.loadedSprites[sprHandle] == null && (img = BImage.CreateColumnByRow(name, cols, rows)) != null) {
            this.loadedSprites[sprHandle] = new Sprite(img, 0, 0, 0);
        }
        return this.loadedSprites[sprHandle];
    }

    private Sprite appSpecificSpriteFactory(int sprHandle) {
        Sprite createdSprite = null;
        Image createdImage = null;
        boolean verbose = false;
        switch (sprHandle) {
            case 1: {
                createdSprite = this.getSpriteRefFromHandle(1, 15, 0, 0);
                break;
            }
            case 0: {
                Image img = this.getImageRefFromHandle(14);
                if (img == null) break;
                createdSprite = this.getSpriteRefFromHandle(0, 14, this.gh.WIDTH / 2, img.getHeight() / 2);
                createdSprite.setVelocity(0, 0);
                break;
            }
            case 2: {
                Image imgSilhouette = this.getImageRefFromHandle(16);
                if (imgSilhouette != null) {
                    Sprite sprSilhouette;
                    createdSprite = sprSilhouette = this.getSpriteRefFromHandle(2, 16, imgSilhouette.getWidth() / 2, this.gh.HEIGHT - imgSilhouette.getHeight() / 2);
                    break;
                }
                createdSprite = null;
                break;
            }
            case 3: {
                Image imgSilhouette = this.getImageRefFromHandle(17);
                if (imgSilhouette != null) {
                    Sprite sprSilhouette;
                    createdSprite = sprSilhouette = this.getSpriteRefFromHandle(3, 17, this.gh.WIDTH - imgSilhouette.getWidth() / 2, this.gh.HEIGHT - imgSilhouette.getHeight() / 2);
                    break;
                }
                createdSprite = null;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                Image tempScroll = OptionsViscount.createImage(imgFileNames[20]);
                if (tempScroll == null) break;
                if (tempScroll.getWidth() > 7) {
                    createdSprite = this.getSpriteRefFromHandle(sprHandle, imgFileNames[20], 3, 1);
                    if (createdSprite == null) break;
                    createdSprite.speed = 100;
                    break;
                }
                Util.out(">>>>MAM:appSpecificSpriteHandler: Creating Single Frame Sprite");
                createdSprite = this.getSpriteRefFromHandle(6, 20, 0, 0);
                break;
            }
            case 7: {
                Image tempScroll = OptionsViscount.createImage(imgFileNames[20]);
                if (tempScroll == null) break;
                if (tempScroll.getWidth() > 7) {
                    createdSprite = this.getSpriteRefFromHandle(sprHandle, imgFileNames[21], 3, 1);
                    if (createdSprite == null) break;
                    createdSprite.speed = 100;
                    break;
                }
                createdSprite = this.getSpriteRefFromHandle(7, 21, 0, 0);
                break;
            }
            case 8: {
                createdImage = this.getImageRefFromHandle(22);
                if (createdImage == null) break;
                int sprHalfHeight = createdImage.getHeight() / 2;
                int sprYPosition = this.gh.HEIGHT - sprHalfHeight;
                int sprXPosition = this.gh.WIDTH / 2;
                createdSprite = this.getSpriteRefFromHandle(8, 22, sprXPosition, sprYPosition);
                break;
            }
            case 9: {
                Sprite sprChooser = this.getSpriteRefFromHandle(8);
                if (sprChooser == null || (createdImage = this.getImageRefFromHandle(23)) == null) break;
                int sprHalfHeight = createdImage.getHeight() / 2;
                int sprYPosition = sprChooser.getPosY() + 2;
                int sprXPosition = sprChooser.getPosX() - createdImage.getWidth() + 4;
                createdSprite = this.getSpriteRefFromHandle(9, 23, sprXPosition, sprYPosition);
                break;
            }
            case 10: {
                Sprite sprChooser = this.getSpriteRefFromHandle(8);
                if (sprChooser == null || (createdImage = this.getImageRefFromHandle(24)) == null) break;
                int sprYPosition = sprChooser.getPosY() + 2;
                int sprXPosition = sprChooser.getPosX() + createdImage.getWidth() - 4;
                createdSprite = this.getSpriteRefFromHandle(10, 24, sprXPosition, sprYPosition);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                int[] imgGuitarHandles = new int[]{25, 26, 27, 28};
                int imgIndex = sprHandle - 11;
                Sprite sprFire = this.getSpriteRefFromHandle(15);
                int sprGuitarHalfHeight = this.getImageRefFromHandle(imgGuitarHandles[imgIndex]).getHeight() / 2;
                int sprGuitarYPosition = this.gh.HEIGHT - sprGuitarHalfHeight - sprFire.image.getHeight(0, 0) + sprFire.image.getHeight(0, 0) / 2;
                int sprGuitarXPosition = this.gh.WIDTH / 2;
                createdSprite = this.getSpriteRefFromHandle(sprHandle, imgGuitarHandles[imgIndex], sprGuitarXPosition, sprGuitarYPosition);
                break;
            }
            case 15: {
                createdSprite = this.getSpriteRefFromHandle(sprHandle, imgFileNames[29], 1, 4);
                if (createdSprite == null) break;
                int sprHalfHeight = createdSprite.image.getHeight(0, 0) / 2;
                int sprYPosition = this.gh.HEIGHT - sprHalfHeight;
                createdSprite.x = this.gh.WIDTH / 2;
                createdSprite.y = sprYPosition;
                createdSprite.speed = 100;
                break;
            }
            case 16: {
                createdSprite = this.getSpriteRefFromHandle(sprHandle, imgFileNames[30], 1, 4);
                if (createdSprite == null) break;
                int sprHalfHeight = createdSprite.image.getHeight(0, 0) / 2;
                int sprYPosition = OptionsViscount.getSpeakerAnimTop();
                createdSprite.x = createdSprite.image.getImageWidth() / 2;
                createdSprite.y = sprYPosition;
                createdSprite.speed = 100;
                break;
            }
            case 17: {
                createdSprite = this.getSpriteRefFromHandle(sprHandle, imgFileNames[31], 1, 4);
                if (createdSprite == null) break;
                int sprHalfHeight = createdSprite.image.getHeight(0, 0) / 2;
                int sprYPosition = OptionsViscount.getSpeakerAnimTop();
                createdSprite.x = this.gh.WIDTH - createdSprite.image.getImageWidth() / 2;
                createdSprite.y = sprYPosition;
                createdSprite.speed = 100;
                break;
            }
            case 18: {
                createdSprite = this.getSpriteRefFromHandle(sprHandle, imgFileNames[32], 1, 14);
                if (createdSprite == null) break;
                createdSprite.speed = -1;
                break;
            }
        }
        return createdSprite;
    }

    public Sprite getSpriteRefFromHandle(int sprHandle) {
        boolean verbose = false;
        if (!cacheLocked) {
            if (this.loadedSprites[sprHandle] == null && this.couldAssetBeInFileSystem(4, sprHandle)) {
                this.loadedSprites[sprHandle] = this.appSpecificSpriteFactory(sprHandle);
                if (this.loadedSprites[sprHandle] == null) {
                    this.markAssetAsNotInFileSystem(4, sprHandle);
                }
            }
            return this.loadedSprites[sprHandle];
        }
        if (cacheLocked) {
            // empty if block
        }
        return null;
    }

    private void purgeInternalAssets(int assetType) {
        boolean verbose = false;
        Object[] assetReference = null;
        this.debugOut("MAM:PurgeInternalAssets", false);
        switch (assetType) {
            case 0: {
                assetReference = this.loadedBkdImages;
                break;
            }
            case 1: {
                assetReference = this.loadedImages;
                break;
            }
            case 2: {
                assetReference = this.loadedBImages;
                break;
            }
            case 4: {
                assetReference = this.loadedSprites;
                break;
            }
        }
        for (int i = 0; i < assetReference.length; ++i) {
            Player player;
            if (5 == assetType && null != (player = (Player)assetReference[i])) {
                try {
                    player.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            assetReference[i] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockAndPurge(Object mutex) {
        boolean verbose = false;
        Object object = mutex;
        synchronized (object) {
            cacheLocked = true;
            this.purgeAssets();
        }
        Util.maybeGC();
    }

    public boolean isLocked() {
        return cacheLocked;
    }

    public void unlock() {
        boolean verbose = false;
        if (cacheLocked) {
            // empty if block
        }
        cacheLocked = false;
    }

    private void purgeAssets() {
        boolean verbose = false;
        if (this.assetTypePurgeMethod[0] == 2) {
            this.purgeInternalAssets(0);
        }
        if (this.assetTypePurgeMethod[1] == 2) {
            this.purgeInternalAssets(1);
        }
        if (this.assetTypePurgeMethod[2] == 2) {
            this.purgeInternalAssets(2);
        }
        if (this.assetTypePurgeMethod[4] == 2) {
            this.purgeInternalAssets(4);
        }
    }
}

